/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.adapters;

import com.ez.analysis.mainframe.usage.adapters.RecordsetProviderImpl;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysisbrowser.actions.AbstractActionContext;
import com.ez.analysisbrowser.actions.IActionContext;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UsageStateAdapter
extends AbstractActionContext {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(UsageStateAdapter.class);
    public static final String RECORDSET = "RECORDSET";
    public static final String ALL_RECORDSETS = "ALL_RECORDSETS";
    private State state;
    private Map<String, Object> data = new HashMap<String, Object>();

    public UsageStateAdapter() {
        this.state = State.Initialized;
    }

    public Map<String, Object> getData() {
        if (this.state != State.Initialized) {
            throw new IllegalStateException("Actual state: " + (Object)((Object)this.state));
        }
        return this.data;
    }

    public synchronized void setRecordsets(LinkedHashMap<String, RecordsetProvider> providers) {
        if (providers == null) {
            throw new IllegalArgumentException("providers is null");
        }
        if (providers.size() == 1) {
            this.data.putAll(providers);
        }
        this.data.put(ALL_RECORDSETS, providers);
    }

    public void detach() {
        LinkedHashMap recs = (LinkedHashMap)this.data.remove(ALL_RECORDSETS);
        if (recs != null) {
            for (RecordsetProvider p : recs.values()) {
                p.dispose();
            }
        }
    }

    public void dispose() {
        if (this.state != State.Disposed) {
            this.detach();
            if (this.data != null) {
                this.data.clear();
            }
            this.state = State.Disposed;
        }
    }

    public String getId() {
        return null;
    }

    public IActionContext getClone() {
        IActionContext clone = null;
        try {
            LinkedHashMap allrecs;
            clone = (IActionContext)((Object)((Object)this)).getClass().newInstance();
            clone.getData().putAll(this.getData());
            if (this.data.containsKey(ALL_RECORDSETS) && (allrecs = (LinkedHashMap)this.getData().get(ALL_RECORDSETS)) != null) {
                LinkedHashMap<String, RecordsetProviderImpl> cloneAllrecs = new LinkedHashMap<String, RecordsetProviderImpl>();
                for (String key : allrecs.keySet()) {
                    cloneAllrecs.put(key, ((RecordsetProvider)allrecs.get(key)).getClone());
                }
                clone.getData().put(ALL_RECORDSETS, cloneAllrecs);
            }
        }
        catch (Exception e) {
            L.warn("cannot instantiate a clone for current state ", (Throwable)e);
        }
        return clone;
    }

    public static enum State {
        Initializing,
        Initialized,
        Disposed,
        FullyDisposed;

    }
}

