/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.adapters;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.FormatInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.adapters.CsvExportDescriptor;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.FilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.adapters.RecordsetProviderBuilder;
import com.ez.analysis.mainframe.usage.adapters.SerializationHandler;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.internal.GuiErrorLog;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.preferences.PreferencesUtils;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.analysis.mainframe.usage.queries.StoredProcDetail;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.ResultsLabelProvider;
import com.ez.analysis.mainframe.usage.ui.ResultsTreeProvider;
import com.ez.analysis.mainframe.usage.ui.UsageViewer;
import com.ez.analysisbrowser.actions.DescriptorAdapter;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.actions.IResultViewer;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezdao.api.NonBlockingOperationHandle;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.ezsource.connection.ServerType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UsageDescriptorAdapter
extends DescriptorAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(UsageDescriptorAdapter.class);
    protected static final String PROCEDURE_NAME_PREFIX = "EZViewer_Dyn_";
    public static final String PARAM_MARKER = "@";
    public static final String PROGRAM_PARAMETER_NAME = "@Program";
    public static final String JOB_PARAMETER_NAME = "@JCLName";
    public static final String DD_PARAMETER_NAME = "@DDName";
    public static final String DS_PARAMETER_NAME = "@DSName";
    public static final String DS_MEMBER_PARAMETER_NAME = "@DSMemberName";
    public static final String STEP_PARAMETER_NAME = "@StepName";
    public static final String ADABAS_VIEW_PARAMETER_NAME = "@AdabasViewName";
    public static final String ADABAS_DB_PARAMETER_NAME = "@AdabasDB";
    public static final String ADABAS_FILE_PARAMETER_NAME = "@AdabasFile";
    public static final String DAL_PARAM = "@DAL";
    public static final String DBI_PARAM = "@DBI";
    public static final String DDCL_ELEM_PARAM = "@ddclElemName";
    public static final String DDCL_ELEM_NAME_PARAM = "@usedDdclElemName";
    public static final String DDCL_ELEM_FILE_PARAM = "@ddclElemFileName";
    public static final String FILE_PARAMETER_NAME = "@File";
    public static final String MQ_QUEUE_PARAMETER_NAME = "@Queue";
    public static final String MQ_MANAGER_PARAMETER_NAME = "@ManagerQueue";
    public static final String INCLUDE_PARAMETER_NAME = "@Include";
    public static final String IDMS_RECORD_PARAM_NAME = "@Record";
    public static final String IDMS_SET_PARAM_NAME = "@Set";
    public static final String STATEMENT_TYPE_PARAM = "@StatementType";
    public static final String ANCESTOR_NAME_PARAM = "@Ancestor";
    public static final String PROGRAM_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.PROGRAM, new String[0]);
    public static final String STATEMENT_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.STMT_TYPE, new String[0]);
    public static final String VARIABLE_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.VARIABLE, new String[0]);
    protected static final String INCLUDE_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.INCLUDE, new String[0]);
    protected static final String SQL_TABLE_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.SQL_TABLE, new String[0]);
    protected static final String DATACOM_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.DATACOM, new String[0]);
    protected static final String SQL_TABLE_FIELD_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.SQL_FIELD_TABLE, new String[0]);
    protected static final String ANCESTOR_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.PROGRAM, "LIKE_OR_IN_SECOND");
    protected static final String JOB_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.JCL_JOB, new String[0]);
    protected static final String STEP_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.JCL_STEP, new String[0]);
    protected static final String DD_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.DDNAME, new String[0]);
    protected static final String DS_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.DATASET, new String[0]);
    protected static final String DS_MEMBER_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.DATASET, "LIKE_OR_IN_SECOND");
    protected static final String MQ_MANAGER_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.MQ_MANAGER, new String[0]);
    protected static final String MQ_QUEUE_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.MQ_QUEUE, new String[0]);
    protected static final String IDMS_SET_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.IDMS_SET, new String[0]);
    protected static final String IDMS_RECORD_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.IDMS_RECORD, new String[0]);
    protected static final String DDCL_ELEM_NAME_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.DDCL_ELEMENT_NAME, new String[0]);
    protected static final String DDCL_ELEM_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.DDCL_ELEMENT, new String[0]);
    protected static final String DDCL_ELEM_FILE_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.DDCL_ELEMENT_FILE_NAME, new String[0]);
    protected static final String IMSDB_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.IMSDB, new String[0]);
    protected static final String STMT_TYPE_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.STMT_TYPE, new String[0]);
    protected static final String ADABAS_DB_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.ADABAS_DB, new String[0]);
    protected static final String ADABAS_FILE_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.ADABAS_FILE, new String[0]);
    protected static final String ADABAS_VIEW_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.ADABAS_VIEW, new String[0]);
    protected static final String IMSDB_DATABASE_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.IMSDB_DATABASE, new String[0]);
    protected static final String IMSDB_SEGMENT_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.IMSDB_SEGMENT, new String[0]);
    protected static final String IMSDB_FIELD_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.IMSDB_FIELD, new String[0]);
    protected static final String IMSDB_SEARCH_FIELD_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.IMSDB_SEARCH_FIELD, new String[0]);
    protected static final String CTRLM_JOB_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.CTRLM_JOB, new String[0]);
    protected static final String CTRLM_APPLICATION_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.CTRLM_APPLICATION, new String[0]);
    protected static final String CTRLM_FOLDER_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.CTRLM_FOLDER, new String[0]);
    private UsageViewer viewer = null;
    protected UsageStateAdapter state = null;
    protected Map<ResultElementType, String> elemTypeToElemNameColumns = new HashMap<ResultElementType, String>();
    protected ResultsTreeProvider resultsTreeProvider;
    protected Map<ResultElementType, Pair<String, List<ResultElementType>>> csvFileSuffixMap = null;
    protected CsvExportDescriptor csvExportDescriptor = null;
    protected IProgressMonitor monitor;

    public UsageDescriptorAdapter(EZAnalysisType at) {
        super(at);
    }

    public void initialize() {
        this.initTreeProvider();
        this.initElemTypeToElemNameColumnsMap();
        this.initializeCSVSuffixes();
        this.initializeCsvExportDescriptor();
    }

    protected abstract void initTreeProvider();

    protected abstract void initElemTypeToElemNameColumnsMap();

    protected void initializeCSVSuffixes() {
    }

    protected void initializeCsvExportDescriptor() {
    }

    public void setState(UsageStateAdapter state) {
        this.state = state;
        if (this.viewer != null) {
            this.viewer.update(null);
        }
    }

    public UsageStateAdapter getState() {
        return this.state;
    }

    public boolean isEmbedded() {
        return true;
    }

    public void loadState(String arg0) {
    }

    public String persistState() {
        return null;
    }

    public IResultViewer getResultViewer() {
        if (this.viewer == null) {
            this.viewer = new UsageViewer(this);
        }
        return this.viewer;
    }

    public void createState(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)1000);
        this.monitor = monitor;
        if (!monitor.isCanceled()) {
            UsageStateAdapter newState = this.createNewState();
            Map<String, Object> contextData = this.state.getData();
            newState.getData().put("projects", contextData.get("projects"));
            if (contextData.get("projects") == null) {
                newState.getData().put("projects", new ArrayList());
            }
            FilterData filter = (FilterData)contextData.get("FilterData");
            List objTypes = (List)contextData.get("ANALYSIS_TYPE_INPUTS");
            ArrayList<ProjectInfo> inputProjects = (ArrayList<ProjectInfo>)contextData.get("PROJECT_LIST");
            if (objTypes != null && inputProjects == null) {
                inputProjects = new ArrayList<ProjectInfo>();
                for (EZObjectType objType : objTypes) {
                    ProjectInfo pi = (ProjectInfo)objType.getProperty("PROJECT_INFO");
                    if (pi == null) {
                        EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)objType.getEntID().getSegment(EZSourceProjectIDSg.class);
                        pi = prjSg.getProjectInfo();
                    }
                    if (pi == null || inputProjects.contains(pi)) continue;
                    inputProjects.add(pi);
                }
                contextData.put("PROJECT_LIST", inputProjects);
            }
            if (filter == null) {
                filter = this.getFilter(objTypes);
            }
            newState.getData().put("PROJECT_LIST", inputProjects);
            Boolean enableLimits = (Boolean)contextData.get("EnableLimitsState");
            if (enableLimits == null) {
                this.setEnableLimits(enableLimits);
                enableLimits = (Boolean)contextData.get("EnableLimitsState");
            }
            newState.getData().put("EnableLimitsState", enableLimits);
            newState.getData().put("FilterData", filter);
            if (inputProjects == null || inputProjects.isEmpty()) {
                L.debug("no projectinfo input available when creating state");
                return;
            }
            HashMap<String, SerializationHandler> tempSHMap = null;
            if (!(monitor.isCanceled() || contextData.containsKey("NOT_COMPUTE_USAGE_RESULTS") && ((Boolean)contextData.get("NOT_COMPUTE_USAGE_RESULTS")).booleanValue())) {
                long jobStartTime = System.currentTimeMillis();
                L.info("{} - start time: {}", (Object)this.getAnalysisType().toString(), (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
                tempSHMap = new HashMap<String, SerializationHandler>();
                int workPerProject = 1000 / inputProjects.size();
                SerializationHandler sh = new SerializationHandler(SerializationHandler.getFile(), this.getRowHeaderInfo(), FormatInfo.getDefault());
                tempSHMap.put("RECORDSET", sh);
                HashMap<String, List<Integer>> tempParamForAdditionalSP = new HashMap<String, List<Integer>>();
                if (this.mustRunAdditionalSP()) {
                    for (String key : this.getAdditionalSpMap().keySet()) {
                        StoredProcDetail spd = this.getAdditionalSpMap().get(key);
                        ColumnInfo paramType = spd.getParamType();
                        if (paramType != null && !tempParamForAdditionalSP.containsKey(paramType.getName())) {
                            tempParamForAdditionalSP.put(paramType.getName(), null);
                        }
                        SerializationHandler spSH = new SerializationHandler(SerializationHandler.getFile(), spd.getRowHeaderInfo(), FormatInfo.getDefault());
                        tempSHMap.put(key, spSH);
                    }
                }
                RuntimeException e = null;
                boolean oneOk = false;
                Iterator it = inputProjects.iterator();
                while (!monitor.isCanceled() && it.hasNext()) {
                    ProjectInfo pi = (ProjectInfo)it.next();
                    try {
                        this.computeResultsPerProject(pi, (IActionContext)this.state, newState, tempSHMap, tempParamForAdditionalSP, filter, (IProgressMonitor)monitor.newChild(workPerProject));
                        oneOk = true;
                    }
                    catch (RuntimeException ee) {
                        L.debug("Unexpected error.", (Throwable)ee);
                        e = ee;
                    }
                }
                if (!oneOk && e != null) {
                    throw e;
                }
                long jobDuration = System.currentTimeMillis() - jobStartTime;
                L.info("{} - duration: {} ms.", (Object)this.getAnalysisType().toString(), (Object)jobDuration);
            } else {
                L.debug("computes results when user press filter button");
            }
            newState.getData().put("last executed entries, only in use entries", this.getEntryInUseNames(filter));
            RecordsetProviderBuilder recProBuilder = new RecordsetProviderBuilder();
            if (tempSHMap != null) {
                for (String key : tempSHMap.keySet()) {
                    recProBuilder.addRecordset(key, (SerializationHandler)tempSHMap.get(key));
                }
            }
            newState.setRecordsets(recProBuilder.build());
            this.setState(newState);
        }
        monitor.setWorkRemaining(0);
    }

    protected List<String> getEntryInUseNames(FilterData filter) {
        ArrayList<String> list = new ArrayList<String>();
        for (FilterEntry entry : filter.getEntries()) {
            if (!entry.isEntryInUse()) continue;
            String name = entry.get("filterEntryName");
            list.add(name);
        }
        return list;
    }

    protected abstract FilterData getFilter(List<EZObjectType> var1);

    protected void computeResultsPerProject(final ProjectInfo pi, IActionContext context, UsageStateAdapter state, final Map<String, SerializationHandler> tempSHMap, final Map<String, List<Integer>> tempParamForAdditionalSP, final FilterData filter, IProgressMonitor pmonitor) {
        final SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        if (!monitor.isCanceled()) {
            String prjName = pi.getName();
            try {
                final ServerType dbEngine = ServerType.findByValue((int)((Integer)pi.getInfo().get("dbEngine")));
                L.debug("will open project {}", (Object)prjName);
                IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
                final IMFProjectHandler ph = service.getProjectHandler(prjName, null);
                Map<String, FilterEntryParameterGenerator> filterEntryParameterGeneratorMap = this.getFilterEntryParameterGeneratorMap();
                List<String> paramsList = filter.getParameters(filterEntryParameterGeneratorMap, dbEngine);
                filter.completeWithSpecificParameters(paramsList);
                final String[] params = paramsList.toArray(new String[0]);
                if (!monitor.isCanceled()) {
                    ph.executeWithLock(ph, new IMFRunnable(){

                        public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                            SubMonitor sm = SubMonitor.convert((IProgressMonitor)pmonitor, (int)120);
                            if (!sm.isCanceled()) {
                                boolean ok;
                                boolean bl = ok = !UsageDescriptorAdapter.this.useCache() || Utils.prepareCache((EZSourceConnection)conn, (String)UsageDescriptorAdapter.this.getDatabaseViewName(), (IProgressMonitor)sm.newChild(20));
                                if (ok) {
                                    if (!sm.isCanceled()) {
                                        Pair<String, String> spPair = UsageDescriptorAdapter.this.createDynamicProc(pi, ph, filter, (IProgressMonitor)monitor.newChild(10));
                                        String sql = (String)spPair.getSecond();
                                        switch (dbEngine) {
                                            case SqlServer: {
                                                conn.executeUpdate(sql);
                                                break;
                                            }
                                            case Db2: 
                                            case Db2Z: {
                                                boolean exists = UsageDescriptorAdapter.storedProcedureExists(conn, dbEngine, (String)spPair.getFirst());
                                                if (exists) break;
                                                conn.executeUpdate(sql);
                                            }
                                        }
                                        L.debug("after verify and insert if not exists dynamic proc: {}", spPair.getFirst());
                                        UsageDescriptorAdapter.this.queryForData(pi, tempSHMap, tempParamForAdditionalSP, filter, params, (String)spPair.getFirst(), conn, (IProgressMonitor)sm.newChild(100));
                                    }
                                } else {
                                    L.warn("Cache already in progress. Retry later.");
                                }
                            }
                        }
                    }, LockType.Shared, (IProgressMonitor)monitor.newChild(90));
                }
                if (monitor.isCanceled()) {
                    state.getData().put("IS_CANCELED", true);
                }
                monitor.setWorkRemaining(0);
                monitor.done();
            }
            catch (Exception e) {
                L.error("while computing results", (Throwable)e);
                GuiErrorLog.err(e.getMessage(), e);
            }
        }
    }

    private static boolean storedProcedureExists(EZSourceConnection conn, ServerType dbEngine, String spName) {
        boolean result = true;
        String schema = conn.getProjectInfo().getDatabaseInfo().getSchema();
        if (schema == null) {
            String projectName = conn.getProjectInfo().getProjectName();
            L.error("schema name is NULL for project: {}; please check settings!", (Object)projectName);
            throw new RuntimeException(Messages.getString(UsageDescriptorAdapter.class, "noSchema.exception", new String[]{projectName}));
        }
        String sql = null;
        switch (dbEngine) {
            case Db2Z: {
                sql = String.format("SELECT NAME FROM SYSIBM.SYSROUTINES WHERE SCHEMA = UPPER('%s') and ROUTINETYPE='P' and NAME=UPPER('%s')", schema, spName);
                break;
            }
            case Db2: {
                sql = String.format("SELECT ROUTINENAME FROM SYSCAT.ROUTINES WHERE ROUTINESCHEMA = UPPER('%s') and ROUTINETYPE='P' and ROUTINENAME=UPPER('%s')", schema, spName);
                break;
            }
        }
        Assert.isNotNull(sql);
        String[][] res = conn.executeSQL(sql);
        if (res == null || res.length == 0 || res[0][0] == null) {
            result = false;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    protected void queryForData(ProjectInfo pi, Map<String, SerializationHandler> tempSHMap, Map<String, List<Integer>> tempParamForAdditionalSP, FilterData filter, Object[] params, String procName, EZSourceConnection conn, IProgressMonitor pmonitor) {
        block22: {
            block21: {
                block23: {
                    sm = SubMonitor.convert((IProgressMonitor)pmonitor);
                    sm.setTaskName(Messages.getString(UsageDescriptorAdapter.class, "query.for.data"));
                    tempTables = new HashSet<String>();
                    try {
                        try {
                            for (FilterEntry e : filter.getEntries()) {
                                if (!e.isEntryInUse()) continue;
                                conn.beginTransaction();
                                tempTableName = e.get("TempTableName");
                                if (!tempTableName.isEmpty()) {
                                    UsageDescriptorAdapter.L.trace("create temp table for {}", (Object)e.get("filterEntryName"));
                                    values = e.get("TempTableValues");
                                    if (e.mustSolveAliases()) {
                                        values = this.addParamFromAliases(conn, values);
                                    }
                                    tempTables.add(tempTableName);
                                    this.prepareTempTables(conn, tempTableName, values);
                                }
                                if (!(secTempTableName = e.get("TempTableNameSecond")).isEmpty()) {
                                    UsageDescriptorAdapter.L.trace("create second temp table for {}", (Object)e.get("filterEntryName"));
                                    values = e.get("TempTableValuesSecond");
                                    tempTables.add(secTempTableName);
                                    this.prepareTempTables(conn, secTempTableName, values);
                                }
                                conn.voteCommitTransaction();
                                conn.endTransaction();
                            }
                            conn.beginTransaction();
                            estimatedRowNumber = filter.getEstimatedRowNumber();
                            UsageDescriptorAdapter.L.trace("calling {} with params {} ", (Object)procName, Arrays.asList(params));
                            resultHandler = conn.beginNonTransactionalStoredProc(procName, params, 200);
                            rowNumber = resultHandler.totalRowsCount();
                            if (rowNumber == null) {
                                rowNumber = estimatedRowNumber;
                            }
                            UsageDescriptorAdapter.L.trace("done call");
                            sm.worked(10);
                            sh = tempSHMap.get("RECORDSET");
                            this.fillState(sh, resultHandler, pi, tempParamForAdditionalSP, (IProgressMonitor)sm.newChild(70), rowNumber);
                            sm.setWorkRemaining(40);
                            resultHandler.close();
                            this.runAdditionalQueries(pi, tempSHMap, tempParamForAdditionalSP, (IProgressMonitor)sm.newChild(40), conn, estimatedRowNumber, filter);
                            if (tempParamForAdditionalSP != null) {
                                for (String key : tempParamForAdditionalSP.keySet()) {
                                    tempParamForAdditionalSP.put(key, null);
                                }
                            }
                            conn.voteCommitTransaction();
                            break block21;
                        }
                        catch (Exception e) {
                            UsageDescriptorAdapter.L.error("while fetching results", (Throwable)e);
                            GuiErrorLog.err(e.getMessage(), e);
                            conn.endTransaction();
                            if (tempTables == null || tempTables.size() <= 0) break block22;
                            conn.beginTransaction();
                            ** for (tbl : tempTables)
                        }
                    }
                    catch (Throwable var17_25) {
                        conn.endTransaction();
                        if (tempTables == null || tempTables.size() <= 0) break block23;
                        conn.beginTransaction();
                        ** for (tbl : tempTables)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            conn.executeUpdate("drop table " + tbl);
                        }
                        catch (Exception v0) {}
                        continue;
                    }
lbl61:
                    // 1 sources

                    conn.voteCommitTransaction();
                    conn.endTransaction();
                    break block22;
lbl-1000:
                    // 1 sources

                    {
                        try {
                            conn.executeUpdate("drop table " + tbl);
                        }
                        catch (Exception v1) {}
                        continue;
                    }
lbl74:
                    // 1 sources

                    conn.voteCommitTransaction();
                    conn.endTransaction();
                }
                throw var17_25;
            }
            conn.endTransaction();
            if (tempTables != null && tempTables.size() > 0) {
                conn.beginTransaction();
                for (String tbl : tempTables) {
                    try {
                        conn.executeUpdate("drop table " + tbl);
                    }
                    catch (Exception v2) {}
                }
                conn.voteCommitTransaction();
                conn.endTransaction();
            }
        }
    }

    private String addParamFromAliases(EZSourceConnection conn, String values) {
        String[] vals = values.split(",");
        String[][] pVals = new String[vals.length][1];
        int j = 0;
        String[] stringArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            pVals[j][0] = v.trim();
            ++j;
            ++n2;
        }
        String[][] results = null;
        if (j == 1) {
            String q = String.format("select DISTINCT AliasName from ProgramAliases where programID in   (select ProgramId from ProgramAliases where AliasName like '%s' )", values.trim());
            results = conn.executeSQL(q);
        } else if (j > 1) {
            ServerType dbengine = conn.getProjectInfo().getDbEngine();
            String tempTbl = Utils.getTempTableName((ServerType)dbengine, (String)"string_param_temp_aliases");
            String createTempSql = null;
            switch (dbengine) {
                case SqlServer: {
                    createTempSql = "create table " + tempTbl + " (name varchar(255))";
                    break;
                }
                case Db2Z: {
                    createTempSql = " DECLARE GLOBAL TEMPORARY TABLE " + tempTbl;
                    createTempSql = String.valueOf(createTempSql) + "( name VARGRAPHIC(255) NOT NULL) CCSID UNICODE ";
                    createTempSql = String.valueOf(createTempSql) + " ON COMMIT PRESERVE ROWS NOT LOGGED";
                    break;
                }
                case Db2: {
                    createTempSql = " DECLARE GLOBAL TEMPORARY TABLE " + tempTbl;
                    createTempSql = String.valueOf(createTempSql) + "( name VARGRAPHIC(255) NOT NULL) ";
                    createTempSql = String.valueOf(createTempSql) + " WITH REPLACE ON COMMIT PRESERVE ROWS NOT LOGGED ";
                    break;
                }
            }
            Assert.isNotNull(createTempSql);
            conn.executeUpdate(createTempSql);
            ArrayList<EZSourceDataType> param = new ArrayList<EZSourceDataType>();
            param.add(EZSourceDataType.String);
            conn.insertBatch(tempTbl, pVals, param);
            String q = String.format("select DISTINCT AliasName from ProgramAliases where programID in    (select ProgramId from ProgramAliases where AliasName   in (select * from %s ))", tempTbl);
            results = conn.executeSQL(q);
            conn.executeUpdate("drop table " + tempTbl);
        }
        if (results != null) {
            String[][] stringArray2 = results;
            int n3 = results.length;
            n = 0;
            while (n < n3) {
                String[] result = stringArray2[n];
                values = values.concat(", ".concat(result[0]));
                ++n;
            }
        }
        return values;
    }

    private void prepareTempTables(EZSourceConnection conn, String tempTableName, String values) {
        ServerType dbengine = conn.getProjectInfo().getDbEngine();
        String createTempSql = null;
        switch (dbengine) {
            case SqlServer: {
                createTempSql = "create table " + tempTableName + " (name varchar(255))";
                break;
            }
            case Db2Z: {
                createTempSql = " DECLARE GLOBAL TEMPORARY TABLE " + tempTableName;
                createTempSql = String.valueOf(createTempSql) + " ( name VARGRAPHIC(255) NOT NULL) ";
                createTempSql = String.valueOf(createTempSql) + " CCSID UNICODE ";
                createTempSql = String.valueOf(createTempSql) + " ON COMMIT PRESERVE ROWS NOT LOGGED ";
                break;
            }
            case Db2: {
                createTempSql = " DECLARE GLOBAL TEMPORARY TABLE " + tempTableName;
                createTempSql = String.valueOf(createTempSql) + " ( name VARGRAPHIC(255) NOT NULL) ";
                createTempSql = String.valueOf(createTempSql) + " WITH REPLACE ON COMMIT PRESERVE ROWS NOT LOGGED ";
                break;
            }
        }
        Assert.isNotNull(createTempSql);
        conn.executeUpdate(createTempSql);
        ArrayList<EZSourceDataType> param = new ArrayList<EZSourceDataType>();
        param.add(EZSourceDataType.String);
        String[] vals = values.split(",");
        String[][] pVals = new String[vals.length][1];
        int j = 0;
        String[] stringArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            pVals[j][0] = v.trim();
            ++j;
            ++n2;
        }
        conn.insertBatch(tempTableName, pVals, param);
    }

    protected Pair<String, String> createDynamicProc(ProjectInfo pInfo, IMFProjectHandler ph, FilterData filter, IProgressMonitor pmonitor) {
        SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        AbstractQueryBuilder qb = this.getQueryBuilder();
        Pair<String, String> spPair = qb.makeSP(this, pInfo, filter.getEntries());
        String procName = (String)spPair.getFirst();
        L.debug("procedure name: {}", (Object)procName);
        return spPair;
    }

    private void runAdditionalQueries(ProjectInfo pi, Map<String, SerializationHandler> tempSHMap, Map<String, List<Integer>> tempParamForAdditionalSP, IProgressMonitor pmonitor, EZSourceConnection conn, int estimatedRowNumber, FilterData filter) {
        if (pmonitor.isCanceled() || !this.mustRunAdditionalSP()) {
            return;
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)(10 * this.getAdditionalSpMap().size()));
        for (String key : this.getAdditionalSpMap().keySet()) {
            NonBlockingOperationHandle resultHandler;
            Integer rowNumber;
            StoredProcDetail spd = this.getAdditionalSpMap().get(key);
            String spName = spd.getSpName();
            L.debug("run stored procedure: {}", (Object)spName);
            String ci = spd.getParamType().getName();
            List<Integer> paramList = tempParamForAdditionalSP.get(ci);
            if (paramList == null) continue;
            ArrayList<EZSourceDataType> types = new ArrayList<EZSourceDataType>();
            Iterator<Integer> iterator = paramList.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                types.add(EZSourceDataType.Integer);
            }
            String[] procParam = null;
            List<Pair<ResultElementType, Integer>> ppe = spd.getProcParamEntries();
            if (ppe != null) {
                ArrayList<String> procParams = new ArrayList<String>();
                for (Pair<ResultElementType, Integer> pair : ppe) {
                    if (ResultElementType.FAKE_NON_FILTER_SP_PARAM.equals(pair.getFirst())) {
                        procParams.add(String.valueOf(pair.getSecond()));
                        continue;
                    }
                    FilterEntry entry = filter.getEntry((ResultElementType)pair.getFirst());
                    String value = entry.getValidAttribute((Integer)pair.getSecond());
                    String processedValue = (String)filter.processSQLParameter(value, entry.useTempTable()).getSecond();
                    procParams.add(processedValue);
                }
                procParam = procParams.toArray(new String[0]);
            }
            if ((rowNumber = (resultHandler = conn.beginNonTransactionalStoredProc(spName, procParam, types, paramList, 200)).totalRowsCount()) == null) {
                rowNumber = estimatedRowNumber;
            }
            SerializationHandler sh = tempSHMap.get(key);
            this.fillState(sh, resultHandler, pi, null, (IProgressMonitor)monitor.newChild(10), rowNumber);
            resultHandler.close();
        }
    }

    private void fillState(SerializationHandler sh, NonBlockingOperationHandle resultHandler, ProjectInfo pi, Map<String, List<Integer>> paramsToCollect, IProgressMonitor pmonitor) {
        this.fillState(sh, resultHandler, pi, paramsToCollect, pmonitor, 200);
    }

    protected void fillState(SerializationHandler sh, NonBlockingOperationHandle resultHandler, ProjectInfo pi, Map<String, List<Integer>> paramsToCollect, IProgressMonitor pmonitor, int estimatedRowNumber) {
        if (!pmonitor.isCanceled()) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
            monitor.setTaskName(Messages.getString(((Object)((Object)this)).getClass(), "compute.results", new String[]{pi.getName()}));
            L.trace("before load recordset");
            sh.write(resultHandler, pi, paramsToCollect, (IProgressMonitor)monitor.newChild(100), estimatedRowNumber);
            monitor.setWorkRemaining(0);
        }
    }

    public abstract String getDatabaseViewName();

    public abstract Map<String, String> getStoredProcedureWhereClause();

    public abstract Map<String, String> getStoredProcedureParam();

    public abstract Map<String, String> getStoredProcedureOrderBy();

    public Map<String, String> getStoredProcedureDetailsSelect() {
        return null;
    }

    protected abstract UsageStateAdapter createNewState();

    public abstract RowHeaderInfo getRowHeaderInfo();

    public abstract String getFileName();

    public Map<ResultElementType, String> getElemTypeToElemNameColumnsMap() {
        return this.elemTypeToElemNameColumns;
    }

    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        return null;
    }

    public ResultsTreeProvider getTreeProvider() {
        return this.resultsTreeProvider;
    }

    public boolean hasReorderResultsAction() {
        return true;
    }

    public Map<ResultElementType, Pair<String, List<ResultElementType>>> getCSVFileSuffixMap() {
        return this.csvFileSuffixMap;
    }

    public CsvExportDescriptor getCsvExportDescriptor() {
        return this.csvExportDescriptor;
    }

    public boolean hasManyProjects() {
        List prjList = (List)this.state.getData().get("PROJECT_LIST");
        return prjList != null && prjList.size() > 1;
    }

    protected abstract AbstractQueryBuilder getQueryBuilder();

    public int getDefaultExpandLevel() {
        return -1;
    }

    public String getProcedurePrefix() {
        return PROCEDURE_NAME_PREFIX;
    }

    public void cancel() {
        L.debug("canceled forced");
        if (this.monitor != null) {
            this.monitor.setCanceled(true);
        }
    }

    protected Map<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap() {
        return null;
    }

    public IBaseLabelProvider getResultsLabelProvider(ImageRegistry imgRegistry) {
        return new ResultsLabelProvider(imgRegistry);
    }

    public boolean mustRunAdditionalSP() {
        return this.getAdditionalSpMap() != null;
    }

    public Map<String, StoredProcDetail> getAdditionalSpMap() {
        return null;
    }

    public RecordsetProvider getRecordsetProvider(String key) {
        LinkedHashMap recordSetProviders = (LinkedHashMap)this.getState().getData().get("ALL_RECORDSETS");
        return recordSetProviders != null ? (RecordsetProvider)recordSetProviders.get(key) : null;
    }

    protected boolean useCache() {
        return false;
    }

    public void setEnableLimits(Boolean enableLimits) {
        if (enableLimits == null) {
            IPreferenceStore store = PreferencesUtils.getPreferenceStore();
            enableLimits = store.getBoolean("limit query results");
        }
        this.state.getData().put("EnableLimitsState", enableLimits);
    }

    public boolean isEnableLimits() {
        Boolean enableState = (Boolean)this.state.getData().get("EnableLimitsState");
        if (enableState == null) {
            L.warn("enableLimits not set, use limits from preferences: {}", (Object)enableState);
            this.setEnableLimits(enableState);
            return (Boolean)this.state.getData().get("EnableLimitsState");
        }
        return enableState;
    }

    public boolean hasAnnotationsFilterAction() {
        return true;
    }

    public void dispose() {
        if (this.viewer != null) {
            this.viewer.close();
        }
    }

    public List<ResultElementType> computeLevelsOrder() {
        ArrayList<ResultElementType> elementTypes = (ArrayList<ResultElementType>)this.getState().getData().get("LEVELS_ORDER");
        if (elementTypes == null) {
            elementTypes = new ArrayList<ResultElementType>();
            FilterData fd = (FilterData)this.getState().getData().get("FilterData");
            List<FilterEntry> entries = fd.getEntries();
            for (FilterEntry entry : entries) {
                if (!entry.isEntryInUse()) continue;
                String type = entry.get("filterEntryName");
                elementTypes.add(ResultElementType.valueOfName((String)type));
            }
            this.completeLevelsOrderWithProjectLvl(elementTypes);
            this.addLevelNotInFilter(elementTypes);
        }
        return elementTypes;
    }

    private void completeLevelsOrderWithProjectLvl(List<ResultElementType> list) {
        if (list.contains(ResultElementType.PROJECT_INFO) && !this.hasManyProjects()) {
            list.remove(ResultElementType.PROJECT_INFO);
        }
        if (!list.contains(ResultElementType.PROJECT_INFO) && this.hasManyProjects()) {
            list.add(0, ResultElementType.PROJECT_INFO);
        }
    }

    protected void addLevelNotInFilter(List<ResultElementType> list) {
    }
}

