/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.adapters;

import com.ez.analysis.mainframe.db.FormatInfo;
import com.ez.analysis.mainframe.db.ProcessRowCallbackInterface;
import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.serialization.Deserializer;
import com.ez.analysis.mainframe.serialization.Serializer;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.ezdao.api.NonBlockingOperationHandle;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.preferences.Utils;
import com.ez.workspace.utils.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(SerializationHandler.class);
    private File file;
    private Map<String, ProjectInfo> infos;
    private int rows;
    private RowHeaderInfo headerInfo;
    private FormatInfo fi;
    private boolean disposed;
    private RowMangler rowMangler;

    public static File getFile() {
        File folder = new File(String.valueOf(Utils.getTemporaryFolder()) + File.separator + "usage" + File.separator);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File file = new File(folder, "f" + Math.random());
        while (file.exists()) {
            file = new File(folder, "f" + Math.random());
        }
        return file;
    }

    public SerializationHandler(File file, RowHeaderInfo headerInfo, FormatInfo fi) {
        this(file, headerInfo, fi, null);
    }

    public SerializationHandler(File file, RowHeaderInfo headerInfo, FormatInfo fi, RowMangler rowMangler) {
        this.headerInfo = headerInfo;
        this.fi = fi;
        this.file = file;
        this.infos = new HashMap<String, ProjectInfo>();
        this.rowMangler = rowMangler;
    }

    public synchronized int getRows() {
        if (this.disposed) {
            throw new IllegalStateException("Already disposed.");
        }
        return this.rows;
    }

    public synchronized void write(NonBlockingOperationHandle resultHandler, ProjectInfo pi, Map<String, List<Integer>> paramsToCollect, IProgressMonitor pMonitor, int estimatedRowNumber) {
        if (this.disposed) {
            throw new IllegalStateException("Already disposed.");
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)(estimatedRowNumber + 100));
        HashMap<String, ProjectInfo> infos = new HashMap<String, ProjectInfo>();
        int records = 0;
        L.trace("file " + this.file + " is for prj: " + pi.getName());
        if (resultHandler != null) {
            try {
                BufferedOutputStream oos = null;
                boolean append = this.file.exists() && this.file.length() > 0L;
                this.infos.put(pi.getName(), pi);
                oos = new BufferedOutputStream(new FileOutputStream(this.file, append));
                try (Serializer se = new Serializer(this.headerInfo, this.fi, append, oos);){
                    long start = System.currentTimeMillis();
                    int idx = 0;
                    monitor.setWorkRemaining(estimatedRowNumber);
                    block11: while (!monitor.isCanceled()) {
                        if (!resultHandler.dataAvailable()) {
                            if (resultHandler.finished()) break;
                            try {
                                Thread.sleep(10L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                L.debug("while sleeping", (Throwable)e);
                                break;
                            }
                        }
                        for (String[] rawRow : resultHandler.getAvailableData()) {
                            if (this.rowMangler != null) {
                                rawRow = this.rowMangler.mangle(rawRow);
                            }
                            Row row = Row.load(rawRow, this.headerInfo, this.fi, pi.getName());
                            this.collectParams(row, paramsToCollect);
                            row.setProjectInfo(pi);
                            se.write(row);
                            infos.put(pi.getName(), pi);
                            ++this.rows;
                            if (++records % 1000 == 0) {
                                monitor.setTaskName(Messages.getString(SerializationHandler.class, "fetched.records.text", new String[]{String.valueOf(records)}));
                            }
                            if (monitor.isCanceled()) continue block11;
                            if (++idx >= estimatedRowNumber) continue;
                            monitor.worked(1);
                            idx = 0;
                        }
                    }
                    L.trace("load and save recordset (size=" + records + ") in " + (System.currentTimeMillis() - start) + " ms");
                }
                finally {
                    ((OutputStream)oos).close();
                }
            }
            catch (FileNotFoundException e) {
                L.error("error at loading objects", (Throwable)e);
            }
            catch (IOException e) {
                L.error("error at loading objects", (Throwable)e);
            }
        }
    }

    private void collectParams(Row row, Map<String, List<Integer>> paramsToCollect) {
        if (paramsToCollect == null) {
            return;
        }
        for (String cname : paramsToCollect.keySet()) {
            Integer value = (Integer)row.getColumnValue(cname);
            if (value == null) {
                L.debug("current raw has null value for column " + cname);
                continue;
            }
            List<Integer> params = paramsToCollect.get(cname);
            if (params == null) {
                params = new ArrayList<Integer>();
                paramsToCollect.put(cname, params);
            }
            if (params.contains(value)) continue;
            params.add(value);
        }
    }

    public synchronized void read(ProcessRowCallbackInterface callback, IProgressMonitor pMonitor) {
        if (this.disposed) {
            throw new IllegalStateException("Already disposed.");
        }
        if (this.file.exists()) {
            int rowIndex = 0;
            boolean continueProcess = true;
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)-1);
            try {
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.file));){
                    Deserializer de = new Deserializer(this.headerInfo, this.fi, is);
                    try {
                        while (continueProcess) {
                            Row r = de.read();
                            if (r == null) {
                                break;
                            }
                            r.setProjectInfo(this.infos.get(r.getProjectName()));
                            continueProcess = callback.processRow(r, rowIndex, (IProgressMonitor)monitor);
                            ++rowIndex;
                        }
                    }
                    finally {
                        de.close(false);
                    }
                }
                catch (Exception e) {
                    L.error("error when read file " + this.file + " (rowIndex=" + rowIndex + ")", (Throwable)e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    public void dispose() {
        block8: {
            if (this.infos != null) {
                this.infos.clear();
                this.infos = null;
            }
            if (this.file != null && this.file.exists()) {
                L.debug("dispose(); trying to delete temp file " + this.file);
                try {
                    try {
                        boolean del = this.file.delete();
                        if (!del) {
                            L.warn("File " + this.file + " cannot be deleted; is marked to be removed when JVM closes");
                            this.file.deleteOnExit();
                        }
                    }
                    catch (Exception ex) {
                        L.warn("Cannot delete temp file " + this.file, (Throwable)ex);
                        this.file = null;
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.file = null;
                    throw throwable;
                }
                this.file = null;
            }
        }
        this.disposed = true;
    }

    public SerializationHandler getClone() {
        File cloneFile = SerializationHandler.getFile();
        try {
            FileUtils.copyFileUsingStream((File)this.file, (File)cloneFile);
        }
        catch (IOException iOException) {
            L.warn("cannot replicate results for duplicated usage");
        }
        SerializationHandler clone = new SerializationHandler(cloneFile, this.headerInfo, FormatInfo.getDefault());
        clone.infos.putAll(this.infos);
        return clone;
    }

    public static interface RowMangler {
        public String[] mangle(String[] var1);
    }
}

