/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.adapters;

import com.ez.analysis.mainframe.usage.adapters.RecordsetProviderImpl;
import com.ez.analysis.mainframe.usage.adapters.SerializationHandler;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import java.util.LinkedHashMap;

public class RecordsetProviderBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String RECORDSET = "RECORDSET";
    public static final String ALL_RECORDSETS = "ALL_RECORDSETS";
    private LinkedHashMap<String, RecordsetProvider> map = new LinkedHashMap();
    private boolean singleton = false;
    private boolean built = false;

    public void setRecordset(SerializationHandler sh) {
        if (this.built) {
            throw new IllegalStateException("Already built.");
        }
        if (this.map.size() > 0) {
            throw new IllegalStateException("Builder already in multi recordset mode (addRecordset() called before)");
        }
        if (sh == null) {
            throw new IllegalArgumentException("sh is null");
        }
        this.map.put(RECORDSET, new RecordsetProviderImpl(sh));
        this.singleton = true;
    }

    public void addRecordset(String key, SerializationHandler sh) {
        if (this.built) {
            throw new IllegalStateException("Already built.");
        }
        if (this.singleton) {
            throw new IllegalStateException("Recordset already set.");
        }
        if (sh == null) {
            throw new IllegalArgumentException("sh is null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (this.map.containsKey(key)) {
            throw new IllegalArgumentException("Key already added: " + key);
        }
        this.map.put(key, new RecordsetProviderImpl(sh));
    }

    public LinkedHashMap<String, RecordsetProvider> build() {
        LinkedHashMap<String, RecordsetProvider> r = this.map;
        this.map = null;
        this.built = true;
        return r;
    }
}

