/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.adapters;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.GroupFilterEntry;
import com.ez.analysis.mainframe.usage.queries.ProgramIdsIntersectionQueryBuilder;
import com.ez.ezsource.connection.ServerType;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.ProjectInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FilterData {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(FilterData.class);
    public static final String INCONTEXT_KEY = "incontext";
    protected List<FilterEntry> entries;
    protected boolean canSkipFilterEntry = true;

    protected FilterEntry makeFilterEntry(ResultElementType type, Map<ResultElementType, StringBuilder> defaultPatterns, Integer limitFromPreferences) {
        String pattern = "";
        if (defaultPatterns != null && defaultPatterns.containsKey(type) && !(pattern = defaultPatterns.get(type).toString()).contains(",")) {
            pattern = Utils.escapeForDbLikeValueExactMatch((String)pattern);
        }
        FilterEntry e = new FilterEntry(type, pattern, limitFromPreferences);
        this.makeFilterEntrySettings(e, type);
        return e;
    }

    protected void makeFilterEntrySettings(FilterEntry e, ResultElementType type) {
    }

    protected void addColumnsForStmt(FilterEntry e) {
        e.put(DatabaseMetadata.STMT_DESC.getName(), DatabaseMetadata.STMT_DESC.getName());
        e.put("DynamicProcParamName", "@StatementType");
        this.addMandatoryColumns(e);
    }

    protected void addMandatoryColumns(FilterEntry e) {
        e.put(DatabaseMetadata.STMT_START_ROW.getName(), DatabaseMetadata.STMT_START_ROW.getName());
        e.put(DatabaseMetadata.PRG_TYPE_ID.getName(), DatabaseMetadata.PRG_TYPE_ID.getName());
        e.put(DatabaseMetadata.STMT_PATH_STR.getName(), DatabaseMetadata.STMT_PATH_STR.getName());
        e.put(DatabaseMetadata.STMT_START_COL.getName(), DatabaseMetadata.STMT_START_COL.getName());
        e.put(DatabaseMetadata.STMT_END_ROW.getName(), DatabaseMetadata.STMT_END_ROW.getName());
        e.put(DatabaseMetadata.STMT_END_COL.getName(), DatabaseMetadata.STMT_END_COL.getName());
    }

    public List<String> getParameters(Map<String, FilterEntryParameterGenerator> filterEntryParameterGeneratorMap, ServerType dbEngine) {
        ArrayList<String> procParamsList = new ArrayList<String>();
        int tempTableNumber = 0;
        for (FilterEntry e : this.entries) {
            if (!e.isEntryInUse()) continue;
            if (filterEntryParameterGeneratorMap == null || filterEntryParameterGeneratorMap.get(e.get("filterEntryName")) == null) {
                String value = null;
                if (e.canModify(3)) {
                    value = e.getValidAttribute(3);
                }
                if (value != null) {
                    procParamsList.add(String.valueOf(Integer.valueOf(value)));
                }
                if (e.isComboEntry()) {
                    L.trace("process a combo entry");
                    procParamsList.add(e.getComboValue());
                    continue;
                }
                String v = e.isDialogTextEntry() ? e.getDialogTextValue() : e.getValidAttribute(2);
                Pair<Boolean, String> process = this.processSQLParameter(v, e.useTempTable());
                tempTableNumber = this.processParam(process, e, tempTableNumber, procParamsList, dbEngine);
                continue;
            }
            FilterEntryParameterGenerator filterEntryParameterGenerator = filterEntryParameterGeneratorMap.get(e.get("filterEntryName"));
            List<String> toProcess = filterEntryParameterGenerator.addParameters(this, procParamsList, e);
            int j = 0;
            for (String entries : toProcess) {
                Pair<Boolean, String> processEntry = this.processSQLParameter(entries, e.useTempTable());
                tempTableNumber = this.processParam(processEntry, e, tempTableNumber, procParamsList, j != 0, dbEngine);
                ++j;
            }
        }
        return procParamsList;
    }

    public int processParam(Pair<Boolean, String> process, FilterEntry e, int tempTableNumber, List<String> procParamsList, ServerType dbEngine) {
        return this.processParam(process, e, tempTableNumber, procParamsList, false, dbEngine);
    }

    public int processParam(Pair<Boolean, String> process, FilterEntry e, int tempTableNumber, List<String> procParamsList, boolean isSecond, ServerType dbEngine) {
        String tempTableValuesKey;
        String likeOrInMarker = isSecond ? "LIKE_OR_IN_SECOND" : "LIKE_OR_IN";
        String tempTableNameKey = isSecond ? "TempTableNameSecond" : "TempTableName";
        String string = tempTableValuesKey = isSecond ? "TempTableValuesSecond" : "TempTableValues";
        if (e.useTempTable() && ((Boolean)process.getFirst()).booleanValue() || ((Boolean)process.getFirst()).booleanValue()) {
            String inClause = ProgramIdsIntersectionQueryBuilder.getLIKE_OR_IN(dbEngine)[1];
            inClause = inClause.replaceAll("x", String.valueOf(tempTableNumber));
            e.put(likeOrInMarker, inClause);
            procParamsList.add("");
            e.put(tempTableNameKey, Utils.getTempTableName((ServerType)dbEngine, (String)("string_param_temp_" + tempTableNumber)));
            e.put(tempTableValuesKey, (String)process.getSecond());
            ++tempTableNumber;
        } else {
            String parameterNameKey = isSecond ? "DynamicProcParamNameSecond" : "DynamicProcParamName";
            e.put(likeOrInMarker, String.valueOf(ProgramIdsIntersectionQueryBuilder.getLIKE_OR_IN(dbEngine)[0]) + e.get(parameterNameKey));
            procParamsList.add((String)process.getSecond());
            e.put(tempTableNameKey, null);
            e.put(tempTableValuesKey, null);
        }
        return tempTableNumber;
    }

    public int getEstimatedRowNumber() {
        int number = 1;
        HashMap<GroupFilterEntry, Integer> gFENrMap = new HashMap<GroupFilterEntry, Integer>();
        for (FilterEntry e : this.entries) {
            if (!e.isEntryInUse()) continue;
            GroupFilterEntry gfe = e.getGroupFilterEntry();
            if (gfe == null) {
                gfe = new GroupFilterEntry();
            }
            String value = e.getValidAttribute(3);
            Integer nrPerGroup = null;
            if (value != null && !value.isEmpty()) {
                nrPerGroup = Integer.valueOf(value);
            }
            if (nrPerGroup == null) {
                nrPerGroup = 200;
            }
            if (gFENrMap.containsKey(gfe)) {
                nrPerGroup = nrPerGroup + (Integer)gFENrMap.get(gfe);
            }
            gFENrMap.put(gfe, nrPerGroup);
        }
        Iterator<FilterEntry> iterator = gFENrMap.values().iterator();
        while (iterator.hasNext()) {
            int value = (Integer)((Object)iterator.next());
            number *= value;
        }
        int min = 50000;
        number = number < min ? min : number;
        int max = 500000;
        number = number > max ? max : number;
        return number;
    }

    public static boolean acceptType(List<ResultElementType> paramTypes, FilterEntry e) {
        String name = e.get("filterEntryName");
        for (ResultElementType type : paramTypes) {
            if (!type.name().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public List<FilterEntry> getEntries() {
        return this.entries;
    }

    public boolean isCanSkipFilterEntry() {
        return this.canSkipFilterEntry;
    }

    public Pair<Boolean, String> processSQLParameter(String parameter, boolean useTempTable) {
        String result = new String("%");
        boolean isMultipleInputs = true;
        if (parameter != null && !parameter.isEmpty()) {
            if (parameter.contains(",") || parameter.contains(":") && useTempTable) {
                result = parameter;
            } else {
                result = Utils.convertDbLikeValue((String)parameter, (boolean)true);
                isMultipleInputs = useTempTable;
            }
        } else {
            isMultipleInputs = false;
        }
        return new Pair((Object)isMultipleInputs, (Object)result.toUpperCase());
    }

    public String createShortenedSummary(boolean enableLimits, int maxLength, List<ProjectInfo> selectedProjects) {
        StringBuilder sBuilderFiltersPart = new StringBuilder();
        for (FilterEntry filterEntry : this.entries) {
            String entryStr;
            if (!filterEntry.isEntryInUse() || (entryStr = filterEntry.toDisplay(enableLimits)) == null || entryStr.length() <= 0) continue;
            sBuilderFiltersPart.append(entryStr);
            sBuilderFiltersPart.append(" ");
        }
        if (sBuilderFiltersPart.length() > 1) {
            sBuilderFiltersPart.deleteCharAt(sBuilderFiltersPart.length() - 1);
        }
        StringBuilder prjStr = new StringBuilder();
        if (selectedProjects != null) {
            Iterator<ProjectInfo> it = selectedProjects.iterator();
            while (it.hasNext() && prjStr.length() < maxLength) {
                prjStr.append(it.next().getName());
                if (!it.hasNext()) continue;
                prjStr.append(", ");
            }
        } else {
            L.debug("projects list is empty!");
        }
        if (prjStr.length() > maxLength && selectedProjects.size() > 1) {
            prjStr = new StringBuilder();
            prjStr.append(selectedProjects.get(0).getName());
            prjStr.append("...");
        }
        return Messages.getString(FilterData.class, "shortedSummary", new String[]{prjStr.toString(), sBuilderFiltersPart.toString()});
    }

    public String createFullSummaryFormatted(boolean enableLimits, List<ProjectInfo> selectedProjects) {
        StringBuilder sBuilder = new StringBuilder();
        if (selectedProjects != null) {
            for (ProjectInfo projectInfo : selectedProjects) {
                sBuilder.append(projectInfo.getName());
                sBuilder.append(", ");
            }
            if (sBuilder.length() > 2) {
                sBuilder.delete(sBuilder.length() - 2, sBuilder.length());
            }
        } else {
            L.debug("projects list is empty!");
        }
        StringBuilder sBuilder2 = new StringBuilder();
        for (FilterEntry filterEntry : this.entries) {
            String entryStr;
            if (!filterEntry.isEntryInUse() || (entryStr = filterEntry.toDisplay(enableLimits)) == null || entryStr.length() <= 0) continue;
            sBuilder2.append("\n" + entryStr);
        }
        return Messages.getString(FilterData.class, "fullSummaryFormatted", new String[]{sBuilder.toString(), sBuilder2.toString()});
    }

    public String createFullSummary(boolean enableLimits, boolean usePrjInfo, List<ProjectInfo> selectedProjects) {
        StringBuilder sBuilder = new StringBuilder();
        if (usePrjInfo && selectedProjects != null) {
            for (ProjectInfo projectInfo : selectedProjects) {
                sBuilder.append(projectInfo.getName());
                sBuilder.append(", ");
            }
            if (sBuilder.length() > 2) {
                sBuilder.delete(sBuilder.length() - 2, sBuilder.length());
            }
        }
        StringBuilder sBuilder2 = new StringBuilder();
        boolean hasFilter = false;
        for (FilterEntry filterEntry : this.entries) {
            if (!filterEntry.isEntryInUse()) continue;
            String entryStr = filterEntry.toDisplay(enableLimits);
            if (entryStr != null && entryStr.length() > 0) {
                sBuilder2.append(entryStr);
                sBuilder2.append(" ");
            }
            hasFilter = true;
        }
        if (hasFilter) {
            return sBuilder.length() > 0 ? Messages.getString(FilterData.class, "fullSummary.longformat", new String[]{sBuilder.toString(), sBuilder2.toString().trim()}) : Messages.getString(FilterData.class, "fullSummary.shortformat", new String[]{sBuilder2.toString().trim()});
        }
        return null;
    }

    public void completeWithSpecificParameters(List<String> paramsList) {
    }

    public FilterEntry getEntry(ResultElementType entryType) {
        for (FilterEntry e : this.entries) {
            if (!entryType.name().equals(e.get("filterEntryName"))) continue;
            return e;
        }
        return null;
    }

    public static String getResElemTypeMarker(String ret, String ... likeOrInConstant) {
        String prefix = "LIKE_OR_IN";
        if (likeOrInConstant != null && likeOrInConstant.length > 0) {
            prefix = likeOrInConstant[0];
        }
        return String.valueOf(prefix) + ret + "ez";
    }

    public static String getResElemTypeMarker(ResultElementType ret, String ... likeOrInConstant) {
        return FilterData.getResElemTypeMarker(ret.name(), likeOrInConstant);
    }
}

