/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.adabas;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.ResultsTreeProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.ProgramUtils;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.gui.properties.StmtSourceInfoNode;
import com.ez.mainframe.model.ProjectInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class AdabasTreeProvider
extends ResultsTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public AdabasTreeProvider(UsageDescriptorAdapter descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void buildResultsTree(ResultElement root, RecordsetProvider rsProvider, IProgressMonitor monitor) {
        List<ResultElementType> levelsOrder = this.getLevelsOrder();
        Map<ResultElementType, String> elemTypeToElemNameColumnsMap = this.descriptor.getElemTypeToElemNameColumnsMap();
        MyCallback callback = new MyCallback(root, levelsOrder, elemTypeToElemNameColumnsMap);
        rsProvider.load(callback, monitor);
    }

    @Override
    protected boolean isTreeLevelOrderSameAsFiltersOrder() {
        return this.defaultIsTreeLevelOrderSameAsFiltersOrder();
    }

    @Override
    protected Set<ResultElementType> getLevelsWithCategoriesAndLimit() {
        HashSet<ResultElementType> ret = new HashSet<ResultElementType>();
        ret.add(ResultElementType.PROGRAM);
        return ret;
    }

    class MyCallback
    extends AbstractProcessRowCallback {
        private static final String NOT_AVAILABLE_LABEL = "N/A";

        public MyCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            int levelIndex = 0;
            while (levelIndex <= this.levelsOrder.size()) {
                if (levelIndex < this.levelsOrder.size()) {
                    String name;
                    ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                    String key = name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                    if (levelElementType.equals((Object)ResultElementType.PROGRAM)) {
                        Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                        if (id != null) {
                            key = id.toString().concat(name);
                        }
                        parent = ProgramUtils.getOrCreateCategoryForProgram(r, parent, name);
                    } else if (levelElementType.equals((Object)ResultElementType.ADABAS_VIEW)) {
                        if (name.isEmpty()) {
                            name = NOT_AVAILABLE_LABEL;
                        } else {
                            String natview = Utils.null2empty(r.getColumnValue(DatabaseMetadata.ADABAS_NATURAL_VIEW.getName()));
                            name = natview.isEmpty() ? name : String.valueOf(name) + "(" + natview + ")";
                            String viewSource = Utils.null2empty(r.getColumnValue(DatabaseMetadata.ADABAS_VIEW_SOURCE.getName()));
                            name = viewSource.isEmpty() ? name : String.valueOf(name) + "(" + viewSource + ")";
                        }
                    } else if (levelElementType.equals((Object)ResultElementType.ADABAS_FILE)) {
                        if (name.isEmpty()) {
                            name = NOT_AVAILABLE_LABEL;
                        }
                    } else if (levelElementType.equals((Object)ResultElementType.ADABAS_DB) && name.isEmpty()) {
                        name = NOT_AVAILABLE_LABEL;
                    }
                    ResultElement resultElement = parent.getChild(key);
                    if (resultElement == null) {
                        resultElement = new ResultElement(name, levelElementType, parent);
                        this.addElementInfo(resultElement, r);
                        Utils.completeProjectInfo(resultElement, projectInfo);
                        parent.addChild(key, resultElement);
                    }
                    AdabasTreeProvider.this.checkLimitReached(levelElementType, this.root, parent);
                    parent = resultElement;
                } else if (levelIndex == this.levelsOrder.size()) {
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(ResultElementType.STMT_SOURCE_INFO);
                    String prgName = Utils.null2empty(r.getColumnValue(elemNameColumn));
                    ResultElement resultElement = new ResultElement(prgName, ResultElementType.STMT_SOURCE_INFO, parent);
                    Utils.completeProjectInfo(resultElement, projectInfo);
                    this.addElementInfo(resultElement, r);
                    parent.addChild(resultElement.getDisplayName(), resultElement);
                }
                ++levelIndex;
            }
            return true;
        }

        private void addElementInfo(ResultElement resultElement, Row r) {
            String name = null;
            switch (resultElement.getType()) {
                case ADABAS_DB: {
                    name = (String)r.getColumnValue(DatabaseMetadata.ADABAS_DB.getName());
                    if (NOT_AVAILABLE_LABEL.equals(name) || name == null) {
                        resultElement.addProperty("adabasNotAvailable", Boolean.TRUE);
                    } else {
                        resultElement.addProperty(DatabaseMetadata.ADABAS_DB.getName(), name);
                    }
                    if (name == null) break;
                    resultElement.addProperty("Node_Mainframe", new GenericProgramRelatedNode(name, ResultElementType.ADABAS_DB.getDisplayName()));
                    break;
                }
                case ADABAS_FILE: {
                    Integer fileid = (Integer)r.getColumnValue(DatabaseMetadata.ADABAS_FILE_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.ADABAS_FILE_ID.getName(), fileid);
                    name = (String)r.getColumnValue(DatabaseMetadata.ADABAS_FILE.getName());
                    if (name == null || NOT_AVAILABLE_LABEL.equals(name)) {
                        resultElement.addProperty("adabasNotAvailable", Boolean.TRUE);
                    } else {
                        resultElement.addProperty(DatabaseMetadata.ADABAS_FILE.getName(), name);
                    }
                    if (name == null) break;
                    resultElement.addProperty("Node_Mainframe", new GenericProgramRelatedNode(name, ResultElementType.ADABAS_FILE.getDisplayName()));
                    break;
                }
                case ADABAS_VIEW: {
                    name = (String)r.getColumnValue(DatabaseMetadata.ADABAS_VIEW.getName());
                    if (name == null || NOT_AVAILABLE_LABEL.equals(name)) {
                        resultElement.addProperty("adabasNotAvailable", Boolean.TRUE);
                    } else {
                        resultElement.addProperty(DatabaseMetadata.ADABAS_VIEW.getName(), name);
                        String vPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.ADABAS_VIEW_PATH.getName()));
                        if (!vPath.isEmpty()) {
                            Integer vStartRow = (Integer)r.getColumnValue(DatabaseMetadata.ADABAS_VIEW_START_ROW.getName());
                            Integer vStartCol = (Integer)r.getColumnValue(DatabaseMetadata.ADABAS_VIEW_START_COL.getName());
                            Utils.setFileAttribute(resultElement, String.valueOf(3), vPath, vStartRow, vStartCol);
                        }
                    }
                    if (name == null) break;
                    resultElement.addProperty("Node_Mainframe", new GenericProgramRelatedNode(name, ResultElementType.ADABAS_VIEW.getDisplayName()));
                    break;
                }
                case PROGRAM: {
                    Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.PRG_ID.getName(), id);
                    Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                    resultElement.addProperty("Program Type Id", programTypeId);
                    resultElement.addProperty("Ancestor Name", r.getColumnValue(DatabaseMetadata.PRG_ANCESTOR.getName()));
                    String programPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_PATH.getName()));
                    resultElement.addProperty(DatabaseMetadata.PRG_PATH.getName(), programPath);
                    Integer prgStartRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_ROW.getName());
                    Integer prgStartCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_COL.getName());
                    Integer prgEndRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_ROW.getName());
                    Integer prgEndCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_COL.getName());
                    String programType = com.ez.mainframe.data.utils.Utils.getPrgType((String)programTypeId.toString());
                    ProgramUtils.setPropertiesViewer(resultElement, "", programPath, programType);
                    Utils.setFileAttribute(resultElement, programTypeId.toString(), programPath, prgStartRow, prgStartCol, prgEndRow, prgEndCol);
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                    break;
                }
                case STMT_SOURCE_INFO: {
                    Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                    resultElement.addProperty("Program Type Id", programTypeId);
                    String stmtTypeName = (String)r.getColumnValue(DatabaseMetadata.STMT_DESC.getName());
                    String prgType = com.ez.mainframe.data.utils.Utils.getPrgType((String)programTypeId.toString());
                    String stmtPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.STMT_PATH_STR.getName()));
                    resultElement.addProperty(DatabaseMetadata.STMT_PATH_STR.getName(), stmtPath);
                    Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_ROW.getName());
                    resultElement.addProperty("Stmt Start Row", startRow);
                    Integer startCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_COL.getName());
                    Integer endRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_END_ROW.getName());
                    Integer endCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_END_COL.getName());
                    Utils.setFileAttribute(resultElement, programTypeId.toString(), stmtPath, startRow, startCol, endRow, endCol);
                    resultElement.addProperty("Node_Mainframe", new StmtSourceInfoNode(stmtPath, stmtTypeName, prgType));
                    break;
                }
                case PROJECT_INFO: {
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                }
            }
        }
    }
}

