/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.adabas;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.validation.IntRangePreferenceValidator;
import com.ez.analysis.mainframe.usage.ui.StmtDialogTextCellEditor;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.Map;

public class AdabasFilter
extends FilterData {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final int DEFAULT_LIMIT_VALUE = 50;

    public AdabasFilter(Map<ResultElementType, StringBuilder> defaultPatterns) {
        int limit = 50;
        IntRangePreferenceValidator limitValidator = new IntRangePreferenceValidator(50, null, 0, "ADABASUsageADABASLimit", 0);
        this.entries = new ArrayList();
        FilterEntry e = this.makeFilterEntry(ResultElementType.ADABAS_DB, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@AdabasDB");
        e.setValidator(3, limitValidator);
        this.addColumnsForAdabasDB(e);
        this.entries.add(e);
        e = this.makeFilterEntry(ResultElementType.ADABAS_FILE, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@AdabasFile");
        e.setValidator(3, limitValidator);
        this.addColumnsForAdabasFile(e);
        this.entries.add(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "ADABASUsageADABASViewLimit", 0);
        e = this.makeFilterEntry(ResultElementType.ADABAS_VIEW, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@AdabasViewName");
        e.setValidator(3, limitValidator);
        this.addColumnsForAdabasView(e);
        this.entries.add(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "ADABASUsageProgramLimit", 0);
        e = this.makeFilterEntry(ResultElementType.PROGRAM, defaultPatterns, limit);
        e.put("must search aliases", Boolean.toString(true));
        e.put("DynamicProcParamName", "@Program");
        e.put("DynamicProcParamNameSecond", "@Ancestor");
        e.setValidator(3, limitValidator);
        this.addColumnsForProgram(e);
        this.entries.add(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "ADABASUsageStmtTypeLimit", 0);
        e = this.makeFilterEntry(ResultElementType.STMT_TYPE, defaultPatterns, limit);
        e.put("entry is a text field and opens a dialog for the list of values", Boolean.toString(true));
        e.put("DynamicProcParamName", "@StatementType");
        e.put(FilterEntry.ENTRY_ATTRIBUTES[2], StmtDialogTextCellEditor.DEFAULT_ALLSTMT);
        e.setValidator(3, limitValidator);
        this.addColumnsForStmt(e);
        this.entries.add(e);
    }

    private void addColumnsForAdabasFile(FilterEntry e) {
        e.put(DatabaseMetadata.ADABAS_FILE.getName(), DatabaseMetadata.ADABAS_FILE.getName());
        e.put(DatabaseMetadata.ADABAS_FILE_ID.getName(), DatabaseMetadata.ADABAS_FILE_ID.getName());
        this.addMandatoryColumns(e);
    }

    private void addColumnsForAdabasDB(FilterEntry e) {
        e.put(DatabaseMetadata.ADABAS_DB.getName(), DatabaseMetadata.ADABAS_DB.getName());
        this.addMandatoryColumns(e);
    }

    private void addColumnsForAdabasView(FilterEntry e) {
        e.put(DatabaseMetadata.ADABAS_VIEW.getName(), DatabaseMetadata.ADABAS_VIEW.getName());
        e.put(DatabaseMetadata.ADABAS_NATURAL_VIEW.getName(), DatabaseMetadata.ADABAS_NATURAL_VIEW.getName());
        e.put(DatabaseMetadata.ADABAS_VIEW_PATH.getName(), DatabaseMetadata.ADABAS_VIEW_PATH.getName());
        e.put(DatabaseMetadata.ADABAS_VIEW_SOURCE.getName(), DatabaseMetadata.ADABAS_VIEW_SOURCE.getName());
        e.put(DatabaseMetadata.ADABAS_VIEW_START_ROW.getName(), DatabaseMetadata.ADABAS_VIEW_START_ROW.getName());
        e.put(DatabaseMetadata.ADABAS_VIEW_START_COL.getName(), DatabaseMetadata.ADABAS_VIEW_START_COL.getName());
        this.addMandatoryColumns(e);
    }

    private void addColumnsForProgram(FilterEntry e) {
        e.put(DatabaseMetadata.PRG_ID.getName(), DatabaseMetadata.PRG_ID.getName());
        e.put(DatabaseMetadata.PRG_NAME.getName(), DatabaseMetadata.PRG_NAME.getName());
        e.put(DatabaseMetadata.PRG_PATH.getName(), DatabaseMetadata.PRG_PATH.getName());
        e.put(DatabaseMetadata.PRG_START_ROW.getName(), DatabaseMetadata.PRG_START_ROW.getName());
        e.put(DatabaseMetadata.PRG_START_COL.getName(), DatabaseMetadata.PRG_START_COL.getName());
        e.put(DatabaseMetadata.PRG_END_ROW.getName(), DatabaseMetadata.PRG_END_ROW.getName());
        e.put(DatabaseMetadata.PRG_END_COL.getName(), DatabaseMetadata.PRG_END_COL.getName());
        this.addMandatoryColumns(e);
        e.put(DatabaseMetadata.PRG_ANCESTOR.getName(), DatabaseMetadata.PRG_ANCESTOR.getName());
    }
}

