/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.adabas;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adabas.AdabasFilter;
import com.ez.analysis.mainframe.usage.adabas.AdabasTreeProvider;
import com.ez.analysis.mainframe.usage.adabas.AdabasUsageAnalysis;
import com.ez.analysis.mainframe.usage.adabas.State;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.FilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.all.ProgramWithAncestorFilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.analysis.mainframe.usage.rank.DenseRankDescriptorAdapter;
import com.ez.analysis.mainframe.usage.rank.DenseRankQueryBuilder;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdabasDescriptor
extends DenseRankDescriptorAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AdabasDescriptor.class);
    public static final String MAINFRAME_ADABAS_USAGE = "com.ez.analysis.mainframe.usage.adabas";
    private static final String ADABAS_USAGE_FILTERS_FILE_NAME = "AdabasUsageFilters.properties";
    private static final String ADABAS_DB_COLUMN = DatabaseMetadata.ADABAS_DB.getName();
    private static final String ADABAS_FILE_COLUMN = DatabaseMetadata.ADABAS_FILE.getName();
    private static final String ADABAS_VIEW_COLUMN = DatabaseMetadata.ADABAS_VIEW.getName();
    private static final String PROGRAM_COLUMN = DatabaseMetadata.PRG_NAME.getName();
    private static final String STATEMENT_DESC_COLUMN = DatabaseMetadata.STMT_DESC.getName();
    private static final String ANCESTOR_NAME_COLUMN = DatabaseMetadata.PRG_ANCESTOR.getName();
    public static final Map<String, List<ColumnInfo>> ADABAS_CSV_HEADER = new HashMap<String, List<ColumnInfo>>(){
        {
            ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.PROJECT_INFO.name(), list);
            list.add(DatabaseMetadata.PROJECT_NAME);
            list = new ArrayList();
            this.put(ResultElementType.ADABAS_VIEW.name(), list);
            list.add(DatabaseMetadata.ADABAS_VIEW);
            list.add(DatabaseMetadata.ADABAS_NATURAL_VIEW);
            list = new ArrayList();
            this.put(ResultElementType.STMT_TYPE.name(), list);
            list.add(DatabaseMetadata.STMT_DESC);
            list.add(DatabaseMetadata.STMT_START_ROW);
            list.add(DatabaseMetadata.STMT_START_COL);
            list.add(DatabaseMetadata.STMT_END_ROW);
            list.add(DatabaseMetadata.STMT_END_COL);
            list = new ArrayList();
            this.put(ResultElementType.PROGRAM.name(), list);
            list.add(DatabaseMetadata.PRG_ID);
            list.add(DatabaseMetadata.PRG_NAME);
            list.add(DatabaseMetadata.PRG_TYPE_ID);
            list.add(DatabaseMetadata.PRG_PATH);
            list = new ArrayList();
            this.put(ResultElementType.ADABAS_DB.name(), list);
            list.add(DatabaseMetadata.ADABAS_DB);
            list = new ArrayList();
            this.put(ResultElementType.ADABAS_FILE.name(), list);
            list.add(DatabaseMetadata.ADABAS_FILE);
        }
    };
    private static Map<String, String> spParam;
    private static Map<String, String> spWhereClause;

    public AdabasDescriptor(AdabasUsageAnalysis analysis) {
        super(analysis.getType());
        this.id = MAINFRAME_ADABAS_USAGE;
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new AdabasTreeProvider(this);
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, new ResultElementType[0]);
        return new AdabasFilter(defaultPatterns.isEmpty() ? null : defaultPatterns);
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        RowHeaderInfo res = DatabaseMetadata.ADABAS_HEADER_INFO;
        return res;
    }

    @Override
    public String getDatabaseViewName() {
        return "EZViewer_Usage_Adabas";
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (spParam == null) {
            spParam = new HashMap<String, String>();
            spParam.put(ResultElementType.ADABAS_DB.name(), " @DBLimit INT, @AdabasDB VARCHAR(64)");
            spParam.put(ResultElementType.ADABAS_FILE.name(), " @FileLimit INT, @AdabasFile VARCHAR(64)");
            spParam.put(ResultElementType.ADABAS_VIEW.name(), " @AdabasViewLimit INT, @AdabasViewName VARCHAR(64)");
            spParam.put(ResultElementType.PROGRAM.name(), " @ProgramLimit INT, @Program VARCHAR(255), @Ancestor VARCHAR(255)");
            spParam.put(ResultElementType.STMT_TYPE.name(), " @StatementDescLimit INT, @StatementType VARCHAR(64) ");
        }
        return spParam;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (spWhereClause == null) {
            spWhereClause = new HashMap<String, String>();
            spWhereClause.put(ResultElementType.ADABAS_DB.name(), " (@AdabasDB = ''%'' or UPPER(" + ADABAS_DB_COLUMN + ")" + " " + ADABAS_DB_LIKE_OR_IN_MARKER + ")");
            spWhereClause.put(ResultElementType.ADABAS_FILE.name(), " (@AdabasFile = ''%'' or UPPER(" + ADABAS_FILE_COLUMN + ")" + " " + ADABAS_FILE_LIKE_OR_IN_MARKER + ")");
            spWhereClause.put(ResultElementType.ADABAS_VIEW.name(), " ( @AdabasViewName = ''%'' or UPPER(" + ADABAS_VIEW_COLUMN + ") " + ADABAS_VIEW_LIKE_OR_IN_MARKER + " )");
            spWhereClause.put(ResultElementType.PROGRAM.name(), " ((@Program = ''%'' or UPPER(" + PROGRAM_COLUMN + ") " + PROGRAM_LIKE_OR_IN_MARKER + ")" + " AND (" + "@Ancestor" + " = ''%'' or " + "UPPER(" + ANCESTOR_NAME_COLUMN + ") " + ANCESTOR_LIKE_OR_IN_MARKER + "))");
            spWhereClause.put(ResultElementType.STMT_TYPE.name(), " (@StatementType = ''%'' or UPPER (" + STATEMENT_DESC_COLUMN + ") " + STATEMENT_LIKE_OR_IN_MARKER + ")");
        }
        return spWhereClause;
    }

    @Override
    public Map<String, DenseRankDescriptorAdapter.DenseRankStatement> getStoredProcedureDenseRankStatements() {
        return new HashMap<String, DenseRankDescriptorAdapter.DenseRankStatement>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(ResultElementType.ADABAS_DB.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(ADABAS_DB_COLUMN).limitParamName(" @DBLimit ").create());
                this.put(ResultElementType.ADABAS_FILE.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(ADABAS_FILE_COLUMN).limitParamName(" @FileLimit ").create());
                this.put(ResultElementType.ADABAS_VIEW.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(ADABAS_VIEW_COLUMN).limitParamName(" @AdabasViewLimit ").create());
                this.put(ResultElementType.PROGRAM.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(PROGRAM_COLUMN).limitParamName(" @ProgramLimit ").create());
                this.put(ResultElementType.STMT_TYPE.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(STATEMENT_DESC_COLUMN).limitParamName(" @StatementDescLimit ").create());
            }
        };
    }

    @Override
    public String getFileName() {
        return ADABAS_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.ADABAS_DB, ADABAS_DB_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.ADABAS_FILE, ADABAS_FILE_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.ADABAS_VIEW, ADABAS_VIEW_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.PROGRAM, PROGRAM_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_TYPE, STATEMENT_DESC_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_SOURCE_INFO, PROGRAM_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
    }

    @Override
    protected AbstractQueryBuilder getQueryBuilder() {
        return new DenseRankQueryBuilder();
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        return ADABAS_CSV_HEADER;
    }

    @Override
    public String getProcedurePrefix() {
        return String.valueOf(super.getProcedurePrefix()) + "ADABAS";
    }

    @Override
    protected Map<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap() {
        HashMap<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap = new HashMap<String, FilterEntryParameterGenerator>();
        getFilterEntryParameterGeneratorMap.put(ResultElementType.PROGRAM.name(), new ProgramWithAncestorFilterEntryParameterGenerator());
        return getFilterEntryParameterGeneratorMap;
    }
}

