/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage;

import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.EZInputFilter;
import com.ez.workspace.analysis.audit.IAudit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsageAction
implements IAction,
IAudit {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(UsageAction.class);
    private UsageDescriptorAdapter descriptor;
    private IActionContext context;
    private EZAnalysisType analysisType;
    private EZInputFilter filter;
    private boolean alreadyExecuted;

    public UsageAction(UsageDescriptorAdapter descriptor) {
        this.descriptor = descriptor;
        this.analysisType = descriptor.getAnalysisType();
        this.filter = this.analysisType.getInputFilterInstance();
        this.alreadyExecuted = false;
    }

    public boolean canHandle(IActionContext context) {
        Object oInpTypes;
        Map data;
        boolean canHandle = false;
        if (context != null && (data = context.getData()) != null && (oInpTypes = data.get("ANALYSIS_TYPE_INPUTS")) != null && oInpTypes instanceof Collection) {
            if (this.analysisType.acceptsInputTypes((Collection)oInpTypes)) {
                canHandle = this.filter != null ? this.filter.checkAnalysisAvailability((Collection)oInpTypes) : true;
            } else {
                L.trace("inputs do not applyfor " + this.analysisType.getName());
            }
        }
        return canHandle;
    }

    public void setInputContext(IActionContext context) {
        this.context = context;
    }

    public IActionContext getOutputContext() {
        return this.descriptor.getState();
    }

    public void execute(IProgressMonitor pmonitor) {
        Boolean doRestore;
        Map data;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.beginTask(this.descriptor.getAnalysisType().toString(), 100);
        boolean createState = true;
        if (this.context != null && (data = this.context.getData()) != null && (doRestore = (Boolean)data.get("IActionContext.restored.key")) != null && doRestore.booleanValue() && this.context instanceof UsageStateAdapter) {
            data.remove("ANALYSIS_TYPE_INPUTS");
            this.descriptor.setState((UsageStateAdapter)this.context);
            createState = false;
        }
        if (createState && !monitor.isCanceled()) {
            this.descriptor.getState().getData().putAll(this.context.getData());
            this.descriptor.createState((IProgressMonitor)monitor.newChild(100));
        }
        if (this.alreadyExecuted) {
            this.auditAnalysis();
            this.alreadyExecuted = false;
        } else {
            this.alreadyExecuted = true;
        }
        monitor.done();
    }

    public String getProjectNames4Audit() {
        List inputProjects = (List)this.descriptor.getState().getData().get("PROJECT_LIST");
        StringBuffer projectListSb = new StringBuffer();
        if (inputProjects != null) {
            for (ProjectInfo projectInfo : inputProjects) {
                projectListSb.append(String.valueOf(projectInfo.getName()) + ", ");
            }
        }
        String projectListString = "";
        if (projectListSb.length() > 0) {
            projectListString = projectListSb.substring(0, projectListSb.length() - 1);
        }
        return projectListString;
    }

    public Integer getOperationCode() {
        return this.analysisType.getImplementorInstance().getOperationType().getOperationCode();
    }

    public String getOperationName() {
        return this.analysisType.getImplementorInstance().getOperationType().toString();
    }
}

