/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage;

import com.ez.analysisbrowser.actions.AbstractActionContext;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.views.AbstractScrollableItemsView;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUsageAnalysis
extends AbstractAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AbstractUsageAnalysis.class);

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        return null;
    }

    protected EZEntityID makeID() {
        EZEntityID id = new EZEntityID();
        AnalysisIDSegment sg = new AnalysisIDSegment((EZAnalysis)this);
        id.addSegment((EZSegment)sg);
        return id;
    }

    public boolean scopeIsShared() {
        return false;
    }

    protected void continueAnalysisForLocal() {
        AbstractActionContext state = new AbstractActionContext(){

            public Map<String, Object> getData() {
                HashMap<String, Object> data = new HashMap<String, Object>();
                List list = AbstractUsageAnalysis.this.getContextListValue("input_list");
                data.put("ANALYSIS_TYPE_INPUTS", list);
                Object notComputeResults = AbstractUsageAnalysis.this.getContextValue("NOT_COMPUTE_USAGE_RESULTS");
                if (notComputeResults != null) {
                    data.put("NOT_COMPUTE_USAGE_RESULTS", notComputeResults);
                }
                if (AbstractUsageAnalysis.this.getContextValue("projects") != null) {
                    data.put("projects", AbstractUsageAnalysis.this.getContextValue("projects"));
                }
                return data;
            }

            public String getId() {
                return AbstractUsageAnalysis.this.getUsageAnalysisId();
            }
        };
        Display.getDefault().syncExec(new Runnable((IActionContext)state){
            private final /* synthetic */ IActionContext val$state;
            {
                this.val$state = iActionContext;
            }

            @Override
            public void run() {
                String id = AbstractUsageAnalysis.this.getUsageAnalysisId();
                try {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow window = workbench.getWorkbenchWindows()[0];
                    AbstractScrollableItemsView analysisBrowserViewPart = (AbstractScrollableItemsView)window.getActivePage().showView("com.ez.analysisbrowser.views.UsagesView", null, 1);
                    EZAnalysisType anaysisType = AbstractUsageAnalysis.this.getType();
                    analysisBrowserViewPart.launch(anaysisType, this.val$state);
                }
                catch (PartInitException e) {
                    L.error("while activating view: {}", (Object)id, (Object)e);
                }
            }
        });
    }

    protected void verifyLicenseForLocal() {
        this.continueAnalysisForLocal();
    }

    protected abstract String getUsageAnalysisId();
}

