/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.serialization;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.ColumnType;
import com.ez.analysis.mainframe.db.FormatInfo;
import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.serialization.Deserializer;
import com.ez.analysis.mainframe.serialization.SerializationException;
import com.ez.analysis.mainframe.serialization.protobuf.RecordsetProto;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Serializer {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(Serializer.class);
    public static int VERSION = 1;
    private RowHeaderInfo hi;
    private FormatInfo fi;
    boolean appendMode;
    private boolean initialized;
    private OutputStream os;
    private boolean closed;

    public Serializer(RowHeaderInfo hi, FormatInfo fi, OutputStream os) {
        this(hi, fi, false, os);
    }

    public Serializer(RowHeaderInfo hi, FormatInfo fi, boolean appendMode, OutputStream os) {
        if (hi == null) {
            throw new IllegalArgumentException();
        }
        if (fi == null) {
            throw new IllegalArgumentException();
        }
        if (os == null) {
            throw new IllegalArgumentException();
        }
        this.hi = hi;
        this.fi = fi;
        this.appendMode = appendMode;
        this.os = os;
    }

    public void write(Row row) {
        if (this.closed) {
            throw new IllegalStateException("Already closed.");
        }
        this.ensureInitialized();
        RecordsetProto.Row rowImpl = this.getRow(row);
        try {
            rowImpl.writeDelimitedTo(this.os);
        }
        catch (IOException iOException) {
            throw new SerializationException("Can't write to output stream.");
        }
    }

    public void flush() {
        if (this.closed) {
            throw new IllegalStateException("Already closed.");
        }
    }

    public void close() {
        if (!this.closed) {
            this.ensureInitialized();
            try {
                this.os.flush();
            }
            catch (IOException iOException) {
                throw new SerializationException("Can't flush output stream.");
            }
            this.os = null;
            this.closed = true;
        } else {
            L.warn("Already closed.");
        }
    }

    void ensureInitialized() {
        if (!this.initialized) {
            if (!this.appendMode) {
                RecordsetProto.Header h = this.getHeader();
                RecordsetProto.RecordsetHeader rh = this.getRecordsetHeader();
                try {
                    h.writeDelimitedTo(this.os);
                    rh.writeDelimitedTo(this.os);
                }
                catch (IOException iOException) {
                    throw new SerializationException("Can't write to output stream.");
                }
            }
            this.initialized = true;
        }
    }

    private RecordsetProto.RecordsetHeader getRecordsetHeader() {
        RecordsetProto.RecordsetHeader.Builder b = RecordsetProto.RecordsetHeader.newBuilder();
        List<ColumnInfo> ci = this.hi.getColumnInfo();
        b.setRowSize(ci.size());
        for (ColumnInfo c : ci) {
            b.addColumnType(c.getType().getType());
        }
        return b.build();
    }

    private RecordsetProto.Header getHeader() {
        return RecordsetProto.Header.newBuilder().setVersion(VERSION).build();
    }

    private RecordsetProto.Row getRow(Row row) {
        RecordsetProto.Row.Builder b = RecordsetProto.Row.newBuilder();
        List<ColumnInfo> cis = this.hi.getColumnInfo();
        Iterator<ColumnInfo> cit = cis.iterator();
        b.setProjectName(row.getProjectName());
        int i = 0;
        while (i < cis.size()) {
            Object o = row.getColumnValue(i);
            ColumnInfo ci = cit.next();
            if (o == null) {
                b.addNullIndexes(i);
            } else {
                b.addColumn(ci.getType().toString(o, this.fi));
            }
            ++i;
        }
        return b.build();
    }

    public static void main(String[] args) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        RowHeaderInfo hi = new RowHeaderInfo(Arrays.asList(new ColumnInfo("a", ColumnType.Integer), new ColumnInfo("b", ColumnType.String)));
        FormatInfo fi = FormatInfo.getDefault();
        Serializer s = new Serializer(hi, fi, os);
        s.write(Row.load(new String[]{"1", "aaa"}, hi, fi, "test_project"));
        s.close();
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        Deserializer d = new Deserializer(hi, fi, is);
        d.read();
        d.read();
        is.close();
    }
}

