/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.serialization;

import com.ez.analysis.mainframe.db.FormatInfo;
import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.serialization.SerializationException;
import com.ez.analysis.mainframe.serialization.Serializer;
import com.ez.analysis.mainframe.serialization.protobuf.RecordsetProto;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deserializer {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(Deserializer.class);
    private RowHeaderInfo hi;
    private FormatInfo fi;
    private InputStream is;
    private boolean initialized;
    private boolean closed;
    private boolean eof;
    private HashMap<String, String> cache;
    private static String[] EMPTY_ARRAY = new String[0];
    private static final boolean PROTOBUF_ENABLE_STRING_CACHE = !Deserializer.stringCacheDisabled();

    public static boolean stringCacheDisabled() {
        String sp = System.getProperty("PROTOBUF_DISABLE_STRING_CACHE");
        boolean disabled = sp != null && sp.toLowerCase().equals("true");
        L.debug("Protobuf string cache disabled: " + disabled);
        return disabled;
    }

    public Deserializer(RowHeaderInfo hi, FormatInfo fi, InputStream is) {
        if (hi == null) {
            throw new IllegalArgumentException();
        }
        if (fi == null) {
            throw new IllegalArgumentException();
        }
        if (is == null) {
            throw new IllegalArgumentException();
        }
        this.hi = hi;
        this.fi = fi;
        this.is = is;
        this.cache = new HashMap();
    }

    public Row read() {
        Row row = null;
        if (this.closed) {
            throw new IllegalArgumentException("Already closed.");
        }
        if (!this.eof) {
            this.ensureInitialized();
            try {
                RecordsetProto.Row rowImpl = RecordsetProto.Row.parseDelimitedFrom(this.is);
                if (rowImpl == null) {
                    this.eof = true;
                } else {
                    row = this.getRow(rowImpl);
                }
            }
            catch (IOException iOException) {
                throw new SerializationException();
            }
        }
        return row;
    }

    public void close(boolean closeStream) {
        if (!this.closed) {
            if (closeStream) {
                try {
                    this.is.close();
                }
                catch (IOException e) {
                    L.error("Can't close stream.", (Throwable)e);
                }
            }
            this.is = null;
            this.cache = null;
            this.closed = true;
        } else {
            L.warn("Already closed.");
        }
    }

    private Row getRow(RecordsetProto.Row rowImpl) {
        String[] rowData = this.parseMessage(rowImpl);
        return Row.load(rowData, this.hi, this.fi, rowImpl.getProjectName());
    }

    private final String getCachedString(String d) {
        if (d != null) {
            String o = this.cache.get(d);
            if (o == null) {
                this.cache.put(d, d);
            } else {
                d = o;
            }
        }
        return d;
    }

    private String[] parseMessage(RecordsetProto.Row rowImpl) {
        String[] rowData;
        int nullCount = rowImpl.getNullIndexesCount();
        if (nullCount <= 0) {
            if (PROTOBUF_ENABLE_STRING_CACHE) {
                rowData = rowImpl.getColumnList().toArray(EMPTY_ARRAY);
                int i = 0;
                while (i < rowData.length) {
                    String v = rowData[i];
                    rowData[i] = this.getCachedString(v);
                    ++i;
                }
            } else {
                rowData = rowImpl.getColumnList().toArray(EMPTY_ARRAY);
            }
        } else {
            List<String> columns = rowImpl.getColumnList();
            List<Integer> nullIndexes = rowImpl.getNullIndexesList();
            int p = 0;
            int r = 0;
            rowData = new String[columns.size() + nullCount];
            int j = 0;
            while (j < nullCount) {
                int nulli = nullIndexes.get(j);
                int k = 0;
                while (k < nulli - r) {
                    rowData[r + k] = PROTOBUF_ENABLE_STRING_CACHE ? this.getCachedString(columns.get(p + k)) : columns.get(p + k);
                    ++k;
                }
                rowData[nulli] = null;
                p += nulli - r;
                r = nulli + 1;
                ++j;
            }
            int k = 0;
            while (k < rowData.length - r) {
                rowData[r + k] = PROTOBUF_ENABLE_STRING_CACHE ? this.getCachedString(columns.get(p + k)) : columns.get(p + k);
                ++k;
            }
        }
        return rowData;
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            RecordsetProto.Header h;
            try {
                h = RecordsetProto.Header.parseDelimitedFrom(this.is);
            }
            catch (IOException e) {
                throw new SerializationException("Can't read from input stream.", e);
            }
            if (h.getVersion() != Serializer.VERSION) {
                throw new SerializationException(String.format("Stream version %d not supported.", h.getVersion()));
            }
            try {
                RecordsetProto.RecordsetHeader.parseDelimitedFrom(this.is);
            }
            catch (IOException e) {
                throw new SerializationException("Can't read from input stream.", e);
            }
            this.initialized = true;
        }
    }
}

