/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.db;

import com.ez.analysis.mainframe.db.ColumnInfo;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class RowHeaderInfo
implements Serializable {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private List<ColumnInfo> columnInfo;
    private Map<String, Integer> columnPosition;

    private RowHeaderInfo() {
    }

    public RowHeaderInfo(List<ColumnInfo> columnInfo) {
        this.columnInfo = Collections.unmodifiableList(columnInfo);
        this.columnPosition = new HashMap<String, Integer>();
        ListIterator<ColumnInfo> it = columnInfo.listIterator();
        while (it.hasNext()) {
            ColumnInfo ci = it.next();
            if (ci == null) continue;
            this.columnPosition.put(ci.getName(), it.nextIndex() - 1);
        }
        this.columnPosition = Collections.unmodifiableMap(this.columnPosition);
    }

    public List<ColumnInfo> getColumnInfo() {
        return this.columnInfo;
    }

    public ColumnInfo getColumnInfo(int pos) {
        return this.columnInfo.get(pos);
    }

    public Integer getColumnPosition(String name) {
        return this.columnPosition.get(name);
    }

    public String toString() {
        return "\n RowHeaderInfo.columnInfo=\n" + this.columnInfo + "\nRowHeaderInfo.clumnPosition=" + this.columnPosition;
    }
}

