/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.db;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.ColumnType;
import com.ez.analysis.mainframe.db.FormatInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.db.Utils;
import com.ez.mainframe.model.ProjectInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Row
implements Serializable {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final transient Logger L = LoggerFactory.getLogger(Row.class);
    private Object[] rowData;
    private RowHeaderInfo headerInfo;
    private FormatInfo fi;
    private ProjectInfo pi;
    private String projectName;

    public static Row load(String[] rawData, List<String> columns, ColumnType type, FormatInfo fi, String projectName) {
        return new Row(rawData, columns, type, fi, projectName);
    }

    public static Row load(String[] rawData, RowHeaderInfo headerInfo, FormatInfo fi, String projectName) {
        return new Row(rawData, headerInfo, fi, projectName);
    }

    public static Row create(List<ColumnInfo> columnInfo, FormatInfo fi, String projectName) {
        return new Row(new String[columnInfo.size()], new RowHeaderInfo(columnInfo), fi, projectName);
    }

    Row(String[] rawData, List<String> columns, ColumnType type, FormatInfo fi, String projectName) {
        this(rawData, new RowHeaderInfo(Row.buildInfo(columns, type)), fi, projectName);
    }

    Row(String[] rawData, RowHeaderInfo headerInfo, FormatInfo fi, String projectName) {
        if (headerInfo.getColumnInfo().size() > rawData.length) {
            throw new IllegalArgumentException("colNames.size() < row.length");
        }
        this.headerInfo = headerInfo;
        this.fi = fi;
        this.projectName = projectName;
        this.rowData = new Object[rawData.length];
        ColumnInfo[] cis = this.headerInfo.getColumnInfo().toArray(new ColumnInfo[0]);
        int i = 0;
        while (i < rawData.length) {
            ColumnInfo ci = null;
            if (cis.length > i) {
                ci = cis[i];
            }
            this.rowData[i] = ci != null ? ci.getType().parse(rawData[i], this.fi) : null;
            ++i;
        }
    }

    Row(RowHeaderInfo headerInfo, FormatInfo fi, String projectName) {
        this(new String[headerInfo.getColumnInfo().size()], headerInfo, fi, projectName);
    }

    public Object getColumnValue(String column) {
        Integer pos = this.headerInfo.getColumnPosition(column);
        if (pos == null) {
            throw new IllegalArgumentException("No such column: " + column);
        }
        return this.rowData[pos];
    }

    public Object getColumnValue(int pos) {
        return this.rowData[pos];
    }

    public Object getColumnValue(String joinAlias, String column) {
        String newColumn = Utils.getColumnAlias(joinAlias, column);
        Integer pos = this.headerInfo.getColumnPosition(newColumn);
        if (pos == null) {
            throw new IllegalArgumentException(String.format("No such column %s.%s", joinAlias, column));
        }
        return this.rowData[pos];
    }

    private static List<ColumnInfo> buildInfo(List<String> columns, ColumnType type) {
        ArrayList<ColumnInfo> columnInfo = new ArrayList<ColumnInfo>(columns.size());
        for (String c : columns) {
            columnInfo.add(new ColumnInfo(c, type));
        }
        return columnInfo;
    }

    public ProjectInfo getProjectInfo() {
        return this.pi;
    }

    public boolean hasColumn(String name) {
        Integer pos = this.headerInfo.getColumnPosition(name);
        return pos != null;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectInfo(ProjectInfo pinfo) {
        this.pi = pinfo;
    }

    public void setHeaderInfo(RowHeaderInfo headerInfo2) {
        this.headerInfo = headerInfo2;
    }

    public String toString() {
        return "Row [projectName=" + this.projectName + ", pi=" + this.pi + ", rowData=" + Arrays.toString(this.rowData) + ", headerInfo=" + this.headerInfo + ", fi=" + this.fi + "]";
    }
}

