/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.db;

import com.ez.analysis.mainframe.db.FormatInfo;
import com.ez.mainframe.data.utils.Utils;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public enum ColumnType {
    String(0){

        @Override
        public Object parse(String str) {
            return Utils.filterNullValue((String)str);
        }

        @Override
        public Object parse(String str, FormatInfo fi) {
            return Utils.filterNullValue((String)str);
        }

        @Override
        public String toString(Object value, FormatInfo fi) {
            return (String)value;
        }
    }
    ,
    Integer(1){

        @Override
        public Object parse(String str, FormatInfo fi) {
            Integer i = null;
            if ((str = Utils.filterNullValue((String)str)) != null) {
                i = java.lang.Integer.parseInt(str);
            }
            return i;
        }

        @Override
        public Object parse(String str) {
            return this.parse(str, null);
        }

        @Override
        public String toString(Object value, FormatInfo fi) {
            String str = null;
            if (value != null) {
                Integer i = (Integer)value;
                str = i.toString();
            }
            return str;
        }
    }
    ,
    Date(2){

        @Override
        public Object parse(String str) {
            return this.parse(str, null);
        }

        @Override
        public Object parse(String str, FormatInfo fi) {
            Date dt = null;
            if ((str = Utils.filterNullValue((String)str)) != null) {
                DateFormat df = fi != null ? fi.getDateFormat() : DateFormat.getDateInstance();
                try {
                    dt = df.parse(str);
                }
                catch (ParseException parseException) {
                    throw new RuntimeException("Can't parse as date: " + str);
                }
            }
            return dt;
        }

        @Override
        public String toString(Object value, FormatInfo fi) {
            String str = null;
            if (value != null) {
                Date d = (Date)value;
                DateFormat f = fi.getDateFormat();
                str = f.format(d);
            }
            return str;
        }
    }
    ,
    Datetime(3){

        @Override
        public Object parse(String str) {
            return this.parse(str, null);
        }

        @Override
        public Object parse(String str, FormatInfo fi) {
            Date dt = null;
            if ((str = Utils.filterNullValue((String)str)) != null) {
                DateFormat df = fi != null ? fi.getDateTimeFormat() : DateFormat.getDateTimeInstance();
                try {
                    dt = df.parse(str);
                }
                catch (ParseException parseException) {
                    throw new RuntimeException("Can't parse as datetime: " + str);
                }
            }
            return dt;
        }

        @Override
        public String toString(Object value, FormatInfo fi) {
            String str = null;
            if (value != null) {
                Date d = (Date)value;
                DateFormat f = fi.getDateTimeFormat();
                str = f.format(d);
            }
            return str;
        }
    }
    ,
    EZSourceDatetime(4){

        @Override
        public Object parse(String str) {
            return this.parse(str, null);
        }

        @Override
        public Object parse(String str, FormatInfo fi) {
            Date dt = null;
            if ((str = Utils.filterNullValue((String)str)) != null) {
                DateFormat df = fi != null ? fi.getDateTimeFormat() : DateFormat.getDateTimeInstance();
                try {
                    dt = df.parse(str);
                }
                catch (ParseException parseException) {
                    throw new RuntimeException("Can't parse as datetime: " + str);
                }
            }
            return dt;
        }

        @Override
        public String toString(Object value, FormatInfo fi) {
            String str = null;
            if (value != null) {
                Date d = (Date)value;
                DateFormat f = fi.getDateTimeFormat();
                str = f.format(d);
            }
            return str;
        }
    }
    ,
    Boolean(5){

        @Override
        public Object parse(String str, FormatInfo fi) {
            Boolean r = null;
            if ((str = Utils.filterNullValue((String)str)) != null) {
                try {
                    r = this.parseBoolean(str);
                }
                catch (ParseException parseException) {
                    throw new RuntimeException("Can't parse as boolean: " + str);
                }
            }
            return r;
        }

        @Override
        public Object parse(String str) {
            return this.parse(str, null);
        }

        @Override
        public String toString(Object value, FormatInfo fi) {
            String str = null;
            if (value != null) {
                Boolean b = (Boolean)value;
                str = b != false ? "1" : "0";
            }
            return str;
        }

        private Boolean parseBoolean(String str) throws ParseException {
            Boolean r = null;
            if (str != null) {
                Integer i = java.lang.Integer.parseInt(str);
                if (i == 0) {
                    r = false;
                } else if (i == 1) {
                    r = true;
                } else {
                    throw new ParseException(java.lang.String.format("Can't parse %s as bool.", str), 0);
                }
            }
            return r;
        }
    };

    private int type;

    public static ColumnType get(int type) {
        ColumnType t = G.ALL.get(type);
        if (t == null) {
            throw new IllegalArgumentException("No such type.");
        }
        return t;
    }

    public static ColumnType find(int type) {
        return G.ALL.get(type);
    }

    public int getType() {
        return this.type;
    }

    public abstract Object parse(String var1);

    public abstract Object parse(String var1, FormatInfo var2);

    public abstract String toString(Object var1, FormatInfo var2);

    private ColumnType(int type) {
        this.type = type;
        if (G.ALL.containsKey(type)) {
            throw new IllegalArgumentException();
        }
        G.ALL.put(type, this);
    }

    /* synthetic */ ColumnType(String string, int n, int n2, ColumnType columnType) {
        this(n2);
    }

    private static class G {
        public static Map<Integer, ColumnType> ALL = new HashMap<Integer, ColumnType>();

        private G() {
        }
    }
}

