/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.display.view;

import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

public class LegendComponent
extends Composite {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Composite all = this;
    private Composite main;
    private Composite legend;
    private ComponentBuilderInterface legendBuilder;
    private Sash sash;
    private Listener listener;
    boolean legendVisible = false;
    private FormData sashdata;
    boolean needRebuild = false;

    public LegendComponent(Composite parent, int style) {
        super(parent, style);
        this.all.setLayout((Layout)new FillLayout());
    }

    public void setMainAreaBuilder(ComponentBuilderInterface mainBuilder) {
        this.main = mainBuilder.buildComponent(this.all);
    }

    public void refresh() {
        if (this.needRebuild) {
            this.clear();
            if (this.legendVisible) {
                this.setLegendVisible(this.legendVisible);
            }
        }
        this.main.setParent(this.all);
        if (this.legendVisible) {
            FormData fData = new FormData();
            if (this.legendVisible) {
                fData.left = new FormAttachment(0, 0);
                fData.right = new FormAttachment((Control)this.sash, 0);
                fData.top = new FormAttachment(0, 0);
                fData.bottom = new FormAttachment(100, 0);
            }
            this.main.setLayoutData((Object)fData);
        }
        this.all.layout(true, true);
    }

    public void setLegend(ComponentBuilderInterface legendBuilder) {
        this.needRebuild = this.legendBuilder != legendBuilder;
        this.legendBuilder = legendBuilder;
    }

    public void setLegendVisible(boolean legendVisible) {
        this.legendVisible = legendVisible;
        if (legendVisible && this.sash != null) {
            return;
        }
        if (this.legendBuilder != null) {
            if (legendVisible) {
                this.all.setLayout((Layout)new FormLayout());
                this.sash = new Sash(this.all, 2560);
                this.sash.setVisible(false);
                this.sashdata = new FormData();
                this.sashdata.top = new FormAttachment(0, 0);
                this.sashdata.bottom = new FormAttachment(100, 0);
                this.sashdata.left = new FormAttachment(65, 0);
                this.sash.setLayoutData((Object)this.sashdata);
                this.listener = new Listener(){

                    public void handleEvent(Event e) {
                        Rectangle sashRect = LegendComponent.this.sash.getBounds();
                        Rectangle shellRect = LegendComponent.this.all.getClientArea();
                        int right = shellRect.width - sashRect.width - 20;
                        e.x = Math.max(Math.min(e.x, right), 20);
                        if (e.x != sashRect.x) {
                            ((LegendComponent)LegendComponent.this).sashdata.left = new FormAttachment(0, e.x);
                            LegendComponent.this.all.layout();
                        }
                    }
                };
                this.sash.addListener(13, this.listener);
                FormData fData = new FormData();
                if (legendVisible) {
                    fData.left = new FormAttachment(0, 0);
                    fData.right = new FormAttachment((Control)this.sash, 0);
                    fData.top = new FormAttachment(0, 0);
                    fData.bottom = new FormAttachment(100, 0);
                }
                this.main.setLayoutData((Object)fData);
                this.legend = this.legendBuilder.buildComponent(this.all);
                if (this.legendBuilder.getPercent() > 0) {
                    this.sashdata.left.numerator = this.legendBuilder.getPercent();
                }
                FormData button2Data = new FormData();
                button2Data.left = new FormAttachment((Control)this.sash, 0);
                button2Data.right = new FormAttachment(100, 0);
                button2Data.top = new FormAttachment(0, 0);
                button2Data.bottom = new FormAttachment(100, 0);
                this.legend.setLayoutData((Object)button2Data);
                this.sash.setVisible(true);
                this.legend.setVisible(true);
            } else {
                this.clear();
            }
        } else {
            this.all.setLayout((Layout)new FillLayout());
        }
        this.all.layout();
    }

    private void clear() {
        if (this.sash != null) {
            this.sash.removeListener(13, this.listener);
            this.sash.dispose();
            this.sash = null;
        }
        if (this.legend != null) {
            Control[] ctrls;
            Control[] controlArray = ctrls = this.legend.getChildren();
            int n = ctrls.length;
            int n2 = 0;
            while (n2 < n) {
                Control ctrl = controlArray[n2];
                if (ctrl != null) {
                    ctrl.dispose();
                }
                ++n2;
            }
            this.legend.dispose();
            this.legend = null;
        }
        this.all.setLayout((Layout)new FillLayout());
    }

    public boolean isLegendVisible() {
        return this.legendVisible;
    }
}

