/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.display.view;

import com.ez.analysis.display.Activator;
import com.ez.analysis.display.Messages;
import com.ez.analysis.display.utils.AnalysisDisplayLogUtil;
import com.ez.analysis.display.view.AnalysisView;
import com.ez.analysis.display.view.GraphInnerStructureView;
import com.ez.analysis.display.view.GraphOverview;
import com.ez.internal.graphmodel.EZSelection;
import com.ez.internal.id.EZEntityID;
import com.ez.workspace.analysis.graph.gui.EZFitInCanvasCommand;
import com.ez.workspace.analysis.graph.model.GraphNodeIDSegment;
import com.ez.workspace.preferences.PreferenceUtils;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.TSEObject;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.interactive.command.TSCommandInterface;
import com.tomsawyer.interactive.command.TSCommandManager;
import com.tomsawyer.interactive.swing.TSSwingCanvas;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphsView
extends AnalysisView {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(GraphsView.class);
    private int numberOfLinks = 2;
    private GraphInnerStructureView structureView = null;
    private Action legendAction = null;
    protected Frame overviewFrame = null;
    protected GraphOverview overviewPart = null;
    private SelectInStructTree selectInStructTree = null;
    protected AnalysisView.RefreshStructTree refreshStructTree = null;
    protected AnalysisView.RefreshFilters refreshFilters = null;
    private static final String LEGEND_TEXT = Messages.getString(GraphsView.class, "btnLegend");

    public GraphsView() {
        IPreferencesService service = Platform.getPreferencesService();
        Object defZoomLevel = PreferenceUtils.getDefaultValue((String)"levelsZoomPreference");
        try {
            int defZoomNo = Integer.parseInt((String)defZoomLevel);
            this.numberOfLinks = service.getInt("com.ez.workspace", "levelsZoomPreference", defZoomNo, null);
        }
        catch (NumberFormatException nfe) {
            L.error("error on retrieving the zoomLevel number", (Throwable)nfe);
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IWorkbenchPage page = this.getSite().getPage();
        IViewReference overviewRef = page.findViewReference("com.ez.analysis.display.view.GraphOverview");
        IViewReference innerRef = page.findViewReference("com.ez.analysis.display.view.GraphInnerStructureView");
        if (overviewRef == null) {
            try {
                L.debug("showing overview");
                page.showView("com.ez.analysis.display.view.GraphOverview");
            }
            catch (Throwable pie) {
                L.error("could not show overview ", pie);
            }
        }
        if (innerRef == null) {
            try {
                L.debug("showing innergraphview");
                page.showView("com.ez.analysis.display.view.GraphInnerStructureView");
            }
            catch (Throwable pie) {
                L.error("could not show innergraphview ", pie);
            }
        }
    }

    @Override
    protected void initElements() {
        this.legendAction = new Action(){

            public void run() {
                GraphsView.this.toogleLegend();
            }
        };
        ImageDescriptor id = Activator.getImageDescriptor("icons//legend.gif");
        this.legendAction.setImageDescriptor(id);
        this.legendAction.setText(LEGEND_TEXT);
        this.legendAction.setToolTipText(LEGEND_TEXT);
    }

    @Override
    protected void addLegendAction(AnalysisView.PartInfo info, IContributionManager manager, boolean enabled) {
        if (info.hasLegend) {
            manager.add((IContributionItem)new ActionContributionItem((IAction)this.legendAction));
            this.legendAction.setChecked(info.control.isLegendVisible());
            this.legendAction.setEnabled(enabled);
        }
    }

    private void toogleLegend() {
        AnalysisView.PartInfo selInfo;
        CTabItem item = this.folder.getSelection();
        if (item != null && (selInfo = (AnalysisView.PartInfo)this.tabs.get(item)) != null && selInfo.hasLegend) {
            selInfo.control.setLegendVisible(this.legendAction.isChecked());
            selInfo.control.forceFocus();
        }
    }

    @Override
    protected void doRefresh(AnalysisView.PartInfo pInfo) {
        this.refreshOverviewFrame(pInfo);
        this.refreshStructTree(this.refreshStructTree, pInfo);
        this.refreshFilters(this.refreshFilters, pInfo);
    }

    @Override
    protected void refreshOverviewFrame(final AnalysisView.PartInfo pInfo) {
        if (this.overviewFrame != null && pInfo != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GraphsView.this.overviewFrame.removeAll();
                    if (pInfo.overviewComponent != null) {
                        GraphsView.this.overviewFrame.add((Component)pInfo.overviewComponent);
                        pInfo.overviewComponent.repaint();
                    } else {
                        GraphsView.this.overviewFrame.add(new Label());
                    }
                    GraphsView.this.overviewFrame.validate();
                }
            });
        } else {
            L.debug("overview frame null (not created)");
            AnalysisDisplayLogUtil.debug(Messages.getString(GraphsView.class, "overview.notCreated.message"));
        }
    }

    @Override
    public void refreshStructTree(AnalysisView.PartInfo pInfo) {
        if (this.structureView != null) {
            if (this.structureView.treeViewer != null) {
                Tree structTree = this.structureView.treeViewer.getTree();
                if (!structTree.isDisposed()) {
                    if (pInfo != null && pInfo.contentProviders != null) {
                        if (pInfo.enabled) {
                            this.structureView.setContentProviders(pInfo.contentProviders);
                        } else {
                            this.structureView.resetState();
                        }
                    } else {
                        structTree.removeAll();
                        this.structureView.resetState();
                    }
                }
            } else {
                L.warn("tree viewer from Structure view is not created");
            }
        } else {
            L.warn("structure view is null in refreshTree");
        }
    }

    @Override
    public void refreshStructTree(AnalysisView.RefreshStructTree refreshStructTree, AnalysisView.PartInfo pInfo) {
        if (refreshStructTree == null) {
            refreshStructTree = new AnalysisView.RefreshStructTree();
        }
        refreshStructTree.pInfo = pInfo;
        Display.getDefault().asyncExec((Runnable)refreshStructTree);
    }

    @Override
    protected void clearAtRemoveTabItem(CTabItem item, AnalysisView.PartInfo pInfo) {
        if (pInfo.overviewComponent != null) {
            pInfo.overviewComponent.removeAll();
            this.refreshOverviewFrame(pInfo);
        }
        if (pInfo.contentProviders != null) {
            pInfo.contentProviders = null;
            this.refreshStructTree(this.refreshStructTree, pInfo);
        }
        if (pInfo.control != null) {
            pInfo.control.setLegend(null);
        }
        pInfo.selectionListener = null;
        pInfo.id = null;
        pInfo.graphFilterInfo = null;
        pInfo.graphInfo = null;
        CTabItem selItem = this.folder.getSelection();
        if (selItem != null && selItem != item) {
            AnalysisDisplayLogUtil.debug(Messages.getString(GraphsView.class, "refresh.log.message"));
            AnalysisView.PartInfo selInfo = (AnalysisView.PartInfo)this.tabs.get(selItem);
            this.refreshItem(selItem);
            this.contributeToActionBars(selInfo, true);
            this.refreshOverviewFrame(selInfo);
            this.refreshStructTree(this.refreshStructTree, selInfo);
            this.refreshFilters(this.refreshFilters, selInfo);
        }
    }

    @Override
    protected void closeAllTabs() {
        super.closeAllTabs();
        if (this.overviewFrame != null) {
            this.overviewFrame.removeAll();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GraphsView.this.overviewFrame.repaint();
                }
            });
        }
        if (this.structureView != null) {
            this.structureView.resetState();
        }
    }

    @Override
    public void setOverviewPart(GraphOverview overviewPart) {
        AnalysisView.PartInfo info;
        this.overviewPart = overviewPart;
        this.overviewFrame = overviewPart.overviewFrame;
        CTabItem item = this.folder.getSelection();
        if (item != null && (info = (AnalysisView.PartInfo)this.tabs.get(item)) != null) {
            this.refreshOverviewFrame(info);
        }
    }

    @Override
    public void setSelection(ISelection selection) {
        GraphNodeIDSegment graphSG;
        EZEntityID entityId;
        super.setSelection(selection);
        if (this.structureView != null) {
            this.structureView.setSelection(selection);
        }
        if (selection instanceof EZSelection && this.structureView != null && this.structureView.treeViewer != null && (entityId = ((EZSelection)selection).getSelectedEntity()) != null && (graphSG = (GraphNodeIDSegment)entityId.getSegment(GraphNodeIDSegment.class)) != null) {
            if (this.selectInStructTree == null) {
                this.selectInStructTree = new SelectInStructTree();
            }
            this.selectInStructTree.node = graphSG.getNode();
            Display.getDefault().syncExec((Runnable)this.selectInStructTree);
        }
    }

    @Override
    public void setStructurePart(GraphInnerStructureView structurePart) {
        AnalysisView.PartInfo info;
        this.structureView = structurePart;
        this.structureView.treeViewer = structurePart.treeViewer;
        structurePart.setAnalysisView(this);
        CTabItem item = this.folder.getSelection();
        if (item != null && (info = (AnalysisView.PartInfo)this.tabs.get(item)) != null) {
            L.trace("-------------- refresh structure view------------------");
            this.refreshStructTree(this.refreshStructTree, info);
        }
    }

    @Override
    public void dispose() {
        IWorkbenchPage pg;
        IWorkbenchPartSite ps;
        if (this.overviewPart != null) {
            try {
                ps = this.overviewPart.getSite();
                if (ps != null && (pg = ps.getPage()) != null) {
                    pg.hideView((IViewPart)this.overviewPart);
                }
            }
            catch (Throwable t) {
                L.warn("error while hiding overview", t);
            }
            this.overviewPart = null;
        }
        if (this.structureView != null) {
            try {
                ps = this.structureView.getSite();
                if (ps != null && (pg = ps.getPage()) != null) {
                    pg.hideView((IViewPart)this.structureView);
                }
            }
            catch (Throwable t) {
                L.warn("error while hiding structureView", t);
            }
            this.structureView = null;
        }
        super.dispose();
    }

    public void selectAndFitInCanvas(TSEObject obj) {
        Component cmp;
        TSSwingCanvas canvas;
        AnalysisView.PartInfo info;
        CTabItem item = this.getUserArea().getSelection();
        if (item != null && (info = (AnalysisView.PartInfo)this.tabs.get(item)) != null && (canvas = (TSSwingCanvas)(cmp = info.canvasComponent)) != null) {
            final EZFitInCanvasCommand fit = new EZFitInCanvasCommand(canvas);
            canvas.deselectAll(false);
            TSENode nodeSelected = this.selectObject(obj);
            if (nodeSelected != null && obj != nodeSelected) {
                nodeSelected.setAttribute("Selected_Border_Color", (Object)TSEColor.red);
            }
            ArrayList<Object> adjacentNodeList = new ArrayList<Object>();
            ArrayList<TSENode> inputNodes = new ArrayList<TSENode>();
            if (nodeSelected != null) {
                TSENode node = (TSENode)obj;
                inputNodes.add(nodeSelected);
                int i = 0;
                while (i < this.numberOfLinks) {
                    List ret = this.collectAdjacentNodes(inputNodes);
                    if (ret.size() == 0) break;
                    adjacentNodeList.addAll(ret);
                    inputNodes.clear();
                    inputNodes.addAll(ret);
                    ++i;
                }
                if (adjacentNodeList.size() == 0 && node.hasAttribute("PARENTFORFIT")) {
                    adjacentNodeList.add(node.getAttributeValue("PARENTFORFIT"));
                }
                fit.setNode(nodeSelected);
                fit.setParents(adjacentNodeList);
                nodeSelected.setAttribute("Selected_Border_Color", (Object)new TSEColor(0, 153, 255));
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TSCommandManager mgr = canvas.getCommandManager();
                    mgr.transmit((TSCommandInterface)fit);
                }
            });
        }
    }

    class SelectInStructTree
    implements Runnable {
        TSENode node = null;

        SelectInStructTree() {
        }

        @Override
        public void run() {
            GraphsView.this.structureView.selectGraphNodeInTree(this.node);
        }
    }
}

