/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.display.view;

import com.ez.analysis.display.Activator;
import com.ez.analysis.display.EZSelectionProvider;
import com.ez.analysis.display.Messages;
import com.ez.analysis.display.job.StructureViewJob;
import com.ez.analysis.display.listener.ViewPartListener;
import com.ez.analysis.display.view.GraphInnerLabelProvider;
import com.ez.analysis.display.view.GraphPartView;
import com.ez.analysis.display.view.GraphsView;
import com.ez.internal.graphmodel.EZSelection;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.Pair;
import com.ez.workspace.analysis.graph.model.ChangeObserver;
import com.ez.workspace.analysis.graph.model.GraphInnerElement;
import com.ez.workspace.analysis.graph.model.InventoryPathUtils;
import com.ez.workspace.analysis.graph.model.NodeFilter;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.graph.model.StructureContentProviderAdapter;
import com.ez.workspace.analysis.job.SelectionJob;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.TSEObject;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphInnerStructureView
extends ViewPart
implements GraphPartView,
ITabbedPropertySheetPageContributor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String EZ_EXPORT_ACTION_ID = "ez_export";
    private static final Logger L = LoggerFactory.getLogger(GraphInnerStructureView.class);
    private static final String EMPTY_STRING = new String("");
    public TreeViewer treeViewer = null;
    protected Text text;
    protected GraphInnerLabelProvider labelProvider;
    protected GraphsView analysisView;
    private Action doubleClickAction;
    private ChangeObserver co = new ChangeObserver(){

        public void contentsChanged() {
            if (GraphInnerStructureView.this.currentCP != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GraphInnerStructureView.this.refreshFilters((ViewerFilter)(this).GraphInnerStructureView.this.currentCP.getViewerFilter());
                    }
                });
            }
        }
    };
    private ITreeContentProvider defaultCP = null;
    EZSelectionProvider sp = new EZSelectionProvider();
    private IPartListener2 partListener = null;
    Set<StructureContentProvider> contentProviders;
    StructureContentProvider currentCP = null;
    private NameSorter nameSorter = new NameSorter();
    private TreeItem ti = null;

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        PatternFilter patternFilter = new PatternFilter();
        patternFilter.setIncludeLeadingWildcard(true);
        FilteredTree filter = new FilteredTree(parent, 772, patternFilter, true);
        filter.setInitialText(Messages.getString(GraphInnerStructureView.class, "initialTxt"));
        this.treeViewer = filter.getViewer();
        this.labelProvider = new GraphInnerLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setUseHashlookup(true);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this.treeViewer.getControl().setLayoutData((Object)layoutData);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.makeActions();
        this.hookSingleDoubleClickActions();
        this.hookContextMenu();
        this.hookListeners();
        this.createToolBar();
        StructureViewJob strJob = new StructureViewJob(this);
        strJob.schedule();
        this.defaultCP = new DefaultTreeContentProvider();
        this.resetState();
        this.getSite().setSelectionProvider((ISelectionProvider)this.sp);
        this.partListener = new ViewPartListener(this);
        this.getSite().getPage().addPartListener(this.partListener);
    }

    public void resetState() {
        this.currentCP = null;
        this.contentProviders = null;
        this.setViewerContentProvider(this.defaultCP, null);
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.removeAll();
        mgr.update(true);
        this.getViewSite().getActionBars().updateActionBars();
    }

    private void refreshFilters(ViewerFilter filter) {
        ViewerFilter[] viewerFilterArray = this.treeViewer.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter f = viewerFilterArray[n2];
            if (f instanceof NodeFilter) {
                this.treeViewer.removeFilter(f);
            }
            ++n2;
        }
        if (filter != null) {
            this.treeViewer.addFilter(filter);
        }
    }

    private void setViewerContentProvider(ITreeContentProvider provider, ViewerFilter filter) {
        this.refreshFilters(filter);
        this.treeViewer.setContentProvider((IContentProvider)provider);
    }

    private void colorize(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            item.setForeground(new Color((Device)this.treeViewer.getControl().getDisplay(), 200, 0, 0));
            ++n2;
        }
    }

    public void setSelection(ISelection selection) {
        final ISelection ss = selection;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                GraphInnerStructureView.this.sp.setSelection(ss);
            }
        });
    }

    protected void hookListeners() {
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)GraphInnerStructureView.this.treeViewer.getSelection();
                for (Object selected : (StructuredSelection)sel) {
                    if (!(selected instanceof GraphInnerElement)) continue;
                    GraphInnerElement gie = (GraphInnerElement)selected;
                    Object member = gie.getSelection();
                    GraphInnerStructureView.this.analysisView.selectObject(member);
                    if (member == null || !(member instanceof TSGraphMember) || !((TSGraphMember)member).hasAttribute("PATH_TS_NODES")) continue;
                    InventoryPathUtils.markPath((TSGraphMember)((TSGraphMember)member));
                }
            }
        });
    }

    private void makeActions() {
        this.doubleClickAction = new Action(){

            public void run() {
                GraphInnerElement gie;
                TSGraphMember node;
                ISelection selection = GraphInnerStructureView.this.treeViewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof GraphInnerElement && (node = (gie = (GraphInnerElement)obj).getNode()) != null) {
                    GraphInnerStructureView.this.analysisView.selectAndFitInCanvas((TSEObject)node);
                }
            }
        };
    }

    private void hookSingleDoubleClickActions() {
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                GraphInnerStructureView.this.doubleClickAction.run();
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                this.setPropertiesViewer(event.getSelection());
            }

            private void setPropertiesViewer(ISelection selection) {
                selection = GraphInnerStructureView.this.treeViewer.getSelection();
                Object objSel = ((IStructuredSelection)selection).getFirstElement();
                if (objSel != null && objSel instanceof GraphInnerElement) {
                    GraphInnerElement gie = (GraphInnerElement)objSel;
                    StructureContentProvider cp = (StructureContentProvider)GraphInnerStructureView.this.treeViewer.getContentProvider();
                    TSGraphMember member = gie.getNode();
                    if (member != null && member instanceof TSENode) {
                        Action action;
                        TSENode tsNode = (TSENode)member;
                        if (tsNode != null && cp.getMouseActionsHook() != null && (action = cp.getMouseActionsHook().getClickSelection(tsNode)) != null) {
                            action.run();
                        }
                    } else {
                        EZEntityID id = new EZEntityID();
                        SelectionJob selectJob = new SelectionJob(id);
                        selectJob.setSelection((ISelection)new StructuredSelection());
                        selectJob.schedule();
                    }
                }
            }
        });
    }

    public void setFocus() {
        Control c;
        if (this.treeViewer != null && (c = this.treeViewer.getControl()) != null && !c.isDisposed()) {
            c.setFocus();
        }
    }

    private void fillContextMenu(IMenuManager manager) {
        ISelection sel = this.treeViewer.getSelection();
        Object objSel = ((IStructuredSelection)sel).getFirstElement();
        if (objSel != null && objSel instanceof GraphInnerElement) {
            TSEEdge tsEdge;
            final GraphInnerElement gie = (GraphInnerElement)objSel;
            StructureContentProvider cp = (StructureContentProvider)this.treeViewer.getContentProvider();
            TSGraphMember member = gie.getNode();
            List actions = null;
            if (member == null) {
                actions = cp.getMouseActionsHook() != null ? cp.getMouseActionsHook().getRightClickContributions(gie) : null;
            } else if (member instanceof TSENode) {
                TSENode tsNode = (TSENode)member;
                if (tsNode != null && cp.getMouseActionsHook() != null) {
                    actions = cp.getMouseActionsHook().getRightClickContributions(tsNode);
                }
            } else if (member instanceof TSEEdge && (tsEdge = (TSEEdge)member) != null && cp.getMouseActionsHook() != null) {
                actions = cp.getMouseActionsHook().getRightClickContributions(tsEdge, gie.getContextData());
            }
            if (actions != null) {
                for (Object objItem : actions) {
                    ContributionItem item;
                    if (objItem instanceof ContributionItem) {
                        item = (ContributionItem)objItem;
                        manager.add((IContributionItem)item);
                        continue;
                    }
                    if (!(objItem instanceof IMenuManager)) continue;
                    item = (IMenuManager)objItem;
                    manager.add((IContributionItem)item);
                }
            }
            if (!gie.getElems().isEmpty()) {
                Action expandRightClickAction = new Action(){

                    public void run() {
                        GraphInnerStructureView.this.treeViewer.expandToLevel((Object)gie, -1);
                    }
                };
                expandRightClickAction.setText(Messages.getString(GraphInnerStructureView.class, "expand.toDepth.text"));
                manager.add((IAction)expandRightClickAction);
            }
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GraphInnerStructureView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }

    public void setAnalysisView(GraphsView analysisView) {
        this.analysisView = analysisView;
    }

    public void selectGraphNodeInTree(TSENode node) {
        if (node == null) {
            return;
        }
        TreeItem treeItem = this.getTreeItemForTSNode(node);
        if (treeItem != null) {
            this.treeViewer.getTree().setSelection(treeItem);
            this.ti = null;
        } else {
            Tree tree = this.treeViewer.getTree();
            if (!tree.isDisposed()) {
                this.treeViewer.getTree().deselectAll();
            }
        }
    }

    private TreeItem getTreeItemForTSNode(TSENode node) {
        Tree treeWidget;
        String tag = node.getText();
        if (node.hasAttribute("TAG_VISIBLE_ONLY_GRAPHINVENTORY")) {
            tag = (String)node.getAttributeValue("TAG_VISIBLE_ONLY_GRAPHINVENTORY");
        }
        GraphInnerElement gie = new GraphInnerElement(tag, (TSGraphMember)node);
        TSENode node1 = (TSENode)node.getAttributeValue("ALTERNATIVENODE");
        GraphInnerElement gie1 = null;
        if (node1 != null) {
            gie1 = new GraphInnerElement(node1.getText(), (TSGraphMember)node1);
        }
        if (!(treeWidget = this.treeViewer.getTree()).isDisposed()) {
            TreeItem[] treeItems = treeWidget.getItems();
            this.recursiv(treeItems, gie, gie1);
        }
        return this.ti;
    }

    private void recursiv(TreeItem[] input, GraphInnerElement gie, GraphInnerElement gie1) {
        int i = 0;
        while (input != null && i < input.length) {
            if (this.ti != null) {
                return;
            }
            Object obj = input[i].getData();
            if (gie.equals((Object)((GraphInnerElement)obj))) {
                this.ti = input[i];
                return;
            }
            if (gie1 != null && gie1.equals((Object)((GraphInnerElement)obj))) {
                this.ti = input[i];
                return;
            }
            boolean expandedState = false;
            if (this.ti == null) {
                if (!this.treeViewer.getExpandedState(obj)) {
                    this.treeViewer.expandToLevel(obj, 1);
                    expandedState = true;
                }
                this.recursiv(input[i].getItems(), gie, gie1);
            }
            if (expandedState) {
                this.treeViewer.collapseToLevel(obj, 1);
            }
            ++i;
        }
    }

    public void dispose() {
        IWorkbenchPage page = this.getSite().getPage();
        page.removePartListener(this.partListener);
    }

    public void clearAtCloseTab() {
        if (this.currentCP != null) {
            this.currentCP.dispose();
            this.currentCP = null;
        }
    }

    @Override
    public void setPart(GraphsView view) {
        view.setStructurePart(this);
    }

    public String getContributorId() {
        return "ezselection.contributor";
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            TabbedPropertySheetPage page = new TabbedPropertySheetPage(this){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    if (selection instanceof EZSelection) {
                        super.selectionChanged(part, (ISelection)new StructuredSelection((Object)selection));
                    } else {
                        super.selectionChanged(part, selection);
                    }
                }
            };
            return page;
        }
        return super.getAdapter(adapter);
    }

    public void setContentProviders(Set<StructureContentProvider> contentProviders) {
        if (!contentProviders.equals(this.contentProviders)) {
            this.contentProviders = new TreeSet<StructureContentProvider>(contentProviders);
            this.currentCP = null;
            if (this.contentProviders.size() == 1) {
                this.currentCP = this.contentProviders.iterator().next();
                this.currentCP.setCurrent(true);
            }
            for (StructureContentProvider structContentProvider : this.contentProviders) {
                if (!structContentProvider.isCurrent()) continue;
                this.currentCP = structContentProvider;
                break;
            }
            if (this.currentCP == null) {
                for (StructureContentProvider structContentProvider : this.contentProviders) {
                    if (!structContentProvider.isDefault()) continue;
                    this.currentCP = structContentProvider;
                    structContentProvider.setCurrent(true);
                    IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
                    int i = 0;
                    while (i < mgr.getItems().length) {
                        ActionContributionItem itm = (ActionContributionItem)mgr.getItems()[i];
                        itm.getAction().setEnabled(true);
                        ++i;
                    }
                    break block1;
                }
            }
            this.refreshCurrentCP(false);
            this.createToolBar();
        } else {
            IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
            int i = 0;
            while (i < mgr.getItems().length) {
                ActionContributionItem itm = (ActionContributionItem)mgr.getItems()[i];
                if (itm.getAction() instanceof ToolbarAction) {
                    ToolbarAction ta = (ToolbarAction)itm.getAction();
                    if (ta.provider == this.currentCP) {
                        ta.setChecked(true);
                    } else {
                        ta.setChecked(false);
                    }
                }
                ++i;
            }
            this.refreshCurrentCP(false);
        }
    }

    private void createToolBar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        if (this.contentProviders != null && this.contentProviders.size() > 1) {
            mgr.removeAll();
            for (StructureContentProvider provider : this.contentProviders) {
                ToolbarAction ta = new ToolbarAction(provider);
                mgr.add((IAction)ta);
            }
        } else {
            mgr.removeAll();
        }
        this.checkAndCreateExportAction(mgr);
        mgr.update(true);
        this.getViewSite().getActionBars().updateActionBars();
    }

    private void checkAndCreateExportAction(IToolBarManager mgr) {
        if (this.currentCP != null && this.currentCP.hasExport()) {
            ToolbarExportAction exportAction = new ToolbarExportAction();
            exportAction.setId(EZ_EXPORT_ACTION_ID);
            mgr.add((IAction)exportAction);
            exportAction.setEnabled(true);
        }
    }

    private void refreshCurrentCP(boolean considerExport) {
        this.treeViewer.setSorter(null);
        this.currentCP.setChangeObserver(this.co);
        this.treeViewer.setInput(this.currentCP.getInputTree());
        this.setViewerContentProvider((ITreeContentProvider)this.currentCP, (ViewerFilter)this.currentCP.getViewerFilter());
        if (this.currentCP != null) {
            StyledCellLabelProvider lblProv;
            if (((StructureContentProviderAdapter)this.currentCP).hasStringSorter()) {
                ViewerSorter srt = ((StructureContentProviderAdapter)this.currentCP).getSorter();
                if (srt != null) {
                    this.treeViewer.setSorter(srt);
                } else {
                    this.treeViewer.setSorter((ViewerSorter)this.nameSorter);
                }
            }
            if ((lblProv = ((StructureContentProviderAdapter)this.currentCP).getLabelProvider()) != null) {
                if (this.treeViewer.getLabelProvider() != lblProv) {
                    this.treeViewer.setLabelProvider((IBaseLabelProvider)lblProv);
                }
            } else if (this.treeViewer.getLabelProvider() != this.labelProvider) {
                this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            }
        }
        if (considerExport) {
            IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
            IContributionItem exportItm = mgr.find(EZ_EXPORT_ACTION_ID);
            if (exportItm != null) {
                ToolbarExportAction exportAction = (ToolbarExportAction)((ActionContributionItem)exportItm).getAction();
                if (this.currentCP != null) {
                    exportAction.setEnabled(this.currentCP.hasExport());
                } else {
                    exportAction.setEnabled(false);
                }
            } else if (this.currentCP != null && this.currentCP.hasExport()) {
                this.checkAndCreateExportAction(mgr);
                mgr.update(true);
            }
        }
    }

    private class DefaultTreeContentProvider
    implements ITreeContentProvider {
        private Object[] o = new Object[0];

        private DefaultTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.o;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            String name2;
            String name1;
            if (viewer == null || !(viewer instanceof ContentViewer)) {
                name1 = e1.toString();
                name2 = e2.toString();
            } else {
                IBaseLabelProvider prov = ((ContentViewer)viewer).getLabelProvider();
                if (prov instanceof ILabelProvider) {
                    ILabelProvider lprov = (ILabelProvider)prov;
                    name1 = lprov.getText(e1);
                    name2 = lprov.getText(e2);
                } else {
                    name1 = e1.toString();
                    name2 = e2.toString();
                }
            }
            if (name1 == null) {
                name1 = EMPTY_STRING;
            }
            if (name2 == null) {
                name2 = EMPTY_STRING;
            }
            return Collator.getInstance().compare(name1, name2);
        }
    }

    class ToolbarAction
    extends Action {
        StructureContentProvider provider;

        public ToolbarAction(StructureContentProvider provider) {
            super(EMPTY_STRING, 8);
            this.provider = provider;
            this.setChecked(this.provider.isCurrent());
        }

        public String getToolTipText() {
            return this.provider != null ? this.provider.getToolbarName() : EMPTY_STRING;
        }

        public void run() {
            if (this.isChecked()) {
                this.provider.setCurrent(true);
                GraphInnerStructureView.this.currentCP = this.provider;
                IToolBarManager mgr = GraphInnerStructureView.this.getViewSite().getActionBars().getToolBarManager();
                int i = 0;
                while (i < mgr.getItems().length) {
                    ToolbarAction toolBarAction;
                    Action action = (Action)((ActionContributionItem)mgr.getItems()[i]).getAction();
                    if (action instanceof ToolbarAction && (toolBarAction = (ToolbarAction)action) != this) {
                        toolBarAction.provider.setCurrent(false);
                    }
                    ++i;
                }
                GraphInnerStructureView.this.refreshCurrentCP(true);
            }
        }

        public ImageDescriptor getImageDescriptor() {
            return this.provider.getToolbarImage();
        }
    }

    class ToolbarExportAction
    extends Action {
        private List<List<String>> exportList2;

        public ToolbarExportAction() {
            super(EMPTY_STRING, 1);
            this.exportList2 = new ArrayList<List<String>>();
            this.setChecked(false);
        }

        public String getToolTipText() {
            String toolTip = Messages.getString(GraphInnerStructureView.class, "export.file.tooltip");
            return GraphInnerStructureView.this.currentCP != null ? toolTip : EMPTY_STRING;
        }

        public void run() {
            L.debug("Export Graph Inventory action starts");
            this.exportList2.clear();
            if (GraphInnerStructureView.this.currentCP != null) {
                String pathFile;
                Object tree = GraphInnerStructureView.this.currentCP.getInputTree();
                if (tree != null && tree instanceof GraphInnerElement) {
                    GraphInnerElement root = (GraphInnerElement)tree;
                    this.parseChildren(root);
                }
                if ((pathFile = this.getExportPath()) != null) {
                    this.saveToFile(pathFile);
                }
            }
            L.debug("Export action finished execution");
        }

        private void parseChildren(GraphInnerElement root) {
            if (root != null) {
                Stack<Pair> stack = new Stack<Pair>();
                LinkedList<String> path = new LinkedList<String>();
                Integer level = new Integer(0);
                stack.push(new Pair((Object)root, (Object)level));
                while (!stack.isEmpty()) {
                    Pair node = (Pair)stack.pop();
                    while (Integer.valueOf(level) > Integer.valueOf((Integer)node.getSecond())) {
                        if (path.isEmpty()) continue;
                        path.removeFirst();
                        level = level - 1;
                    }
                    if (((GraphInnerElement)node.getFirst()).getName() != null) {
                        String name = this.parseName((GraphInnerElement)node.getFirst());
                        path.add(0, name);
                    }
                    level = (Integer)node.getSecond();
                    List children = ((GraphInnerElement)node.getFirst()).getElems();
                    if (children.isEmpty()) {
                        if (level <= 0) continue;
                        this.exportList2.add(new ArrayList(path));
                        path.removeFirst();
                        continue;
                    }
                    for (GraphInnerElement child : children) {
                        stack.push(new Pair((Object)child, (Object)(level + 1)));
                    }
                }
            }
        }

        private String parseName(GraphInnerElement graphInnerElement) {
            String nodeName;
            String result = graphInnerElement.getName();
            if (graphInnerElement.getNode() != null && (nodeName = (String)graphInnerElement.getNode().getName()) != null && nodeName.equals(result)) {
                return nodeName;
            }
            if (result != null && result.lastIndexOf("(") >= 0) {
                int pos = result.lastIndexOf("(");
                result = result.substring(0, pos);
                result = result.trim();
            }
            return result;
        }

        public void saveToFile(String file) {
            block20: {
                FileWriter fWriter = null;
                String SEPARATOR = ",";
                try {
                    try {
                        fWriter = new FileWriter(file);
                        BufferedWriter br = new BufferedWriter(fWriter);
                        if (!this.exportList2.isEmpty()) {
                            Collections.sort(this.exportList2, new CustomComparator());
                            int maxListSize = this.getMaxListSize(this.exportList2);
                            Iterator<List<String>> iterator = this.exportList2.iterator();
                            while (iterator.hasNext()) {
                                int i;
                                List<String> list = iterator.next();
                                if (list != null) {
                                    if (list.size() < maxListSize) {
                                        i = list.size();
                                        while (i < maxListSize) {
                                            br.write(SEPARATOR);
                                            ++i;
                                        }
                                    }
                                    i = 0;
                                    while (i < list.size()) {
                                        br.write(list.get(i));
                                        if (i < list.size() - 1) {
                                            br.write(SEPARATOR);
                                        }
                                        ++i;
                                    }
                                    if (!iterator.hasNext()) continue;
                                    br.newLine();
                                    continue;
                                }
                                i = 0;
                                while (i < maxListSize - 1) {
                                    br.write(SEPARATOR);
                                    ++i;
                                }
                                if (!iterator.hasNext()) continue;
                                br.newLine();
                            }
                            br.flush();
                        }
                    }
                    catch (Exception e) {
                        L.error("Error occurred when exporting file: {}", (Object)e.getMessage());
                        if (fWriter == null) break block20;
                        try {
                            fWriter.close();
                        }
                        catch (IOException e2) {
                            L.error("cannot save exported file ", (Throwable)e2);
                        }
                    }
                }
                finally {
                    if (fWriter != null) {
                        try {
                            fWriter.close();
                        }
                        catch (IOException e) {
                            L.error("cannot save exported file ", (Throwable)e);
                        }
                    }
                }
            }
        }

        private int getMaxListSize(List<List<String>> exportList2) {
            int maxListSize = 0;
            for (List<String> lista : exportList2) {
                if (lista == null || lista.size() <= maxListSize) continue;
                maxListSize = lista.size();
            }
            return maxListSize;
        }

        private String getExportPath() {
            String result = null;
            String allFiles = new String("*.*");
            String csvExtension = new String(".csv");
            FileDialog fDialog = new FileDialog(GraphInnerStructureView.this.getViewSite().getShell(), 8192);
            fDialog.setFilterExtensions(new String[]{csvExtension, allFiles});
            fDialog.setText(Messages.getString(GraphInnerStructureView.class, "export.file.txt"));
            result = fDialog.open();
            return result;
        }

        public ImageDescriptor getImageDescriptor() {
            ImageDescriptor descriptor = Activator.getImageDescriptor("icons/exportGraphInventory.png");
            return descriptor;
        }

        private class CustomComparator
        implements Comparator<List<String>> {
            private CustomComparator() {
            }

            @Override
            public int compare(List<String> l1, List<String> l2) {
                if (l1 == null && l2 == null) {
                    return 0;
                }
                if (l1 == null) {
                    return -1;
                }
                if (l2 == null) {
                    return 1;
                }
                if (l1.size() == 1 && l2.size() == 1) {
                    return l1.get(0).compareTo(l2.get(0));
                }
                if (l1.size() == 1) {
                    return 1;
                }
                if (l2.size() == 1) {
                    return -1;
                }
                if (l1.get(1).compareTo(l2.get(1)) == 0) {
                    return l1.get(0).compareTo(l2.get(0));
                }
                return l1.get(1).compareTo(l2.get(1));
            }
        }
    }
}

