/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.display.view;

import com.ez.workspace.Activator;
import com.ez.workspace.analysis.graph.model.GraphInnerElement;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;

public class GraphInnerLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Color red = null;
    private Color darkRed = null;
    private Color blue = null;
    private Image imgfunnel = Activator.getImageDescriptor((String)"icons/funnel.png").createImage();
    private Image imgmore = Activator.getImageDescriptor((String)"icons/graph_more.png").createImage();
    private Image imgpath = Activator.getImageDescriptor((String)"icons/no_path.png").createImage();

    public String getText(Object element) {
        if (element instanceof GraphInnerElement) {
            if (((GraphInnerElement)element).getName() == null) {
                return null;
            }
            return ((GraphInnerElement)element).getName();
        }
        return null;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (element instanceof GraphInnerElement) {
            boolean isNotExpandedNode;
            boolean hasPath;
            boolean isExpandableNode;
            boolean isRestrictedNode;
            boolean isNodeInput;
            boolean dynamic;
            GraphInnerElement gel = (GraphInnerElement)element;
            TSGraphMember node = gel.getNode();
            Boolean value = node == null ? Boolean.FALSE : (Boolean)node.getAttributeValue("DYNAMIC");
            boolean bl = dynamic = value != null && value != false;
            if (dynamic) {
                cell.setForeground(this.getRed());
            }
            value = node == null ? Boolean.FALSE : (Boolean)node.getAttributeValue("node is input for callgraph");
            boolean bl2 = isNodeInput = value != null && value != false;
            if (isNodeInput) {
                cell.setForeground(this.getBlue());
            } else {
                cell.setForeground(null);
            }
            value = node == null ? Boolean.FALSE : (Boolean)node.getAttributeValue("node with restrictions, in callgraph ");
            boolean bl3 = isRestrictedNode = value != null && value != false;
            if (isRestrictedNode) {
                cell.setForeground(this.getDarkRed());
                cell.setImage(this.imgfunnel);
            }
            value = node == null ? Boolean.FALSE : (Boolean)node.getAttributeValue("node is not expanded, but can be expanded, in callgraph");
            boolean bl4 = isExpandableNode = value != null && value != false;
            if (isExpandableNode && !isRestrictedNode) {
                cell.setImage(this.imgmore);
            }
            if (node != null && (value = (Boolean)node.getAttributeValue("program occur")) != null && !(hasPath = value.booleanValue())) {
                cell.setImage(this.imgpath);
            }
            value = node == null ? Boolean.FALSE : (Boolean)node.getAttributeValue("node is not expanded in callgraph");
            boolean bl5 = isNotExpandedNode = value != null && value != false;
            if (isNotExpandedNode) {
                cell.setForeground(this.getDarkRed());
            }
            if (node != null && node.hasAttribute("java wazi graph node")) {
                TSEColor c = null;
                if (node.hasAttribute("uiStyle") && ((String)node.getAttributeValue("uiStyle")).equals("svg")) {
                    c = (TSEColor)node.getAttributeValue("Text_Color");
                } else if (node.hasAttribute("uiStyle") && ((String)node.getAttributeValue("uiStyle")).equals("!svg")) {
                    c = (TSEColor)node.getAttributeValue("Fill_Color");
                }
                if (c != null && (node.hasAttribute("java wazi graph library node") && ((Boolean)node.getAttributeValue("java wazi graph library node")).booleanValue() || !node.hasAttribute("java wazi graph library node"))) {
                    cell.setForeground(new Color((Device)this.getViewer().getControl().getDisplay(), c.getColor().getRed(), c.getColor().getGreen(), c.getColor().getBlue()));
                }
            }
            if (isNodeInput) {
                cell.setForeground(this.getBlue());
            }
        }
        cell.setText(this.getText(element));
        super.update(cell);
    }

    protected RuntimeException unknownElement(Object element) {
        return new RuntimeException("Unknown type of element in tree of type " + element.getClass().getName());
    }

    public Image getImage(Object element) {
        return null;
    }

    private Color getRed() {
        if (this.red == null || this.red.isDisposed()) {
            this.red = new Color((Device)this.getViewer().getControl().getDisplay(), 255, 0, 0);
        }
        return this.red;
    }

    private Color getDarkRed() {
        if (this.darkRed == null || this.darkRed.isDisposed()) {
            this.darkRed = new Color((Device)this.getViewer().getControl().getDisplay(), 153, 0, 0);
        }
        return this.darkRed;
    }

    private Color getBlue() {
        if (this.blue == null || this.blue.isDisposed()) {
            this.blue = new Color((Device)this.getViewer().getControl().getDisplay(), 0, 0, 255);
        }
        return this.blue;
    }

    public void dispose() {
        if (this.red != null && !this.red.isDisposed()) {
            this.red.dispose();
        }
        if (this.blue != null && !this.blue.isDisposed()) {
            this.blue.dispose();
        }
        if (this.darkRed != null && !this.darkRed.isDisposed()) {
            this.darkRed.dispose();
        }
        if (this.imgfunnel != null) {
            this.imgfunnel.dispose();
        }
        if (this.imgmore != null) {
            this.imgmore.dispose();
        }
        if (this.imgpath != null) {
            this.imgpath.dispose();
        }
        super.dispose();
    }
}

