/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.display.view;

import com.ez.analysis.display.Messages;
import com.ez.analysis.display.job.FiltersViewJob;
import com.ez.analysis.display.listener.ViewPartListener;
import com.ez.analysis.display.view.GraphPartView;
import com.ez.analysis.display.view.GraphsView;
import com.ez.workspace.analysis.graph.model.GraphFilter;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.part.ViewPart;

public class GraphFiltersView
extends ViewPart
implements GraphPartView {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private GraphsView analysisView;
    private IPartListener2 partListener = null;
    private Label test;
    private Composite filters;
    private StackLayout stackLayout = null;
    private Composite component = null;
    private Composite byTypePanel = null;
    private Composite typesPanel = null;
    private Composite byDetailPanel = null;
    private GraphFilterInfo filterInfo = null;
    private FilterSelection selectionHandler = new FilterSelection();

    public void createPartControl(Composite parent) {
        this.component = new Composite(parent, 0);
        this.stackLayout = new StackLayout();
        this.component.setLayout((Layout)this.stackLayout);
        this.test = new Label(this.component, 0);
        this.test.setText(Messages.getString(GraphFiltersView.class, "test.label.text"));
        this.stackLayout.topControl = this.test;
        this.filters = new Composite(this.component, 0);
        this.filters.setLayout((Layout)new FillLayout());
        CTabFolder folder = new CTabFolder(this.filters, 2048);
        folder.setSimple(false);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(Messages.getString(GraphFiltersView.class, "item.text"));
        this.byTypePanel = new Composite((Composite)folder, 0);
        FormLayout fl = new FormLayout();
        this.byTypePanel.setLayout((Layout)fl);
        item.setControl((Control)this.byTypePanel);
        folder.setSelection(item);
        Button showMeta = new Button(this.byTypePanel, 32);
        showMeta.setText(Messages.getString(GraphFiltersView.class, "showMeta.button.text"));
        showMeta.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GraphFiltersView.this.filterInfo.setUseMetaEdges(((Button)e.getSource()).getSelection());
            }
        });
        this.typesPanel = new Composite(this.byTypePanel, 0);
        this.typesPanel.setLayout((Layout)new GridLayout(2, false));
        FormData fd = new FormData();
        fd.top = new FormAttachment(0);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        showMeta.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)showMeta, 0);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        fd.bottom = new FormAttachment(100);
        this.typesPanel.setLayoutData((Object)fd);
        Label l = new Label(this.typesPanel, 0);
        l.setText(Messages.getString(GraphFiltersView.class, "label.text"));
        CTabItem item2 = new CTabItem(folder, 0);
        item2.setText(Messages.getString(GraphFiltersView.class, "filter.bydetail.item.text"));
        this.byDetailPanel = new Composite((Composite)folder, 0);
        this.byDetailPanel.setLayout((Layout)new RowLayout());
        item2.setControl((Control)this.byDetailPanel);
        FiltersViewJob filtersJob = new FiltersViewJob(this);
        filtersJob.schedule();
        this.partListener = new ViewPartListener(this);
        this.getSite().getPage().addPartListener(this.partListener);
    }

    @Override
    public void setPart(GraphsView view) {
        this.analysisView = view;
    }

    public void setFocus() {
    }

    public void setFilters(GraphFilterInfo filterInfo) {
        this.filterInfo = filterInfo;
        if (filterInfo == null || filterInfo.getFilters().size() == 0) {
            this.stackLayout.topControl = this.test;
            this.component.layout();
        } else {
            Control[] controlArray = this.typesPanel.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                if (c instanceof Button) {
                    ((Button)c).removeSelectionListener((SelectionListener)this.selectionHandler);
                }
                c.dispose();
                ++n2;
            }
            for (GraphFilter gf : filterInfo.getFilters()) {
                Button b = new Button(this.typesPanel, 32);
                b.addSelectionListener((SelectionListener)this.selectionHandler);
                b.setData((Object)gf);
                b.setSelection(filterInfo.getSelection(gf));
                Image image = gf.image;
                b.setImage(image);
                Label l2 = new Label(this.typesPanel, 0);
                l2.setText(gf.text);
            }
            this.typesPanel.computeSize(-1, -1);
            this.typesPanel.layout();
            this.stackLayout.topControl = this.filters;
            this.byDetailPanel.layout();
            this.component.layout();
        }
    }

    class FilterSelection
    extends SelectionAdapter {
        FilterSelection() {
        }

        public void widgetSelected(SelectionEvent e) {
            GraphFilter gf = (GraphFilter)((Button)e.getSource()).getData();
            boolean b = ((Button)e.getSource()).getSelection();
            GraphFiltersView.this.filterInfo.selectionChanged(gf, b);
        }
    }
}

