/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.display.view;

import com.ez.analysis.display.utils.Utils;
import com.ez.analysis.display.view.AnalysisView;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.change.DirtyStatus;
import com.ez.workspace.change.EZResourceModifiedEvent;
import com.ez.workspace.change.IEZResourceChangedListener;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Display;

public class AnalysisViewResChangeListener
implements IEZResourceChangedListener {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final char DIRTY_SYMBOL = '*';
    private Map infos;

    public AnalysisViewResChangeListener(Map infos) {
        this.infos = infos;
    }

    public void resourceModified(EZResourceModifiedEvent event) {
        this.handleDirtyGraph(event);
    }

    private void markAsDirtyTab(final AnalysisView.PartInfo partInfo, final DirtyStatus isDirty) {
        if (partInfo != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CTabItem item = partInfo.item;
                    if (item != null && !item.isDisposed()) {
                        String currentText = item.getText();
                        if ((currentText = AnalysisViewResChangeListener.this.markAsDirtyText(currentText, isDirty)) != null) {
                            item.setText(currentText);
                        }
                    }
                }
            });
        }
    }

    private String markAsDirtyText(String text, DirtyStatus dirty) {
        return Utils.computeDirtyText(text, dirty);
    }

    private void handleDirtyGraph(EZResourceModifiedEvent event) {
        IResource resource;
        if (event != null && event.getResource() != null && (resource = event.getResource()) != null) {
            ArrayList<IResource> resources = new ArrayList<IResource>();
            resources.add(resource);
            ArrayList partInfos = new ArrayList(this.infos.values());
            for (AnalysisView.PartInfo partInfo : partInfos) {
                boolean haveToMarkResources;
                GraphInfo graphInfo;
                if (partInfo == null || (graphInfo = partInfo.graphInfo) == null || !(haveToMarkResources = graphInfo.checkResourcesInAnalsysis(resources, event.getType()))) continue;
                this.markAsDirtyTab(partInfo, event.getType());
            }
        }
    }
}

