/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.display.view;

import com.ez.analysis.display.AnalysisViewSelectionListener;
import com.ez.analysis.display.EZSelectionProvider;
import com.ez.analysis.display.Messages;
import com.ez.analysis.display.job.EZJobsListener;
import com.ez.analysis.display.listener.EZSelTabListener;
import com.ez.analysis.display.listener.EZTabListener;
import com.ez.analysis.display.listener.HistoryManager;
import com.ez.analysis.display.utils.AnalysisDisplayLogUtil;
import com.ez.analysis.display.utils.Utils;
import com.ez.analysis.display.view.AnalysisViewResChangeListener;
import com.ez.analysis.display.view.GraphInnerStructureView;
import com.ez.analysis.display.view.GraphOverview;
import com.ez.analysis.display.view.LegendComponent;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.graphmodel.EZSelection;
import com.ez.internal.id.EZEntityID;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.job.GraphTranslateJob;
import com.ez.workspace.change.DirtyStatus;
import com.ez.workspace.change.EZChangingManager;
import com.ez.workspace.change.IEZResourceChangedListener;
import com.ez.workspace.model.EZJobAdapterFactory;
import com.ez.workspace.model.EZWorkspace;
import com.tomsawyer.drawing.geometry.shared.TSConstRect;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.TSEObject;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.interactive.swing.TSSwingCanvas;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnalysisView
extends ViewPart
implements ITabbedPropertySheetPageContributor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AnalysisView.class);
    public List menuItems = new ArrayList();
    public List toolBarItems = new ArrayList();
    public List contextItems = new ArrayList();
    private EZSelTabListener selTabListener = null;
    private EZTabListener tabListener = null;
    private IJobChangeListener jobListener = null;
    private TabsListener listener = null;
    private MouseAdapter closeListener = null;
    private FolderDisposeListener folderDisposeListener = null;
    private EZSelectionProvider selProvider = new EZSelectionProvider();
    protected CTabFolder folder = null;
    private Map infos = new HashMap();
    protected Map tabs = new HashMap();
    private Map hooks = new HashMap();
    private Cursor handCursor = null;
    private Cursor arrowCursor = null;
    private HistoryManager hm;
    private IEZResourceChangedListener modifyResourceListener;
    private Frame frame = null;
    private JPanel jPanel = null;
    private Composite panel = null;
    private AnalysisViewSelectionListener selectionListener;
    private List handlerKeys = new ArrayList();

    public void createPartControl(Composite parent) {
        this.folder = new CTabFolder(parent, 1051714);
        this.folder.setMRUVisible(true);
        this.listener = new TabsListener();
        this.folder.addListener(29, (Listener)this.listener);
        this.folder.addListener(4, (Listener)this.listener);
        this.folder.addListener(5, (Listener)this.listener);
        this.folder.addListener(7, (Listener)this.listener);
        this.folder.addListener(6, (Listener)this.listener);
        this.closeListener = new CloseFolderListener();
        this.folder.addMouseListener((MouseListener)this.closeListener);
        this.hm = new HistoryManager(this);
        this.hm.initActions(this.folder);
        this.selTabListener = new EZSelTabListener(this);
        this.folder.addSelectionListener((SelectionListener)this.selTabListener);
        this.folder.addSelectionListener((SelectionListener)this.hm);
        this.tabListener = new EZTabListener(this);
        this.folder.addCTabFolder2Listener((CTabFolder2Listener)this.tabListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selProvider);
        this.jobListener = new EZJobsListener(this);
        Job.getJobManager().addJobChangeListener(this.jobListener);
        this.folderDisposeListener = new FolderDisposeListener();
        this.folder.addDisposeListener((DisposeListener)this.folderDisposeListener);
        this.handCursor = new Cursor((Device)this.folder.getDisplay(), 21);
        this.arrowCursor = new Cursor((Device)this.folder.getDisplay(), 0);
        this.initElements();
        this.frame = this.getFrame();
        this.selectionListener = new AnalysisViewSelectionListener(this);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this.selectionListener);
        this.addChangingResourceListener();
    }

    protected void initElements() {
    }

    private void displayInitialGraphs() {
        IWorkbenchPage page = this.getSite().getPage();
        IEditorReference[] editorRefs = page.getEditorReferences();
        IEditorPart part = null;
        IFile resource = null;
        IEditorInput iei = null;
        EZWorkspace ws = EZWorkspace.getInstance();
        EZJobAdapterFactory jobFactory = (EZJobAdapterFactory)ws.getAdapter(EZJobAdapterFactory.class);
        EZEntityID modelID = null;
        if (jobFactory != null) {
            int i = 0;
            while (i < editorRefs.length) {
                part = editorRefs[i].getEditor(true);
                iei = ((EditorPart)part).getEditorInput();
                if (iei instanceof IFileEditorInput) {
                    resource = ((IFileEditorInput)iei).getFile();
                }
                if (resource != null && (modelID = ws.getModelEntityID((IResource)resource)) != null) {
                    GraphTranslateJob job = jobFactory.getInstance(modelID);
                    if (job != null) {
                        job.init();
                    } else {
                        L.debug("AnalysisView : adapter null part: {}", (Object)part);
                    }
                }
                ++i;
            }
        }
    }

    public void close(GraphInfo info) {
        if (this.folder == null || info == null) {
            return;
        }
        EZEntityID key = info.getID();
        EntityKey ezKey = new EntityKey(key, info.getClass().getName());
        PartInfo pInfo = (PartInfo)this.infos.get(ezKey);
        if (pInfo != null) {
            if (pInfo.item != null) {
                final CTabItem item = pInfo.item;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        AnalysisView.this.removeTabItem(item);
                        item.dispose();
                    }
                });
            }
        } else {
            L.debug("could not find part info for {} graphInfo was not set.", (Object)ezKey);
        }
    }

    public void setGraphInfo(GraphInfo info, boolean enabled) {
        if (this.folder == null) {
            return;
        }
        EZEntityID key = info.getID();
        EntityKey ezKey = new EntityKey(key, info.getClass().getName());
        Component cmp = info.getCanvasComponent();
        if (cmp != null) {
            this.refreshPanelWith(cmp);
        }
        RefreshGraphInfo refreshInfo = new RefreshGraphInfo();
        refreshInfo.ezKey = ezKey;
        refreshInfo.enabled = enabled;
        refreshInfo.info = info;
        Display.getDefault().asyncExec((Runnable)refreshInfo);
        PartInfo pInfo = (PartInfo)this.infos.get(ezKey);
        if (pInfo != null) {
            pInfo.enabled = enabled;
            this.doRefresh(pInfo);
        } else {
            L.debug("could not find part info for {} graphInfo was not set.", (Object)ezKey);
        }
    }

    protected abstract void doRefresh(PartInfo var1);

    private String computeTabNameOrTooltip(GraphInfo info, boolean computeTooltip) {
        String result = null;
        if (info != null) {
            String text = info.getText();
            String tooltip = info.getTooltip();
            String string = result = computeTooltip && tooltip != null ? tooltip : text;
            if (!computeTooltip) {
                text = Utils.truncateTextIfNecessary(result);
            }
            DirtyStatus status = info.getDirty();
            result = Utils.computeDirtyText(result, status);
        }
        return result;
    }

    public void refreshDetailsFor(CTabItem item) {
        PartInfo pInfo = (PartInfo)this.tabs.get(item);
        this.refreshItem(item);
        if (pInfo != null) {
            this.contributeToActionBars(pInfo, true);
        }
        this.doRefresh(pInfo);
    }

    public void removeTabItem(CTabItem item) {
        if (this.tabs.containsKey(item)) {
            this.hm.deleteItem(item);
            PartInfo pInfo = this.unregisterTab(item);
            this.resetActionBars();
            this.clearAtRemoveTabItem(item, pInfo);
        } else {
            L.debug("tab not found in <tabs>");
        }
    }

    protected abstract void clearAtRemoveTabItem(CTabItem var1, PartInfo var2);

    protected void refreshOverviewFrame(PartInfo pInfo) {
    }

    public void refreshStructTree(PartInfo pInfo) {
    }

    public void refreshStructTree(RefreshStructTree refreshStructTree, PartInfo pInfo) {
    }

    public void removeTabItem(String itemTitle, String className, EZEntityID id) {
        RemoveTabRunnable runn = new RemoveTabRunnable(itemTitle);
        runn.id = id;
        runn.clazzName = className;
        Display.getDefault().syncExec((Runnable)runn);
    }

    public PartInfo unregisterTab(CTabItem item) {
        PartInfo pInfo = null;
        if (this.tabs.containsKey(item)) {
            pInfo = (PartInfo)this.tabs.remove(item);
            EZEntityID id = pInfo.id;
            EntityKey key = new EntityKey(id, pInfo.className);
            this.infos.remove(key);
            item.setControl(null);
            CloseHook hook = (CloseHook)this.hooks.get(key);
            if (hook != null) {
                L.trace("unregisterTab(): before closing job {}", (Object)hook);
                hook.closing();
                this.hooks.remove(key);
            }
            this.unregisterGlobalActions(pInfo);
        }
        return pInfo;
    }

    public void disposeTabs() {
        Set tabsSet = this.tabs.keySet();
        PartInfo pInfo = null;
        if (tabsSet != null) {
            ArrayList tabList = new ArrayList(tabsSet);
            Iterator tIt = tabList.iterator();
            while (tIt.hasNext()) {
                pInfo = (PartInfo)this.tabs.remove(tIt.next());
                EZEntityID id = pInfo.id;
                EntityKey key = new EntityKey(id, pInfo.className);
                this.infos.remove(key);
                CloseHook hook = (CloseHook)this.hooks.get(key);
                if (hook != null) {
                    L.trace("disposeTabs(): before closing job {}", (Object)hook);
                    hook.closing();
                    this.hooks.remove(key);
                }
                this.unregisterGlobalActions(pInfo);
                pInfo.selectionListener = null;
                pInfo.id = null;
            }
        }
    }

    private void resetActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        IMenuManager menuManager = bars.getMenuManager();
        IToolBarManager toolBarManager = bars.getToolBarManager();
        menuManager.removeAll();
        toolBarManager.removeAll();
        menuManager.update(true);
        toolBarManager.update(true);
        bars.updateActionBars();
    }

    public void contributeToActionBars(PartInfo info, boolean enabled) {
        IActionBars bars = this.getViewSite().getActionBars();
        IMenuManager menuManager = bars.getMenuManager();
        IToolBarManager toolBarManager = bars.getToolBarManager();
        this.fillVariablePullDown(info, menuManager, enabled);
        this.fillVariableToolBar(info, toolBarManager, enabled);
        menuManager.update(true);
        toolBarManager.update(true);
        bars.updateActionBars();
    }

    private void fillVariablePullDown(PartInfo info, IMenuManager manager, boolean enabled) {
        manager.removeAll();
        this.addLegendAction(info, (IContributionManager)manager, enabled);
        if (info.menuItems != null) {
            for (IContributionItem item : info.menuItems) {
                if (item instanceof ActionContributionItem) {
                    IAction action = ((ActionContributionItem)item).getAction();
                    if (!enabled) {
                        action.setEnabled(false);
                    }
                }
                manager.add(item);
            }
        }
    }

    private void fillVariableToolBar(PartInfo info, IToolBarManager manager, boolean enabled) {
        manager.removeAll();
        manager.add((IContributionItem)new ActionContributionItem((IAction)this.hm.getBackAction()));
        manager.add((IContributionItem)new ActionContributionItem((IAction)this.hm.getForwardAction()));
        manager.add((IContributionItem)new Separator());
        this.addLegendAction(info, (IContributionManager)manager, enabled);
        if (info != null && info.toolBarItems != null) {
            for (IContributionItem item : info.toolBarItems) {
                if (item instanceof ActionContributionItem) {
                    IAction action = ((ActionContributionItem)item).getAction();
                    if (!enabled) {
                        action.setEnabled(false);
                    }
                }
                manager.add(item);
            }
        }
    }

    protected void addLegendAction(PartInfo info, IContributionManager manager, boolean enabled) {
    }

    public void setFocus() {
        this.folder.setFocus();
    }

    public CTabFolder getUserArea() {
        return this.folder;
    }

    public void setSelection(ISelection selection) {
        L.debug("AnalysisView : setSelection : {}", (Object)selection);
        final ISelection ss = selection;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                AnalysisView.this.selProvider.setSelection(ss);
            }
        });
    }

    public abstract void setOverviewPart(GraphOverview var1);

    public abstract void setStructurePart(GraphInnerStructureView var1);

    protected void refreshFilters(RefreshFilters refreshFiltersRunnable, PartInfo info) {
    }

    private void refreshFilters(PartInfo info) {
    }

    public void dispose() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.PRINT.getId(), null);
        this.disposeTabs();
        if (this.selectionListener != null) {
            this.getSite().getPage().removeSelectionListener((ISelectionListener)this.selectionListener);
            this.selectionListener = null;
        }
        if (!this.folder.isDisposed()) {
            this.folder.dispose();
        }
        this.folder = null;
        this.infos.clear();
        this.tabs.clear();
        this.hooks.clear();
        this.handCursor.dispose();
        this.arrowCursor.dispose();
        Job.getJobManager().removeJobChangeListener(this.jobListener);
        super.dispose();
    }

    public void closeSelectedTab() {
        CTabItem item = this.folder.getSelection();
        if (item != null) {
            this.removeTabItem(item);
            item.dispose();
        }
    }

    public void closeOtherTabs() {
        CTabItem selItem = this.folder.getSelection();
        CTabItem[] items = this.folder.getItems();
        int i = 0;
        while (i < items.length) {
            if (selItem != items[i]) {
                this.hm.deleteItem(items[i]);
                this.unregisterTab(items[i]);
                items[i].dispose();
            }
            ++i;
        }
        if (selItem != null) {
            this.refreshItem(selItem);
        }
    }

    protected void refreshItem(CTabItem item) {
        PartInfo selInfo = (PartInfo)this.tabs.get(item);
        if (selInfo != null) {
            Component cmp = selInfo.canvasComponent;
            if (cmp != null) {
                this.refreshPanelWith(cmp);
            }
            selInfo.control.refresh();
            item.setControl((Control)selInfo.control);
            this.refreshGlobalActionsEnablement(selInfo, true);
        }
    }

    private void refreshPanelWith(final Component cmp) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    AnalysisView.this.jPanel.removeAll();
                    AnalysisView.this.jPanel.add(cmp, "Center");
                    AnalysisView.this.jPanel.validate();
                }
                catch (Throwable t) {
                    L.error("refresh error", t);
                }
            }
        });
    }

    protected void closeAllTabs() {
        CTabItem[] items = this.folder.getItems();
        int i = 0;
        while (i < items.length) {
            this.hm.deleteItem(items[i]);
            this.unregisterTab(items[i]);
            items[i].dispose();
            ++i;
        }
        this.resetActionBars();
    }

    public boolean isLinkWithEditor() {
        return false;
    }

    private Frame getFrame() {
        if (this.frame == null) {
            this.panel = new Composite((Composite)this.folder, 0x1000000);
            this.panel.setLayout((Layout)new FillLayout());
            this.frame = SWT_AWT.new_Frame((Composite)this.panel);
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.frame.add(this.jPanel);
        }
        return this.frame;
    }

    public TSENode selectObject(Object o) {
        Component cmp;
        TSSwingCanvas canvas;
        PartInfo info;
        TSENode ret = null;
        CTabItem item = this.getUserArea().getSelection();
        if (item != null && (info = (PartInfo)this.tabs.get(item)) != null && (canvas = (TSSwingCanvas)(cmp = info.canvasComponent)) != null && o != null) {
            canvas.deselectAll(false);
            if (o instanceof Collection) {
                Collection tmp = (Collection)o;
                if (tmp.size() < 30) {
                    for (TSEObject obj : tmp) {
                        canvas.selectObject(obj, true);
                    }
                } else {
                    L.info("too many edges to select ({}); selection ignored.", (Object)tmp.size());
                }
            } else {
                TSEObject obj = (TSEObject)o;
                canvas.selectObject(obj, true);
                TSConstRect bounds = obj.getBounds();
                if (obj instanceof TSENode) {
                    TSENode node = (TSENode)obj;
                    node.setAttribute("Selected_Border_Color", (Object)new TSEColor(0, 153, 255));
                    TSENode parent = null;
                    TSENode parentViaGraph = null;
                    if (!node.isSelected()) {
                        if (node.hasAttribute("PARENT")) {
                            parent = (TSENode)node.getAttributeValue("PARENT");
                            canvas.selectObject((TSEObject)parent, true);
                            parent.setAttribute("Selected_Border_Color", (Object)TSEColor.red);
                            bounds = parent.getBounds();
                            while (!parent.isSelected()) {
                                if (!parent.hasAttribute("PARENT")) break;
                                parent = (TSENode)parent.getAttributeValue("PARENT");
                                canvas.selectObject((TSEObject)parent, true);
                                parent.setAttribute("Selected_Border_Color", (Object)TSEColor.red);
                                bounds = parent.getBounds();
                            }
                        }
                        if (parent == null || !parent.isSelected()) {
                            if (node.getOwnerGraph().hasAttribute("PARENT")) {
                                parentViaGraph = (TSENode)node.getOwnerGraph().getAttributeValue("PARENT");
                                canvas.selectObject((TSEObject)parentViaGraph, true);
                                parentViaGraph.setAttribute("Selected_Border_Color", (Object)TSEColor.red);
                                if (parentViaGraph.isSelected()) {
                                    bounds = parentViaGraph.getBounds();
                                    ret = parentViaGraph;
                                } else if (parentViaGraph.hasAttribute("PARENT")) {
                                    parent = (TSENode)parentViaGraph.getAttributeValue("PARENT");
                                    canvas.selectObject((TSEObject)parent, true);
                                    parent.setAttribute("Selected_Border_Color", (Object)TSEColor.red);
                                    bounds = parent.getBounds();
                                    while (!parent.isSelected()) {
                                        if (parent.hasAttribute("PARENT")) {
                                            parent = (TSENode)parent.getAttributeValue("PARENT");
                                            canvas.selectObject((TSEObject)parent, true);
                                            parent.setAttribute("Selected_Border_Color", (Object)TSEColor.red);
                                            bounds = parent.getBounds();
                                            continue;
                                        }
                                        break;
                                    }
                                }
                            }
                        } else {
                            ret = parent;
                        }
                    } else {
                        ret = node;
                    }
                    if (bounds == null) {
                        if (node.hasAttribute("PARENTFORFIT")) {
                            TSENode node4Center = (TSENode)node.getAttributeValue("PARENTFORFIT");
                            bounds = node4Center.getBounds();
                        } else {
                            bounds = node.getBounds();
                        }
                    }
                }
                if (bounds != null) {
                    if (bounds.getWidth() == 0.0) {
                        bounds = new TSConstRect(bounds.getLeft(), bounds.getBottom(), bounds.getRight() + 0.01, bounds.getTop());
                    } else if (bounds.getHeight() == 0.0) {
                        bounds = new TSConstRect(bounds.getLeft(), bounds.getBottom(), bounds.getRight(), bounds.getTop() + 0.01);
                    }
                }
                canvas.centerRectInCanvas(bounds, true);
            }
        }
        if (ret != null) {
            ret.setAttribute("Selected_Border_Color", (Object)new TSEColor(0, 153, 255));
        }
        return ret;
    }

    public void centerRect(TSConstRect rect) {
        Component cmp;
        TSSwingCanvas canvas;
        PartInfo info;
        if (rect == null) {
            throw new IllegalArgumentException();
        }
        CTabItem item = this.getUserArea().getSelection();
        if (item != null && (info = (PartInfo)this.tabs.get(item)) != null && (canvas = (TSSwingCanvas)(cmp = info.canvasComponent)) != null) {
            canvas.centerRectInCanvas(rect, false);
        }
    }

    public List collectAdjacentNodes(List input) {
        TSENode node2 = null;
        ArrayList adjacentNodes = new ArrayList();
        for (TSENode node2 : input) {
            Iterator aIt = node2.adjacentNodeIterator();
            while (aIt.hasNext()) {
                adjacentNodes.add(aIt.next());
            }
        }
        return adjacentNodes;
    }

    private void hookGlobalActions(PartInfo pInfo) {
        IActionBars bars = this.getViewSite().getActionBars();
        if (pInfo.globalActions != null) {
            for (String key : pInfo.globalActions.keySet()) {
                if (bars.getGlobalActionHandler(key) != null) continue;
                L.debug("*********************  registering for {}", (Object)key);
                bars.setGlobalActionHandler(key, (IAction)new GlobalActionHandler(key));
                if (this.handlerKeys.contains(key)) continue;
                this.handlerKeys.add(key);
            }
        }
    }

    private void unregisterGlobalActions(PartInfo pInfo) {
        IActionBars bars = this.getViewSite().getActionBars();
        if (pInfo.globalActions != null) {
            for (String key : pInfo.globalActions.keySet()) {
                IAction action;
                boolean has = false;
                for (PartInfo pi : this.tabs.values()) {
                    if (pi.globalActions == null || pi == pInfo || !pi.globalActions.containsKey(key)) continue;
                    has = true;
                    break;
                }
                if (has) continue;
                L.debug("*************** unregister for {}", (Object)key);
                if (bars != null && (action = bars.getGlobalActionHandler(key)) != null) {
                    action.setEnabled(false);
                    bars.setGlobalActionHandler(key, null);
                }
                this.handlerKeys.remove(key);
            }
        }
    }

    private void refreshGlobalActionsEnablement(PartInfo pInfo, boolean enabled) {
        IAction action;
        IActionBars bars = this.getViewSite().getActionBars();
        for (String key : this.handlerKeys) {
            action = bars.getGlobalActionHandler(key);
            action.setEnabled(false);
        }
        if (enabled && pInfo.globalActions != null) {
            for (String key : pInfo.globalActions.keySet()) {
                action = bars.getGlobalActionHandler(key);
                action.setEnabled(true);
            }
        }
    }

    public String getContributorId() {
        return "ezselection.contributor";
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            TabbedPropertySheetPage page = new TabbedPropertySheetPage(this){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    L.debug("---------analysisView selection: {}", (Object)selection);
                    if (selection instanceof EZSelection) {
                        super.selectionChanged(part, (ISelection)new StructuredSelection((Object)selection));
                    } else {
                        super.selectionChanged(part, selection);
                    }
                }
            };
            return page;
        }
        return super.getAdapter(adapter);
    }

    private void addChangingResourceListener() {
        this.modifyResourceListener = new AnalysisViewResChangeListener(this.infos);
        EZChangingManager.getManager().registerEZResourceModifiedListener(this.modifyResourceListener);
    }

    public void notifySelection(IWorkbenchPart part, ISelection selection) {
        ArrayList pInfos = new ArrayList(this.infos.values());
        for (PartInfo partInfo : pInfos) {
            if (partInfo.selectionListener == null) continue;
            partInfo.selectionListener.selectionChanged(part, selection);
        }
    }

    private class CloseFolderListener
    extends MouseAdapter {
        private MenuManager contextManager = new MenuManager();
        private Action close = null;
        private Action closeOthers = null;
        private Action closeAll = null;

        public CloseFolderListener() {
            this.contextManager.setRemoveAllWhenShown(true);
            this.contextManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager mgr) {
                    CloseFolderListener.this.fillFolderContextMenu(mgr);
                }
            });
        }

        public List getRightClickContributions() {
            ArrayList<ActionContributionItem> contextItems = new ArrayList<ActionContributionItem>();
            if (this.close == null) {
                this.close = new Action(){

                    public void run() {
                        AnalysisView.this.closeSelectedTab();
                    }
                };
                this.close.setText(Messages.getString(AnalysisView.class, "btnClose"));
            }
            if (this.closeOthers == null) {
                this.closeOthers = new Action(){

                    public void run() {
                        AnalysisView.this.closeOtherTabs();
                    }
                };
                this.closeOthers.setText(Messages.getString(AnalysisView.class, "btnCloseOthers"));
            }
            if (this.closeAll == null) {
                this.closeAll = new Action(){

                    public void run() {
                        AnalysisView.this.closeAllTabs();
                    }
                };
                this.closeAll.setText(Messages.getString(AnalysisView.class, "btnCloseAll"));
            }
            contextItems.add(new ActionContributionItem((IAction)this.close));
            contextItems.add(new ActionContributionItem((IAction)this.closeOthers));
            contextItems.add(new ActionContributionItem((IAction)this.closeAll));
            return contextItems;
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 3) {
                Menu menu = this.contextManager.createContextMenu((Control)AnalysisView.this.getSite().getShell());
                AnalysisView.this.getSite().getShell().setMenu(menu);
                menu.setVisible(true);
            }
        }

        private void fillFolderContextMenu(IMenuManager mgr) {
            List contextItems;
            if (AnalysisView.this.folder.getItemCount() > 0 && (contextItems = this.getRightClickContributions()) != null && contextItems.size() > 0) {
                for (ContributionItem item : contextItems) {
                    mgr.add((IContributionItem)item);
                }
            }
        }
    }

    private class EntityKey {
        EZEntityID ezEntityID;
        String className;

        public EntityKey(EZEntityID ezEntityID, String className) {
            this.ezEntityID = ezEntityID;
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public EZEntityID getEzEntityID() {
            return this.ezEntityID;
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntityKey other = (EntityKey)obj;
            if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
                return false;
            }
            return !(this.ezEntityID == null ? other.ezEntityID != null : !this.ezEntityID.equals((Object)other.ezEntityID));
        }
    }

    private class FolderDisposeListener
    implements DisposeListener {
        private FolderDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent e) {
            AnalysisDisplayLogUtil.debug(Messages.getString(AnalysisView.class, "folder.disposed.msg"));
            AnalysisView.this.folder.removeListener(29, (Listener)AnalysisView.this.listener);
            AnalysisView.this.folder.removeListener(4, (Listener)AnalysisView.this.listener);
            AnalysisView.this.folder.removeListener(5, (Listener)AnalysisView.this.listener);
            AnalysisView.this.folder.removeListener(7, (Listener)AnalysisView.this.listener);
            AnalysisView.this.folder.removeListener(6, (Listener)AnalysisView.this.listener);
            AnalysisView.this.folder.removeMouseListener((MouseListener)AnalysisView.this.closeListener);
        }
    }

    class GlobalActionHandler
    extends Action {
        private String type;

        public GlobalActionHandler(String type) {
            this.type = type;
        }

        public void run() {
            CTabItem item = AnalysisView.this.folder.getSelection();
            if (item != null) {
                PartInfo selInfo = (PartInfo)AnalysisView.this.tabs.get(item);
                L.debug("printing {}, {}", (Object)item.getText(), (Object)selInfo);
                if (selInfo != null) {
                    AnalysisView.this.getViewSite().getActionBars();
                    IAction action = (IAction)selInfo.globalActions.get(this.type);
                    L.debug("action:{}", (Object)action);
                    if (action != null) {
                        L.debug("run {} action", (Object)this.type);
                        action.run();
                    }
                }
            }
            super.run();
        }
    }

    class PartInfo {
        public EZEntityID id;
        public CTabItem item;
        public ContentViewer viewer;
        public LegendComponent control;
        public boolean hasLegend;
        public List menuItems;
        public List toolBarItems;
        public MenuManager contextManager;
        public TSEOverviewComponent overviewComponent;
        public Set<StructureContentProvider> contentProviders;
        public Component canvasComponent;
        public String className;
        @Deprecated
        public boolean hasLinkWithEditor = false;
        public Map globalActions;
        public ISelectionListener selectionListener;
        public boolean enabled;
        public GraphFilterInfo graphFilterInfo;
        public GraphInfo graphInfo;

        PartInfo() {
        }
    }

    class RefreshFilters
    implements Runnable {
        PartInfo pInfo = null;

        RefreshFilters() {
        }

        @Override
        public void run() {
            AnalysisView.this.refreshFilters(this.pInfo);
        }
    }

    class RefreshGraphInfo
    implements Runnable {
        EntityKey ezKey = null;
        GraphInfo info = null;
        TSSwingCanvas canvas = null;
        boolean enabled;

        RefreshGraphInfo() {
        }

        @Override
        public void run() {
            Set contentProvider;
            String tabName;
            PartInfo pInfo = null;
            if (AnalysisView.this.folder == null) {
                return;
            }
            Component cmp = this.info.getCanvasComponent();
            if (cmp instanceof TSSwingCanvas) {
                this.canvas = (TSSwingCanvas)cmp;
            }
            boolean inserted = false;
            Composite control = null;
            control = cmp != null ? AnalysisView.this.panel : null;
            if (!AnalysisView.this.infos.containsKey(this.ezKey)) {
                CTabItem item = new CTabItem(AnalysisView.this.folder, 0x100000);
                inserted = true;
                Image img = this.info.getImage();
                if (img != null && !img.isDisposed()) {
                    item.setImage(img);
                }
                ContentViewer viewer = this.info.getViewer();
                if (control == null) {
                    control = this.info.getControl();
                }
                LegendComponent lc = new LegendComponent((Composite)AnalysisView.this.folder, 0);
                final Composite mainControl = control;
                lc.setMainAreaBuilder(new ComponentBuilderInterface(){

                    public Composite buildComponent(Composite parent) {
                        mainControl.setParent(parent);
                        return mainControl;
                    }

                    public int getPercent() {
                        return 0;
                    }
                });
                if (this.info.hasLegend()) {
                    lc.setLegend(this.info.getLegendControl());
                }
                item.setControl((Control)lc);
                pInfo = new PartInfo();
                pInfo.id = this.info.getID();
                pInfo.className = this.info.getClass().getName();
                pInfo.item = item;
                pInfo.viewer = viewer;
                pInfo.control = lc;
                pInfo.hasLegend = this.info.hasLegend();
                pInfo.canvasComponent = cmp;
                pInfo.selectionListener = this.info.getSelectionListener();
                pInfo.graphFilterInfo = this.info.getGraphFilterInfo();
                pInfo.graphInfo = this.info;
                AnalysisView.this.infos.put(this.ezKey, pInfo);
                AnalysisView.this.tabs.put(item, pInfo);
                pInfo.globalActions = this.info.getGlobalActionsContributions();
                AnalysisView.this.hookGlobalActions(pInfo);
                CloseHook hook = this.info.getCloseHook();
                if (hook != null) {
                    AnalysisView.this.hooks.put(this.ezKey, hook);
                }
            } else {
                pInfo = (PartInfo)AnalysisView.this.infos.get(this.ezKey);
                pInfo.enabled = this.enabled;
                if (pInfo.graphInfo != null && pInfo.graphInfo != this.info) {
                    pInfo.viewer = this.info.getViewer();
                    pInfo.hasLegend = this.info.hasLegend();
                    pInfo.selectionListener = this.info.getSelectionListener();
                    pInfo.graphFilterInfo = this.info.getGraphFilterInfo();
                    pInfo.control.setLegend(this.info.getLegendControl());
                    AnalysisView.this.unregisterGlobalActions(pInfo);
                    pInfo.globalActions = this.info.getGlobalActionsContributions();
                    AnalysisView.this.hookGlobalActions(pInfo);
                    CloseHook oldHook = (CloseHook)AnalysisView.this.hooks.get(this.ezKey);
                    CloseHook hook = this.info.getCloseHook();
                    if (oldHook != null && hook != null && oldHook != hook) {
                        GraphInfo cpy = pInfo.graphInfo;
                        this.info.updateInfoAdapter(cpy);
                        pInfo.graphInfo = this.info;
                        L.trace("refreshTab(): before closing job {}", (Object)oldHook);
                        L.trace("oldHook={}", (Object)oldHook);
                        L.trace("newHook={}", (Object)hook);
                        oldHook.closing();
                        oldHook = null;
                        if (hook != null) {
                            AnalysisView.this.hooks.put(this.ezKey, hook);
                        }
                        cpy.dispose();
                        cpy = null;
                    }
                }
                if (pInfo.viewer != null && this.info.getViewer() != null) {
                    IContentProvider cp = this.info.getViewer().getContentProvider();
                    if (cp != null) {
                        pInfo.viewer.setContentProvider(cp);
                    }
                    if (cmp != null) {
                        boolean refresh;
                        pInfo.canvasComponent = cmp;
                        pInfo.viewer = this.info.getViewer();
                        boolean bl = refresh = !this.info.hasLegend() || this.info.isLegendAvailable();
                        if (refresh) {
                            if (pInfo.control.isLegendVisible()) {
                                pInfo.control.setLegendVisible(false);
                                pInfo.control.setLegend(this.info.getLegendControl());
                                pInfo.control.setLegendVisible(true);
                            }
                            pInfo.control.refresh();
                        }
                        pInfo.item.setControl((Control)pInfo.control);
                    }
                } else {
                    pInfo.canvasComponent = cmp;
                    control = this.info.isReport() ? pInfo.graphInfo.getControl() : this.info.getControl();
                    final Composite mainControl = control;
                    pInfo.control.setMainAreaBuilder(new ComponentBuilderInterface(){

                        public Composite buildComponent(Composite parent) {
                            mainControl.setParent(parent);
                            return mainControl;
                        }

                        public int getPercent() {
                            return 0;
                        }
                    });
                    pInfo.item.setControl((Control)pInfo.control);
                    if (!this.info.isReport()) {
                        pInfo.control.refresh();
                    }
                }
            }
            if ((tabName = AnalysisView.this.computeTabNameOrTooltip(this.info, false)).contains("&")) {
                tabName = tabName.replaceAll("&", "&&");
            }
            pInfo.item.setText(tabName);
            String tooltip = AnalysisView.this.computeTabNameOrTooltip(this.info, true);
            if (tooltip.contains("&")) {
                tooltip = tooltip.replaceAll("&", "&&");
            }
            pInfo.item.setToolTipText(tooltip);
            pInfo.menuItems = this.info.getMenuItems();
            pInfo.toolBarItems = this.info.getToolBarItems();
            Object overviewComponent = this.info.getOverviewComponent();
            if (overviewComponent != null && overviewComponent instanceof TSEOverviewComponent) {
                pInfo.overviewComponent = (TSEOverviewComponent)overviewComponent;
            }
            if ((contentProvider = this.info.getContentProviders()) != null) {
                pInfo.contentProviders = contentProvider;
            }
            AnalysisView.this.contributeToActionBars(pInfo, this.enabled);
            AnalysisView.this.folder.setSelection(pInfo.item);
            AnalysisView.this.folder.showItem(pInfo.item);
            if (inserted) {
                AnalysisView.this.hm.registerItem(pInfo.item);
            }
            AnalysisView.this.refreshGlobalActionsEnablement(pInfo, this.enabled);
            if (this.canvas != null) {
                SwingWorker worker = new SwingWorker(){

                    protected Object doInBackground() throws Exception {
                        RefreshGraphInfo.this.canvas.repaint();
                        return null;
                    }
                };
                worker.execute();
            }
        }
    }

    class RefreshStructTree
    implements Runnable {
        PartInfo pInfo = null;

        RefreshStructTree() {
        }

        @Override
        public void run() {
            AnalysisView.this.refreshStructTree(this.pInfo);
        }
    }

    private class RemoveTabRunnable
    implements Runnable {
        String title;
        public EZEntityID id;
        public String clazzName;

        public RemoveTabRunnable(String title) {
            this.title = title;
        }

        @Override
        public void run() {
            CTabItem searched = null;
            EntityKey ezKey = new EntityKey(this.id, this.clazzName);
            PartInfo pInfo = (PartInfo)AnalysisView.this.infos.get(ezKey);
            if (pInfo != null) {
                searched = pInfo.item;
            }
            if (searched == null) {
                CTabItem[] items = AnalysisView.this.folder.getItems();
                int i = 0;
                while (i < items.length) {
                    CTabItem item = items[i];
                    L.debug("tab title: {}", (Object)item.getText());
                    if (item.getText().equalsIgnoreCase(this.title)) {
                        searched = item;
                        L.debug("tab found!");
                        break;
                    }
                    ++i;
                }
            }
            if (searched != null) {
                AnalysisView.this.removeTabItem(searched);
                searched.dispose();
            } else {
                L.debug("tab with name: {} not found!", (Object)this.title);
            }
        }
    }

    private class TabsListener
    implements Listener {
        boolean drag = false;
        boolean exitDrag = false;
        CTabItem dragItem;

        private TabsListener() {
        }

        public void handleEvent(Event e) {
            Point p = new Point(e.x, e.y);
            int ypos = 0;
            ypos = (AnalysisView.this.folder.getStyle() & 0x80) > 0 ? 2 : AnalysisView.this.folder.getSize().y - 2;
            switch (e.type) {
                case 29: {
                    CTabItem item = AnalysisView.this.folder.getItem(p);
                    if (item == null) {
                        return;
                    }
                    this.drag = true;
                    this.exitDrag = false;
                    this.dragItem = item;
                    AnalysisView.this.folder.setCursor(AnalysisView.this.handCursor);
                    break;
                }
                case 6: {
                    if (!this.exitDrag) break;
                    this.exitDrag = false;
                    this.drag = e.button != 0;
                    break;
                }
                case 7: {
                    if (!this.drag) break;
                    AnalysisView.this.folder.setInsertMark(null, false);
                    this.exitDrag = true;
                    this.drag = false;
                    break;
                }
                case 4: {
                    AnalysisView.this.folder.setCursor(AnalysisView.this.arrowCursor);
                    if (!this.drag) {
                        return;
                    }
                    CTabItem item = AnalysisView.this.folder.getItem(new Point(p.x, ypos));
                    if (item == null) {
                        CTabItem[] items = AnalysisView.this.folder.getItems();
                        int i = items.length - 1;
                        while (i >= 0) {
                            if (items[i].isShowing()) {
                                item = items[i];
                                break;
                            }
                            --i;
                        }
                    }
                    if (item != null) {
                        Rectangle rect = item.getBounds();
                        boolean after = p.x > rect.x + rect.width / 2;
                        int index = AnalysisView.this.folder.indexOf(item);
                        int newindex = after ? index + 1 : index;
                        newindex = Math.max(0, newindex);
                        CTabItem newItem = new CTabItem(AnalysisView.this.folder, 0, newindex);
                        newItem.setText(this.dragItem.getText());
                        newItem.setImage(this.dragItem.getImage());
                        AnalysisView.this.hm.deleteItem(this.dragItem);
                        PartInfo info = (PartInfo)AnalysisView.this.tabs.remove(this.dragItem);
                        info.item = newItem;
                        AnalysisView.this.tabs.put(newItem, info);
                        this.dragItem.getControl();
                        this.dragItem.setControl(null);
                        this.dragItem.dispose();
                        AnalysisView.this.folder.setSelection(newItem);
                        AnalysisView.this.hm.registerItem(newItem);
                        AnalysisView.this.refreshDetailsFor(newItem);
                    }
                    this.drag = false;
                    this.exitDrag = false;
                    this.dragItem = null;
                    break;
                }
                case 5: {
                    if (!this.drag) {
                        return;
                    }
                    CTabItem item = AnalysisView.this.folder.getItem(new Point(p.x, ypos));
                    if (item == null) {
                        AnalysisView.this.folder.setInsertMark(null, false);
                        return;
                    }
                    Rectangle rect = item.getBounds();
                    boolean after = p.x > rect.x + rect.width / 2;
                    AnalysisView.this.folder.setInsertMark(item, after);
                }
            }
        }
    }
}

