/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.display.utils;

import com.ez.workspace.change.DirtyStatus;

public class Utils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Integer MAXIM_TAB_NAME_LENGHT = new Integer(17);

    public static String computeDirtyText(String text, DirtyStatus dirty) {
        String result = text;
        if (dirty != null && text != null) {
            text = Utils.removeExistingMark(text);
            StringBuffer sb = new StringBuffer();
            sb.append(dirty.getSymbol());
            sb.append(text);
            result = sb.toString();
        }
        return result;
    }

    private static String removeExistingMark(String text) {
        String result = text;
        if (text != null) {
            DirtyStatus[] dirtyStatusArray = DirtyStatus.values();
            int n = dirtyStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                DirtyStatus status = dirtyStatusArray[n2];
                String symbol = status.getSymbol();
                if (text.startsWith(symbol) && symbol.length() > 0) {
                    result = text.substring(symbol.length());
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    public static String truncateTextIfNecessary(String text) {
        StringBuffer buf = new StringBuffer();
        int idx = text.lastIndexOf(40);
        if (idx != -1) {
            String inputs = text.substring(0, idx);
            String analysisname = text.substring(idx);
            if (inputs.length() > MAXIM_TAB_NAME_LENGHT) {
                inputs = inputs.substring(0, MAXIM_TAB_NAME_LENGHT).concat("...");
            }
            buf.append(inputs).append(analysisname);
        } else {
            buf.append(text);
        }
        return buf.toString();
    }
}

