/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.display.listener;

import com.ez.analysis.display.Activator;
import com.ez.analysis.display.Messages;
import com.ez.analysis.display.view.AnalysisView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public class HistoryManager
implements SelectionListener {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private List history = new ArrayList();
    private Action backAction = null;
    private Action forwardAction = null;
    private int current = 0;
    private AnalysisView view;

    public HistoryManager(AnalysisView view) {
        this.view = view;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.registerItem((CTabItem)e.item);
    }

    public void registerItem(CTabItem item) {
        int i = this.current + 1;
        while (i < this.history.size()) {
            this.history.remove(i);
            ++i;
        }
        int size = this.history.size();
        if (size == 0 || !this.history.get(size - 1).equals(item)) {
            this.history.add(item);
        }
        if ((size = this.history.size()) > 0) {
            this.current = size - 1;
        }
        this.setActionsEnablement();
    }

    public void deleteItem(CTabItem item) {
        int pos = this.history.indexOf(item);
        if (pos != -1) {
            int i = this.history.size() - 1;
            while (i >= pos) {
                this.history.remove(i);
                --i;
            }
        }
        this.current = this.history.size() - 1;
        this.setActionsEnablement();
    }

    private void setActionsEnablement() {
        int size = this.history.size();
        if (this.current > 0) {
            this.backAction.setEnabled(true);
        } else {
            this.backAction.setEnabled(false);
        }
        if (this.current < size - 1) {
            this.forwardAction.setEnabled(true);
        } else {
            this.forwardAction.setEnabled(false);
        }
    }

    public CTabItem getBackItem() {
        return this.current > 0 ? (CTabItem)this.history.get(this.current - 1) : null;
    }

    public CTabItem getForwardItem() {
        return this.current < this.history.size() - 1 ? (CTabItem)this.history.get(this.current + 1) : null;
    }

    public Action getBackAction() {
        return this.backAction;
    }

    public Action getForwardAction() {
        return this.forwardAction;
    }

    public void initActions(final CTabFolder folder) {
        this.forwardAction = new Action(){

            public void run() {
                CTabItem forwardItem = HistoryManager.this.getForwardItem();
                if (forwardItem != null) {
                    folder.setSelection(forwardItem);
                    HistoryManager.this.view.refreshDetailsFor(forwardItem);
                    HistoryManager historyManager = HistoryManager.this;
                    historyManager.current = historyManager.current + 1;
                    HistoryManager.this.setActionsEnablement();
                }
            }
        };
        this.forwardAction.setText(Messages.getString(HistoryManager.class, "txtFw"));
        this.forwardAction.setToolTipText(Messages.getString(HistoryManager.class, "txtFw"));
        ImageDescriptor id = Activator.getImageDescriptor("icons//forward.gif");
        this.forwardAction.setImageDescriptor(id);
        this.forwardAction.setEnabled(false);
        this.backAction = new Action(){

            public void run() {
                CTabItem backItem = HistoryManager.this.getBackItem();
                if (backItem != null) {
                    folder.setSelection(backItem);
                    HistoryManager.this.view.refreshDetailsFor(backItem);
                    HistoryManager historyManager = HistoryManager.this;
                    historyManager.current = historyManager.current - 1;
                    HistoryManager.this.setActionsEnablement();
                }
            }
        };
        this.backAction.setText(Messages.getString(HistoryManager.class, "txtBack"));
        this.backAction.setToolTipText(Messages.getString(HistoryManager.class, "txtBack"));
        id = Activator.getImageDescriptor("icons//back.gif");
        this.backAction.setImageDescriptor(id);
        this.backAction.setEnabled(false);
    }
}

