/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.display.job;

import com.ez.analysis.display.job.GraphOverviewJob;
import com.ez.analysis.display.job.StructureViewJob;
import com.ez.analysis.display.view.AnalysisView;
import com.ez.analysis.display.view.GraphsView;
import com.ez.analysis.display.view.ReportsView;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.job.CloseTabJob;
import com.ez.workspace.analysis.job.GraphSelectionJob;
import com.ez.workspace.analysis.job.GraphTranslateJob;
import org.eclipse.core.internal.jobs.JobStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZJobsListener
implements IJobChangeListener {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZJobsListener.class);
    private AnalysisView view = null;

    public EZJobsListener(AnalysisView view) {
        this.view = view;
    }

    public void aboutToRun(IJobChangeEvent event) {
        if (this.view == null || this.view.getUserArea().isDisposed()) {
            return;
        }
        Job job = event.getJob();
        if (job.belongsTo((Object)"GRAPH_JOB") && this.view instanceof GraphsView || job.belongsTo((Object)"REPORT_JOB") && this.view instanceof ReportsView) {
            L.debug("view {}", (Object)this.view);
            L.debug("-----------> aboutToRun graphJob {}. priority: {}", (Object)job, (Object)job.getPriority());
            GraphTranslateJob gJob = (GraphTranslateJob)job;
            gJob.buildComponents((Composite)this.view.getUserArea());
            GraphInfo info = (GraphInfo)gJob.getGraphInfo();
            if (info != null) {
                this.view.setGraphInfo(info, false);
                L.trace("after setGi(false) on {}", (Object)job);
            }
        } else if (job instanceof GraphOverviewJob) {
            GraphOverviewJob ovJob = (GraphOverviewJob)job;
            this.view.setOverviewPart(ovJob.overviewPart);
        } else if (job instanceof StructureViewJob) {
            StructureViewJob strJob = (StructureViewJob)job;
            this.view.setStructurePart(strJob.structureView);
        } else if (job.belongsTo((Object)"CLOSE_TAB_JOB")) {
            CloseTabJob strJob = (CloseTabJob)job;
            L.debug("CloseTabJob aboutToRun; before removeTabItem");
            this.view.removeTabItem(strJob.getTabTitle(), strJob.getClazzName(), strJob.getId());
        }
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
        Job job = event.getJob();
        if (job.belongsTo((Object)"GRAPH_JOB") && this.view instanceof GraphsView || job.belongsTo((Object)"REPORT_JOB") && this.view instanceof ReportsView) {
            L.debug("-----------> done graphJob {}. priority: {}", (Object)job, (Object)job.getPriority());
            GraphTranslateJob gJob = (GraphTranslateJob)job;
            GraphInfo info = (GraphInfo)gJob.getGraphInfo();
            if (info != null) {
                this.view.setGraphInfo(info, true);
                L.trace("after setGi(true) on {}", (Object)job);
            }
            if (JobStatus.CANCEL_STATUS.equals(job.getResult())) {
                L.trace("job {} done with CANCEL status; view it will be closed", (Object)job);
                this.view.close(info);
            }
        } else if (job.belongsTo((Object)"GRAPH SEL JOB")) {
            GraphSelectionJob sJob = (GraphSelectionJob)job;
            ISelection sel = sJob.getSelection();
            this.view.setSelection(sel);
        }
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }
}

