/*******************************************************************************
 *  		Licensed Materials - Property of IBM
 *    		xxxx-xxx
 *  		© Copyright IBM Corporation 2015. All rights reserved.
 *  		US Government Users Restricted Rights - Use, duplication or disclosure
 *  		restricted by GSA ADP Schedule Contract with IBM Corp.
 *   
 *  The source code for this program is not published or otherwise
 *  divested of its trade secrets, irrespective of what has been
 *  deposited with the U.S. Copyright Office.
 *******************************************************************************/
package samples;

import java.io.IOException;
import java.io.InputStream;

import com.ibm.debug.pdt.codecoverage.core.results.CCResultException;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultsFactory;
import com.ibm.debug.pdt.codecoverage.core.results.ICCFile;
import com.ibm.debug.pdt.codecoverage.core.results.ICCResult;

/**
 * Illustrates how to retrieve the contents of a file from the cc data
 * This will only work if the source/listing was saved at the time of capture
 *
 * If using a command line then enter the following<br>
 * {@code java -cp ".;".;./plugins/com.ibm.debug.pdt.codecoverage.core.results_<version>/lib/ccapi.jar" " samples.TestFileStream "path to cc
 * data file or directory" }
 */
public class TestFileStream {

	public TestFileStream() {
	}

	/**
	 * one or more paths to a directory of file that contains cc data
	 * 
	 * @param args
	 *            arguments
	 */
	public static void main(String[] args) {

		CCResultsFactory.setExceptionLogging();
		ICCResult result = null;
		try {
			result = CCResultsFactory.getInstance().createResult(args);
		} catch (CCResultException e1) {
			e1.printStackTrace();
			return;
		}

		for (ICCFile file : result.getFiles()) {
			try {
				InputStream is = file.getStream();
				byte[] signature = file.getSignature();
				for(byte b : signature)
					System.out.print(b);
				System.out.println();
				System.out.println(is);
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

}
