/*******************************************************************************
 * 		Licensed Materials - Property of IBM
 *   		xxxx-xxx
 * 		© Copyright IBM Corporation 2014, 2016. All rights reserved.
 * 		US Government Users Restricted Rights - Use, duplication or disclosure
 * 		restricted by GSA ADP Schedule Contract with IBM Corp.
 *  
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has been
 * deposited with the U.S. Copyright Office.
 *******************************************************************************/
package samples;

import java.io.IOException;

import com.ibm.debug.pdt.codecoverage.core.results.CCResultException;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultsFactory;
import com.ibm.debug.pdt.codecoverage.core.results.ICCResult;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.CCExportException;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.CCExporterFactory;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.ICCExporter;

/**
 * This illustrates imported data in one format (could be a .clcoveragedata file)
 * and exporting it to the "merged" cczip format
 *
 * If using a command line then enter the following<br>
 * {@code
 * java -cp ".;./plugins/com.ibm.debug.pdt.codecoverage.core.results_<version>/lib/ccapi.jar" samples.TestExportDriver
 * "path_to_output_file"
 * "one or more paths to the input cc data files"}
 */
@SuppressWarnings("nls")
public class TestExportDriver {

	/**
	 * The first parameter is the output file
	 * The rest of the parameters are results that should be merged (if there are &gt;1) and exported
	 * 
	 * @param args
	 *            arguments
	 * @throws IOException
	 *             problems during export
	 */
	public static void main(String[] args) throws IOException {

		String outputPath = args[0];
		String[] inputPaths = new String[args.length -1];

		for (int i = 1; i < args.length; i++) {
			inputPaths[i-1] = args[i];
		}


		CCResultsFactory.setExceptionLogging();
		ICCResult results = null;
		try {
			results = CCResultsFactory.getInstance().createResult(inputPaths);
		} catch (CCResultException e) {
			e.printStackTrace();
		}
		// this exporter will generate a merged file with a .cczip extension
		ICCExporter exporter = CCExporterFactory.getInstance().getExporter("CCRESULT");

		try {
			exporter.exportResult(results, null, outputPath, true);
		} catch (CCExportException e) {
			e.printStackTrace();
		}

	}

}
