function TagParser(data,handler) {
	this.data = data;
	this.handler = handler;
	  
	this.stack = new Array();
	
	this.parse = parse;
	this.next = next;
	this.makeProps = makeProps;
	this.getName = getName;
	
	this.parse();
}

function parse()
{
	while(this.next()){
		;
	}
}

function next() {

	if (this.data=='')
		return false;

	var props = new Hashtable();	
	var isChars = this.data.charAt(0)!='<';
	var tag;
	
	var endex;
	if (!isChars){
		endex = this.data.indexOf(">");
	}
	else{
		endex = this.data.indexOf("<")-1;
	}
	
	var chunk = this.data.substring(0,endex+1);
	this.data = this.data.substring(endex+1);
	
	if (isChars)
	{
		var element = this.stack.pop();
		this.handler.characters(element,chunk);
		this.stack.push(element);
	}
	else{
		tag = this.getName(chunk);
		if (chunk.indexOf(' ')>-1){
			chunk = chunk.substring(chunk.indexOf(' ')+1,chunk.length-1);	
			props = makeProps(chunk);
		}
	
		if (chunk.indexOf("</")>-1){
			var element = this.stack.pop();
			this.handler.endElement(element);
		}
		else if (chunk.indexOf("/>")>-1)
		{	
			var element = new TagElement(tag,props);
			this.handler.startElement(element);
			this.handler.endElement(element);
		}
		else
		{
			var element = new TagElement(tag,props);
			this.stack.push(element);
			this.handler.startElement(element);
		}
	}
	return true;
}

function getName(tag)
{
	tag = tag.substring(1);

	var index = tag.indexOf(" ");

	if (index>-1){
		tag = tag.substring(0,index);
	}
	else{
		if (tag.indexOf(">")==tag.length-1){
			tag = tag.substring(0,tag.length-1);
		}
		if (tag.indexOf("/")==tag.length-1){
			tag = tag.substring(0,tag.length-1);
		}
		if (tag.indexOf("?")==tag.length-1){
			tag = tag.substring(0,tag.length-1);
		}
	}
	return tag;
}

function makeProps(line)
{
	var props = new Hashtable();
	var name = '';
	var val = '';
	
	var inVal = false;
	var inQVal = false;
	
	for (var l=0;l<line.length;l++)
	{
		if (line.charAt(l)=='='){
			inVal = true;
		}
		else if (line.charAt(l)=='"'){
			inQVal = !inQVal;
		}
		else if (line.charAt(l)==' '){
			if (inQVal){
				val+=line.charAt(l);
			}
			else{
				inVal = false;
				props.put(name,val);
				name='';
				val='';
			}
		}
		else{
			if (inVal){
				val+=line.charAt(l);
			}
			else{
				name+=line.charAt(l);
			}
		}
	}
	props.put(name,val);
	return props;
}

function TagElement(name,atts)
{
	this.name = name;
	this.atts = atts;
}


function TagHandler()
{
	this.characters = characters;
	this.startElement = startElement;
	this.endElement = endElement;
}

function characters(element,chars)
{
}

function startElement(element)
{
}

function endElement(element)
{
}