
if (!Array.prototype.indexOf) {
	Array.prototype.indexOf = function(obj, start) {
	     for (var i = (start || 0), j = this.length; i < j; i++) {
	         if (this[i] === obj) { return i; }
	     }
	     return -1;
	}
}


function Hashtable()
{
	this.keys = new Array();
	this.vals = new Array();
}

Hashtable.prototype.put = function(key,val)
{
	this.keys.push(key);
	this.vals.push(val);
}

Hashtable.prototype.get = function(key)
{
	var index = this.keys.indexOf(key);
	if (index==-1)
		return null;
	return this.vals[index];
}

Hashtable.prototype.remove = function(key)
{
	var index = this.keys.indexOf(key);
	if (index==-1)
		return;
		
	this.keys.splice(index,1);
	this.vals.splice(index,1);
}

Hashtable.prototype.length = function()
{
	return this.keys.length;
}

Hashtable.prototype.keyAt = function(index)
{
	return this.keys[index];
}
Hashtable.prototype.valAt = function(index)
{
	return this.vals[index];
}
