/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.core.utilities;

import com.ibm.debug.pdt.codecoverage.core.results.ICCConstants;
import com.ibm.debug.pdt.codecoverage.internal.core.CCParams;
import com.ibm.debug.pdt.codecoverage.internal.core.ICCCoreConstants;
import java.util.Map;
import java.util.Properties;

public class CCStartupKeyGenerator
implements ICCCoreConstants {
    private static final String CC = "CC";
    public static final String EQA_STARTUP_KEY = "EQA_STARTUP_KEY";
    private String fProfile;
    private Properties p = new Properties();
    private boolean fIsModuleList = false;
    private boolean fUseShortParms = true;

    public CCStartupKeyGenerator() {
        this(false);
    }

    public CCStartupKeyGenerator(boolean isModuleList) {
        this.fIsModuleList = isModuleList;
    }

    public String generateStartupKey() {
        return this.generateStartupKey(true, EQA_STARTUP_KEY);
    }

    public String generateStartupKey(boolean useSingleQuotes, String startupKeyName) {
        StringBuilder sb = new StringBuilder();
        if (startupKeyName != null) {
            sb.append(startupKeyName);
            sb.append('=');
        }
        sb.append(CC);
        sb.append(',');
        if (this.fProfile != null) {
            sb.append(this.fProfile);
        }
        sb.append(',');
        boolean needsComma = false;
        for (Map.Entry<Object, Object> e : this.p.entrySet()) {
            Object value;
            String key = (String)e.getKey();
            if (this.fUseShortParms) {
                key = CCParams.getShortParmName(key);
            }
            if (((String)(value = (String)e.getValue())).indexOf(32) > -1 || ((String)value).indexOf(44) > -1) {
                char quote = useSingleQuotes ? (char)'\'' : '\"';
                value = quote + (String)value + quote;
            }
            if (needsComma) {
                sb.append(',');
            }
            if (value == null) continue;
            sb.append(key);
            sb.append('=');
            sb.append((String)value);
            needsComma = true;
        }
        return sb.toString();
    }

    private String getListAsString(String[] list) {
        StringBuilder sb = new StringBuilder();
        if (list != null) {
            String[] stringArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (sb.length() != 0) {
                    sb.append(',');
                }
                sb.append(item);
                ++n2;
            }
        }
        return sb.toString();
    }

    public void setCCLevel(ICCConstants.COVERAGE_LEVEL level) {
        if (level == ICCConstants.COVERAGE_LEVEL.LINE) {
            this.p.remove("cclevel");
        } else {
            this.p.setProperty("cclevel", level.toString());
        }
    }

    public void setFilter(String filename) {
        if (filename == null || filename.isEmpty()) {
            this.p.remove(this.fIsModuleList ? "moduleexcludelist" : "filterlist");
        } else {
            this.p.setProperty(this.fIsModuleList ? "moduleexcludelist" : "filterlist", filename);
        }
    }

    public void setGenHtml(boolean value) {
        if (value) {
            this.p.setProperty("ccGenerateHtml", Boolean.toString(value));
        } else {
            this.p.remove("ccGenerateHtml");
        }
    }

    public void setGenPDF(boolean value) {
        if (value) {
            this.p.setProperty("ccGeneratePDF", Boolean.toString(value));
        } else {
            this.p.remove("ccGeneratePDF");
        }
    }

    public void setIgnoreError(boolean value) {
        if (value) {
            this.p.setProperty("ignoreerrors", Boolean.toString(value));
        } else {
            this.p.remove("ignoreerrors");
        }
    }

    public void setIncludedModules(String[] modules) {
        if (modules == null || modules.length == 0) {
            this.p.remove("moduleinclude");
        } else {
            this.p.setProperty("moduleinclude", this.getListAsString(modules));
        }
    }

    public void setProfileName(String profilename) {
        this.fProfile = profilename;
    }

    public void setSuppressTimeStamps(boolean value) {
        if (value) {
            this.p.setProperty("Isuppresstimestamps", Boolean.toString(value));
        } else {
            this.p.remove("Isuppresstimestamps");
        }
    }

    public void setTestId(String testid) {
        if (testid == null || testid.isEmpty()) {
            this.p.remove("testid");
        } else {
            this.p.setProperty("testid", testid);
        }
    }

    public void setTestTags(String tags) {
        if (tags == null || tags.isEmpty()) {
            this.p.remove("tag");
        } else {
            this.p.setProperty("tag", tags);
        }
    }

    public static String stripStartupKeyPrefix(String startupKey) {
        if (startupKey.startsWith("EQA_STARTUP_KEY=")) {
            startupKey = startupKey.substring(EQA_STARTUP_KEY.length() + 1);
        }
        return startupKey;
    }

    public void setViewPreference(ICCCoreConstants.DESIRED_COVERAGE_VIEW view) {
        if (view != ICCCoreConstants.DESIRED_COVERAGE_VIEW.DEFAULT) {
            this.p.setProperty("view", view.toString());
        } else {
            this.p.remove("view");
        }
    }

    public void setZunit(String zunit) {
        if (zunit == null || zunit.isEmpty()) {
            this.p.remove("zunit");
        } else {
            this.p.setProperty("zunit", zunit);
        }
    }

    public void setRoot(String root) {
        if (root == null || root.isEmpty()) {
            this.p.remove("root");
        } else {
            this.p.setProperty("root", root);
        }
    }

    public void useShortParms(boolean value) {
        this.fUseShortParms = value;
    }
}

