/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.core.utilities;

import com.ibm.debug.pdt.codecoverage.internal.core.CCParams;
import com.ibm.debug.pdt.codecoverage.internal.core.CCUtilities;
import com.ibm.debug.pdt.codecoverage.internal.core.ICCCoreConstants;
import com.ibm.debug.pdt.codecoverage.internal.core.Messages;
import java.util.Iterator;
import org.eclipse.osgi.util.NLS;

public class CCCoreUtilities
implements ICCCoreConstants {
    public static boolean processStartupkey(String startupKey, CCParams properties) {
        if (startupKey == null || startupKey.isEmpty()) {
            return false;
        }
        boolean CC = false;
        String[] parms = startupKey.split(",");
        int parmCount = 0;
        while (parmCount < parms.length) {
            String[] keyValuePairs;
            String keyValuePair;
            if (parmCount == 0) {
                CC = parms[0].trim().equals("CC");
            } else if (parmCount == 1) {
                String pgmName = parms[1].trim();
                if (!pgmName.isEmpty()) {
                    properties.setProperty("programName", pgmName);
                    properties.setPgmNameOverride(false);
                }
            } else if (parmCount > 1 && !(keyValuePair = parms[parmCount]).isEmpty() && (keyValuePairs = keyValuePair.split("=", 2)).length > 1) {
                String actualValue = keyValuePairs[1];
                String trimmedValue = actualValue.trim();
                if (trimmedValue.startsWith("'") || trimmedValue.startsWith("\"")) {
                    char delimiter = trimmedValue.charAt(0);
                    StringBuilder value = new StringBuilder(actualValue.substring(actualValue.indexOf(39) + 1));
                    try {
                        while (value.charAt(value.length() - 1) != delimiter) {
                            value.append(',').append(parms[++parmCount]);
                        }
                    }
                    catch (Exception e) {
                        CCUtilities.log("CC startupkey contains unbalanced quotes, parms after the quote are ignored");
                        return CC;
                    }
                    value.deleteCharAt(value.lastIndexOf(String.valueOf(delimiter)));
                    actualValue = value.toString();
                }
                if (actualValue.isEmpty()) {
                    if (CCUtilities.fLogging) {
                        CCUtilities.log(String.format("key %s removed", keyValuePairs[0].trim()));
                    }
                    properties.remove(keyValuePairs[0].trim());
                } else {
                    if (CCUtilities.fLogging) {
                        CCUtilities.log(String.format("key=value %s=%s", keyValuePairs[0].trim(), actualValue));
                    }
                    if (keyValuePairs[0].trim().equals("optionsfile")) {
                        properties.setProperty("startupkeyoptionsfile", actualValue);
                    } else {
                        properties.setProperty(keyValuePairs[0].trim(), actualValue);
                    }
                }
            }
            ++parmCount;
        }
        CCCoreUtilities.validateStartupkeyValue(properties);
        return CC;
    }

    private static void validateStartupkeyValue(CCParams properties) {
        Iterator<?> keys = properties.propertyNames().asIterator();
        while (keys.hasNext()) {
            String key;
            switch (key = keys.next().toString()) {
                case "Imodulefilter": {
                    CCUtilities.log(2, NLS.bind((String)Messages.CRRDG7161, (Object)key, (Object)"filter"));
                    break;
                }
                case "moduleinclude": 
                case "moduleexclude": {
                    CCUtilities.log(2, NLS.bind((String)Messages.CRRDG7160, (Object)key, (Object)"filter"));
                    break;
                }
                case "moduleincludelist": 
                case "moduleexcludelist": {
                    CCUtilities.log(2, NLS.bind((String)Messages.CRRDG7160, (Object)key, (Object)"filterlist"));
                }
            }
        }
    }
}

