/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.core.events;

import com.ibm.debug.pdt.codecoverage.internal.core.CCUtilities;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEvent;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventCollectionEnd;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventCollectionStart;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventComplete;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventCoverageChange;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventError;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventReportEnd;
import com.ibm.debug.pdt.codecoverage.internal.core.events.ICCListener;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class CCEventManager {
    private static final String CODE_COVERAGE_LISTENERS = "codeCoverageListeners";
    private static final String ATTR_CLASS = "class";
    private ArrayList<ICCListener> fListeners = new ArrayList();
    private static CCEventManager fInstance = null;
    private static Object fLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CCEventManager getInstance() {
        Object object = fLock;
        synchronized (object) {
            if (fInstance == null) {
                fInstance = new CCEventManager();
                fInstance.initListeners();
            }
            return fInstance;
        }
    }

    public synchronized void add(ICCListener listener) {
        this.fListeners.add(listener);
    }

    public synchronized void remove(ICCListener listener) {
        this.fListeners.remove(listener);
    }

    public synchronized void notify(final CCEvent event) {
        if (CCUtilities.fLogging) {
            CCUtilities.log("notify event :" + String.valueOf(event));
        }
        Iterator<ICCListener> iterator = this.fListeners.iterator();
        while (iterator.hasNext()) {
            ICCListener alistener;
            final ICCListener listener = alistener = iterator.next();
            new Job("Event processing"){

                protected IStatus run(IProgressMonitor arg0) {
                    if (event instanceof CCEventCollectionStart) {
                        listener.collectionStart((CCEventCollectionStart)event);
                    } else if (event instanceof CCEventCollectionEnd) {
                        listener.collectionEnd((CCEventCollectionEnd)event);
                    } else if (event instanceof CCEventReportEnd) {
                        listener.reportEnd((CCEventReportEnd)event);
                    } else if (event instanceof CCEventError) {
                        listener.error((CCEventError)event);
                    } else if (event instanceof CCEventComplete) {
                        listener.complete((CCEventComplete)event);
                    } else if (event instanceof CCEventCoverageChange) {
                        listener.coverageChanged((CCEventCoverageChange)event);
                    } else {
                        CCUtilities.log("**unknown event** " + String.valueOf(event));
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private void initListeners() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.pdt.codecoverage.core", CODE_COVERAGE_LISTENERS);
        if (extensionPoint != null) {
            IConfigurationElement[] configs;
            IConfigurationElement[] iConfigurationElementArray = configs = extensionPoint.getConfigurationElements();
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                try {
                    this.add((ICCListener)config.createExecutableExtension(ATTR_CLASS));
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }
}

