/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.core;

import com.ibm.debug.pdt.codecoverage.core.results.CCAbstractException;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultException;
import com.ibm.debug.pdt.codecoverage.internal.core.CCData;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class CCUtilities {
    private static final String traceString = System.getProperty("trace");
    public static final boolean TRACE_ON = traceString != null && Boolean.TRUE.equals(Boolean.parseBoolean(traceString));
    private static ILog fLog;
    public static boolean fLogging;
    public static boolean fTiming;
    public static final String PLUGIN_ID = "com.ibm.debug.pdt.codecoverage.core";
    static final Integer[] ALLHIT;
    static final String SEPARATOR;
    static final String[] EMPTYCOMMANDS;

    static {
        fLogging = false;
        fTiming = false;
        ALLHIT = new Integer[]{-1};
        SEPARATOR = System.getProperty("line.separator");
        EMPTYCOMMANDS = new String[0];
        try {
            fLog = Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID));
            String option = Platform.getDebugOption((String)"com.ibm.debug.pdt.codecoverage.core/log");
            if (option != null && option.equalsIgnoreCase("true")) {
                fLogging = true;
            }
            if ((option = Platform.getDebugOption((String)"com.ibm.debug.pdt.codecoverage.core/timing")) != null && option.equalsIgnoreCase("true")) {
                fTiming = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final void log(int severity, String message, Throwable e) {
        if (fLog != null) {
            fLog.log((IStatus)new Status(severity, PLUGIN_ID, message, e));
        } else if (severity != 1 || TRACE_ON) {
            System.out.print(message);
            if (e != null && TRACE_ON) {
                e.printStackTrace();
            }
        }
    }

    public static final void log(Throwable e) {
        CCUtilities.log(e, false);
    }

    public static final void log(Throwable e, boolean forceStdout) {
        block7: {
            block9: {
                block8: {
                    if (e == null) break block7;
                    if (fLog == null || forceStdout) break block8;
                    fLog.log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), e));
                    if (!(e instanceof CCResultException) || ((CCResultException)e).isEmpty()) break block7;
                    CCAbstractException[] cCAbstractExceptionArray = ((CCResultException)e).getExceptions();
                    int n = cCAbstractExceptionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CCAbstractException ex = cCAbstractExceptionArray[n2];
                        fLog.log((IStatus)new Status(4, PLUGIN_ID, ex.getMessage(), (Throwable)ex));
                        ++n2;
                    }
                    break block7;
                }
                if (!TRACE_ON) break block9;
                e.printStackTrace();
                if (!(e instanceof CCResultException) || ((CCResultException)e).isEmpty()) break block7;
                CCAbstractException[] cCAbstractExceptionArray = ((CCResultException)e).getExceptions();
                int n = cCAbstractExceptionArray.length;
                int n3 = 0;
                while (n3 < n) {
                    CCAbstractException ex = cCAbstractExceptionArray[n3];
                    ex.printStackTrace();
                    ++n3;
                }
                break block7;
            }
            System.out.println(e.getMessage());
            if (e instanceof CCResultException) {
                int n;
                int n4;
                String[] stringArray;
                String[] messages = ((CCResultException)e).getMessages();
                if (messages != null) {
                    stringArray = messages;
                    n4 = messages.length;
                    n = 0;
                    while (n < n4) {
                        String m = stringArray[n];
                        System.out.println(m);
                        ++n;
                    }
                }
                if (!((CCResultException)e).isEmpty()) {
                    stringArray = ((CCResultException)e).getExceptions();
                    n4 = stringArray.length;
                    n = 0;
                    while (n < n4) {
                        String ex = stringArray[n];
                        System.out.println(ex.getMessage());
                        ++n;
                    }
                }
            }
        }
    }

    public static final void log(int severity, String message) {
        CCUtilities.log(severity, message, false);
    }

    public static final void log(int severity, String message, boolean forceStdout) {
        if (fLog != null && !forceStdout) {
            fLog.log((IStatus)new Status(severity, PLUGIN_ID, message));
        } else if (severity != 1 || TRACE_ON) {
            System.out.println(message);
        }
    }

    public static final void log(String message) {
        CCUtilities.log(message, false);
    }

    public static final void log(String message, boolean forceStdout) {
        if (fLog != null && !forceStdout) {
            fLog.log((IStatus)new Status(1, PLUGIN_ID, message));
        } else {
            System.out.println(message);
        }
    }

    public static String rootName(String name) {
        Path path = new Path(name);
        return path.lastSegment();
    }

    public static void logTiming(String prefixMessage, CCData data) {
        long currentTime = System.currentTimeMillis();
        float elapsedFromStart = currentTime - data.fStartTime;
        float elapsedTime = currentTime - data.getElapsedTime();
        data.fElapsedTime = currentTime;
        CCUtilities.log(String.format("Elapsed start/last %.2f/%.2f - %s", Float.valueOf(elapsedFromStart / 1000.0f), Float.valueOf(elapsedTime / 1000.0f), prefixMessage));
    }

    public static void logTiming(String prefixMessage, long elapsedTime) {
        CCUtilities.log(String.format("%s: %.2f seconds", prefixMessage, (double)elapsedTime / 1000.0));
    }

    public static String[] getCommands(String commandString) {
        if (commandString == null || commandString.isEmpty()) {
            return EMPTYCOMMANDS;
        }
        StringTokenizer tokenizer = new StringTokenizer(commandString, SEPARATOR);
        ArrayList<String> commands = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            commands.add(tokenizer.nextToken());
        }
        return commands.toArray(new String[commands.size()]);
    }

    public static boolean delete(IPath eclipsePath) {
        return CCUtilities.delete(eclipsePath.toFile().toPath());
    }

    public static boolean delete(java.nio.file.Path path) {
        if (path == null || !path.toFile().exists()) {
            return true;
        }
        try {
            Files.walkFileTree(path, new Visitor());
        }
        catch (IOException e) {
            CCUtilities.log(e);
            return false;
        }
        return true;
    }

    public static String getPID() {
        String processLabel = ManagementFactory.getRuntimeMXBean().getName();
        StringTokenizer st = new StringTokenizer(processLabel, "@");
        try {
            return st.nextToken();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static boolean isISeriesEngine(String engineKey) {
        if (engineKey != null && !engineKey.isEmpty()) {
            char c = engineKey.charAt(0);
            return c == IEPDCConstants.PLATFORM_OS_CHAR[4];
        }
        return false;
    }

    public static String getBaselinePath(File dataFile) {
        String parent = dataFile.getParent();
        if (parent != null) {
            String baselineShortName = CCUtilities.getFileBaseName(dataFile) + ".metadata";
            String baselineFullPath = parent + File.separator + baselineShortName;
            return baselineFullPath;
        }
        return null;
    }

    public static String getComponentMapPath(File dataFile) {
        String parent = dataFile.getParent();
        if (parent != null) {
            String componentMapShortName = CCUtilities.getFileBaseName(dataFile) + ".componentMap";
            String componentMapFullPath = parent + File.separator + componentMapShortName;
            return componentMapFullPath;
        }
        return null;
    }

    public static String getFileBaseName(File file) {
        String fileName = file.getName();
        String baseName = null;
        int dotIndex = fileName.lastIndexOf(46);
        baseName = dotIndex > 0 ? fileName.substring(0, dotIndex) : fileName;
        return baseName;
    }

    private static class Visitor
    extends SimpleFileVisitor<java.nio.file.Path> {
        private Visitor() {
        }

        @Override
        public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
            if (file.toFile().exists()) {
                file.toFile().setWritable(true);
            }
            Files.deleteIfExists(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(java.nio.file.Path dir, IOException exc) throws IOException {
            Files.deleteIfExists(dir);
            return FileVisitResult.CONTINUE;
        }
    }
}

