/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.core;

import com.ibm.debug.pdt.codecoverage.core.results.CCResultException;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultsFactory;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultsModifierFactory;
import com.ibm.debug.pdt.codecoverage.core.results.ICCConstants;
import com.ibm.debug.pdt.codecoverage.core.results.ICCFile;
import com.ibm.debug.pdt.codecoverage.core.results.ICCFlowPoint;
import com.ibm.debug.pdt.codecoverage.core.results.ICCResult;
import com.ibm.debug.pdt.codecoverage.core.results.ICCResultModifier;
import com.ibm.debug.pdt.codecoverage.core.results.ICCTreeItem;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.CCExportException;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.CCExporterFactory;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.ICCExporter;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.ICCExporterInfo;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.ICCExporterSettings;
import com.ibm.debug.pdt.codecoverage.core.results.importers.CCDuplicateFlowPointException;
import com.ibm.debug.pdt.codecoverage.core.results.importers.CCImportException;
import com.ibm.debug.pdt.codecoverage.core.results.importers.CCImportFlowPointException;
import com.ibm.debug.pdt.codecoverage.core.results.importers.ICCImportFile;
import com.ibm.debug.pdt.codecoverage.core.results.importers.ICCImportFlowPoint;
import com.ibm.debug.pdt.codecoverage.core.results.importers.ICCImportFlowPointParent;
import com.ibm.debug.pdt.codecoverage.core.results.importers.ICCImportResult;
import com.ibm.debug.pdt.codecoverage.internal.core.CCData;
import com.ibm.debug.pdt.codecoverage.internal.core.CCThreadEventListener;
import com.ibm.debug.pdt.codecoverage.internal.core.CCUtilities;
import com.ibm.debug.pdt.codecoverage.internal.core.Messages;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventCollectionEnd;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventError;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventManager;
import com.ibm.debug.pdt.codecoverage.internal.core.results.exporters.ccresults.CCResultExporterSettings;
import com.ibm.debug.pdt.codecoverage.internal.core.results.filters.CCResultsFilter;
import com.ibm.debug.pdt.codecoverage.internal.core.results.importers.CCImportUtilities;
import com.ibm.debug.pdt.codecoverage.internal.core.results.parsers.ICCLanguageEntryPoint;
import com.ibm.debug.pdt.codecoverage.internal.core.results.parsers.ICCLanguageParser;
import com.ibm.debug.pdt.codecoverage.internal.core.results.parsers.IncludeFile;
import com.ibm.debug.pdt.codecoverage.internal.core.results.parsers.ParserEntryPointUtils;
import com.ibm.debug.pdt.internal.core.model.BreakpointAddedEvent;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.EngineConnectionException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ExpressionAddedEvent;
import com.ibm.debug.pdt.internal.core.model.ICCEventListener;
import com.ibm.debug.pdt.internal.core.model.IProcessEventListener;
import com.ibm.debug.pdt.internal.core.model.IThreadEventListener;
import com.ibm.debug.pdt.internal.core.model.ModuleAddedEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessDetachedEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessEndedEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessPgmError;
import com.ibm.debug.pdt.internal.core.model.ProcessPgmOutput;
import com.ibm.debug.pdt.internal.core.model.ProcessStoppedEvent;
import com.ibm.debug.pdt.internal.core.model.ThreadAddedEvent;
import com.ibm.debug.pdt.internal.epdc.EStdFileFlowPoints;
import com.ibm.debug.pdt.internal.epdc.EStdFlowPoint;
import com.ibm.debug.pdt.internal.epdc.EStdFlowPointsHit;
import com.ibm.debug.pdt.internal.epdc.EStdNumberList;
import com.ibm.debug.pdt.internal.epdc.EStdTraceEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;

public class CCProcessEventListener
implements IProcessEventListener,
ICCEventListener {
    protected CCData fData;
    private Map<Integer, ICCImportFlowPoint> fMapping = new HashMap<Integer, ICCImportFlowPoint>();

    public CCProcessEventListener(CCData data) {
        this.fData = data;
    }

    public void moduleAdded(ModuleAddedEvent event) {
        this.fData.add(event.getModule());
    }

    public void processEnded(ProcessEndedEvent event) {
        this.handleProcessEnded((ProcessEvent)event);
    }

    public void expressionAdded(ExpressionAddedEvent event) {
    }

    public void processDetached(ProcessDetachedEvent event) {
        this.handleProcessEnded((ProcessEvent)event);
    }

    public void programOutput(ProcessPgmOutput event) {
    }

    public void programError(ProcessPgmError event) {
    }

    protected void handleProcessEnded(ProcessEvent event) {
        block28: {
            if (CCUtilities.fTiming) {
                CCUtilities.logTiming("Code coverage from engine ended.", this.fData);
            }
            try {
                event.getProcess().fireTerminateEvent();
                DebugEngine engine = event.getProcess().getDebugEngine();
                engine.terminate();
            }
            catch (EngineConnectionException e1) {
                if (CCUtilities.fLogging) {
                    CCUtilities.log(1, e1.getMessage());
                }
            }
            catch (EngineRequestException e2) {
                if (!CCUtilities.fLogging) break block28;
                CCUtilities.log(e2);
            }
        }
        if (this.fData.isSessionError()) {
            CCEventManager.getInstance().notify(new CCEventError(this.fData, this.fData.getSessionMessage()));
            return;
        }
        if (!this.isValidResults(this.fData)) {
            if (!this.fData.isZunit() || CCUtilities.TRACE_ON) {
                System.out.println(Messages.CRRDG7033);
            }
            CCEventManager.getInstance().notify(new CCEventError(this.fData, Messages.CRRDG7033));
            return;
        }
        File result = null;
        try {
            String[] epdcDumpLocations;
            Path path2;
            if (CCUtilities.fTiming) {
                CCUtilities.logTiming("Export results started.", this.fData);
            }
            this.fData.updateTestcaseElapsedTime();
            ICCFile[] iCCFileArray = this.fData.getResults().getFiles();
            int n = iCCFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICCFile file = iCCFileArray[n2];
                this.postParse((ICCImportFile)file);
                ++n2;
            }
            if (!this.fData.fSaveSource) {
                for (Path path2 : this.fData.getPathsToDelete()) {
                    CCUtilities.delete(path2);
                }
            }
            path2 = this.fData.getResultsPath(false);
            if (!this.fData.isForcedOutputDir()) {
                path2 = path2.removeLastSegments(1);
            }
            if (!path2.toFile().exists()) {
                Files.createDirectories(path2.toFile().toPath(), new FileAttribute[0]);
            }
            CCResultExporterSettings settings = new CCResultExporterSettings();
            if (this.fData.getResultsFilter() != null) {
                this.addFilterDetails(settings, this.fData);
            }
            String[] stringArray = epdcDumpLocations = this.fData.getEngineSession().getEPDCDumpFileLocation(this.fData.getDebugTarget());
            int n3 = epdcDumpLocations.length;
            int n4 = 0;
            while (n4 < n3) {
                Path fileName;
                String epdcDumpLocation = stringArray[n4];
                File epdcDumpFile = new File(epdcDumpLocation);
                if (epdcDumpFile.exists() && (fileName = Paths.get(epdcDumpFile.toURI()).getFileName()) != null) {
                    settings.addFile((InputStream)new DataInputStream(new FileInputStream(epdcDumpLocation)), "log/" + fileName.toString());
                }
                ++n4;
            }
            ICCExporterInfo info = this.doExport(settings, (IPath)path2);
            if (!info.isSuccessful()) {
                String[] stringArray2 = info.getDecodedMessages();
                int n5 = stringArray2.length;
                n3 = 0;
                while (n3 < n5) {
                    String msg = stringArray2[n3];
                    CCUtilities.log(msg);
                    ++n3;
                }
            } else {
                result = new File(info.getDestination());
            }
            if (CCUtilities.fTiming) {
                CCUtilities.logTiming("Export results complete.", this.fData);
            }
        }
        catch (Throwable e1) {
            CCUtilities.log(e1);
        }
        for (Path path2 : this.fData.getPathsToDelete()) {
            CCUtilities.delete(path2);
        }
        Path filterLogPath = this.fData.getResultsFilterLog();
        if (filterLogPath != null) {
            File filterLogFile = filterLogPath.toFile();
            try {
                filterLogFile.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (CCUtilities.fTiming) {
            CCUtilities.logTiming("Code coverage complete.", this.fData);
        }
        CCEventManager.getInstance().notify(new CCEventCollectionEnd(this.fData, result));
    }

    private ICCExporterInfo doExport(CCResultExporterSettings settings, IPath path) throws CCResultException, IOException, CCExportException {
        ICCExporter exporter = CCExporterFactory.getInstance().getExporter("CCRESULT");
        ICCImportResult ccResult = this.fData.getResults();
        if (this.fData.getRoot() != null) {
            Path tempFolder = null;
            ICCExporterInfo info = null;
            try {
                tempFolder = Files.createTempDirectory(ResourcesPlugin.getWorkspace().getRoot().getLocation().toPath(), this.fData.getResultsName(), new FileAttribute[0]);
                tempFolder.toFile().deleteOnExit();
                Path tempResult = tempFolder.resolve(this.fData.getResultsName() + ".cczip");
                tempResult.toFile().deleteOnExit();
                exporter.exportResult((ICCResult)ccResult, null, tempResult.toString(), false);
                ICCResultModifier rootModifier = CCResultsModifierFactory.createRootRelativePathModifier((String)this.fData.getRoot());
                ccResult = CCResultsFactory.getInstance().createResult(new String[]{tempResult.toString()}, rootModifier);
                settings.addFile(rootModifier.getLogInputStream(), "log/rootLog.txt");
                info = exporter.exportResult((ICCResult)ccResult, (ICCExporterSettings)settings, path.append(this.fData.getResultsName()).toOSString(), false);
            }
            catch (Throwable throwable) {
                if (tempFolder != null) {
                    CCUtilities.delete(tempFolder);
                }
                throw throwable;
            }
            if (tempFolder != null) {
                CCUtilities.delete(tempFolder);
            }
            return info;
        }
        return exporter.exportResult((ICCResult)ccResult, (ICCExporterSettings)settings, path.append(this.fData.getResultsName()).toOSString(), false);
    }

    private void postParse(ICCImportFile importFile) {
        this.postPL1Parse(importFile);
    }

    private void postPL1Parse(ICCImportFile importFile) {
        if (importFile.getLanguage() != 4) {
            return;
        }
        if (!importFile.isSourceAvailable()) {
            return;
        }
        ICCLanguageParser parser = ParserEntryPointUtils.getParser((int)importFile.getLanguage());
        if (parser == null) {
            return;
        }
        int end = (Integer)importFile.getProperty("srcEndIndex", (Object)-1);
        int start = (Integer)importFile.getProperty("srcStartIndex", (Object)0);
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (InputStream is = importFile.getStream();){
                if (!parser.parse(is, importFile.getEncoding(), new Integer[0], start, end)) {
                    return;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            CCUtilities.log(4, NLS.bind((String)"Error accessing file: {1}", (Object)importFile.getFileName()), e);
            importFile.addMessage(NLS.bind((String)Messages.CRRDG7123, (Object)importFile.getFileName()), new String[0]);
            return;
        }
        catch (Throwable t) {
            CCUtilities.log(4, NLS.bind((String)"Parser {0} failed for file: {1}", (Object)parser.getClass().getName(), (Object)importFile.getFileName()), t);
            importFile.addMessage(NLS.bind((String)Messages.CRRDG7123, (Object)importFile.getFileName()), new String[0]);
            return;
        }
        ICCLanguageEntryPoint[] iCCLanguageEntryPointArray = parser.getEntryPoints();
        int n = iCCLanguageEntryPointArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICCLanguageEntryPoint entryPoint = iCCLanguageEntryPointArray[n2];
            ICCImportFile includeFile = this.getIncludeFile(importFile, entryPoint);
            if (includeFile != null && includeFile.getNumExecutableLines() != 0) {
                ICCFlowPoint flowPoint;
                String details = this.getDetails((ICCFile)includeFile);
                ICCImportFile parent = importFile;
                ICCFlowPoint[] iCCFlowPointArray = importFile.getRootFlowPoints();
                int n3 = iCCFlowPointArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    flowPoint = iCCFlowPointArray[n4];
                    if (entryPoint.getLine() >= flowPoint.getLine() && entryPoint.getLastLine() <= flowPoint.getLastLine()) {
                        parent = (ICCImportFlowPointParent)flowPoint;
                    }
                    ++n4;
                }
                try {
                    importFile.addLines(new Integer[]{entryPoint.getLine()});
                    if (includeFile.isHit()) {
                        importFile.addHitLines(this.fData.getTestCaseID(), new Integer[]{entryPoint.getLine()});
                    }
                    flowPoint = parent.createFlowPoint(entryPoint.getEntryPoint(), entryPoint.getLine(), entryPoint.getLastLine(), entryPoint.getType());
                    flowPoint.setProperty("details", (Object)details);
                    if (includeFile.isHit()) {
                        flowPoint.setHit();
                    }
                }
                catch (CCDuplicateFlowPointException e) {
                    String existingDetails;
                    ICCImportFlowPoint existing = (ICCImportFlowPoint)e.getExistingFlowPoint();
                    if (includeFile.isHit()) {
                        existing.setHit();
                    }
                    if ((existingDetails = (String)existing.getProperty("details")) == null) {
                        existing.setProperty("details", (Object)details);
                    } else {
                        existing.setProperty("details", (Object)(existingDetails + "," + details));
                    }
                }
                catch (CCImportException e) {
                    parent.addMessage((Throwable)e);
                }
            }
            ++n2;
        }
    }

    private ICCImportFile getIncludeFile(ICCImportFile parentFile, ICCLanguageEntryPoint entryPoint) {
        if (!(entryPoint instanceof IncludeFile)) {
            return null;
        }
        String includeFileName = ((IncludeFile)entryPoint).getIncludeFile();
        ICCFile includeFile = parentFile.getResult().getFile(includeFileName);
        if (includeFile == null) {
            ICCFile[] iCCFileArray = parentFile.getResult().getFiles();
            int n = iCCFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICCFile file = iCCFileArray[n2];
                String memberName = this.getMemberName(file.getName());
                if (memberName.equalsIgnoreCase(includeFileName)) {
                    return (ICCImportFile)file;
                }
                ++n2;
            }
        }
        return null;
    }

    private String getMemberName(String fileName) {
        int end;
        int begin = fileName.lastIndexOf("(");
        if (begin >= 0 && (end = fileName.indexOf(")", begin)) > begin + 1) {
            return fileName.substring(begin + 1, end);
        }
        return "";
    }

    private void addLines(boolean hit, EStdNumberList[] lines) {
        EStdNumberList[] eStdNumberListArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            EStdNumberList line = eStdNumberListArray[n2];
            ICCImportFile ccFile = this.fData.getCCFile(line);
            if (ccFile != null) {
                try {
                    if (hit) {
                        int testId = this.fData.getTestCaseID();
                        ccFile.addHitLines(testId, CCImportUtilities.getLines((String)line.getLinesAttribute()));
                    } else {
                        ccFile.addLines(CCImportUtilities.getLines((String)line.getLinesAttribute()));
                    }
                }
                catch (CCImportException e) {
                    CCUtilities.log(e);
                }
            }
            ++n2;
        }
    }

    public void addLines(EStdNumberList[] executableLines, EStdNumberList[] hitLines) {
        this.addLines(false, executableLines);
        this.addLines(true, hitLines);
    }

    public void addFlowPoints(EStdFileFlowPoints[] fileFlowPoints) {
        boolean isFunctionCoverage = this.fData.getLevel() == ICCConstants.COVERAGE_LEVEL.FUNCTION;
        EStdFileFlowPoints[] eStdFileFlowPointsArray = fileFlowPoints;
        int n = fileFlowPoints.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                EStdFileFlowPoints fileFlowPoint = eStdFileFlowPointsArray[n2];
                ICCImportFile ccFile = this.fData.getCCFile(fileFlowPoint);
                if (ccFile != null) {
                    block5: {
                        if (!isFunctionCoverage && ccFile.isSourceAvailable() && ParserEntryPointUtils.isParserAvailable((ICCImportFile)ccFile)) {
                            try {
                                if (!ParserEntryPointUtils.parseFlowPoints((ICCImportFile)ccFile, null)) break block5;
                                break block6;
                            }
                            catch (Throwable t) {
                                CCUtilities.log(4, NLS.bind((String)"Entry Point Parser failed for file: {1}", (Object)ccFile.getFileName()), t);
                                ccFile.addMessage(NLS.bind((String)Messages.CRRDG7123, (Object)ccFile.getFileName()), new String[0]);
                            }
                        }
                    }
                    this.loadFlowPoints(ccFile, fileFlowPoint);
                }
            }
            ++n2;
        }
    }

    public void addFlowPointsHit(EStdFlowPointsHit[] flowPointsHit) {
        boolean isFunctionCoverage = this.fData.getLevel() == ICCConstants.COVERAGE_LEVEL.FUNCTION;
        int testId = this.fData.getTestCaseID();
        EStdFlowPointsHit[] eStdFlowPointsHitArray = flowPointsHit;
        int n = flowPointsHit.length;
        int n2 = 0;
        while (n2 < n) {
            int[] ids;
            EStdFlowPointsHit flowPointHit = eStdFlowPointsHitArray[n2];
            int[] nArray = ids = flowPointHit.getFlowPointsHit();
            int n3 = ids.length;
            int n4 = 0;
            while (n4 < n3) {
                int id = nArray[n4];
                ICCImportFlowPoint fp = this.fMapping.get(id);
                if (fp != null) {
                    ICCFile ccFile;
                    fp.setHit();
                    if (isFunctionCoverage && (ccFile = fp.getCCFile()) instanceof ICCImportFile) {
                        ((ICCImportFile)ccFile).addHitLines(testId, new Integer[]{fp.getLine()});
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void addTraceEntries(EStdTraceEntry[] traceEntries) {
    }

    private void loadFlowPoints(ICCImportFile ccFile, EStdFileFlowPoints fileFlowPoints) {
        int maxLastLine = 0;
        EStdFlowPoint[] fps = fileFlowPoints.getFlowPoints();
        boolean isFunctionCoverage = this.fData.getLevel() == ICCConstants.COVERAGE_LEVEL.FUNCTION;
        int i = 0;
        while (i < fps.length) {
            EStdFlowPoint flowPoint = fps[i];
            byte type = this.convertFlowPointType(flowPoint.getType(), ccFile.getLanguage());
            int firstLine = flowPoint.getFirstLine();
            int lastLine = flowPoint.getLastLine();
            if (lastLine == 0) {
                lastLine = this.computeLastLine(maxLastLine, fps, i);
            }
            maxLastLine = Math.max(maxLastLine, lastLine);
            if (!this.exists(ccFile, flowPoint.getSignature(), firstLine, lastLine)) {
                ICCImportFlowPointParent parent = CCImportUtilities.findParent((ICCImportFile)ccFile, (int)firstLine, (int)lastLine);
                try {
                    ICCImportFlowPoint fp = null;
                    fp = parent == null ? ccFile.createFlowPoint(flowPoint.getSignature(), firstLine, lastLine, type) : parent.createFlowPoint(flowPoint.getSignature(), firstLine, lastLine, type);
                    this.fMapping.put(flowPoint.getId(), fp);
                    if (isFunctionCoverage) {
                        try {
                            ccFile.addLines(new Integer[]{firstLine});
                        }
                        catch (CCImportException e) {
                            CCUtilities.log(e);
                        }
                    }
                }
                catch (CCDuplicateFlowPointException fp) {
                }
                catch (CCImportFlowPointException e) {
                    ccFile.addMessage((Throwable)e);
                }
            }
            ++i;
        }
    }

    private boolean exists(ICCImportFile ccFile, String name, int firstLine, int lastLine) {
        ICCTreeItem[] iCCTreeItemArray = ccFile.getChildren();
        int n = iCCTreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICCTreeItem child = iCCTreeItemArray[n2];
            if (this.findFlowPoint((ICCFlowPoint)child, name, firstLine, lastLine)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean findFlowPoint(ICCFlowPoint fp, String name, int firstLine, int lastLine) {
        if (fp.getLine() == firstLine && fp.getLastLine() == lastLine && fp.getName().equals(name)) {
            return true;
        }
        ICCTreeItem[] iCCTreeItemArray = fp.getChildren();
        int n = iCCTreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICCTreeItem child = iCCTreeItemArray[n2];
            if (this.findFlowPoint((ICCFlowPoint)child, name, firstLine, lastLine)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private byte convertFlowPointType(EStdFlowPoint.TYPE type, int language) {
        switch (type) {
            case ENTRY: {
                if (language == 6) {
                    return 3;
                }
                return 0;
            }
            case PARAGRAPH: {
                return 1;
            }
            case PROGRAM: {
                return 3;
            }
            case SECTION: {
                return 2;
            }
        }
        return 0;
    }

    private int computeLastLine(int maxLastLine, EStdFlowPoint[] flowPoints, int index) {
        try {
            return flowPoints[index + 1].getFirstLine() - 1;
        }
        catch (IndexOutOfBoundsException e) {
            return maxLastLine;
        }
    }

    public void breakpointAdded(BreakpointAddedEvent event) {
    }

    public void processStopped(ProcessStoppedEvent event) {
        if (!this.fData.isAsync()) {
            this.fData.setRunnable(event.getProcessStopInfo());
        }
    }

    public void threadAdded(ThreadAddedEvent event) {
        if (this.fData.isAsync()) {
            event.getThread().addEventListener((IThreadEventListener)new CCThreadEventListener(this.fData));
        }
    }

    private boolean isValidResults(CCData data) {
        if (data.getResults().getNumFiles() > 0) {
            return true;
        }
        return data.getLevel() == ICCConstants.COVERAGE_LEVEL.MODULE && data.getResults().getModules().length > 0;
    }

    private String getDetails(ICCFile file) {
        StringBuilder sb = new StringBuilder();
        sb.append(4);
        sb.append(',').append(file.getName());
        sb.append(',').append(file.getPercentCoverage());
        sb.append(',').append(file.getNumExecutableLines());
        sb.append(',').append(file.getNumHitLines());
        return sb.toString();
    }

    private void addFilterDetails(CCResultExporterSettings settings, CCData ccdata) {
        Throwable throwable;
        CCResultsFilter filter = ccdata.getResultsFilter();
        if (filter == null) {
            return;
        }
        try {
            Throwable throwable2 = null;
            throwable = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                filter.writeFilters((OutputStream)baos);
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                settings.addFile((InputStream)bais, "filters/filterlist.txt");
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (IOException e) {
            CCUtilities.log(e);
        }
        filter.getLogStream().close();
        Path logPath = ccdata.getResultsFilterLog();
        try {
            throwable = null;
            Object var6_11 = null;
            try (FileInputStream inputStream = new FileInputStream(logPath.toFile());){
                settings.addFile((InputStream)inputStream, "filters/filterlog.txt");
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            CCUtilities.log(e);
        }
    }
}

