/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.core;

import com.ibm.debug.daemon.internal.core.CorePortUtility;
import com.ibm.debug.pdt.codecoverage.core.results.CCMessageUtilities;
import com.ibm.debug.pdt.codecoverage.internal.core.CCUtilities;
import com.ibm.debug.pdt.codecoverage.internal.core.ICCCoreConstants;
import com.ibm.debug.pdt.codecoverage.internal.core.Messages;
import com.ibm.debug.pdt.codecoverage.internal.core.results.filters.CCResultsFilter;
import com.ibm.debug.pdt.internal.genpassword.utils.Decryptor;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class CCParams
extends Properties
implements ICCCoreConstants {
    private static final ICCCoreConstants.Argument[] COMMAND_ARGUMENTS = new ICCCoreConstants.Argument[]{new ICCCoreConstants.Argument("programName"), new ICCCoreConstants.Argument("programParms"), new ICCCoreConstants.Argument("programOverride"), new ICCCoreConstants.Argument("port", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("output", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("cclevel", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("reportformat", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("startdaemon", ICCCoreConstants.VALUE_OPTION.VALUE_NOT_REQUIRED), new ICCCoreConstants.Argument("stopdaemon", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("singleconnect", ICCCoreConstants.VALUE_OPTION.VALUE_NOT_REQUIRED), new ICCCoreConstants.Argument("savesource", ICCCoreConstants.VALUE_OPTION.VALUE_NOT_REQUIRED), new ICCCoreConstants.Argument("optionsfile", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("help", ICCCoreConstants.VALUE_OPTION.VALUE_NOT_REQUIRED), new ICCCoreConstants.Argument("startupcommandlist", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("Isuppresstimestamps", ICCCoreConstants.VALUE_OPTION.VALUE_NOT_REQUIRED), new ICCCoreConstants.Argument("Iepdcdump", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("localonly", ICCCoreConstants.VALUE_OPTION.VALUE_NOT_REQUIRED), new ICCCoreConstants.Argument("tag", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("Idaemonasync", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("zipresult", ICCCoreConstants.VALUE_OPTION.VALUE_OPTIONAL), new ICCCoreConstants.Argument("Ioutputdir", ICCCoreConstants.VALUE_OPTION.VALUE_NOT_REQUIRED), new ICCCoreConstants.Argument("Idata2", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("Itimerpid", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("ignoreerrors", ICCCoreConstants.VALUE_OPTION.VALUE_NOT_REQUIRED), new ICCCoreConstants.Argument("timeout", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("Istartupcommandlist_nofile", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("testid", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("zunit", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("moduleexcludelist", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("Imodulefilter", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("moduleexclude", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("moduleincludelist", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("moduleinclude", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("providerid", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("provideriddir", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("printparms", ICCCoreConstants.VALUE_OPTION.VALUE_NOT_REQUIRED), new ICCCoreConstants.Argument("exportertype", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("view", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("ccsport", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("filter", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("filterlist", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("allowoutputlocation", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("ccskeystoreproperties", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("exportencoding", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("enablebasicauth", ICCCoreConstants.VALUE_OPTION.VALUE_NOT_REQUIRED), new ICCCoreConstants.Argument("applid", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("Iaks", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("Iakp", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("Iapb", ICCCoreConstants.VALUE_OPTION.VALUE_NOT_REQUIRED), new ICCCoreConstants.Argument("daemonkeystoreproperties", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("authkeystoreproperties", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new ICCCoreConstants.Argument("root", ICCCoreConstants.VALUE_OPTION.VALUE_REQUIRED)};
    static final String SEPARATOR = System.getProperty("line.separator");
    private static final Integer[] EMPTYPORTS = new Integer[0];
    private static final long serialVersionUID = 20160425L;
    private static Properties fParmProperties = null;
    private boolean fAllowOutputParameter = true;
    private String fOutputParmSpecified = null;

    public CCParams() {
    }

    public CCParams(Properties initialParams) {
        super(initialParams);
        if (initialParams.containsKey("Iapb")) {
            this.put("Iapb", initialParams.get("Iapb"));
        }
    }

    public static CCParams load(File optionsFile) throws CCParseException {
        if (optionsFile == null || !optionsFile.exists()) {
            return null;
        }
        CCParams params = new CCParams();
        String codepage = CCParams.isZos() ? "IBM-1047" : Charset.defaultCharset().name();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(optionsFile), codepage);){
                params.load(reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw new CCParseException(Messages.bind((String)Messages.CRRDG7112, (Object)optionsFile.getAbsolutePath()), ex);
        }
        return params;
    }

    public static IPath getWorkingDir() {
        Path path = new Path(System.getProperty("user.home"));
        path = path.append("CC");
        return path;
    }

    private static void validateArgumentValue(ICCCoreConstants.Argument arg, String value) throws CCParseException, Decryptor.DecryptorException {
        if (arg.isInternal()) {
            return;
        }
        if (arg.isRequired() && (value == null || value.isEmpty())) {
            throw new CCParseException(NLS.bind((String)Messages.CRRDG7015, (Object)arg.getName()));
        }
        if (value != null) {
            value = value.trim();
        }
        switch (arg.getName()) {
            case "port": {
                CCParams.validatePortList(value);
                break;
            }
            case "output": 
            case "provideriddir": {
                CCParams.validateDirectoryPath(arg.getName(), value);
                break;
            }
            case "startupcommandlist": 
            case "optionsfile": 
            case "Iaks": {
                CCParams.validateFile(arg.getName(), value);
                break;
            }
            case "filterlist": 
            case "filter": {
                CCParams.validateRegex(arg, value);
                break;
            }
            case "cclevel": {
                CCParams.validateCCLevel(value);
                break;
            }
            case "allowoutputlocation": 
            case "Idaemonasync": {
                CCParams.validateBooleanValue(arg, value);
                break;
            }
            case "Iepdcdump": {
                CCParams.validateEPDC(value);
                break;
            }
            case "stopdaemon": 
            case "ccsport": {
                CCParams.validatePort(value);
                break;
            }
            case "timeout": {
                CCParams.validateInteger(arg, value);
                break;
            }
            case "exportertype": {
                CCParams.validateExporterType(value);
                break;
            }
            case "exportencoding": {
                CCParams.validateExportEncoding(arg, value);
                break;
            }
            case "savesource": {
                try {
                    CCParams.validateBasicValue(arg, value);
                }
                catch (CCParseException e) {
                    CCParams.validateBooleanValue(arg, value);
                }
                break;
            }
            case "ccskeystoreproperties": {
                CCParams.validateFile(arg.getName(), value);
                CCParams.validateKeystoreFile(arg.getName(), value);
                break;
            }
            case "authkeystoreproperties": 
            case "daemonkeystoreproperties": {
                CCParams.validateFile(arg.getName(), value);
                CCParams.validateDaemonKeystoreFile(arg.getName(), value);
                break;
            }
            case "root": {
                CCParams.validateBasicValue(arg, value);
                CCParams.validateRoot(value);
                break;
            }
            default: {
                CCParams.validateBasicValue(arg, value);
            }
            case "prevresultpath": 
            case "reportformat": 
        }
    }

    private static void validateRegex(ICCCoreConstants.Argument arg, String value) throws CCParseException {
        OutputStream nullStream = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        };
        switch (arg.getName()) {
            case "filter": {
                try {
                    CCResultsFilter resultFilter = new CCResultsFilter(nullStream);
                    String[] stringArray = value.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String filter = stringArray[n2];
                        resultFilter.addFilter(filter);
                        ++n2;
                    }
                    break;
                }
                catch (CCResultsFilter.FilterFormatException e) {
                    System.out.println(e.getRegexError());
                    throw new CCParseException(NLS.bind((String)Messages.CRRDG7067, (Object)e.getFilter()), (Exception)((Object)e));
                }
            }
            case "filterlist": {
                CCParams.validateFile(arg.getName(), value);
                try {
                    new CCResultsFilter(nullStream).load(value);
                    break;
                }
                catch (CCResultsFilter.FilterFormatException e) {
                    System.out.println(e.getRegexError());
                    Object[] msgArgs = new String[]{e.getFilter(), String.valueOf(e.getLineNumber()), e.getFilename()};
                    throw new CCParseException(NLS.bind((String)Messages.CRRDG7068, (Object[])msgArgs));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    private static void validateInteger(ICCCoreConstants.Argument arg, String value) throws CCParseException {
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new CCParseException(NLS.bind((String)Messages.CRRDG7011, (Object)arg.getName()));
        }
    }

    public static void validateBooleanValue(ICCCoreConstants.Argument arg, String value) throws CCParseException {
        if (Boolean.parseBoolean(value) || value.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return;
        }
        throw new CCParseException(NLS.bind((String)Messages.CRRDG7017, (Object)arg.getName()));
    }

    private static void validateCCLevel(String value) throws CCParseException {
        if (value.equalsIgnoreCase("LINE") || value.equalsIgnoreCase("FUNCTION")) {
            return;
        }
        throw new CCParseException(NLS.bind((String)Messages.CRRDG7007, (Object)value));
    }

    public static void validateDirectoryPath(String argument, String value) throws CCParseException {
        File dirPath = new File(value);
        if (!dirPath.isDirectory()) {
            throw new CCParseException(NLS.bind((String)Messages.CRRDG7018, (Object)argument, (Object)value));
        }
    }

    private static void validateEPDC(String value) throws CCParseException {
        File epdcFile = new File(value);
        if (epdcFile.isDirectory()) {
            return;
        }
        throw new CCParseException(String.format("Path (%s) for EPDC dump is invalid", value));
    }

    public static void validateFile(String argument, String value) throws CCParseException {
        File file = new File(value);
        if (file.exists() && file.isFile()) {
            return;
        }
        throw new CCParseException(NLS.bind((String)Messages.CRRDG7019, (Object)argument, (Object)value));
    }

    public static void validateRoot(String value) throws CCParseException {
        String SLASH = "/";
        String PATH_TRAVERSAL = "..";
        if (!value.startsWith("/") && value.contains("/")) {
            throw new CCParseException(NLS.bind((String)Messages.CRRDG7163, (Object)value));
        }
        if (value.startsWith("..") || value.contains("/..")) {
            throw new CCParseException(NLS.bind((String)Messages.CRRDG7163, (Object)value));
        }
    }

    public static void validateBasicValue(ICCCoreConstants.Argument arg, String value) throws CCParseException {
        if (arg.isNotRequired()) {
            if (value == null || value.isEmpty() || value.equals(Boolean.TRUE.toString()) || value.equals(Boolean.FALSE.toString())) {
                return;
            }
            throw new CCParseException(NLS.bind((String)Messages.CRRDG7016, (Object)arg.getName()));
        }
        if (arg.isRequired() && (value == null || value.isEmpty())) {
            throw new CCParseException(NLS.bind((String)Messages.CRRDG7015, (Object)arg.getName()));
        }
    }

    private static Integer[] validatePortList(String value) throws CCParseException {
        Integer[] ports = EMPTYPORTS;
        try {
            ports = CorePortUtility.getPorts((String)value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (ports.length == 0) {
            throw new CCParseException(NLS.bind((String)Messages.CRRDG7009, (Object)value));
        }
        return ports;
    }

    private static int validatePort(String value) throws CCParseException {
        try {
            int port = Integer.parseInt(value);
            if (port > 0) {
                return port;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new CCParseException(NLS.bind((String)Messages.CRRDG7009, (Object)value));
    }

    public Integer[] getDaemonPorts() {
        try {
            return CCParams.validatePortList(this.getProperty("port"));
        }
        catch (CCParseException e) {
            return EMPTYPORTS;
        }
    }

    public int getStopDaemonPort() throws CCParseException {
        return CCParams.validatePort(this.getProperty("stopdaemon"));
    }

    public String getEPDCDumpPath() {
        return this.getProperty("Iepdcdump");
    }

    private File getOptionsFile(String optionsFileName) throws CCParseException {
        if (optionsFileName == null || optionsFileName.isEmpty()) {
            return null;
        }
        File file = new File(optionsFileName);
        if (file.exists()) {
            return file;
        }
        throw new CCParseException(NLS.bind((String)Messages.CRRDG7021, (Object)optionsFileName));
    }

    public IPath getOutputDir() {
        String value = this.getProperty("output");
        if (value == null) {
            IPath newValue = CCParams.getWorkingDir();
            this.setProperty("output", newValue.toString());
            return newValue;
        }
        return new Path(value);
    }

    public String getPgmName() {
        return this.getProperty("programName");
    }

    public void setPgmName(String pgmName) {
        this.setProperty("programName", pgmName);
    }

    public boolean isPgmNameOverride() {
        return this.getProperty("programOverride", true);
    }

    public void setPgmNameOverride(boolean pgmNameOverride) {
        this.setProperty("programOverride", pgmNameOverride);
    }

    public String getPgmParms() {
        return this.getProperty("programParms");
    }

    public void setPgmParms(String pgmParms) {
        this.setProperty("programParms", pgmParms);
    }

    public String getStartupCommands() {
        String value = this.getProperty("Istartupcommandlist_nofile");
        if (value != null) {
            return value;
        }
        value = this.getProperty("startupcommandlist");
        if (value != null) {
            StringBuilder sb = new StringBuilder();
            File f = new File(value);
            String codepage = CCParams.isZos() ? "IBM-1047" : Charset.defaultCharset().name();
            try {
                Throwable throwable = null;
                Object var6_9 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), codepage));){
                    while (reader.ready()) {
                        sb.append(reader.readLine());
                        sb.append(SEPARATOR);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                CCUtilities.log(e);
            }
            catch (IOException e) {
                CCUtilities.log(e);
            }
            return sb.toString();
        }
        return "";
    }

    public static File getSysOptionsFile() throws CCParseException {
        IPath path = CCParams.getWorkingDir();
        File file = (path = path.append("CC.ini")).toFile();
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public File getUserOptionsFile() throws CCParseException {
        String fileName = this.getUserOptionsFileName();
        if (fileName == null) {
            return null;
        }
        return this.getOptionsFile(fileName);
    }

    public String getUserOptionsFileName() {
        return this.getProperty("optionsfile");
    }

    public File getSKUserOptionsFile() throws CCParseException {
        String fileName = this.getSKUserOptionsFileName();
        if (fileName == null) {
            return null;
        }
        return this.getOptionsFile(fileName);
    }

    public String getSKUserOptionsFileName() {
        return this.getProperty("startupkeyoptionsfile");
    }

    public String getTestCase() {
        return this.getProperty("testid", "");
    }

    public String getTag() {
        return this.getProperty("tag", "");
    }

    public boolean isDaemonMode() {
        return this.isStopDaemon() || this.isStartDaemon();
    }

    public boolean isEPDCDump() {
        return this.isProperty("Iepdcdump");
    }

    public boolean isPorts() {
        return this.isProperty("port");
    }

    public boolean isSaveSource() {
        return this.getProperty("savesource", true);
    }

    public boolean isShowHelp() {
        return this.getProperty("help", false);
    }

    public boolean isSingleConnect() {
        return this.getProperty("singleconnect", false);
    }

    public boolean isStartDaemon() {
        return this.getProperty("startdaemon", false);
    }

    public boolean isStopDaemon() {
        return this.isProperty("stopdaemon");
    }

    public boolean isDaemonAsync() {
        return this.getProperty("Idaemonasync", false);
    }

    public boolean isTimeStamps() {
        return !this.getProperty("Isuppresstimestamps", false);
    }

    public boolean isLocalOnly() {
        return this.getProperty("localonly", false);
    }

    public boolean isIgnoreError() {
        return this.getProperty("ignoreerrors", false);
    }

    public boolean isEnableBasicAuth() {
        return this.getProperty("enablebasicauth", false);
    }

    public boolean isApplId() {
        return this.isProperty("applid");
    }

    public boolean isForcedOutputDir() {
        return this.getProperty("Ioutputdir", false);
    }

    public boolean isFiltering() {
        return this.isProperty("filter") || this.isProperty("filterlist");
    }

    @Deprecated
    public boolean isModuleParams() {
        return this.isProperty("Imodulefilter") || this.isProperty("moduleexclude") || this.isProperty("moduleexcludelist") || this.isProperty("moduleinclude") || this.isProperty("moduleincludelist");
    }

    public void validate(boolean acceptParms) throws CCParseException, Decryptor.DecryptorException {
        this.validateParams(acceptParms);
        if (this.isPorts()) {
            CCParams.validatePortList(this.getProperty("port"));
        } else if (this.isStopDaemon()) {
            CCParams.validatePort(this.getProperty("stopdaemon"));
        }
    }

    public void validateArgumentCombinations(boolean supportsProgramLaunch) throws CCParseException {
        String ccsPort;
        if (!this.isDaemonMode() && !this.isShowHelp()) {
            if (supportsProgramLaunch && this.getPgmName() == null) {
                throw new CCParseException(Messages.CRRDG7012);
            }
            throw new CCParseException(Messages.CRRDG7053);
        }
        if (this.isModuleParams()) {
            if (this.isProperty("Imodulefilter")) {
                CCUtilities.log(2, NLS.bind((String)Messages.CRRDG7161, (Object)"Imodulefilter", (Object)"filter"));
            }
            if (this.isProperty("moduleexclude")) {
                CCUtilities.log(2, NLS.bind((String)Messages.CRRDG7160, (Object)"moduleexclude", (Object)"filter"), true);
            }
            if (this.isProperty("moduleinclude")) {
                CCUtilities.log(2, NLS.bind((String)Messages.CRRDG7160, (Object)"moduleinclude", (Object)"filter"), true);
            }
            if (this.isProperty("moduleexcludelist")) {
                CCUtilities.log(2, NLS.bind((String)Messages.CRRDG7160, (Object)"moduleexcludelist", (Object)"filterlist"), true);
            }
            if (this.isProperty("moduleincludelist")) {
                CCUtilities.log(2, NLS.bind((String)Messages.CRRDG7160, (Object)"moduleincludelist", (Object)"filterlist"), true);
            }
        }
        if (this.isFiltering() && this.isModuleParams()) {
            throw new CCParseException(Messages.CRRDG7060);
        }
        if (this.isFiltering() && this.isProperty("zunit")) {
            throw new CCParseException(Messages.CRRDG7061);
        }
        if (this.isSingleConnect() && !this.isStartDaemon()) {
            throw new CCParseException(NLS.bind((String)Messages.CRRDG7013, (Object[])new Object[]{"singleconnect", "startdaemon"}));
        }
        if (this.isDaemonMode() && this.getPgmName() != null) {
            throw new CCParseException(Messages.CRRDG7010);
        }
        if (this.isStopDaemon()) {
            Enumeration<?> arguments = this.propertyNames();
            Object extraArgument = null;
            while (arguments.hasMoreElements()) {
                String arg = (String)arguments.nextElement();
                if (arg.equals("stopdaemon")) continue;
                throw new CCParseException(NLS.bind((String)Messages.CRRDG7014, (Object)"stopdaemon", extraArgument));
            }
        }
        if (!(ccsPort = this.getProperty("ccsport", "")).isEmpty()) {
            boolean outputOverride = this.getProperty("allowoutputlocation", false);
            if (outputOverride) {
                throw new CCParseException(NLS.bind((String)Messages.CRRDG7014, (Object)"allowoutputlocation", (Object)"ccsport"));
            }
        } else {
            String keystoreFile = this.getProperty("ccskeystoreproperties", "");
            if (!keystoreFile.isEmpty()) {
                throw new CCParseException(NLS.bind((String)Messages.CRRDG7013, (Object)"ccskeystoreproperties", (Object)"ccsport"));
            }
        }
        if (this.isExportEncoding() && (!this.isExporterType() || !this.getExporterType().equalsIgnoreCase("CCSONARQUBE") && !this.getExporterType().equalsIgnoreCase("SQ"))) {
            throw new CCParseException(NLS.bind((String)Messages.CRRDG7013, (Object)"exportencoding", (Object)"CCSONARQUBE"));
        }
        if (CCParams.isZos() && !ccsPort.isEmpty() && !this.isApplId() && !this.isEnableBasicAuth()) {
            throw new CCParseException(Messages.CRRDG7155);
        }
        String keystore = this.getProperty("Iaks");
        String pwd = this.getProperty("Iakp");
        if (keystore == null && pwd != null || keystore != null && pwd == null) {
            throw new CCParseException(NLS.bind((String)Messages.CRRDG7013, (Object)"Iaks", (Object)"Iakp"));
        }
        if (pwd != null && keystore != null) {
            CCParams.validateKeystorePwd(keystore, pwd);
        }
    }

    public void validateParams(boolean acceptParms) throws CCParseException, Decryptor.DecryptorException {
        Enumeration<?> arguments = this.propertyNames();
        while (arguments.hasMoreElements()) {
            String arg = (String)arguments.nextElement();
            ICCCoreConstants.Argument argument = CCParams.getArgument(arg);
            if (argument == null) {
                this.remove(arg);
                if (acceptParms) continue;
                throw new CCParseException(NLS.bind((String)Messages.CRRDG7011, (Object)arg));
            }
            String value = this.getProperty(arg);
            CCParams.validateArgumentValue(argument, value);
            if (!arg.startsWith("-")) continue;
            this.remove(arg);
            this.setProperty(arg.substring(1), value);
        }
    }

    public static ICCCoreConstants.Argument getArgument(String argument) {
        ICCCoreConstants.Argument[] argumentArray = COMMAND_ARGUMENTS;
        int n = COMMAND_ARGUMENTS.length;
        int n2 = 0;
        while (n2 < n) {
            ICCCoreConstants.Argument arg = argumentArray[n2];
            if (argument.startsWith("-") ? arg.getName().equals(argument.substring(1)) : arg.getName().equals(argument)) {
                return arg;
            }
            ++n2;
        }
        return null;
    }

    public boolean isTimerRunning() {
        return this.isProperty("Itimerpid");
    }

    public String getTimerPid() {
        return this.getProperty("Itimerpid");
    }

    public boolean isPrintParms() {
        return this.isProperty("printparms");
    }

    public Object setProperty(String name, boolean value) {
        return super.setProperty(name, Boolean.toString(value));
    }

    public synchronized boolean getProperty(String name, boolean defaultValue) {
        String property = this.getProperty(name);
        if (property == null) {
            return defaultValue;
        }
        if (property.isEmpty()) {
            return true;
        }
        return Boolean.parseBoolean(property);
    }

    private synchronized boolean isProperty(String key) {
        String value = this.getProperty(key);
        return value != null && !value.equals(Boolean.FALSE.toString());
    }

    public String getProviderID() {
        return this.getProperty("providerid");
    }

    public String getProviderIDDir() {
        return this.getProperty("provideriddir");
    }

    public static CCParams parse(String[] args, boolean acceptParms, boolean supportsProgramLaunch) throws CCParseException {
        CCParams params = new CCParams();
        CharArrayWriter cw = new CharArrayWriter();
        try {
            int i = 0;
            while (i < args.length) {
                String arg = args[i];
                if (arg.equals("--")) {
                    if (supportsProgramLaunch) {
                        CCParams.parsePgmParms(args, i + 1, params);
                        break;
                    }
                    throw new CCParseException(Messages.CRRDG7051);
                }
                if (!arg.startsWith("-")) {
                    if (supportsProgramLaunch) {
                        CCParams.parsePgmParms(args, i, params);
                        break;
                    }
                    throw new CCParseException(Messages.CRRDG7051);
                }
                arg = arg.replace("\\", "\\\\");
                cw.write(arg);
                cw.write(SEPARATOR);
                ++i;
            }
            params.load(new CharArrayReader(cw.toCharArray()));
        }
        catch (IOException e) {
            throw new CCParseException(e.getMessage(), e);
        }
        return params;
    }

    private static void parsePgmParms(String[] args, int programNameIndex, CCParams params) throws CCParseException {
        if (programNameIndex < args.length) {
            params.setPgmName(args[programNameIndex]);
        }
        if (programNameIndex + 1 < args.length) {
            StringBuffer sb = new StringBuffer();
            int i = programNameIndex + 1;
            while (i < args.length) {
                if (i > programNameIndex + 1) {
                    sb.append(' ');
                }
                sb.append(args[i]);
                ++i;
            }
            if (sb.toString().trim().length() > 0) {
                params.setPgmParms(sb.toString());
            }
        }
    }

    public int getNumParms() {
        return this.stringPropertyNames().size();
    }

    public void printParms(OutputStream out) {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out, Charset.defaultCharset()));
        Set<String> parms = this.stringPropertyNames();
        for (String parm : parms) {
            String value = this.getProperty(parm);
            pw.printf("%s=%s%n", parm, value.isEmpty() ? Boolean.valueOf(true) : value);
        }
        pw.flush();
    }

    public ICCCoreConstants.DESIRED_COVERAGE_VIEW getDesiredView() {
        String property = this.getProperty("view", ICCCoreConstants.DESIRED_COVERAGE_VIEW.DEFAULT.toString());
        if (property == null || property.isEmpty() || property.equals(ICCCoreConstants.DESIRED_COVERAGE_VIEW.DEFAULT.toString()) || property.equals(ICCCoreConstants.DESIRED_COVERAGE_VIEW.DEFAULT.abbr)) {
            return ICCCoreConstants.DESIRED_COVERAGE_VIEW.DEFAULT;
        }
        if (property.equals(ICCCoreConstants.DESIRED_COVERAGE_VIEW.SOURCE_LISTING.toString()) || property.equals(ICCCoreConstants.DESIRED_COVERAGE_VIEW.SOURCE_LISTING.abbr)) {
            return ICCCoreConstants.DESIRED_COVERAGE_VIEW.SOURCE_LISTING;
        }
        if (property.equals(ICCCoreConstants.DESIRED_COVERAGE_VIEW.LISTING_ONLY.toString()) || property.equals(ICCCoreConstants.DESIRED_COVERAGE_VIEW.LISTING_ONLY.abbr)) {
            return ICCCoreConstants.DESIRED_COVERAGE_VIEW.LISTING_ONLY;
        }
        if (property.equals(ICCCoreConstants.DESIRED_COVERAGE_VIEW.SOURCE_ONLY.toString()) || property.equals(ICCCoreConstants.DESIRED_COVERAGE_VIEW.SOURCE_ONLY.abbr)) {
            return ICCCoreConstants.DESIRED_COVERAGE_VIEW.SOURCE_ONLY;
        }
        return ICCCoreConstants.DESIRED_COVERAGE_VIEW.DEFAULT;
    }

    public static String[] validateExporterType(String value) throws CCParseException {
        HashSet<String> exporterTypeSet = new HashSet<String>(Arrays.asList(value.split(",")));
        ArrayList<String> exporterTypeList = new ArrayList<String>();
        for (String exporterType : exporterTypeSet) {
            switch (exporterType = exporterType.trim().toUpperCase()) {
                case "CCRESULT": 
                case "CCSONARQUBE": 
                case "CCCOBERTURA": 
                case "SQ": 
                case "COB": 
                case "PDF": 
                case "URL": 
                case "CCPDF": 
                case "CCURL": {
                    exporterTypeList.add(exporterType);
                    break;
                }
                default: {
                    throw new CCParseException(NLS.bind((String)Messages.CRRDG7133, (Object)exporterType));
                }
            }
        }
        return exporterTypeList.toArray(new String[exporterTypeList.size()]);
    }

    public String getExporterType() {
        return this.getProperty("exportertype", "");
    }

    public boolean isExporterType() {
        return this.isProperty("exportertype");
    }

    public boolean isExportEncoding() {
        return this.isProperty("exportencoding");
    }

    public String getFilterList() {
        return this.getProperty("filterlist");
    }

    public String getFilter() {
        return this.getProperty("filter");
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        if (((String)key).charAt(0) == '-' && ((String)key).length() == 2) {
            key = "-" + CCParams.getLongParmName(((String)key).substring(1));
        } else if (((String)key).length() == 1) {
            key = CCParams.getLongParmName((String)key);
        }
        if (((String)key).equals("output") && !this.isOutputParmOk(value)) {
            return null;
        }
        if (((String)key).equals("allowoutputlocation") && !this.fAllowOutputParameter) {
            CCUtilities.log(2, "allowoutputlocation was specifed and ignored");
            return null;
        }
        if (((String)key).equals("zunit")) {
            this.setPgmNameOverride(false);
            if (this.getPgmName() == null || this.getPgmName().isEmpty()) {
                String[] zunit = value.split(":");
                if (zunit.length == 2 && !zunit[1].isEmpty()) {
                    this.setPgmName(zunit[1]);
                } else {
                    this.setPgmName(zunit[0]);
                }
            }
        }
        return super.setProperty((String)key, value);
    }

    static synchronized String getLongParmName(String parm) {
        CCParams.initParmSingleLetter();
        if (fParmProperties.containsKey(parm)) {
            return fParmProperties.getProperty(parm);
        }
        return parm;
    }

    public static synchronized String getShortParmName(String parm) {
        CCParams.initParmSingleLetter();
        for (Map.Entry<Object, Object> entry : fParmProperties.entrySet()) {
            if (!entry.getValue().equals(parm)) continue;
            return entry.getKey().toString();
        }
        return parm;
    }

    private static synchronized void initParmSingleLetter() {
        if (fParmProperties == null) {
            fParmProperties = new Properties();
            try {
                Throwable throwable = null;
                Object var1_3 = null;
                try (InputStream stream = CCParams.class.getResourceAsStream("parm.properties");){
                    fParmProperties.load(stream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                CCUtilities.log(e);
            }
        }
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (key instanceof String) {
            if (((String)key).charAt(0) == '-' && ((String)key).length() == 2) {
                key = "-" + CCParams.getLongParmName(((String)key).substring(1));
            } else if (((String)key).length() == 1) {
                key = CCParams.getLongParmName((String)key);
            }
        }
        if (key.equals("-Iakp") && value instanceof String && !this.containsKey("Iapb")) {
            value = new String(CCParams.encodeString((String)value), StandardCharsets.UTF_8);
            super.setProperty("Iapb", Boolean.toString(true));
        }
        if (key.equals("output") && !this.isOutputParmOk(value)) {
            return null;
        }
        return super.put(key, value);
    }

    @Override
    public synchronized String getProperty(String key) {
        String property = super.getProperty(key);
        if ("Iakp".equals(key) && property != null && this.containsKey("Iapb")) {
            return CCParams.decodeString(property.getBytes(StandardCharsets.UTF_8));
        }
        return property;
    }

    @Override
    public synchronized void putAll(Map<? extends Object, ? extends Object> t) {
        if (t instanceof Properties) {
            Set<String> parms = ((Properties)t).stringPropertyNames();
            if (t.containsKey("Iapb")) {
                this.put("Iapb", Boolean.toString(true));
            }
            for (String string : parms) {
                if (string.equals("Iakp")) {
                    this.put(string, t.get(string));
                    continue;
                }
                this.put(string, ((Properties)t).getProperty(string));
            }
        } else {
            super.putAll(t);
        }
    }

    public synchronized void setAllowOuputParam(boolean value) {
        this.fAllowOutputParameter = value;
    }

    public void validateOutputParameter() throws CCParseException {
        if (this.fOutputParmSpecified != null) {
            throw new CCParseException(NLS.bind((String)Messages.CRRDG7150, (Object)this.fOutputParmSpecified, (Object)this.get("output")));
        }
    }

    private boolean isOutputParmOk(Object value) {
        boolean outputOverride = this.getProperty("allowoutputlocation", false);
        if (!outputOverride && !this.fAllowOutputParameter && value instanceof String) {
            this.fOutputParmSpecified = (String)value;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean equals(Object arg0) {
        return super.equals(arg0) && arg0 instanceof CCParams;
    }

    @Override
    public synchronized int hashCode() {
        return super.hashCode() + 10;
    }

    private static void validateKeystoreFile(String arg, String value) throws CCParseException, Decryptor.DecryptorException {
        Properties p = new Properties();
        String codepage = CCParams.isZos() ? "IBM-1047" : Charset.defaultCharset().name();
        try {
            Decryptor.checkKeystoreFileEncoding((String)value);
            codepage = "UTF-8";
        }
        catch (Decryptor.DecryptorException decryptorException) {
            // empty catch block
        }
        try {
            Throwable throwable = null;
            Object var5_9 = null;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(value), codepage);){
                p.load(reader);
                String keystoreFile = p.getProperty("ccskeystorefile", null);
                if (keystoreFile == null || keystoreFile.trim().isEmpty()) {
                    throw new CCParseException(NLS.bind((String)Messages.CRRDG7145, (Object)"<>"));
                }
                try {
                    CCParams.validateFile(arg, keystoreFile);
                }
                catch (CCParseException e) {
                    throw new CCParseException(NLS.bind((String)Messages.CRRDG7145, (Object)keystoreFile));
                }
                char[] pwd = p.getProperty("ccskeystorepassword", null).toCharArray();
                if (pwd == null || pwd.length == 0) {
                    throw new CCParseException(NLS.bind((String)Messages.CRRDG7151, (Object)value));
                }
                if (Decryptor.isEncrypted((Properties)p).booleanValue()) {
                    pwd = Decryptor.decryptEncryptedPwd((String)value, (String)"ccskeystorepassword");
                }
                CCParams.validateKeystorePwd(keystoreFile, pwd);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            CCUtilities.log(e);
            throw new CCParseException(NLS.bind((String)Messages.CRRDG7145, (Object)value));
        }
        catch (IOException e) {
            CCUtilities.log(e);
            throw new CCParseException(NLS.bind((String)Messages.CRRDG7145, (Object)value));
        }
    }

    private static void validateDaemonKeystoreFile(String arg, String value) throws CCParseException, Decryptor.DecryptorException {
        Properties p = new Properties();
        String codepage = "UTF-8";
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(value), "UTF-8");){
                p.load(reader);
                String keystoreFile = p.getProperty("keystorefile", null);
                if (keystoreFile == null || keystoreFile.trim().isEmpty()) {
                    throw new CCParseException(NLS.bind((String)Messages.CRRDG7145, (Object)"<>"));
                }
                try {
                    CCParams.validateFile(arg, keystoreFile);
                }
                catch (CCParseException e) {
                    throw new CCParseException(NLS.bind((String)Messages.CRRDG7145, (Object)keystoreFile));
                }
                if (!p.containsKey("keystorepassword")) {
                    throw new CCParseException(NLS.bind((String)Messages.CRRDG7151, (Object)value));
                }
                if (p.getProperty("keystorepassword", "").isBlank()) {
                    throw new CCParseException(Messages.CRRDG7151);
                }
                char[] pwd = Decryptor.decryptEncryptedPwd((String)value, (String)"keystorepassword");
                CCParams.validateKeystorePwd(keystoreFile, pwd);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            CCUtilities.log(e);
            throw new CCParseException(NLS.bind((String)Messages.CRRDG7145, (Object)value));
        }
        catch (IOException e) {
            CCUtilities.log(e);
            throw new CCParseException(NLS.bind((String)Messages.CRRDG7145, (Object)value));
        }
    }

    final boolean isUserPathNeeded() {
        String ccaasPort = this.getProperty("ccsport", "");
        return !ccaasPort.isEmpty() && CCParams.isZos();
    }

    static boolean isZos() {
        return "z/OS".equalsIgnoreCase(System.getProperty("os.name"));
    }

    public static void validateExportEncoding(ICCCoreConstants.Argument arg, String value) throws CCParseException {
        if (value == null || value.isEmpty()) {
            throw new CCParseException(NLS.bind((String)Messages.CRRDG7015, (Object)arg.getName()));
        }
        if (!Charset.isSupported(value)) {
            throw new CCParseException(NLS.bind((String)CCMessageUtilities.getMessage((String)"ACRRDG7280E"), (Object)value));
        }
    }

    private static void validateKeystorePwd(String keystorePath, String keystorePwd) throws CCParseException {
        CCParams.validateKeystorePwd(keystorePath, keystorePwd.toCharArray());
    }

    private static void validateKeystorePwd(String keystorePath, char[] keystorePwd) throws CCParseException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fileInputStream = new FileInputStream(keystorePath);){
                String type = "JKS";
                KeyStore keystore = KeyStore.getInstance(type);
                keystore.load(fileInputStream, keystorePwd);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            if (CCUtilities.TRACE_ON) {
                CCUtilities.log(e);
            }
            try {
                Throwable throwable = null;
                Object var4_11 = null;
                try (FileInputStream fileInputStream2 = new FileInputStream(keystorePath);){
                    String type = "PKCS12";
                    KeyStore keystore = KeyStore.getInstance(type);
                    keystore.load(fileInputStream2, keystorePwd);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Exception e2) {
                if (CCUtilities.TRACE_ON) {
                    CCUtilities.log(e2);
                }
                throw new CCParseException(NLS.bind((String)Messages.CRRDG7158, (Object)keystorePath));
            }
        }
    }

    private static final byte[] encodeString(String input) {
        return Base64.getEncoder().encode(input.getBytes(StandardCharsets.UTF_8));
    }

    public static final String decodeString(byte[] input) {
        return new String(Base64.getDecoder().decode(input), StandardCharsets.UTF_8);
    }

    public String getAuthKeystore() {
        String keystore = this.getProperty("Iaks");
        if (keystore != null) {
            return keystore;
        }
        return this.getDaemonKeystore("authkeystoreproperties");
    }

    public String getDaemonKeystore(String param) {
        block12: {
            if (this.containsKey(param)) {
                String codepage = "UTF-8";
                String daemonPropertiesfile = this.getProperty(param);
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(daemonPropertiesfile), "UTF-8");){
                        Properties p = new Properties();
                        p.load(reader);
                        String keystoreFile = p.getProperty("keystorefile", null);
                        return keystoreFile;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    if (!CCUtilities.TRACE_ON) break block12;
                    CCUtilities.log(e);
                }
            }
        }
        return null;
    }

    public char[] getAuthKeystorePwd() throws Decryptor.DecryptorException {
        if (this.containsKey("Iakp")) {
            return this.getProperty("Iakp").toCharArray();
        }
        return this.getDaemonKeystorePwd("authkeystoreproperties");
    }

    public char[] getDaemonKeystorePwd(String param) throws Decryptor.DecryptorException {
        block12: {
            if (this.containsKey(param)) {
                String daemonPropertiesfile = this.getProperty(param);
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(daemonPropertiesfile), "UTF-8");){
                        Properties p = new Properties();
                        p.load(reader);
                        return Decryptor.decryptEncryptedPwd((String)daemonPropertiesfile, (String)"keystorepassword");
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    if (!CCUtilities.TRACE_ON) break block12;
                    CCUtilities.log(e);
                }
            }
        }
        return null;
    }

    public static class CCParseException
    extends Exception {
        private static final long serialVersionUID = -8597723804229844796L;

        public CCParseException(String message) {
            super(message);
        }

        public CCParseException(String message, Exception ex) {
            super(message, ex);
        }
    }
}

