/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.core;

import com.ibm.debug.daemon.IDaemonDebugTarget2;
import com.ibm.debug.pdt.codecoverage.core.results.ICCConstants;
import com.ibm.debug.pdt.codecoverage.internal.core.CCData;
import com.ibm.debug.pdt.codecoverage.internal.core.CCDebugEngineEventListener;
import com.ibm.debug.pdt.codecoverage.internal.core.CCParams;
import com.ibm.debug.pdt.codecoverage.internal.core.CCUtilities;
import com.ibm.debug.pdt.codecoverage.internal.core.ICCCoreConstants;
import com.ibm.debug.pdt.codecoverage.internal.core.Labels;
import com.ibm.debug.pdt.codecoverage.internal.core.Messages;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventError;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventManager;
import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.internal.core.EngineParameters;
import com.ibm.debug.pdt.internal.core.IPDTDebugTargetWithLabelProvider;
import com.ibm.debug.pdt.internal.core.IPDTLabelProvider;
import com.ibm.debug.pdt.internal.core.OldEngineParameters;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebuggeeAttachOptions;
import com.ibm.debug.pdt.internal.core.model.DebuggeePrepareOptions;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.DetachHandler;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestUnsupportedException;
import com.ibm.debug.pdt.internal.core.model.IDebugEngineEventListener;
import com.ibm.debug.pdt.internal.core.model.IProcessEventListener;
import com.ibm.debug.pdt.internal.epdc.ECCFilter;
import com.ibm.debug.pdt.internal.epdc.ECCModuleFilter;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EReqStartCC;
import java.io.IOException;
import java.net.Socket;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.osgi.util.NLS;

public class CCDebugTarget
extends DebugElement
implements IDaemonDebugTarget2,
IPDTDebugTargetWithLabelProvider {
    private static final IThread[] EMPTY_THREADS = new IThread[0];
    private static final IBreakpoint[] EMPTY_BREAKPOINTS = new IBreakpoint[0];
    protected CCData fData;
    private String fID = String.valueOf(PDTCorePlugin.getUniqueId());
    private ILaunch fLaunch;
    private int fKey;
    protected DebugEngine fDebugEngine;
    protected IPDTLabelProvider fLabelProvider;

    public CCDebugTarget(EngineParameters engineParameters, ILaunch launch, CCData data, int key) {
        super(null);
        String user;
        this.fData = data;
        this.fData.setDebugTarget((IPDTDebugTarget)this);
        this.fData.initTimer();
        this.fLaunch = launch;
        this.fKey = key;
        PDTCorePlugin.addDebugTarget((IPDTDebugTarget)this);
        if (engineParameters instanceof OldEngineParameters && ((OldEngineParameters)engineParameters).getUser() != null && (user = ((OldEngineParameters)engineParameters).getUser()) != null && !user.isEmpty()) {
            data.setUser(user);
        }
    }

    public void engineIsWaiting(Socket socket, boolean socketReuse) {
        this.fDebugEngine = new DebugEngine((IDebugTarget)this);
        this.fDebugEngine.setFEFCT(0x8000000);
        EPDC_EngineSession engineSession = this.fDebugEngine.getEngineSession();
        engineSession.setupEPDCDumping((IPDTDebugTarget)this);
        engineSession.setConnectionTimeout(this.fData.getTimeout());
        try {
            this.fDebugEngine.connect(socket);
            if (CCUtilities.fTiming) {
                CCUtilities.logTiming("Code coverage started for pgm " + this.fData.getPgmName(), this.fData);
            }
            this.connectAndInit();
        }
        catch (Exception e) {
            if (CCUtilities.fLogging) {
                CCUtilities.log(4, "Failed to connect to the debug engine.", e);
            }
            if (e instanceof EngineRequestUnsupportedException) {
                CCEventManager.getInstance().notify(new CCEventError(this.fData, Messages.CRRDG7134));
            } else {
                Object error = Messages.CRRDG7030;
                if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                    error = (String)error + System.getProperty("line.separator") + (String)error;
                }
                CCEventManager.getInstance().notify(new CCEventError(this.fData, (String)error));
            }
            try {
                socket.close();
            }
            catch (IOException e1) {
                CCUtilities.log(e);
            }
        }
        if (this.fData.isZunit() && this.fDebugEngine.getProcess() != null) {
            this.fDebugEngine.getProcess().setBasePgmProfileName(this.fData.getPgmName());
        }
    }

    protected IDebugEngineEventListener getDebugEngineEventListener() {
        return new CCDebugEngineEventListener(this.fData);
    }

    protected void connectAndInit() throws EngineRequestException {
        this.fDebugEngine.initialize((byte)2, "CC", null, null);
        EPDC_EngineSession engineSession = this.fDebugEngine.getEngineSession();
        boolean runToMain = !engineSession.supportsDebugInitialization();
        this.fData.initialize(this.fDebugEngine);
        this.fDebugEngine.addEventListener(this.getDebugEngineEventListener());
        if (this.fData.isAttach()) {
            DebuggeeAttachOptions options = new DebuggeeAttachOptions(this.fData.getProcessPath(), this.fData.getProcessId(), 0, null, false, true, this.fData.getLanguage());
            if (!this.fData.supportsEnhancedCC() || !this.fDebugEngine.getEngineSession().supportsEnhancedCC()) {
                throw new EngineRequestUnsupportedException();
            }
            this.fDebugEngine.processRequest(this.startEnhCC(this.fData, engineSession));
            this.fDebugEngine.attach(options);
        } else {
            DebuggeePrepareOptions options = new DebuggeePrepareOptions(this.fData.getPgmName(), this.fData.getPgmParms(), 0, null, runToMain, false, false, null, this.fData.getLanguage());
            if (!this.fData.supportsEnhancedCC() || !this.fDebugEngine.getEngineSession().supportsEnhancedCC()) {
                throw new EngineRequestUnsupportedException();
            }
            this.fDebugEngine.processRequest(this.startEnhCC(this.fData, engineSession));
            this.fDebugEngine.prepareProgram(options);
        }
    }

    private EPDC_Request startEnhCC(CCData data, EPDC_EngineSession engineSession) {
        int view = switch (this.fData.getDesiredCoverageView()) {
            case ICCCoreConstants.DESIRED_COVERAGE_VIEW.SOURCE_ONLY -> 3;
            case ICCCoreConstants.DESIRED_COVERAGE_VIEW.LISTING_ONLY -> 2;
            case ICCCoreConstants.DESIRED_COVERAGE_VIEW.SOURCE_LISTING -> 4;
            default -> 1;
        };
        byte level = switch (this.fData.getLevel()) {
            case ICCConstants.COVERAGE_LEVEL.LINE -> 1;
            case ICCConstants.COVERAGE_LEVEL.FUNCTION -> 2;
            default -> 1;
        };
        ECCFilter[] filters = null;
        if (this.fData.isZunit()) {
            filters = new ECCFilter[]{new ECCModuleFilter(true, this.fData.getZunitModule(), engineSession)};
        }
        return new EReqStartCC(level, view, filters, engineSession);
    }

    public IFolder getViewFileCache() throws CoreException {
        return this.fData.getSourceFolder();
    }

    public String getId() {
        return this.fID;
    }

    public IProcess getProcess() {
        return this.fDebugEngine == null ? null : this.fDebugEngine.getProcess();
    }

    public IThread[] getThreads() throws DebugException {
        return EMPTY_THREADS;
    }

    public boolean hasThreads() throws DebugException {
        return false;
    }

    public String getName() throws DebugException {
        Object result = null;
        result = this.fData.isSessionError() ? Labels.CCDebugTarget_name + " " + Messages.CRRDG7006 : Labels.CCDebugTarget_name;
        if (this.fLabelProvider != null) {
            return this.fLabelProvider.getLabel((DebugElement)this, (String)result);
        }
        return result;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return false;
    }

    public String getModelIdentifier() {
        return "com.ibm.debug.pdt.codecoverage.core";
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.fData.isTerminated();
    }

    public void terminate() throws DebugException {
        block14: {
            if (CCUtilities.fTiming) {
                CCUtilities.logTiming("Ready to terminate debug engine", this.fData);
            }
            if (this.isTerminated()) {
                return;
            }
            if (!this.isAcceptingRequests()) {
                if (this.getDebugEngine() != null) {
                    try {
                        this.getDebugEngine().setConnectionTerminated();
                        this.getDebugEngine().getConnection().close();
                    }
                    catch (Exception exception) {}
                } else {
                    this.fData.setTerminated(true);
                }
            } else {
                DebuggeeProcess process = (DebuggeeProcess)this.getProcess();
                if (process != null && !process.isTerminated()) {
                    try {
                        process.terminate(this.getDebugEngine().getEngineSession().getTerminateType());
                    }
                    catch (EngineRequestException e) {
                        if (CCUtilities.fLogging) {
                            CCUtilities.log(e);
                        }
                        break block14;
                    }
                }
                try {
                    this.getDebugEngine().terminate();
                }
                catch (EngineRequestException e) {
                    if (!CCUtilities.fLogging) break block14;
                    CCUtilities.log(e);
                }
            }
        }
    }

    public boolean canResume() {
        return false;
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean isSuspended() {
        return false;
    }

    public void resume() throws DebugException {
    }

    public void suspend() throws DebugException {
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public boolean canDisconnect() {
        if (this.isTerminated()) {
            return false;
        }
        EPDC_EngineSession engineSession = this.fData.getEngineSession();
        return engineSession != null ? engineSession.supportsProcessDetachRelease() : false;
    }

    public void disconnect() throws DebugException {
        if (this.isTerminated()) {
            return;
        }
        if (!this.fData.isAsync() && !this.isSuspended()) {
            ((DebuggeeProcess)this.getProcess()).addEventListener((IProcessEventListener)new DetachHandler(0));
            this.suspend();
        } else {
            try {
                ((DebuggeeProcess)this.getProcess()).detach(0);
            }
            catch (EngineRequestException e) {
                throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", 5012, e.getMessage(), null));
            }
        }
    }

    public boolean isDisconnected() {
        if (this.fDebugEngine == null) {
            return false;
        }
        return !this.fDebugEngine.isConnected();
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public boolean supportsStepFilters() {
        return false;
    }

    public boolean isStepFiltersEnabled() {
        return false;
    }

    public void setStepFiltersEnabled(boolean enabled) {
    }

    public DebuggeeThread getCurrentThread() {
        return null;
    }

    public boolean continueWaiting() {
        System.out.println(NLS.bind((String)Messages.CRRDG7034, (Object)this.fData.getTimeout()));
        return false;
    }

    public void preResume(boolean resumeAllThreads) {
    }

    public void postResume() {
    }

    public void preStepping(boolean stepAllThreads) {
    }

    public void postStepping() {
    }

    public IBreakpoint[] getStoppingBreakpoints() {
        return EMPTY_BREAKPOINTS;
    }

    public void resume(boolean exception) throws EngineRequestException {
    }

    public void saveToProfile() {
    }

    public int getKey() {
        return this.fKey;
    }

    public void setLaunch(ILaunch launch) {
        this.fLaunch = launch;
        if (this.fLaunch != null && this.fDebugEngine.getProcess() != null) {
            this.fLaunch.addProcess((IProcess)this.fDebugEngine.getProcess());
        }
    }

    public boolean isAcceptingRequests() {
        return this.fDebugEngine == null ? false : this.fDebugEngine.isAcceptingRequests();
    }

    public DebugEngine getDebugEngine() {
        return this.fDebugEngine;
    }

    public CCData getCCData() {
        return this.fData;
    }

    public void updateStartupInfo(EngineParameters engineParms) {
        if (engineParms instanceof OldEngineParameters) {
            OldEngineParameters oep = (OldEngineParameters)engineParms;
            CCParams properties = this.fData.fParams;
            properties.setProperty("attach", oep.isAttach());
            if (oep.isAttach()) {
                properties.setPgmNameOverride(true);
                properties.setProperty("processId", oep.getProcessID());
            } else {
                properties.setProperty("programName", oep.getProgramName());
                properties.setProperty("programParms", oep.getProgramParms());
            }
        }
    }

    public void setLabelProvider(IPDTLabelProvider provider) {
        this.fLabelProvider = provider;
    }
}

