/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.core;

import com.ibm.debug.pdt.codecoverage.core.results.importers.CCImportException;
import com.ibm.debug.pdt.codecoverage.core.results.importers.ICCImportModule;
import com.ibm.debug.pdt.codecoverage.internal.core.CCData;
import com.ibm.debug.pdt.codecoverage.internal.core.CCDebugTarget;
import com.ibm.debug.pdt.codecoverage.internal.core.CCProcessEventListener;
import com.ibm.debug.pdt.codecoverage.internal.core.CCUtilities;
import com.ibm.debug.pdt.codecoverage.internal.core.Labels;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventCollectionStart;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventManager;
import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugEngineCommandLogResponseEvent;
import com.ibm.debug.pdt.internal.core.model.DebugEngineTerminatedEvent;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineConnectionException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ErrorOccurredEvent;
import com.ibm.debug.pdt.internal.core.model.IDebugEngineEventListener;
import com.ibm.debug.pdt.internal.core.model.IProcessEventListener;
import com.ibm.debug.pdt.internal.core.model.MessageReceivedEvent;
import com.ibm.debug.pdt.internal.core.model.ModelStateReadyEvent;
import com.ibm.debug.pdt.internal.core.model.Module;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.ProcessAddedEvent;
import com.ibm.debug.pdt.internal.epdc.ProcessStopInfo;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;

public class CCDebugEngineEventListener
implements IDebugEngineEventListener {
    protected CCData fData;

    public CCDebugEngineEventListener(CCData data) {
        this.fData = data;
    }

    public void debugEngineTerminated(DebugEngineTerminatedEvent event) {
        try {
            this.fData.setTerminated(true);
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this.fData.getDebugTarget(), 8)});
            event.getDebugEngine().getConnection().close();
            this.fData.getEngineSession().terminateEPDCDumping(this.fData.getDebugTarget());
            PDTCorePlugin.removeDebugTarget((IPDTDebugTarget)this.fData.getDebugTarget());
        }
        catch (IOException e) {
            CCUtilities.log(e);
        }
    }

    public void processAdded(ProcessAddedEvent event) {
        ILaunch launch;
        DebuggeeProcess process = event.getProcess();
        if (process.getDebugTarget() instanceof CCDebugTarget) {
            process.setLabelProvider(((CCDebugTarget)process.getDebugTarget()).fLabelProvider);
        }
        this.fData.setPgmName(process.getQualifiedName());
        this.fData.setAsync(process.getEngineSession().supportsAsync());
        this.fData.getResultsName();
        process.addEventListener(this.getProcessEventListener());
        CCEventCollectionStart startEvent = new CCEventCollectionStart(this.fData);
        CCEventManager.getInstance().notify(startEvent);
        if (process.isAttached()) {
            Module[] modules;
            Module[] moduleArray = modules = process.getModules(false);
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                Module module = moduleArray[n2];
                ICCImportModule ccModule = this.fData.add(module);
                if (ccModule != null && !this.fData.isModuleLevel()) {
                    Part[] parts;
                    Part[] partArray = parts = module.getParts(false);
                    int n3 = parts.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Part part = partArray[n4];
                        try {
                            this.fData.add(part);
                        }
                        catch (CCImportException e) {
                            if (!(e.getCause() instanceof EngineRequestException)) {
                                CCUtilities.log(e);
                            }
                            return;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        if ((launch = this.fData.getDebugTarget().getLaunch()) != null) {
            launch.addProcess((IProcess)process);
            process.fireCreationEvent();
        }
        if (this.fData.getEngineSession().supportsCommandLog()) {
            String[] commands;
            String configStartupCommandList = this.fData.getStartupCommands();
            String[] stringArray = commands = CCUtilities.getCommands(configStartupCommandList);
            int n = commands.length;
            int n5 = 0;
            while (n5 < n) {
                String command = stringArray[n5];
                try {
                    process.getDebugEngine().commandLog(command, false, false);
                }
                catch (EngineRequestException e) {
                    CCUtilities.log(2, "Command [" + command + "] failed", e);
                }
                ++n5;
            }
        }
    }

    protected boolean isModuleLoadBreakpointSupported(DebugEngine debugEngine) {
        return true;
    }

    public void errorOccurred(ErrorOccurredEvent event) {
        String description = event.getRequest() == null ? "unknown" : event.getRequest().getDescription();
        CCUtilities.log(2, String.format("Request %s rc = %d msg = %s", description, event.getReturnCode(), event.getMessage()));
        this.fData.setSessionMessage(event.getMessage());
        if (this.fData.isIgnoreError()) {
            return;
        }
        if (this.fData.isSessionEndingRC(event.getReturnCode())) {
            this.fData.setSessionError();
        }
    }

    public void modelStateChanged(final ModelStateReadyEvent event) {
        final ProcessStopInfo stopInfo = this.fData.getRunnable();
        final boolean async = this.fData.isAsync();
        if (stopInfo != null) {
            Job job = new Job(Labels.CCDebugEngineEventListener_job_name){

                protected IStatus run(IProgressMonitor monitor) {
                    block14: {
                        if (CCDebugEngineEventListener.this.fData.getDebugTarget() != null && CCDebugEngineEventListener.this.fData.getDebugTarget() instanceof CCDebugTarget && CCDebugEngineEventListener.this.fData.isWaitingForLaunch() && CCDebugEngineEventListener.this.fData.getDebugTarget().getLaunch() == null) {
                            int i = 0;
                            while (i < 60) {
                                if (CCDebugEngineEventListener.this.fData.getDebugTarget().getLaunch() != null) break;
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                ++i;
                            }
                        }
                        if (CCDebugEngineEventListener.this.isTerminated(event.getDebugEngine())) {
                            return Status.CANCEL_STATUS;
                        }
                        DebuggeeProcess process = event.getDebugEngine().getProcess();
                        if (async) {
                            DebuggeeThread thread = process.getThread(stopInfo.getStoppingThreadId());
                            try {
                                if (stopInfo.isStoppedByException()) {
                                    thread.runException();
                                    break block14;
                                }
                                thread.resume();
                            }
                            catch (DebugException e) {
                                CCUtilities.log(e);
                            }
                            catch (EngineRequestException e) {
                                CCUtilities.log(e);
                            }
                        } else {
                            try {
                                process.run(stopInfo.isStoppedByException());
                            }
                            catch (EngineConnectionException ece) {
                                return Status.CANCEL_STATUS;
                            }
                            catch (EngineRequestException e) {
                                CCUtilities.log(e);
                            }
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    protected boolean isTerminated(DebugEngine debugEngine) {
        if (debugEngine.isProgramTerminating()) {
            return true;
        }
        DebuggeeProcess process = debugEngine.getProcess();
        return process == null || process.isTerminated();
    }

    public void messageReceived(MessageReceivedEvent event) {
    }

    public void commandLogResponse(DebugEngineCommandLogResponseEvent event) {
    }

    protected IProcessEventListener getProcessEventListener() {
        return new CCProcessEventListener(this.fData);
    }
}

