/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.core;

import com.ibm.debug.pdt.codecoverage.core.results.CCMessageUtilities;
import com.ibm.debug.pdt.codecoverage.core.results.CCResultsFactory;
import com.ibm.debug.pdt.codecoverage.core.results.ICCConstants;
import com.ibm.debug.pdt.codecoverage.core.results.importers.CCDuplicateModuleException;
import com.ibm.debug.pdt.codecoverage.core.results.importers.CCDuplicatePartException;
import com.ibm.debug.pdt.codecoverage.core.results.importers.CCFileExistsException;
import com.ibm.debug.pdt.codecoverage.core.results.importers.CCImportException;
import com.ibm.debug.pdt.codecoverage.core.results.importers.ICCImportFile;
import com.ibm.debug.pdt.codecoverage.core.results.importers.ICCImportModule;
import com.ibm.debug.pdt.codecoverage.core.results.importers.ICCImportPart;
import com.ibm.debug.pdt.codecoverage.core.results.importers.ICCImportResult;
import com.ibm.debug.pdt.codecoverage.core.results.importers.ICCImportTestcase;
import com.ibm.debug.pdt.codecoverage.internal.core.CCModuleListener;
import com.ibm.debug.pdt.codecoverage.internal.core.CCParams;
import com.ibm.debug.pdt.codecoverage.internal.core.CCTimingLog;
import com.ibm.debug.pdt.codecoverage.internal.core.CCUtilities;
import com.ibm.debug.pdt.codecoverage.internal.core.ICCCoreConstants;
import com.ibm.debug.pdt.codecoverage.internal.core.Messages;
import com.ibm.debug.pdt.codecoverage.internal.core.results.filters.CCResultsFilter;
import com.ibm.debug.pdt.codecoverage.internal.core.results.parsers.ParserEntryPointUtils;
import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.EngineConnectionException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestErrorException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.IModelEventListener;
import com.ibm.debug.pdt.internal.core.model.IModuleEventListener;
import com.ibm.debug.pdt.internal.core.model.Language;
import com.ibm.debug.pdt.internal.core.model.Module;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.View;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.ERepGetFile;
import com.ibm.debug.pdt.internal.epdc.EReqGetFile;
import com.ibm.debug.pdt.internal.epdc.EStdFileFlowPoints;
import com.ibm.debug.pdt.internal.epdc.EStdNumberList;
import com.ibm.debug.pdt.internal.epdc.ProcessStopInfo;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.InflaterInputStream;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class CCData {
    private static final String UPPERCASE_LETTERS_REGEX = "[a-z]";
    private static final String EMPTY = "";
    private static final String COLON = ":";
    private static final String SLASH = "/";
    private static final String COPY_BOOK_FILE_EXTENSION = ".cpy";
    private boolean fAsync = false;
    private boolean fTerminated = false;
    private IPDTDebugTarget fDebugTarget;
    private EPDC_EngineSession fSession;
    protected String fPgmName;
    private final IModuleEventListener fModuleEventListener = new CCModuleListener(this);
    protected CCParams fParams;
    protected int fTimeout;
    long fStartTime;
    long fElapsedTime;
    private final Set<String> fPartNames = new HashSet<String>();
    private static int fPartNameCount = 1;
    private CCResultsFilter fResultFilter = null;
    private java.nio.file.Path fResultFilterLog = null;
    private Object fResultsFilterLock = new Object();
    private Map<String, String[]> fLoggedMessages = null;
    private ViewInformation fViewInfo = null;
    private ViewInformation fPreferredViewInfo = null;
    private ICCCoreConstants.DESIRED_COVERAGE_VIEW fCoverageView = ICCCoreConstants.DESIRED_COVERAGE_VIEW.DEFAULT;
    private final ConcurrentLinkedQueue<ProcessStopInfo> fStopInfoQueue = new ConcurrentLinkedQueue();
    protected Object fPathLock = new Object();
    protected IPath fResultsPath;
    protected IFolder fSourceFolder;
    protected IPath fSourcePath;
    private java.nio.file.Path fTempSourceDir = null;
    private boolean fResultsNameInit = false;
    private ICCImportResult fImportResult = null;
    private Map<Integer, ICCImportModule> fModulesByID = new HashMap<Integer, ICCImportModule>();
    private Map<Integer, ICCImportPart> fPartsByID = new HashMap<Integer, ICCImportPart>();
    private Map<String, ICCImportFile> fFilesByID = new HashMap<String, ICCImportFile>();
    protected ICCConstants.COVERAGE_LEVEL fLevel;
    private boolean fSessionError = false;
    private String fSessionErrorMsg = null;
    private final String fId = UUID.randomUUID().toString();
    protected boolean fSaveSource;
    private boolean fIsISeries = false;
    private String fEngineVersion = "";
    private String fPluginVersion = "";
    private CCTimingLog fTimingLog;
    private static boolean fModuleExcludeLoaded = false;
    private static ArrayList<Pattern> fModuleExcludeGlobal = new ArrayList();
    private final ArrayList<Pattern> fModuleExcludeInstance = new ArrayList();
    private final ArrayList<Pattern> fModuleIncludeInstance = new ArrayList();
    private final int[] fSessionEndingRC = new int[]{998};
    private ICCImportTestcase fTestCase;
    private int fTestCaseID = 0;
    private String fUser;

    public CCData(CCParams params) {
        this.fImportResult = CCResultsFactory.getInstance().createResult();
        this.fParams = params;
        this.fTimeout = Integer.parseInt(this.fParams.getProperty("timeout", "120"));
        this.fPgmName = params.getPgmName();
        String levelAttr = params.getProperty("cclevel", ICCConstants.COVERAGE_LEVEL.LINE.toString()).toUpperCase();
        this.fLevel = ICCConstants.COVERAGE_LEVEL.valueOf((String)levelAttr);
        this.fSaveSource = params.isSaveSource();
        this.fCoverageView = params.getDesiredView();
        String creator = params.getProperty("creator", null);
        if (creator != null) {
            this.fImportResult.setProperty("creator", (Object)creator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFilterSupport(CCParams params) {
        if (params.isFiltering() || this.isZunit()) {
            Object object = this.fResultsFilterLock;
            synchronized (object) {
                if (this.fResultFilter == null) {
                    String filters;
                    block20: {
                        block19: {
                            try {
                                this.fResultFilterLog = Files.createTempFile("cc", ".log", new FileAttribute[0]);
                                this.fResultFilter = new CCResultsFilter((OutputStream)new FileOutputStream(this.fResultFilterLog.toFile()));
                            }
                            catch (IOException e3) {
                                CCUtilities.log(e3);
                                this.fResultFilter = new CCResultsFilter();
                            }
                            String zunitCSECT = this.getZunitCSECT();
                            if (zunitCSECT != null && !zunitCSECT.isEmpty()) {
                                String zunitFilter = this.getZunitModule() + " " + zunitCSECT;
                                if (params.isFiltering()) {
                                    this.logFilterMsg(this.fImportResult, NLS.bind((String)Messages.CRRDG7162, (Object)("- .*, + " + zunitFilter)), new String[0]);
                                }
                                try {
                                    this.fResultFilter.addExcludeFilter(".*");
                                    this.fResultFilter.addIncludeFilter(this.escapeZunitFilter(zunitFilter));
                                }
                                catch (CCResultsFilter.FilterFormatException e) {
                                    this.logFilterMsg(this.fImportResult, "ACRRDG7273W", e.getFilter());
                                    if (e.getRegexError().isEmpty()) break block19;
                                    CCUtilities.log(e.getRegexError());
                                }
                            }
                        }
                        try {
                            if (params.getFilterList() != null) {
                                this.fResultFilter.load(params.getFilterList());
                                this.logFilterMsg(this.fImportResult, "ACRRDG7276I", params.getFilterList());
                            }
                        }
                        catch (FileNotFoundException e1) {
                            this.logFilterMsg(this.fImportResult, "ACRRDG7274W", params.getFilterList());
                        }
                        catch (CCResultsFilter.FilterFormatException e2) {
                            String[] fields = new String[]{e2.getFilter(), String.valueOf(e2.getLineNumber()), e2.getFilename()};
                            this.logFilterMsg(this.fImportResult, "ACRRDG7275W", fields);
                            if (e2.getRegexError().isEmpty()) break block20;
                            CCUtilities.log(e2.getRegexError());
                        }
                    }
                    if ((filters = params.getFilter()) != null && !filters.isEmpty()) {
                        String[] stringArray = filters.split(",");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            block21: {
                                String filter = stringArray[n2];
                                try {
                                    this.fResultFilter.addFilter(filter);
                                }
                                catch (CCResultsFilter.FilterFormatException e) {
                                    this.logFilterMsg(this.fImportResult, "ACRRDG7273W", e.getFilter());
                                    if (e.getRegexError().isEmpty()) break block21;
                                    CCUtilities.log(e.getRegexError());
                                }
                            }
                            ++n2;
                        }
                    }
                }
            }
        }
    }

    private void logFilterMsg(ICCImportResult result, String msgKey, String ... parms) {
        Object[] storedparms;
        if (this.fLoggedMessages == null) {
            this.fLoggedMessages = new HashMap<String, String[]>();
        }
        if ((storedparms = this.fLoggedMessages.get(msgKey)) != null && Arrays.equals(parms, storedparms)) {
            return;
        }
        this.fLoggedMessages.put(msgKey, parms);
        this.fImportResult.addMessage(msgKey, parms);
        if (!this.isZunit() || CCUtilities.TRACE_ON) {
            CCUtilities.log(CCMessageUtilities.getMessage((String)msgKey, (String[])parms));
        }
    }

    private static int getPartCount() {
        return fPartNameCount++;
    }

    public String getId() {
        return this.fId;
    }

    public void setDebugTarget(IPDTDebugTarget debugTarget) {
        this.fDebugTarget = debugTarget;
    }

    public IPDTDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public ICCImportModule add(Module module) {
        if (!this.acceptModule(module)) {
            this.logFilterMsg(this.fImportResult, "ACRRDG7270I", module.getName());
            return null;
        }
        ICCImportModule ccModule = null;
        try {
            ccModule = this.fImportResult.createModule(module.getName());
        }
        catch (CCDuplicateModuleException e) {
            if (this.fModulesByID.containsKey(module.getId())) {
                return e.getExistingModule();
            }
            ccModule = e.getExistingModule();
        }
        catch (CCImportException e) {
            CCUtilities.log(e);
        }
        if (CCUtilities.fLogging) {
            CCUtilities.log("ModuleCC :" + ccModule.getID() + " >" + ccModule.getName());
        }
        this.fModulesByID.put(module.getId(), ccModule);
        if (ccModule != null) {
            ccModule.setHit();
            if (module.hasDebugInfo()) {
                ccModule.setDebuggable();
            }
        }
        if (module.hasDebugInfo() && !this.isModuleLevel()) {
            module.addEventListener(this.getModuleEventListener());
        }
        return ccModule;
    }

    public ICCImportModule get(Module module) {
        return this.fModulesByID.get(module.getId());
    }

    public ICCImportPart add(Part part) throws CCImportException {
        ICCImportPart ccPart;
        ICCImportModule ccModule = this.get(part.getModule());
        if (ccModule == null) {
            return null;
        }
        if (!part.isDebuggable()) {
            return null;
        }
        if (!this.acceptPart(part)) {
            this.logFilterMsg(this.fImportResult, "ACRRDG7271I", part.getName());
            return null;
        }
        try {
            ccPart = ccModule.createPart(CCUtilities.rootName(part.getName()));
        }
        catch (CCDuplicatePartException e) {
            if (this.fPartsByID.containsKey(part.getId())) {
                throw e;
            }
            ccPart = e.getExistingPart();
        }
        this.fPartsByID.put(part.getId(), ccPart);
        ccPart.setDebuggable();
        ccPart.setLanguage(CCData.convertPartLanguage(part));
        part.addListener((IModelEventListener)this.getModuleEventListener());
        View view = null;
        if (this.getPreferredViewInfo() != null) {
            view = part.getView(this.getPreferredViewInfo());
        }
        if (view == null) {
            view = part.getView(this.getViewInfo());
        }
        if (view != null) {
            part.setCurrentView(view);
            ViewFile[] viewFiles = view.getViewFiles();
            boolean first = true;
            ViewFile[] viewFileArray = viewFiles;
            int n = viewFiles.length;
            int n2 = 0;
            while (n2 < n) {
                ViewFile viewFile = viewFileArray[n2];
                try {
                    this.add(viewFile, first);
                }
                catch (Exception e) {
                    ccPart.addMessage(NLS.bind((String)Messages.CRRDG7123, (Object)viewFile.getFileName()), new String[0]);
                    CCUtilities.log(4, String.format("File %s not processed due to error : %s", viewFile.getFileName(), e.getMessage()), e);
                }
                first = false;
                ++n2;
            }
        } else {
            ccPart.addMessage(NLS.bind((String)Messages.CRRDG7131, (Object)this.getDesiredCoverageView().toString()), new String[0]);
        }
        return ccPart;
    }

    public ICCImportPart getCCPart(Part part) {
        return this.fPartsByID.get(part.getId());
    }

    public ICCImportFile add(ViewFile viewFile, boolean first) throws EngineConnectionException {
        Part part = viewFile.getPart();
        ICCImportPart ccPart = this.getCCPart(part);
        if (ccPart == null) {
            return null;
        }
        if (viewFile.isDynamic() || viewFile.getFileName() == null) {
            return null;
        }
        String fileName = this.generateCCFileName(viewFile, ccPart, first);
        if (!this.acceptFile(viewFile, fileName)) {
            this.logFilterMsg(this.fImportResult, "ACRRDG7272I", fileName);
            return null;
        }
        ICCImportFile ccFile = null;
        try {
            ccFile = ccPart.createFile(fileName);
            this.fFilesByID.put(this.getUniqueId(viewFile), ccFile);
            ccFile.setEncoding("UTF-8");
            int language = fileName.endsWith(COPY_BOOK_FILE_EXTENSION) ? 96 : ccPart.getLanguage();
            ccFile.setLanguage(language);
            ccFile.setQualifiedName(this.getQualifiedName(ccPart, ccFile, viewFile, fileName));
            if (this.fSaveSource || ParserEntryPointUtils.isParserAvailable((ICCImportFile)ccFile)) {
                this.getSource(ccFile, viewFile);
            }
        }
        catch (CCFileExistsException fe) {
            ccFile = fe.getExistingFile();
            this.fFilesByID.put(this.getUniqueId(viewFile), ccFile);
        }
        catch (CCImportException e) {
            CCUtilities.log(e);
        }
        return ccFile;
    }

    private String getQualifiedName(ICCImportPart ccPart, ICCImportFile ccFile, ViewFile viewFile, String fileName) {
        Object qualifiedName = fileName;
        if (ccPart.getLanguage() == 6) {
            String viewFileName = viewFile.getFileName();
            if (viewFile.getEngineSession().isDebugTool() && !viewFile.getBaseFileName().equals(viewFile.getFileName())) {
                qualifiedName = viewFile.getFileName().contains(SLASH) ? new Path(viewFileName).removeLastSegments(1).append(fileName).toString() : viewFileName + SLASH + fileName;
            } else if (viewFile.getEngineSession().iszPICL()) {
                qualifiedName = viewFileName.replace(COLON, EMPTY);
            }
        }
        return qualifiedName;
    }

    private String getFileExtension(ViewFile viewFile, boolean useBaseFileName) {
        String[] extensions;
        int id = viewFile.getPart().getLanguage().getId();
        Path filePath = new Path(useBaseFileName ? viewFile.getBaseFileName() : viewFile.getFileName());
        String extension = filePath.getFileExtension();
        if (extension != null && !extension.isEmpty() && Language.getLangID((String)extension.toLowerCase()) == id) {
            return EMPTY;
        }
        String[] stringArray = extensions = viewFile.isIncludeFile() ? Language.getIncludeExtensions((int)id) : Language.getExtensions((int)id);
        if (extensions.length > 0) {
            return extensions[0];
        }
        return EMPTY;
    }

    public Breakpoint getBreakpoint(int id) {
        return this.fDebugTarget.getDebugEngine().getProcess().getBreakpoint(Integer.valueOf(id).intValue());
    }

    protected void setRunnable(ProcessStopInfo stopInfo) {
        this.fStopInfoQueue.add(stopInfo);
    }

    public ProcessStopInfo getRunnable() {
        return this.fStopInfoQueue.poll();
    }

    protected boolean isAsync() {
        return this.fAsync;
    }

    protected void setAsync(boolean async) {
        this.fAsync = async;
    }

    @Deprecated
    public void setCoverageView(ICCConstants.COVERAGE_VIEW coverageView) {
        switch (coverageView) {
            case LISTING: {
                this.setDesiredCoverageView(ICCCoreConstants.DESIRED_COVERAGE_VIEW.LISTING_ONLY);
                break;
            }
            default: {
                this.setDesiredCoverageView(ICCCoreConstants.DESIRED_COVERAGE_VIEW.DEFAULT);
            }
        }
    }

    public void setDesiredCoverageView(ICCCoreConstants.DESIRED_COVERAGE_VIEW coverageView) {
        this.fCoverageView = coverageView;
    }

    @Deprecated
    public ICCConstants.COVERAGE_VIEW getCoverageView() {
        switch (this.fCoverageView) {
            case LISTING_ONLY: {
                return ICCConstants.COVERAGE_VIEW.LISTING;
            }
        }
        return ICCConstants.COVERAGE_VIEW.SOURCE;
    }

    public ICCCoreConstants.DESIRED_COVERAGE_VIEW getDesiredCoverageView() {
        return this.fCoverageView;
    }

    public ViewInformation getViewInfo() {
        return this.fViewInfo;
    }

    public String getPgmName() {
        return this.fPgmName;
    }

    public String getPgmParms() {
        return this.fParams.getPgmParms();
    }

    public void setPgmName(String pgmName) {
        if (this.fParams.isPgmNameOverride()) {
            this.fPgmName = pgmName;
        }
    }

    public void initialize(DebugEngine debugEngine) {
        this.fSession = debugEngine.getEngineSession();
        this.setDesiredCoverageView(this.getDesiredCoverageView());
        this.initializeView(debugEngine);
        this.fEngineVersion = this.fSession.getEngineVersionString();
        this.fPluginVersion = Platform.getBundle((String)"com.ibm.debug.pdt.codecoverage.core").getVersion().toString();
        CCData.loadModuleFilterGlobal();
        String moduleExclude = this.fParams.getProperty("Imodulefilter", EMPTY);
        CCData.loadFilterParm(moduleExclude, this.fModuleExcludeInstance);
    }

    private void initializeView(DebugEngine debugEngine) {
        this.fViewInfo = debugEngine.getViewInformation((short)1);
        ViewInformation viewInfo = null;
        switch (this.fCoverageView) {
            case SOURCE_ONLY: {
                viewInfo = debugEngine.getSourceViewInformation();
                break;
            }
            case LISTING_ONLY: {
                viewInfo = debugEngine.getListingViewInformation();
                break;
            }
            case SOURCE_LISTING: {
                viewInfo = debugEngine.getListingViewInformation();
                this.fPreferredViewInfo = debugEngine.getSourceViewInformation();
                break;
            }
            case DEFAULT: {
                if (this.fViewInfo.equals(debugEngine.getSourceViewInformation())) {
                    this.fPreferredViewInfo = this.fViewInfo;
                    viewInfo = debugEngine.getListingViewInformation();
                    break;
                }
                if (!this.fViewInfo.equals(debugEngine.getListingViewInformation())) break;
                this.fPreferredViewInfo = this.fViewInfo;
                viewInfo = debugEngine.getSourceViewInformation();
                break;
            }
        }
        if (viewInfo != null) {
            this.fViewInfo = viewInfo;
        } else if (this.fCoverageView != ICCCoreConstants.DESIRED_COVERAGE_VIEW.DEFAULT) {
            CCUtilities.log("View " + String.valueOf((Object)this.fCoverageView) + " is not available, using default");
        }
    }

    private static void loadModuleFilterGlobal() {
        IConfigurationElement[] elements;
        if (fModuleExcludeLoaded) {
            return;
        }
        IExtensionPoint extensionPoint = RegistryFactory.getRegistry().getExtensionPoint("com.ibm.debug.pdt.codecoverage.core.codeCoverageModuleFilter");
        IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IContributor contributor;
            Bundle bundle;
            URL fileURL;
            IConfigurationElement element = iConfigurationElementArray[n2];
            String filterFileName = element.getAttribute("excludefileName");
            if (filterFileName != null && !filterFileName.isEmpty() && (fileURL = FileLocator.find((Bundle)(bundle = Platform.getBundle((String)(contributor = element.getContributor()).getName())), (IPath)new Path(filterFileName), null)) != null) {
                try {
                    InputStream in = fileURL.openStream();
                    String codepage = CCParams.isZos() ? "IBM-1047" : Charset.defaultCharset().name();
                    CCData.loadFilter(new InputStreamReader(in, codepage), fModuleExcludeGlobal);
                }
                catch (IOException e) {
                    CCUtilities.log(e);
                }
            }
            ++n2;
        }
        fModuleExcludeLoaded = true;
    }

    private static void loadFilter(Reader filter, ArrayList<Pattern> filterList) throws IOException {
        BufferedReader br = new BufferedReader(filter);
        while (br.ready()) {
            String line = br.readLine();
            if (line == null) break;
            try {
                filterList.add(Pattern.compile(line));
            }
            catch (PatternSyntaxException e) {
                CCUtilities.log(e);
            }
        }
        filter.close();
    }

    private static void loadFilterParm(String filterParm, ArrayList<Pattern> filterList) {
        String[] filters;
        String[] stringArray = filters = filterParm.split(",");
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            StringReader stringReader = new StringReader(filter);
            try {
                CCData.loadFilter(stringReader, filterList);
            }
            catch (IOException e) {
                CCUtilities.log(e);
            }
            ++n2;
        }
    }

    private boolean isModuleIncluded(String moduleName) {
        Matcher m;
        if (!this.fModuleIncludeInstance.isEmpty()) {
            for (Pattern filter : this.fModuleIncludeInstance) {
                Matcher m2 = filter.matcher(moduleName);
                if (!m2.matches()) continue;
                if (!this.isZunit() || CCUtilities.TRACE_ON) {
                    CCUtilities.log(NLS.bind((String)Messages.CRRDG7044, (Object)moduleName));
                }
                return true;
            }
            if (!this.isZunit() || CCUtilities.TRACE_ON) {
                CCUtilities.log(NLS.bind((String)Messages.CRRDG7040, (Object)moduleName));
            }
            return false;
        }
        for (Pattern filter : this.fModuleExcludeInstance) {
            m = filter.matcher(moduleName);
            if (!m.matches()) continue;
            CCUtilities.log(NLS.bind((String)Messages.CRRDG7040, (Object)moduleName));
            return false;
        }
        for (Pattern filter : fModuleExcludeGlobal) {
            m = filter.matcher(moduleName);
            if (!m.matches()) continue;
            CCUtilities.log(NLS.bind((String)Messages.CRRDG7040, (Object)moduleName));
            return false;
        }
        return true;
    }

    public boolean supportsEnhancedCC() {
        return true;
    }

    public EPDC_EngineSession getEngineSession() {
        return this.fSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPath getResultsPath(boolean create) {
        Object object = this.fPathLock;
        synchronized (object) {
            if (this.fResultsPath == null) {
                if (this.isForcedOutputDir()) {
                    this.fResultsPath = this.getOutputDir();
                } else {
                    Path resultsPath = new Path(this.getResultsName());
                    this.fResultsPath = this.getOutputDir().append((IPath)resultsPath);
                }
            }
            if (create) {
                this.mkPath(this.fResultsPath);
            }
        }
        return this.fResultsPath;
    }

    public IPath getOutputDir() {
        return this.fParams.getOutputDir();
    }

    public String getResultsName() {
        if (!this.fResultsNameInit) {
            Path pgmName = new Path(this.getPgmName());
            StringBuilder resultsDir = new StringBuilder(pgmName.lastSegment());
            if (this.isTimeStamps()) {
                resultsDir.append('_');
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy_MM_dd_HHmmss_SSSS");
                String dateString = dateFormat.format(new Date(System.currentTimeMillis()));
                resultsDir.append(dateString);
            }
            this.fImportResult.setName(resultsDir.toString());
            this.fResultsNameInit = true;
        }
        return this.fImportResult.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFolder getSourceFolder() throws CoreException {
        Object object = this.fPathLock;
        synchronized (object) {
            if (this.fSourceFolder == null) {
                IWorkspace ws = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot wsRoot = ws.getRoot();
                IProject project = wsRoot.getProject("sourceProject");
                if (!project.exists()) {
                    project.create(null);
                    project.open(null);
                }
                this.fSourceFolder = project.getFolder(this.getResultsName());
                if (this.isSaveSource()) {
                    try {
                        this.fSourcePath = new Path(Files.createTempDirectory(this.getResultsName(), new FileAttribute[0]).toFile().getAbsolutePath());
                        this.mkPath(this.fSourcePath);
                        this.fSourcePath.toFile().deleteOnExit();
                        this.fSourceFolder.createLink(this.fSourcePath, 0, null);
                    }
                    catch (IOException e) {
                        CCUtilities.log(e);
                    }
                } else {
                    if (!this.fSourceFolder.exists()) {
                        this.fSourceFolder.create(false, true, null);
                    }
                    this.fSourcePath = this.fSourceFolder.getLocation();
                }
            }
        }
        return this.fSourceFolder;
    }

    protected void mkPath(IPath path) {
        try {
            Files.createDirectories(path.toFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            CCUtilities.log(e);
        }
    }

    public boolean isLineLevel() {
        return this.fLevel.equals((Object)ICCConstants.COVERAGE_LEVEL.LINE);
    }

    public boolean isFunctionLevel() {
        return this.fLevel.equals((Object)ICCConstants.COVERAGE_LEVEL.FUNCTION);
    }

    public boolean isModuleLevel() {
        return this.fLevel.equals((Object)ICCConstants.COVERAGE_LEVEL.MODULE);
    }

    public boolean isTimeStamps() {
        return this.fParams.isTimeStamps();
    }

    public boolean isIgnoreError() {
        return this.fParams.isIgnoreError();
    }

    public boolean isSaveSource() {
        return this.fSaveSource;
    }

    public void initTimer() {
        this.fElapsedTime = this.fStartTime = System.currentTimeMillis();
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void setTerminated(boolean terminated) {
        this.fTerminated = terminated;
    }

    public boolean isDT() {
        return this.fSession.isDebugTool();
    }

    public boolean isZosUnix(String file) {
        return file.contains(SLASH);
    }

    public ICCConstants.COVERAGE_LEVEL getLevel() {
        return this.fLevel;
    }

    public String getUniquePartName(String partName) {
        String rootPartName = CCUtilities.rootName(partName);
        boolean unique = this.fPartNames.add(rootPartName);
        if (unique) {
            return partName;
        }
        StringBuilder tempName = new StringBuilder(partName);
        tempName.append("____");
        tempName.append(CCData.getPartCount());
        this.fPartNames.add(CCUtilities.rootName(tempName.toString()));
        if (CCUtilities.fLogging) {
            CCUtilities.log(String.format("Original part name %s / Unique part name %s", partName, tempName));
        }
        return tempName.toString();
    }

    public boolean isSessionError() {
        return this.fSessionError;
    }

    public void setSessionError() {
        this.fSessionError = true;
    }

    public void setSessionMessage(String message) {
        this.fSessionErrorMsg = message;
    }

    public String getSessionMessage() {
        return this.fSessionErrorMsg;
    }

    public boolean isAttach() {
        String value = this.fParams.getProperty("attach", "false");
        return Boolean.parseBoolean(value);
    }

    public boolean isWaitingForLaunch() {
        String value = this.fParams.getProperty("headless", "false");
        return !Boolean.parseBoolean(value);
    }

    public String getProcessPath() {
        return this.fParams.getProperty("processPath");
    }

    public String getProcessId() {
        return this.fParams.getProperty("processId");
    }

    public byte getLanguage() {
        String value = this.fParams.getProperty("language", String.valueOf(1));
        return Byte.parseByte(value, 16);
    }

    public String getStartupCommands() {
        return this.fParams.getStartupCommands();
    }

    public String getTestCase() {
        return this.fParams.getTestCase();
    }

    public String getTag() {
        return this.fParams.getTag();
    }

    public boolean isDeleteResultsDir() {
        return !this.isForcedOutputDir();
    }

    public boolean isForcedOutputDir() {
        return this.fParams.isForcedOutputDir();
    }

    public int getTimeout() {
        return this.fTimeout;
    }

    public boolean isISeries() {
        return this.fIsISeries;
    }

    public void setISeries(boolean flag) {
        this.fIsISeries = flag;
    }

    public IModuleEventListener getModuleEventListener() {
        return this.fModuleEventListener;
    }

    public boolean isSessionEndingRC(int rc) {
        return Arrays.binarySearch(this.fSessionEndingRC, rc) >= 0;
    }

    @Deprecated
    public boolean isGenerateHTMLReport() {
        return this.fParams.getProperty("ccGenerateHtml", false);
    }

    @Deprecated
    public boolean isGeneratePDFReport() {
        if (this.fParams.getProperty("ccGeneratePDF", false)) {
            return true;
        }
        String exporters = this.fParams.getProperty("exportertype", null);
        if (exporters != null) {
            HashSet<String> exporterSet = new HashSet<String>(Arrays.asList(exporters.split(",")));
            return exporterSet.contains("CCPDF") || exporterSet.contains("PDF");
        }
        return false;
    }

    public String getCCPropertiesFilePath() {
        IPath outputPath = this.getResultsPath(true);
        IPath filePath = outputPath.append("." + this.getResultsName()).addFileExtension(".properties");
        return filePath.toOSString();
    }

    public CCTimingLog getTimingLog() {
        if (this.fTimingLog == null) {
            this.fTimingLog = new CCTimingLog();
        }
        return this.fTimingLog;
    }

    public long getElapsedTime() {
        return this.fParams.containsKey("elapsedTime") ? Long.parseLong(this.fParams.getProperty("elapsedTime")) : 0L;
    }

    public String getEngineVersion() {
        return this.fEngineVersion;
    }

    public String getPluginVersion() {
        return this.fPluginVersion;
    }

    public ViewInformation getPreferredViewInfo() {
        return this.fPreferredViewInfo;
    }

    public boolean isExporterType() {
        return this.fParams.isExporterType();
    }

    public String getExporterType() {
        return this.fParams.getExporterType();
    }

    public String[] getExporterTypes() throws CCParams.CCParseException {
        return CCParams.validateExporterType(this.getExporterType());
    }

    public int getTestCaseID() {
        if (this.fTestCase == null) {
            try {
                String name = this.getTestCase();
                if (name.isEmpty()) {
                    name = this.getResultsName();
                    this.fImportResult.addMessage("ACRRDG7202W", new String[]{name});
                }
                this.fTestCase = this.fImportResult.createTestcase(name, this.getDebugTarget().getDebugEngine().getEngineSession().getEngineHardwareString());
                this.fTestCaseID = this.fTestCase.getID();
                this.fTestCase.setStartTime(this.fStartTime);
                this.fTestCase.setTag(this.getTag());
                this.fTestCase.setLevel(this.getLevel());
                this.fTestCase.setEngineKey(this.getDebugTarget().getDebugEngine().getUniqueEngineKey());
                this.fTestCase.setProperty("pluginVersion", (Object)this.getPluginVersion());
                this.fTestCase.setProperty("engineVersion", (Object)this.getEngineVersion());
                this.fImportResult.setProperty("pluginVersion", (Object)this.getPluginVersion());
                this.fImportResult.setProperty("engineVersion", (Object)this.getEngineVersion());
            }
            catch (CCImportException cCImportException) {
                // empty catch block
            }
        }
        return this.fTestCaseID;
    }

    public void updateTestcaseElapsedTime() {
        if (this.fTestCase != null) {
            this.fTestCase.setElapsedTime(System.currentTimeMillis() - this.fStartTime);
        }
    }

    public static final int convertPartLanguage(Part part) {
        return part.getLanguage().getId();
    }

    public ICCImportResult getResults() {
        return this.fImportResult;
    }

    private void getSource(ICCImportFile ccFile, ViewFile viewFile) {
        File sourceFile;
        try {
            if (!viewFile.verify()) {
                ccFile.addMessage(NLS.bind((String)Messages.CRRDG7117, (Object)ccFile.getName()), new String[0]);
                return;
            }
        }
        catch (EngineConnectionException engineConnectionException) {
            // empty catch block
        }
        String fileName = ccFile.getQualifiedName();
        if (new File(fileName).toString().startsWith(File.separator)) {
            fileName = new File(fileName).toString().substring(File.separator.length());
        }
        if (!(sourceFile = this.getTempSourceDir().resolve(new File(fileName).toPath()).toFile()).getParentFile().exists() && !sourceFile.getParentFile().mkdirs()) {
            CCUtilities.log("Unable to create directory:" + sourceFile.getParent());
        }
        BufferedOutputStream bfos = null;
        try {
            bfos = new BufferedOutputStream(new FileOutputStream(sourceFile));
        }
        catch (FileNotFoundException e1) {
            CCUtilities.log(e1);
            return;
        }
        DebugEngine dbgEngine = this.getDebugTarget().getDebugEngine();
        short viewId = viewFile.getPart().getCurrentView().getId();
        EReqGetFile request = new EReqGetFile(viewFile.getPart().getId(), (int)viewId, viewFile.getId(), 0, this.getEngineSession());
        try {
            ERepGetFile reply;
            do {
                block24: {
                    if ((reply = (ERepGetFile)dbgEngine.processRequest((EPDC_Request)request)).isCompressed()) {
                        Throwable throwable = null;
                        Object var11_16 = null;
                        try (InflaterInputStream iis = new InflaterInputStream(new ByteArrayInputStream(reply.getContent()));){
                            while (iis.available() == 1) {
                                bfos.write(iis.read());
                            }
                            break block24;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    bfos.write(reply.getContent());
                }
                request.setStartPosn(reply.getCurrentPosn());
            } while (!reply.isEOF());
            bfos.close();
            ccFile.setFile(sourceFile);
            ccFile.setSourceAvailable(true);
        }
        catch (EngineRequestErrorException e) {
            int returnCode = e.getReply().getReturnCode();
            if (returnCode == 7) {
                ccFile.addMessage(NLS.bind((String)Messages.CRRDG7117, (Object)ccFile.getName()), new String[0]);
            } else {
                CCUtilities.log(e);
            }
        }
        catch (EngineRequestException | IOException e) {
            CCUtilities.log(e);
        }
        this.checkForSequenceNumbers(ccFile, sourceFile);
    }

    java.nio.file.Path getTempSourceDir() {
        if (this.fTempSourceDir == null) {
            try {
                this.fTempSourceDir = Files.createTempDirectory(this.getResultsName(), new FileAttribute[0]);
            }
            catch (IOException e) {
                CCUtilities.log(e);
            }
        }
        return this.fTempSourceDir;
    }

    private String getUniqueId(ViewFile viewFile) {
        StringBuilder sb = new StringBuilder();
        sb.append(viewFile.getPart().getId());
        sb.append('.');
        sb.append(viewFile.getView().getId());
        sb.append('.');
        sb.append(viewFile.getId());
        return sb.toString();
    }

    public ICCImportFile getCCFile(EStdNumberList numList) {
        return this.fFilesByID.get(this.getUniqueId(numList));
    }

    private String getUniqueId(EStdNumberList numList) {
        StringBuilder sb = new StringBuilder();
        sb.append(numList.getPartId());
        sb.append('.');
        if (this.isDT() && numList.getViewId() == 0) {
            sb.append(1);
        } else {
            sb.append(numList.getViewId());
        }
        sb.append('.');
        sb.append(numList.getViewFileId());
        return sb.toString();
    }

    public ICCImportFile getCCFile(EStdFileFlowPoints fileFlowPoints) {
        return this.fFilesByID.get(this.getUniqueId(fileFlowPoints));
    }

    private String getUniqueId(EStdFileFlowPoints fileFlowPoints) {
        StringBuilder sb = new StringBuilder();
        sb.append(fileFlowPoints.getPartId());
        sb.append('.');
        if (this.isDT() && fileFlowPoints.getViewId() == 0) {
            sb.append(1);
        } else {
            sb.append(fileFlowPoints.getViewId());
        }
        sb.append('.');
        sb.append(fileFlowPoints.getViewFileId());
        return sb.toString();
    }

    public ICCImportFile getCCFile(ViewFile viewFile) {
        return this.fFilesByID.get(this.getUniqueId(viewFile));
    }

    public List<java.nio.file.Path> getPathsToDelete() {
        ArrayList<java.nio.file.Path> paths = new ArrayList<java.nio.file.Path>();
        paths.add(this.fTempSourceDir);
        return paths;
    }

    private String generateCCFileName(ViewFile viewFile, ICCImportPart ccPart, boolean first) {
        String extension = this.isDT() && this.isZosUnix(viewFile.getFileName()) ? EMPTY : this.getFileExtension(viewFile, false);
        Object fileName = viewFile.getFileName() + extension;
        if (viewFile.getEngineSession().isiSeriesEngine()) {
            return this.generateISeriesCCFileName(viewFile);
        }
        if (ccPart.getLanguage() == 6) {
            if (viewFile.getEngineSession().isDebugTool()) {
                if (!(first || extension.isEmpty() || viewFile.isIncludeFile())) {
                    extension = COPY_BOOK_FILE_EXTENSION;
                }
                fileName = !viewFile.getBaseFileName().equals(viewFile.getFileName()) ? (this.isZosUnix((String)fileName) ? new Path((String)fileName).lastSegment() : viewFile.getBaseFileName() + extension) : viewFile.getFileName() + extension;
            } else if (viewFile.getEngineSession().iszPICL()) {
                fileName = viewFile.getBaseFileName().replace(COLON, EMPTY) + this.getFileExtension(viewFile, true);
            }
        }
        return fileName;
    }

    private String generateISeriesCCFileName(ViewFile viewFile) {
        int index2;
        String qualifiedName = viewFile.getFileName();
        StringBuilder builder = new StringBuilder();
        int index1 = qualifiedName.indexOf(47);
        if (index1 > 0) {
            builder.append(qualifiedName.substring(0, index1));
            builder.append(".LIB/");
        }
        if ((index2 = qualifiedName.indexOf(40, index1 + 1)) > 0) {
            int index3 = qualifiedName.indexOf(41, index2 + 1);
            if (index3 > 0) {
                builder.append(qualifiedName.substring(index1 + 1, index2));
                builder.append(".FILE/");
                builder.append(qualifiedName.substring(index2 + 1, index3));
            } else {
                builder.append(qualifiedName.substring(index1 + 1));
            }
        } else {
            builder.append(qualifiedName.substring(index1 + 1));
        }
        return builder.toString();
    }

    public ICCImportPart partChanged(Part part) {
        View currentView;
        ICCImportPart ccPart = this.fPartsByID.get(part.getId());
        String newPartName = CCUtilities.rootName(part.getName());
        if (!ccPart.getName().equals(newPartName)) {
            ccPart.setName(newPartName);
        }
        if ((currentView = part.getCurrentView()) != null) {
            ViewFile[] viewFiles = currentView.getViewFiles();
            boolean first = true;
            ViewFile[] viewFileArray = viewFiles;
            int n = viewFiles.length;
            int n2 = 0;
            while (n2 < n) {
                ViewFile viewFile = viewFileArray[n2];
                ICCImportFile ccFile = this.fFilesByID.get(this.getUniqueId(viewFile));
                if (ccFile != null) {
                    String newCCFileName = this.generateCCFileName(viewFile, ccPart, first);
                    if (!ccFile.getName().equals(newCCFileName)) {
                        ccFile.setName(newCCFileName);
                        if (newCCFileName.endsWith(COPY_BOOK_FILE_EXTENSION)) {
                            ccFile.setLanguage(96);
                        }
                        if (this.fSaveSource || ParserEntryPointUtils.isParserAvailable((ICCImportFile)ccFile)) {
                            this.getSource(ccFile, viewFile);
                        }
                    }
                    String newQualifiedName = this.getQualifiedName(ccPart, ccFile, viewFile, newCCFileName);
                    if (!ccFile.getQualifiedName().equals(newQualifiedName)) {
                        ccFile.setQualifiedName(newQualifiedName);
                        if (this.fSaveSource || ParserEntryPointUtils.isParserAvailable((ICCImportFile)ccFile)) {
                            this.getSource(ccFile, viewFile);
                        }
                    }
                } else {
                    try {
                        this.add(viewFile, first);
                    }
                    catch (Exception e) {
                        ccPart.addMessage(NLS.bind((String)Messages.CRRDG7123, (Object)viewFile.getFileName()), new String[0]);
                        CCUtilities.log(4, String.format("File %s not processed due to error : %s", viewFile.getFileName(), e.getMessage()), e);
                    }
                }
                first = false;
                ++n2;
            }
        }
        return ccPart;
    }

    private boolean acceptModule(Module module) {
        this.initFilterSupport(this.fParams);
        if (this.fResultFilter == null) {
            return this.isModuleIncluded(module.getName());
        }
        return this.fResultFilter.acceptModule(module.getName());
    }

    private boolean acceptPart(Part part) {
        this.initFilterSupport(this.fParams);
        if (this.fResultFilter == null) {
            return true;
        }
        return this.fResultFilter.acceptPart(part.getModule().getName(), part.getName());
    }

    private boolean acceptFile(ViewFile viewFile, String name) {
        this.initFilterSupport(this.fParams);
        if (this.fResultFilter == null) {
            return true;
        }
        Part part = viewFile.getPart();
        return this.fResultFilter.acceptFile(part.getModule().getName(), part.getName(), name);
    }

    public CCResultsFilter getResultsFilter() {
        return this.fResultFilter;
    }

    public java.nio.file.Path getResultsFilterLog() {
        return this.fResultFilterLog;
    }

    private final void checkForSequenceNumbers(ICCImportFile ccFile, File sourceFile) {
        if (this.getDebugTarget().getDebugEngine().getEngineSession().is390()) {
            boolean sequenceNumberFound = true;
            int seqLocation = 0;
            int prevLineLength = -1;
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sourceFile), "UTF-8"));){
                    int i = 10;
                    while (i > 0 && sequenceNumberFound) {
                        String line = reader.readLine();
                        if (line == null) {
                            sequenceNumberFound = false;
                            break;
                        }
                        if (prevLineLength > 0 && prevLineLength != line.length()) {
                            sequenceNumberFound = false;
                            break;
                        }
                        boolean bl = sequenceNumberFound = line.length() > 71 && line.matches(".*[\\d8]$");
                        if (sequenceNumberFound) {
                            if (seqLocation > 0) {
                                sequenceNumberFound = line.length() - 8 == seqLocation;
                            } else {
                                seqLocation = line.length() - 8;
                            }
                        }
                        --i;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                CCUtilities.log(e);
            }
            if (sequenceNumberFound) {
                ccFile.setProperty("srcStartIndex", (Object)0);
                ccFile.setProperty("srcEndIndex", (Object)seqLocation);
            }
        }
    }

    public void setUser(String user) {
        String string = this.fUser = this.isUppercaseUser() ? this.uppercaseUser(user) : user;
        if (this.fUser == null) {
            return;
        }
        if (this.isUserPathNeeded()) {
            IPath p = this.getOutputDir();
            p = p.append(this.fUser);
            this.fParams.setProperty("allowoutputlocation", true);
            this.fParams.setProperty("output", p.toString());
            this.fParams.setProperty("allowoutputlocation", false);
            if (!p.toFile().exists()) {
                try {
                    Files.createDirectories(p.toFile().toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    CCUtilities.log(e);
                    return;
                }
                if (p.toFile().exists() && this.isOwnershipPermissionsNeeded()) {
                    try {
                        PosixFileAttributes attrs = Files.getFileAttributeView(p.toFile().getParentFile().toPath(), PosixFileAttributeView.class, new LinkOption[0]).readAttributes();
                        Files.setPosixFilePermissions(p.toFile().toPath(), attrs.permissions());
                    }
                    catch (IOException e) {
                        CCUtilities.log(4, "Unable to configure permissions:" + String.valueOf(p), e);
                    }
                    try {
                        FileSystem fileSystem = p.toFile().toPath().getFileSystem();
                        UserPrincipalLookupService service = fileSystem.getUserPrincipalLookupService();
                        UserPrincipal userPrincipal = service.lookupPrincipalByName(this.fUser);
                        Files.setOwner(p.toFile().toPath(), userPrincipal);
                    }
                    catch (IOException e) {
                        CCUtilities.log(4, "Unable to configure CC ownership of dir:" + String.valueOf(p), e);
                    }
                }
            }
        }
    }

    public String getUser() {
        return this.fUser;
    }

    protected boolean isOwnershipPermissionsNeeded() {
        return false;
    }

    protected boolean isUppercaseUser() {
        return CCParams.isZos();
    }

    protected boolean isUserPathNeeded() {
        return this.fParams.isUserPathNeeded();
    }

    protected String uppercaseUser(String user) {
        return this.uppercaseZosUserID(user);
    }

    private String uppercaseZosUserID(String user) {
        if (user == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(user);
        int i = 0;
        while (i < sb.length()) {
            if (String.valueOf(sb.charAt(i)).matches(UPPERCASE_LETTERS_REGEX)) {
                sb.replace(i, i + 1, (EMPTY + sb.charAt(i)).toUpperCase(Locale.getDefault()));
            }
            ++i;
        }
        return sb.toString();
    }

    public String getExportEncoding() {
        return this.fParams.getProperty("exportencoding", "UTF-8");
    }

    public boolean isZunit() {
        return !this.fParams.getProperty("zunit", EMPTY).trim().isEmpty();
    }

    public String getZunitModule() {
        if (this.fParams.containsKey("zunit")) {
            return this.fParams.getProperty("zunit", null).split(COLON)[0];
        }
        return null;
    }

    public String getZunitCSECT() {
        if (this.fParams.containsKey("zunit")) {
            String[] zunit = this.fParams.getProperty("zunit", null).split(COLON);
            if (zunit.length == 2 && !zunit[1].isEmpty()) {
                return zunit[1];
            }
            return zunit[0];
        }
        return null;
    }

    public String escapeZunitFilter(String zunit) {
        return zunit.replace("$", "\\$");
    }

    protected String getRoot() {
        return this.fParams.getProperty("root", null);
    }
}

