/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.remote;

import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.CLRemoteUtilities;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.RSECoveragePlugin;
import com.ibm.debug.pdt.codecoverage.internal.ui.view.rse.remote.RemoteResultUtilities;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IRemoteResultAdapter;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.IRemoteResultLocation;
import com.ibm.debug.pdt.codecoverage.ui.resultsview.ResultAdapter;
import java.io.File;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.Path;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

public class RemoteResultAdapter
extends ResultAdapter
implements IRemoteResultAdapter {
    private final IRemoteFile fRemotePath;
    private String fLocalPath = null;
    private boolean fIsInitialiazing = true;

    public RemoteResultAdapter(IRemoteFile remotePath) {
        super(remotePath.getAbsolutePathPlusConnection());
        this.fRemotePath = remotePath;
    }

    public void analyze(boolean useResultAPI) {
        if (!this.fIsInitialiazing) {
            super.analyze(useResultAPI);
        }
    }

    public String getSeparator() {
        return this.fRemotePath.getSeparator();
    }

    public String getLocalPath() {
        return this.fLocalPath;
    }

    public String getResultPath(boolean isLocal) {
        if (isLocal) {
            return this.fLocalPath;
        }
        return this.getResultPath();
    }

    public boolean exists() {
        return this.fRemotePath.exists();
    }

    protected void doAnalysis(boolean useResultAPI) {
        this.refreshLocalPath();
        if (this.fLocalPath == null) {
            return;
        }
        super.doAnalysis(useResultAPI);
    }

    public String getName() {
        Path path = new Path(this.fRemotePath.getName());
        return path.removeFileExtension().lastSegment();
    }

    public void cleanup(boolean deleteDataFiles) {
        super.cleanup(deleteDataFiles);
        if (deleteDataFiles) {
            RemoteResultUtilities.deleteRemoteFile(this.fRemotePath);
        }
    }

    public String rename(String newResultName) {
        File parent;
        File newFile;
        File localFolder;
        if (this.fLocalPath != null && (localFolder = new File(this.fLocalPath)).renameTo(newFile = new File(parent = localFolder.getParentFile(), newResultName))) {
            this.fLocalPath = newFile.getAbsolutePath();
        }
        this.setResult(null);
        IRemoteFileSubSystem subsystem = this.fRemotePath.getParentRemoteFileSubSystem();
        try {
            IRemoteFile[] subFiles;
            IRemoteFile[] iRemoteFileArray = subFiles = subsystem.list(this.fRemotePath, 1, null);
            int n = subFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IRemoteFile subFile = iRemoteFileArray[n2];
                if (subFile.getName().toLowerCase().endsWith(".clcoveragedata".toLowerCase())) {
                    subsystem.rename(subFile, newResultName + ".clcoveragedata", null);
                } else if (subFile.getName().toLowerCase().endsWith(".componentMap".toLowerCase())) {
                    subsystem.rename(subFile, newResultName + ".componentMap", null);
                } else if (subFile.getName().toLowerCase().endsWith(".metadata")) {
                    subsystem.rename(subFile, newResultName + ".metadata", null);
                }
                ++n2;
            }
            subsystem.rename(this.fRemotePath, newResultName, null);
            return null;
        }
        catch (SystemMessageException ex) {
            RSECoveragePlugin.log(ex);
            return ex.getSystemMessage().getLevelOneText();
        }
    }

    public IRemoteResultLocation getResultLocation() {
        return (IRemoteResultLocation)super.getResultLocation();
    }

    private void refreshLocalPath() {
        if (this.fLocalPath == null) {
            IFolder localFolder = CLRemoteUtilities.downloadFolder(this.fRemotePath);
            if (localFolder != null) {
                this.fLocalPath = localFolder.getLocation().toOSString();
            } else {
                return;
            }
        }
    }
}

