/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.daemon.internal.ui;

import com.ibm.debug.daemon.CoreDaemon;
import com.ibm.debug.daemon.internal.ui.DebugDaemonAction;
import com.ibm.debug.daemon.internal.ui.DebugDaemonPlugin;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DebugDaemonStartup
implements IStartup {
    private DebugDaemonAction fAction = null;
    private static final Object fLockObject = new Object();
    private static DebugDaemonStartup instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugDaemonStartup() {
        Object object = fLockObject;
        synchronized (object) {
            instance = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DebugDaemonStartup getInstance() {
        Object object = fLockObject;
        synchronized (object) {
            return instance;
        }
    }

    public DebugDaemonAction getAction() {
        return this.fAction;
    }

    public void earlyStartup() {
        CoreDaemon.addDaemonStatusChangeListener();
        if (DebugDaemonPlugin.getInstance().getStartupState()) {
            CoreDaemon.startListening(true);
        }
        if (DebugDaemonPlugin.getInstance().getStartupStateSecure()) {
            CoreDaemon.startListeningSecure(true);
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window != null) {
                    if (window.getActivePage() != null) {
                        DebugDaemonStartup.this.addAction(window.getActivePage());
                    }
                    window.addPageListener(new IPageListener(){

                        public void pageActivated(IWorkbenchPage page) {
                            if (page != null) {
                                DebugDaemonStartup.this.addAction(page);
                            }
                        }

                        public void pageClosed(IWorkbenchPage page) {
                        }

                        public void pageOpened(IWorkbenchPage page) {
                        }
                    });
                }
            }
        });
        workbench.addWindowListener(new IWindowListener(){

            public void windowActivated(IWorkbenchWindow window) {
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
            }

            public void windowOpened(IWorkbenchWindow window) {
                if (window.getActivePage() != null) {
                    DebugDaemonStartup.this.addAction(window.getActivePage());
                    window.addPageListener(new IPageListener(){

                        public void pageActivated(IWorkbenchPage page) {
                            if (page != null) {
                                DebugDaemonStartup.this.addAction(page);
                            }
                        }

                        public void pageClosed(IWorkbenchPage page) {
                        }

                        public void pageOpened(IWorkbenchPage page) {
                        }
                    });
                }
            }
        });
    }

    private boolean addAction(IWorkbenchPage page) {
        page.addPartListener(new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
                if (partRef.getId().equals("org.eclipse.debug.ui.DebugView") && partRef instanceof IViewReference) {
                    DebugDaemonStartup.this.addAction(((IViewReference)partRef).getView(true));
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }
        });
        IViewPart debugViewPart = page.findView("org.eclipse.debug.ui.DebugView");
        if (debugViewPart != null) {
            return this.addAction(debugViewPart);
        }
        return false;
    }

    private boolean addAction(IViewPart debugViewPart) {
        if (debugViewPart instanceof AbstractDebugView) {
            AbstractDebugView debugView = (AbstractDebugView)debugViewPart;
            if (this.fAction == null) {
                this.fAction = new DebugDaemonAction();
            }
            if (debugView.getViewSite().getActionBars().getToolBarManager().find(this.fAction.getId()) == null) {
                debugView.getViewSite().getActionBars().getToolBarManager().add((IAction)this.fAction);
                debugView.getViewSite().getActionBars().updateActionBars();
            }
            return true;
        }
        return false;
    }

    public static void updateButtonState(boolean isChecked) {
        if (DebugDaemonStartup.getInstance() != null && DebugDaemonStartup.getInstance().getAction() != null) {
            DebugDaemonStartup.getInstance().getAction().updateButtonState(isChecked);
        }
    }

    public static void updateButtonState() {
        if (DebugDaemonStartup.getInstance() != null && DebugDaemonStartup.getInstance().getAction() != null) {
            DebugDaemonStartup.getInstance().getAction().updateButtonState();
        }
    }

    public static void updateToolTipText() {
        if (DebugDaemonStartup.getInstance() != null && DebugDaemonStartup.getInstance().getAction() != null) {
            DebugDaemonStartup.getInstance().getAction().updateToolTipText();
        }
    }
}

