/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.daemon.internal.ui;

import com.ibm.debug.daemon.CoreDaemon;
import com.ibm.debug.daemon.internal.core.DaemonCore;
import com.ibm.debug.daemon.internal.core.DaemonLabels;
import com.ibm.debug.daemon.internal.core.DaemonMessages;
import com.ibm.debug.daemon.internal.ui.DaemonUtils;
import com.ibm.debug.daemon.internal.ui.DebugDaemonPlugin;
import com.ibm.debug.daemon.internal.ui.DebugDaemonStartup;
import com.ibm.debug.daemon.internal.ui.PortUtility;
import com.ibm.debug.daemon.internal.ui.PortValidator;
import java.io.FileInputStream;
import java.security.KeyStore;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class DebugDaemonPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button fPortEnable;
    private Text fPortField;
    private Button fPortSetDefaultButton;
    private Button fSecurePortEnable;
    private Text fSecurePortField;
    private Button fSecurePortSetDefaultButton;
    private Text fKeyStoreFileNameField;
    private Text fKeyStorePasswordField;
    private Button fKeyStoreFileNameBrowse;
    private DebugDaemonPlugin fDebugDaemonPlugin = DebugDaemonPlugin.getInstance();
    private String fOriginalPort = this.fDebugDaemonPlugin.getPortPreference();
    private String fOriginalSecurePort = this.fDebugDaemonPlugin.getSecurePortPreference();
    private String fKeyStoreFileName = this.fDebugDaemonPlugin.getKeyStoreFileName();
    private char[] fKeyStorePassword = this.fDebugDaemonPlugin.getKeyStorePassword(this.fKeyStoreFileName);
    private boolean fUIDaemonEnabled = this.fDebugDaemonPlugin.uiDaemonEnabled();
    private boolean fSecureDaemonEnabled = this.fDebugDaemonPlugin.secureDaemonEnabled();
    private Button fReuseSecureSettings;
    private Text fAuthKeyStoreFileNameField;
    private Button fAuthKeyStoreFileNameBrowse;
    private Text fAuthKeyStorePasswordField;
    private String fAuthKeyStoreFileName;
    private char[] fAuthKeyStorePassword;
    private boolean fReuseKeystore = this.fDebugDaemonPlugin.isReuseKeystore();

    public DebugDaemonPreferencePage() {
        super(DaemonLabels.DebugDaemonPreferencePage_label);
        this.fAuthKeyStoreFileName = this.fDebugDaemonPlugin.getAuthKeyStoreFileNamePref();
        this.fAuthKeyStorePassword = this.fDebugDaemonPlugin.getAuthKeyStorePasswordPref(this.fAuthKeyStoreFileName);
    }

    public void init(IWorkbench workbench) {
    }

    public Control createContents(Composite parent) {
        Composite compositeForBoth = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        compositeForBoth.setLayout((Layout)gl);
        this.createContentsUIPortGroup(compositeForBoth);
        this.installSeparator(compositeForBoth, 30);
        this.createContentsSSLGroup(compositeForBoth);
        if (DaemonCore.hasAuthenticators()) {
            this.installSeparator(compositeForBoth, 30);
            this.createContentForAuth(compositeForBoth);
        }
        this.fPortEnable.setSelection(this.fUIDaemonEnabled);
        this.fSecurePortEnable.setSelection(this.fSecureDaemonEnabled);
        this.setFieldEnablement();
        Dialog.applyDialogFont((Control)compositeForBoth);
        return compositeForBoth;
    }

    public void performDefaults() {
        IEclipsePreferences pref = ConfigurationScope.INSTANCE.getNode("com.ibm.debug.daemon");
        this.fPortEnable.setSelection(pref.getBoolean("UIDaemonEnabled", true));
        this.fSecurePortEnable.setSelection(pref.getBoolean("SecureDaemonEnabled", false));
        this.setFieldEnablement();
        this.fPortField.setText(pref.get("DaemonPort", "8001"));
        this.fSecurePortField.setText(pref.get("SecureDaemonPort", "8002"));
        this.fKeyStoreFileNameField.setText(pref.get("KeyStoreFile", ""));
        this.fKeyStorePasswordField.setText("");
        if (DaemonCore.hasAuthenticators()) {
            this.fReuseSecureSettings.setSelection(pref.getBoolean("ReuseKeyStoreFile", false));
            this.fAuthKeyStoreFileNameField.setText(pref.get("AuthKeyStoreFile", ""));
            this.fAuthKeyStorePasswordField.setText("");
        }
        super.performDefaults();
    }

    public boolean performOk() {
        String portString = this.fPortField.getText();
        Integer[] ports = PortUtility.getPorts((String)portString);
        if (this.fUIDaemonEnabled && ports == null) {
            return false;
        }
        String securePortString = this.fSecurePortField.getText();
        Integer[] securePorts = PortUtility.getPorts((String)securePortString);
        if (this.fSecureDaemonEnabled && securePorts == null) {
            return false;
        }
        this.fKeyStoreFileName = this.fKeyStoreFileNameField.getText();
        this.fKeyStorePassword = this.fKeyStorePasswordField.getText().toCharArray();
        if (this.fSecureDaemonEnabled && this.fKeyStoreFileNameField.getText().trim().length() <= 0) {
            return false;
        }
        if (DaemonCore.hasAuthenticators()) {
            this.fReuseKeystore = this.fReuseSecureSettings.getSelection();
            this.fAuthKeyStoreFileName = this.fAuthKeyStoreFileNameField.getText().trim();
            this.fAuthKeyStorePassword = this.fAuthKeyStorePasswordField.getText().toCharArray();
            if (this.fReuseKeystore && this.fSecureDaemonEnabled) {
                CoreDaemon.getInstance().setAuthenticatorKeystore(this.fKeyStoreFileName, this.fKeyStorePassword);
            } else if (!this.fReuseKeystore && !this.fAuthKeyStoreFileName.isEmpty()) {
                try {
                    Throwable throwable = null;
                    Object var6_9 = null;
                    try (FileInputStream fileInputStream = new FileInputStream(this.fAuthKeyStoreFileName);){
                        String ext = this.getFileExtension(this.fAuthKeyStoreFileName);
                        String type = ext.equals("jks") ? "JKS" : "PKCS12";
                        KeyStore keystore = KeyStore.getInstance(type);
                        keystore.load(fileInputStream, this.fAuthKeyStorePassword);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (RuntimeException e) {
                    this.setErrorMessage(DaemonMessages.CRRDG1138);
                    return false;
                }
                catch (Exception e) {
                    this.setErrorMessage(DaemonMessages.CRRDG1138);
                    return false;
                }
                CoreDaemon.getInstance().setAuthenticatorKeystore(this.fAuthKeyStoreFileName, this.fAuthKeyStorePassword);
            } else {
                CoreDaemon.getInstance().setAuthenticatorKeystore(null, null);
            }
        }
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("com.ibm.debug.daemon");
        pref.put("DaemonPort", portString);
        pref.put("SecureDaemonPort", securePortString);
        pref.putBoolean("UIDaemonEnabled", this.fUIDaemonEnabled);
        pref.putBoolean("SecureDaemonEnabled", this.fSecureDaemonEnabled);
        pref.put("KeyStoreFile", this.fKeyStoreFileName);
        pref.putBoolean("SecureDaemonEnabled", this.fSecureDaemonEnabled);
        pref.put("KeyStoreFile", this.fKeyStoreFileName);
        if (DaemonCore.hasAuthenticators()) {
            pref.putBoolean("ReuseKeyStoreFile", this.fReuseKeystore);
            pref.put("AuthKeyStoreFile", this.fAuthKeyStoreFileName);
        }
        try {
            pref.flush();
        }
        catch (BackingStoreException e) {
            DebugDaemonPlugin.log("Problem saving preferences", (Exception)((Object)e));
        }
        DaemonUtils.addPasswordToSecureStorage(DebugDaemonPlugin.getInstance().getSecurePreferences(), this.fKeyStorePassword, "keystore_password");
        if (DaemonCore.hasAuthenticators()) {
            DaemonUtils.addPasswordToSecureStorage(DebugDaemonPlugin.getInstance().getSecurePreferences(), this.fAuthKeyStorePassword, "auth_keystore_password");
        }
        if (CoreDaemon.isListening()) {
            if (!this.fUIDaemonEnabled) {
                CoreDaemon.stopListening();
            } else if (!PortUtility.containsPort((int)CoreDaemon.getCurrentPort(), (Integer[])ports)) {
                CoreDaemon.stopListening();
                if (!CoreDaemon.startListening(false)) {
                    DebugDaemonStartup.updateButtonState(false);
                    this.setErrorMessage(NLS.bind((String)DaemonMessages.CRRDG1118, (Object)portString));
                    return false;
                }
            }
        } else if (this.fUIDaemonEnabled && !PortUtility.chkPorts((String)portString)) {
            this.setErrorMessage(NLS.bind((String)DaemonMessages.CRRDG1118, (Object)portString));
            return false;
        }
        if (CoreDaemon.isListeningSecure()) {
            if (!this.fSecureDaemonEnabled) {
                CoreDaemon.stopListeningSecure();
            } else if (!PortUtility.containsPort((int)CoreDaemon.getCurrentPortSecure(), (Integer[])securePorts)) {
                CoreDaemon.stopListeningSecure();
                if (!CoreDaemon.startListeningSecure(false)) {
                    DebugDaemonStartup.updateButtonState(false);
                    this.setErrorMessage(CoreDaemon.getErrorMessage());
                    return false;
                }
            }
        } else if (this.fSecureDaemonEnabled && !PortUtility.chkPorts((String)securePortString)) {
            this.setErrorMessage(NLS.bind((String)DaemonMessages.CRRDG1118, (Object)securePortString));
            return false;
        }
        if (this.fUIDaemonEnabled && this.fSecureDaemonEnabled) {
            if (CoreDaemon.isListening() && !CoreDaemon.isListeningSecure()) {
                if (!CoreDaemon.startListeningSecure(false)) {
                    CoreDaemon.stopListening();
                    DebugDaemonStartup.updateButtonState(false);
                    this.setErrorMessage(CoreDaemon.getErrorMessage());
                    return false;
                }
            } else if (CoreDaemon.isListeningSecure() && !CoreDaemon.isListening() && !CoreDaemon.startListening(false)) {
                CoreDaemon.stopListeningSecure();
                DebugDaemonStartup.updateButtonState(false);
                this.setErrorMessage(NLS.bind((String)DaemonMessages.CRRDG1118, (Object)portString));
                return false;
            }
        }
        DebugDaemonStartup.updateToolTipText();
        DebugDaemonStartup.updateButtonState();
        return true;
    }

    private void installSeparator(Composite parent, int verticalSpacing) {
        Label separator = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.heightHint = verticalSpacing;
        separator.setLayoutData((Object)gridData);
    }

    private void setFieldEnablement() {
        this.fUIDaemonEnabled = this.fPortEnable.getSelection();
        this.fPortField.setEnabled(this.fUIDaemonEnabled);
        this.fPortSetDefaultButton.setEnabled(this.fUIDaemonEnabled);
        this.fSecureDaemonEnabled = this.fSecurePortEnable.getSelection();
        this.fSecurePortField.setEnabled(this.fSecureDaemonEnabled);
        this.fSecurePortSetDefaultButton.setEnabled(this.fSecureDaemonEnabled);
        this.fKeyStoreFileNameField.setEnabled(this.fSecureDaemonEnabled);
        this.fKeyStorePasswordField.setEnabled(this.fSecureDaemonEnabled);
        this.fKeyStoreFileNameBrowse.setEnabled(this.fSecureDaemonEnabled);
        if (DaemonCore.hasAuthenticators()) {
            this.fReuseSecureSettings.setEnabled(this.fSecureDaemonEnabled);
            this.fAuthKeyStoreFileNameField.setEnabled(!this.fSecureDaemonEnabled || !this.fReuseKeystore);
            this.fAuthKeyStoreFileNameBrowse.setEnabled(!this.fSecureDaemonEnabled || !this.fReuseKeystore);
            this.fAuthKeyStorePasswordField.setEnabled(!this.fSecureDaemonEnabled || !this.fReuseKeystore);
        }
    }

    private void checkValidUIPortField() {
        this.setErrorMessage(null);
        if (this.fPortEnable.getSelection()) {
            String portFieldText = this.fPortField.getText();
            String errorMsg = PortValidator.validate(portFieldText);
            if (errorMsg != null) {
                this.setValid(false);
                this.setErrorMessage(errorMsg);
            } else if (CoreDaemon.isListening() && PortUtility.containsPort((int)CoreDaemon.getCurrentPort(), (Integer[])PortUtility.getPorts((String)portFieldText))) {
                this.setValid(true);
            } else if (!PortUtility.chkPorts((String)this.fPortField.getText())) {
                this.setValid(false);
                this.setErrorMessage(NLS.bind((String)DaemonMessages.CRRDG1124, (Object)this.fPortField.getText()));
            } else {
                if (this.fUIDaemonEnabled && this.fSecureDaemonEnabled) {
                    errorMsg = PortValidator.portsConflict(portFieldText, this.fSecurePortField.getText());
                }
                if (errorMsg != null) {
                    errorMsg = DaemonMessages.CRRDG1132;
                    this.setValid(false);
                    this.setErrorMessage(errorMsg);
                    return;
                }
                this.setValid(true);
                this.setErrorMessage(null);
            }
        }
    }

    private void checkValidSecurePortField() {
        this.setErrorMessage(null);
        String securePortFieldText = this.fSecurePortField.getText();
        String errorMsg = PortValidator.validate(securePortFieldText);
        if (errorMsg != null) {
            this.setValid(false);
            this.setErrorMessage(errorMsg);
        } else if (CoreDaemon.isListeningSecure() && PortUtility.containsPort((int)CoreDaemon.getCurrentPortSecure(), (Integer[])PortUtility.getPorts((String)securePortFieldText))) {
            this.setValid(true);
            this.setErrorMessage(null);
        } else if (!PortUtility.chkPorts((String)this.fSecurePortField.getText())) {
            this.setValid(false);
            this.setErrorMessage(NLS.bind((String)DaemonMessages.CRRDG1124, (Object)this.fSecurePortField.getText()));
        } else {
            if (this.fUIDaemonEnabled && this.fSecureDaemonEnabled) {
                errorMsg = PortValidator.portsConflict(securePortFieldText, this.fPortField.getText());
            }
            if (errorMsg != null) {
                errorMsg = DaemonMessages.CRRDG1133;
                this.setValid(false);
                this.setErrorMessage(errorMsg);
                return;
            }
            if (this.fSecureDaemonEnabled && this.fKeyStoreFileNameField.getText().trim().length() <= 0) {
                errorMsg = DaemonMessages.CRRDG1114;
                this.setValid(false);
                this.setErrorMessage(errorMsg);
                return;
            }
            this.setValid(true);
            this.setErrorMessage(null);
        }
    }

    private boolean checkPortsEnablement() {
        if (this.fPortEnable.getSelection() || this.fSecurePortEnable.getSelection()) {
            return true;
        }
        String errorMsg = DaemonMessages.CRRDG1116;
        this.setValid(false);
        this.setErrorMessage(errorMsg);
        return false;
    }

    private void createContentsUIPortGroup(Composite compositeForBoth) {
        Group uiPortGroup = new Group(compositeForBoth, 0);
        GridData uiPortGridData = new GridData(768);
        uiPortGroup.setLayoutData((Object)uiPortGridData);
        GridLayout uiPortGroupGridLayout = new GridLayout();
        uiPortGroupGridLayout.numColumns = 1;
        uiPortGroup.setLayout((Layout)uiPortGroupGridLayout);
        Composite portEnableComposite = new Composite((Composite)uiPortGroup, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        portEnableComposite.setLayout((Layout)gl);
        portEnableComposite.setLayoutData((Object)new GridData(1808));
        this.fPortEnable = new Button(portEnableComposite, 32);
        this.fPortEnable.setText(DaemonLabels.DaemonPreferencePage_portLabel);
        this.fPortEnable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DebugDaemonPreferencePage.this.setFieldEnablement();
                DebugDaemonPreferencePage.this.validateAllParms();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite portFieldComposite = new Composite((Composite)uiPortGroup, 0);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        portFieldComposite.setLayout((Layout)gl);
        portFieldComposite.setLayoutData((Object)new GridData(1808));
        this.fPortField = new Text(portFieldComposite, 2052);
        GridData gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        this.fPortField.setLayoutData((Object)gd);
        this.fPortField.setText(this.fOriginalPort);
        this.fPortField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DebugDaemonPreferencePage.this.validateAllParms();
            }
        });
        this.fPortSetDefaultButton = new Button(portFieldComposite, 8);
        this.fPortSetDefaultButton.setText(DaemonLabels.PortPrefDialog_SetAsDefault);
        this.fPortSetDefaultButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IEclipsePreferences pref = ConfigurationScope.INSTANCE.getNode("com.ibm.debug.daemon");
                pref.put("DaemonPort", DebugDaemonPreferencePage.this.fPortField.getText());
                try {
                    pref.flush();
                }
                catch (BackingStoreException e1) {
                    DebugDaemonPlugin.log("Problem saving configuration default", (Exception)((Object)e1));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createContentsSSLGroup(Composite compositeForBoth) {
        Group SSLGroup = new Group(compositeForBoth, 0);
        GridData SSLGridData = new GridData(768);
        SSLGroup.setLayoutData((Object)SSLGridData);
        SSLGroup.setText(DaemonLabels.PortPrefDialog_SecureDaemonGroupLabel);
        GridLayout SSLGroupGridLayout = new GridLayout();
        SSLGroupGridLayout.numColumns = 1;
        SSLGroup.setLayout((Layout)SSLGroupGridLayout);
        this.createContentsSSLGroupSecurePort(SSLGroup);
        this.installSeparator((Composite)SSLGroup, 30);
        this.createContentsSSLGroupKeyStoreFile(SSLGroup);
        if (DaemonCore.hasAuthenticators()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.ibm.debug.daemon.preference_page_auth");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.ibm.debug.daemon.preference_page");
        }
    }

    private void createContentsSSLGroupSecurePort(Group SSLGroup) {
        Composite securePortEnableComposite = new Composite((Composite)SSLGroup, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        securePortEnableComposite.setLayout((Layout)gl);
        securePortEnableComposite.setLayoutData((Object)new GridData(1808));
        this.fSecurePortEnable = new Button(securePortEnableComposite, 32);
        this.fSecurePortEnable.setText(DaemonLabels.DaemonPreferencePage_securePortLabel);
        this.fSecurePortEnable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DebugDaemonPreferencePage.this.setFieldEnablement();
                DebugDaemonPreferencePage.this.validateAllParms();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite securePortFieldComposite = new Composite((Composite)SSLGroup, 0);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        securePortFieldComposite.setLayout((Layout)gl);
        securePortFieldComposite.setLayoutData((Object)new GridData(1808));
        this.fSecurePortField = new Text(securePortFieldComposite, 2052);
        GridData secureGD = new GridData(256);
        secureGD.grabExcessHorizontalSpace = true;
        this.fSecurePortField.setLayoutData((Object)secureGD);
        this.fSecurePortField.setText(this.fOriginalSecurePort);
        this.fSecurePortField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DebugDaemonPreferencePage.this.validateAllParms();
            }
        });
        this.fSecurePortSetDefaultButton = new Button(securePortFieldComposite, 8);
        this.fSecurePortSetDefaultButton.setText(DaemonLabels.PortPrefDialog_SetAsDefaultSecurePort);
        this.fSecurePortSetDefaultButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IEclipsePreferences pref = ConfigurationScope.INSTANCE.getNode("com.ibm.debug.daemon");
                pref.put("SecureDaemonPort", DebugDaemonPreferencePage.this.fSecurePortField.getText());
                try {
                    pref.flush();
                }
                catch (BackingStoreException e1) {
                    DebugDaemonPlugin.log("Problem saving configuration default", (Exception)((Object)e1));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createContentsSSLGroupKeyStoreFile(Group SSLGroup) {
        Composite keystoreFileComposite = new Composite((Composite)SSLGroup, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        keystoreFileComposite.setLayout((Layout)gl);
        keystoreFileComposite.setLayoutData((Object)new GridData(1808));
        Label keyStoreFileLabel = new Label(keystoreFileComposite, 0);
        keyStoreFileLabel.setText(DaemonLabels.PortPrefDialog_KeyStoreFileName);
        GridData keystoreGridData = new GridData(128);
        keyStoreFileLabel.setLayoutData((Object)keystoreGridData);
        this.fKeyStoreFileNameField = new Text(keystoreFileComposite, 2052);
        keystoreGridData = new GridData(768);
        keystoreGridData.horizontalSpan = 1;
        this.fKeyStoreFileNameField.setLayoutData((Object)keystoreGridData);
        this.fKeyStoreFileNameField.setText(this.fKeyStoreFileName);
        this.fKeyStoreFileNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DebugDaemonPreferencePage.this.validateAllParms();
            }
        });
        this.fKeyStoreFileNameBrowse = new Button(keystoreFileComposite, 8);
        this.fKeyStoreFileNameBrowse.setText(DaemonLabels.PortPrefDialog_KeyStoreChooseFile);
        keystoreGridData = new GridData(32);
        this.fKeyStoreFileNameBrowse.setLayoutData((Object)keystoreGridData);
        this.fKeyStoreFileNameBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(DebugDaemonPreferencePage.this.getShell());
                String[] extensions = new String[]{"*.jks", "*.p12", "*.pfx"};
                fd.setFilterExtensions(extensions);
                fd.setFilterPath(DebugDaemonPreferencePage.this.fKeyStoreFileName);
                String newDir = fd.open();
                if (newDir != null) {
                    DebugDaemonPreferencePage.this.fKeyStoreFileName = newDir;
                    DebugDaemonPreferencePage.this.fKeyStoreFileNameField.setText(DebugDaemonPreferencePage.this.fKeyStoreFileName);
                }
                DebugDaemonPreferencePage.this.validateAllParms();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite keystorePasswordComposite = new Composite((Composite)SSLGroup, 0);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        keystorePasswordComposite.setLayout((Layout)gl);
        keystorePasswordComposite.setLayoutData((Object)new GridData(1808));
        Label keyStorePasswordLabel = new Label(keystorePasswordComposite, 0);
        keyStorePasswordLabel.setText(DaemonLabels.PortPrefDialog_KeyStorePassword);
        keystoreGridData = new GridData(128);
        keyStorePasswordLabel.setLayoutData((Object)keystoreGridData);
        this.fKeyStorePasswordField = new Text(keystorePasswordComposite, 2052);
        GridData passwordGD = new GridData(256);
        passwordGD.grabExcessHorizontalSpace = true;
        this.fKeyStorePasswordField.setLayoutData((Object)passwordGD);
        this.fKeyStorePasswordField.setEchoChar('*');
        this.fKeyStorePasswordField.setText(String.valueOf(this.fKeyStorePassword));
        this.fKeyStorePasswordField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DebugDaemonPreferencePage.this.fKeyStorePassword = DebugDaemonPreferencePage.this.fKeyStorePasswordField.getText().toCharArray();
                DebugDaemonPreferencePage.this.validateAllParms();
            }
        });
    }

    private String getFileExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int dotIndex = fileName.lastIndexOf(".");
        if (dotIndex >= 0) {
            return fileName.substring(dotIndex + 1);
        }
        return "";
    }

    private void validateKeyStoreParms(Text keyStoreFileNameField, Text keyStorePasswordField, boolean securedDaemonMode) {
        String keyStoreFileName = keyStoreFileNameField.getText();
        String keyStoreFileExt = this.getFileExtension(keyStoreFileName);
        if (keyStoreFileNameField.isEnabled() && keyStoreFileName.trim().length() <= 0 && (securedDaemonMode || keyStorePasswordField.isEnabled() && !keyStorePasswordField.getText().trim().isEmpty())) {
            this.setValid(false);
            this.setErrorMessage(DaemonMessages.CRRDG1114);
        } else if (!(!keyStoreFileNameField.isEnabled() || keyStoreFileName.trim().isEmpty() || keyStoreFileExt.equals("jks") || keyStoreFileExt.equals("p12") || keyStoreFileExt.equals("pfx"))) {
            this.setValid(false);
            this.setErrorMessage(DaemonMessages.CRRDG1137);
        } else if (keyStorePasswordField.isEnabled() && keyStorePasswordField.getText().trim().isEmpty() && (securedDaemonMode || keyStoreFileNameField.isEnabled() && !keyStoreFileName.trim().isEmpty())) {
            this.setValid(false);
            this.setErrorMessage(DaemonMessages.CRRDG1134);
        } else {
            this.setValid(true);
            this.setErrorMessage(null);
        }
    }

    private void validateAllParms() {
        this.setFieldEnablement();
        this.setErrorMessage(null);
        if (this.checkPortsEnablement()) {
            this.checkValidUIPortField();
        }
        if (this.getErrorMessage() == null) {
            this.checkValidSecurePortField();
        }
        if (this.getErrorMessage() == null) {
            this.validateKeyStoreParms(this.fKeyStoreFileNameField, this.fKeyStorePasswordField, true);
        }
        if (DaemonCore.hasAuthenticators()) {
            if (this.getErrorMessage() == null && !this.fReuseKeystore) {
                this.validateKeyStoreParms(this.fAuthKeyStoreFileNameField, this.fAuthKeyStorePasswordField, false);
            }
            if (this.getErrorMessage() == null) {
                this.validateAuthentication();
            }
        }
    }

    private void validateAuthentication() {
        if (this.fUIDaemonEnabled && !this.fAuthKeyStoreFileNameField.getText().trim().isEmpty() && !this.fAuthKeyStorePasswordField.getText().trim().isEmpty()) {
            this.setMessage(DaemonMessages.CRRDG1135, 2);
        } else {
            this.setMessage(null);
        }
    }

    private void createContentForAuth(Composite compositeForBoth) {
        Group authGroup = new Group(compositeForBoth, 0);
        GridLayoutFactory.swtDefaults().applyTo((Composite)authGroup);
        authGroup.setText(DaemonLabels.Daemon_Authentication);
        GridDataFactory.fillDefaults().applyTo((Control)authGroup);
        this.fReuseSecureSettings = new Button((Composite)authGroup, 32);
        this.fReuseSecureSettings.setText(DaemonLabels.Reuse_Secure);
        this.fReuseSecureSettings.setEnabled(this.fSecureDaemonEnabled);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.fReuseSecureSettings);
        this.fReuseSecureSettings.setSelection(this.fReuseKeystore);
        this.fReuseSecureSettings.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DebugDaemonPreferencePage.this.fReuseKeystore = DebugDaemonPreferencePage.this.fReuseSecureSettings.getSelection();
                DebugDaemonPreferencePage.this.validateAllParms();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                DebugDaemonPreferencePage.this.fReuseKeystore = DebugDaemonPreferencePage.this.fReuseSecureSettings.getSelection();
                DebugDaemonPreferencePage.this.validateAllParms();
            }
        });
        Composite keystoreFileComposite = new Composite((Composite)authGroup, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(keystoreFileComposite);
        GridDataFactory.fillDefaults().applyTo((Control)keystoreFileComposite);
        Label keyStoreFileLabel = new Label(keystoreFileComposite, 0);
        keyStoreFileLabel.setText(DaemonLabels.PortPrefDialog_KeyStoreFileName);
        this.fAuthKeyStoreFileNameField = new Text(keystoreFileComposite, 2052);
        this.fAuthKeyStoreFileNameField.setText(this.fAuthKeyStoreFileName);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.fAuthKeyStoreFileNameField);
        this.fAuthKeyStoreFileNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DebugDaemonPreferencePage.this.validateAllParms();
            }
        });
        this.fAuthKeyStoreFileNameBrowse = new Button(keystoreFileComposite, 8);
        this.fAuthKeyStoreFileNameBrowse.setText(DaemonLabels.PortPrefDialog_KeyStoreChooseFile);
        this.fAuthKeyStoreFileNameBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(DebugDaemonPreferencePage.this.getShell());
                String[] extensions = new String[]{"*.jks", "*.p12", "*.pfx"};
                fd.setFilterExtensions(extensions);
                fd.setFilterPath(DebugDaemonPreferencePage.this.fAuthKeyStoreFileName);
                String newDir = fd.open();
                if (newDir != null) {
                    DebugDaemonPreferencePage.this.fAuthKeyStoreFileName = newDir;
                    DebugDaemonPreferencePage.this.fAuthKeyStoreFileNameField.setText(DebugDaemonPreferencePage.this.fAuthKeyStoreFileName);
                }
                DebugDaemonPreferencePage.this.validateAllParms();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite keystorePasswordComposite = new Composite((Composite)authGroup, 0);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)keystorePasswordComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(keystorePasswordComposite);
        keystorePasswordComposite.setLayoutData((Object)new GridData(1808));
        Label keyStorePasswordLabel = new Label(keystorePasswordComposite, 0);
        keyStorePasswordLabel.setText(DaemonLabels.PortPrefDialog_KeyStorePassword);
        this.fAuthKeyStorePasswordField = new Text(keystorePasswordComposite, 2052);
        GridData passwordGD = new GridData(256);
        passwordGD.grabExcessHorizontalSpace = true;
        this.fAuthKeyStorePasswordField.setLayoutData((Object)passwordGD);
        this.fAuthKeyStorePasswordField.setEchoChar('*');
        this.fAuthKeyStorePasswordField.setText(new String(this.fAuthKeyStorePassword));
        this.fAuthKeyStorePasswordField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DebugDaemonPreferencePage.this.fAuthKeyStorePassword = DebugDaemonPreferencePage.this.fKeyStorePasswordField.getText().toCharArray();
                DebugDaemonPreferencePage.this.validateAllParms();
            }
        });
    }
}

