/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.ECPThread;
import com.ibm.debug.pdt.internal.epdc.EPDC_ChangeItem;
import com.ibm.debug.pdt.internal.epdc.EPDC_ChangePacket;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ThreadChangePacket
extends EPDC_ChangePacket {
    ThreadChangePacket(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession, EPDC_Reply reply) throws IOException {
        super(byteBuffer, dataInputStream, engineSession, reply);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        for (EPDC_ChangeItem chgItem : this.fChangeItems) {
            ECPThread item = (ECPThread)chgItem;
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Thread [" + item.getId() + "] " + EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, "StdThd.*", item.getDebugState()));
            item.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        }
    }

    @Override
    public String getDescription() {
        return "Thread change packet";
    }

    @Override
    EPDC_ChangeItem createChangeItem(byte[] byteBuffer, DataInputStream dis, EPDC_EngineSession engineSession) throws IOException {
        return new ECPThread(byteBuffer, dis, engineSession);
    }
}

