/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EBPList;
import com.ibm.debug.pdt.internal.epdc.ECPThread;
import com.ibm.debug.pdt.internal.epdc.ERepProcessStop;

public class ProcessStopInfo {
    private static final int[] EMPTYBREAKPOINTS = new int[0];
    private short _reason = 0;
    private String _exceptionMsg;
    private EBPList[] _breakpoints;
    private int _stoppingThreadID;
    private boolean fEventProcessed = false;

    ProcessStopInfo(ERepProcessStop stopReply) {
        this._reason = stopReply.getWhyStop();
        this._exceptionMsg = stopReply.getExceptionMsg();
        this._breakpoints = stopReply.getBreakpoints();
        this._stoppingThreadID = stopReply.getThreadID();
    }

    public ProcessStopInfo(ECPThread thread) {
        this._reason = thread.getWhyStop();
        this._exceptionMsg = thread.getExceptionMsg();
        this._breakpoints = thread.getBreakpointList();
        this._stoppingThreadID = thread.getId();
    }

    public ProcessStopInfo(int stoppingThreadID) {
        this._stoppingThreadID = stoppingThreadID;
    }

    public short getReason() {
        return this._reason;
    }

    public String getExceptionMsg() {
        return this._exceptionMsg;
    }

    void setExceptionMsg(String message) {
        this._exceptionMsg = message;
    }

    public int[] getBreakpointsHit() {
        if (this._breakpoints.length == 0) {
            return EMPTYBREAKPOINTS;
        }
        int[] breakpoints = new int[this._breakpoints.length];
        int i = 0;
        while (i < breakpoints.length) {
            breakpoints[i] = this._breakpoints[i].getBreakid();
            ++i;
        }
        return breakpoints;
    }

    public int getStoppingThreadId() {
        return this._stoppingThreadID;
    }

    public boolean isStoppedByException() {
        return this._reason == 5 || this._reason == 6 || this._reason == 7 || this._reason == 8;
    }

    public boolean isEnded() {
        return this._reason == 3 || this._reason == 11 || this._reason == 13 || this._reason == 14;
    }

    public boolean isStoppedByBreakpoint() {
        return this._reason == 1 || this._reason == 2 || this._breakpoints.length > 0;
    }

    public boolean isStoppedByFork() {
        return this._reason == 15;
    }

    public boolean isStoppedByExec() {
        return this._reason == 16;
    }

    public boolean isStillProcessing() {
        return this._reason == 17 || this._reason == 18;
    }

    public boolean isEventProcessed() {
        return this.fEventProcessed;
    }

    public void setEventProcessed() {
        this.fEventProcessed = true;
    }

    public boolean isExceptionMsgSet() {
        return this._exceptionMsg != null && !this._exceptionMsg.isEmpty();
    }
}

