/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.ECPMonitorExpr;
import com.ibm.debug.pdt.internal.epdc.ECPMonitorExpr2;
import com.ibm.debug.pdt.internal.epdc.ECPMonitorExprBase;
import com.ibm.debug.pdt.internal.epdc.EPDC_ChangeItem;
import com.ibm.debug.pdt.internal.epdc.EPDC_ChangePacket;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MonitorChangePacket
extends EPDC_ChangePacket {
    MonitorChangePacket(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession, EPDC_Reply reply) throws IOException {
        super(byteBuffer, dataInputStream, engineSession, reply);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        for (EPDC_ChangeItem chgItem : this.fChangeItems) {
            ECPMonitorExprBase item = (ECPMonitorExprBase)chgItem;
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Monitor(" + item.getExpressionString() + ")");
            item.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        }
    }

    @Override
    public String getDescription() {
        return "Monitor change packet";
    }

    @Override
    EPDC_ChangeItem createChangeItem(byte[] byteBuffer, DataInputStream dis, EPDC_EngineSession engineSession) throws IOException {
        if (engineSession.supportsNewMonitorFormat()) {
            return new ECPMonitorExpr2(byteBuffer, dis, engineSession);
        }
        return new ECPMonitorExpr(byteBuffer, dis, engineSession);
    }
}

