/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.ECPFCT;
import com.ibm.debug.pdt.internal.epdc.EFunctCustTable;
import com.ibm.debug.pdt.internal.epdc.EPDC_ChangeItem;
import com.ibm.debug.pdt.internal.epdc.EPDC_ChangePacket;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FCTChangePacket
extends EPDC_ChangePacket {
    FCTChangePacket(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession, EPDC_Reply reply) throws IOException {
        super(byteBuffer, dataInputStream, engineSession, reply);
        ECPFCT[] changePackets = reply.getFCTChanges();
        if (changePackets.length == 1) {
            EFunctCustTable FCTChangeItem = changePackets[0].getFunctionCustomizationTable();
            engineSession.setFCTable(FCTChangeItem);
        }
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "# of FCT", this.getTotalChgItems());
        ((EPDC_ChangeItem)this.fChangeItems.get(0)).writeEPDC(dataOutputStream);
    }

    @Override
    public String getDescription() {
        return "FCT change packet";
    }

    @Override
    EPDC_ChangeItem createChangeItem(byte[] byteBuffer, DataInputStream dis, EPDC_EngineSession engineSession) throws IOException {
        return new ECPFCT(byteBuffer, dis, engineSession);
    }
}

