/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EViewFile
extends EPDC_Structures
implements Cloneable {
    private int _RecLength;
    private int _Startline;
    private int _Endline;
    private EStdString _Filename;
    private EStdString _BaseFilename;
    private byte _ViewAttr;
    private byte fExtendedAttr;
    private byte[] fSignature;

    public EViewFile(int RecLength, int Startline, int Endline, String Filename, String BaseFilename, int ViewAttr, EPDC_EngineSession engineSession) {
        super(engineSession);
        this._RecLength = RecLength;
        this._Startline = Startline;
        this._Endline = Endline;
        this._Filename = new EStdString(Filename, engineSession);
        this._BaseFilename = new EStdString(BaseFilename, engineSession);
        this._ViewAttr = (byte)ViewAttr;
    }

    EViewFile(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._RecLength = dataInputStream.readInt();
        this._Startline = dataInputStream.readInt();
        this._Endline = dataInputStream.readInt();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._Filename = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._BaseFilename = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        this._ViewAttr = dataInputStream.readByte();
        this.fExtendedAttr = dataInputStream.readByte();
        if (this.isSignature()) {
            dataInputStream.skipBytes(2);
            this.fSignature = new byte[16];
            dataInputStream.readFully(this.fSignature);
        }
    }

    private EViewFile(EPDC_EngineSession engineSession) {
        super(engineSession);
    }

    public boolean isSignature() {
        return (this.fExtendedAttr & 1) != 0;
    }

    public Object clone() throws CloneNotSupportedException {
        EViewFile newCopy = new EViewFile(this.getEPDCEngineSession());
        newCopy._RecLength = this._RecLength;
        newCopy._Startline = this._Startline;
        newCopy._Endline = this._Endline;
        newCopy._Filename = this._Filename;
        newCopy._BaseFilename = this._BaseFilename;
        newCopy._ViewAttr = this._ViewAttr;
        return newCopy;
    }

    public int getRecordLength() {
        return this._RecLength;
    }

    public int getFirstLineNumber() {
        return this._Startline;
    }

    public int getLastLineNumber() {
        return this._Endline;
    }

    public String getFileName() {
        if (this._Filename != null) {
            return this._Filename.toString();
        }
        return null;
    }

    public String getBaseFileName() {
        if (this._BaseFilename != null) {
            return this._BaseFilename.toString();
        }
        return null;
    }

    public boolean isVerified() {
        return (this._ViewAttr & 0xFFFFFF80) != 0;
    }

    public boolean isVerifiedLocally() {
        return (this._ViewAttr & 0x10) != 0;
    }

    public boolean isVerificationAttempted() {
        return (this._ViewAttr & 0x40) != 0;
    }

    public boolean isVerificationAttemptedFE() {
        return (this._ViewAttr & 8) != 0;
    }

    public boolean isFileNameOverrideSupported() {
        return (this._ViewAttr & 0x20) != 0;
    }

    public boolean isViewSwitchable() {
        return (this._ViewAttr & 4) == 0;
    }

    public boolean isLocalFileSupported() {
        return (this._ViewAttr & 2) == 0;
    }

    public boolean isDynamic() {
        return (this._ViewAttr & 1) != 0;
    }

    public byte getAttributes() {
        return this._ViewAttr;
    }

    public void setAttributes(byte newAttr) {
        this._ViewAttr = newAttr;
    }

    @Override
    int getFixedLen() {
        return 22;
    }

    @Override
    int getVarLen() {
        int total = 0;
        total += super.getVarLen();
        total += EViewFile.getTotalBytes(this._Filename);
        return total += EViewFile.getTotalBytes(this._BaseFilename);
    }

    void output(DataOutputStream dataOutputStream, int baseOffset) throws IOException {
        dataOutputStream.writeInt(this._RecLength);
        dataOutputStream.writeInt(this._Startline);
        dataOutputStream.writeInt(this._Endline);
        int offset = baseOffset;
        offset += EViewFile.writeOffsetOrZero(dataOutputStream, offset, this._Filename);
        EViewFile.writeOffsetOrZero(dataOutputStream, offset, this._BaseFilename);
        dataOutputStream.writeByte(this._ViewAttr);
        dataOutputStream.writeByte(0);
        if (this._Filename != null) {
            this._Filename.output(dataOutputStream);
        }
        if (this._BaseFilename != null) {
            this._BaseFilename.output(dataOutputStream);
        }
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) {
        EPDC_DumpUtils.NameVal[] attrConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(-128, "Verified"), new EPDC_DumpUtils.NameVal(64, "Eng vrfy attempted"), new EPDC_DumpUtils.NameVal(32, "Can change file"), new EPDC_DumpUtils.NameVal(16, "File is local"), new EPDC_DumpUtils.NameVal(8, "UI vrfy attempted"), new EPDC_DumpUtils.NameVal(4, "No switch"), new EPDC_DumpUtils.NameVal(2, "No local"), new EPDC_DumpUtils.NameVal(1, "Dynamic")};
        EPDC_DumpUtils.NameVal[] attrConstantsExt = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(2, "Include file"), new EPDC_DumpUtils.NameVal(1, "Signature")};
        try {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "RecLength", this.getRecordLength());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "StartLine", this.getFirstLineNumber());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "EndLine", this.getLastLineNumber());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "FileName", this.getFileName());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "BaseFileName", this.getBaseFileName());
            EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "ViewAttr", this.getAttributes(), attrConstants);
            EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "ViewAttrExt", this.getExtendedAttributes(), attrConstantsExt);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private byte getExtendedAttributes() {
        return this.fExtendedAttr;
    }

    @Override
    public String getDescription() {
        return "View file information";
    }

    public boolean isIncludeFile() {
        return (this.fExtendedAttr & 2) != 0;
    }
}

