/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EViewFile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class EViewData
extends EPDC_Structures {
    private int _Prefixl;
    private byte _ViewDataAttr;
    private ArrayList<EViewFile> _ViewsInfo;

    EViewData(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int srcFilesForView = dataInputStream.readUnsignedShort();
        this._Prefixl = dataInputStream.readUnsignedByte();
        dataInputStream.skipBytes(1);
        this._ViewDataAttr = dataInputStream.readByte();
        dataInputStream.skipBytes(1);
        this._ViewsInfo = new ArrayList();
        if (srcFilesForView == 0) {
            new EViewFile(byteBuffer, dataInputStream, engineSession);
        } else {
            int i = 0;
            while (i < srcFilesForView) {
                this._ViewsInfo.add(new EViewFile(byteBuffer, dataInputStream, engineSession));
                ++i;
            }
        }
    }

    public boolean isValidated() {
        return (this._ViewDataAttr & 0x80) != 0;
    }

    public EViewFile[] getViewFiles() {
        return this._ViewsInfo.toArray(new EViewFile[this._ViewsInfo.size()]);
    }

    public int getPrefixLength() {
        return this._Prefixl;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) {
        EPDC_DumpUtils.NameVal[] attrConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(128, "Validated")};
        try {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "SrcFiles", this._ViewsInfo.size());
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Pre_fixl", this.getPrefixLength());
            EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Attr", this._ViewDataAttr, attrConstants);
            if (this._ViewsInfo.size() > 0) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, "FileInfo");
                int i = 0;
                while (i < this._ViewsInfo.size()) {
                    if (this._ViewsInfo.get(i) != null) {
                        EPDC_DumpUtils.beginStructure(dataOutputStream, "[" + (i + 1) + "]");
                        this._ViewsInfo.get(i).writeEPDC(dataOutputStream);
                        EPDC_DumpUtils.endStructure(dataOutputStream);
                    }
                    ++i;
                }
                EPDC_DumpUtils.endStructure(dataOutputStream);
            } else {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "View_Info", "NULL");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getDescription() {
        return "View data";
    }
}

