/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ETraceProperty
extends EPDC_Structures {
    private EStdString fName;
    private EStdString fValue;

    ETraceProperty(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this.fName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this.fValue = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Name", this.fName);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Value", this.fValue);
    }

    public String getNameString() {
        return this.fName != null ? this.fName.toString() : null;
    }

    public String getValueString() {
        return this.fValue != null ? this.fValue.toString() : null;
    }

    @Override
    int getFixedLen() {
        return super.getFixedLen() + 8;
    }

    @Override
    int getVarLen() {
        return super.getVarLen() + ETraceProperty.getTotalBytes(this.fName) + ETraceProperty.getTotalBytes(this.fValue);
    }

    @Override
    public String getDescription() {
        return "Trace Property";
    }
}

