/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EStdEventBPData;
import com.ibm.debug.pdt.internal.epdc.EStdExpression2;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EStdZeroAddressBPData
extends EStdEventBPData {
    private static final long serialVersionUID = 20200720L;
    private EStdString fIgnoreList;
    private EStdString fAction;
    private EStdExpression2 fConditionalExpr;

    public EStdZeroAddressBPData(EPDC_EngineSession engineSession) {
        super(engineSession);
    }

    EStdZeroAddressBPData(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this.fIgnoreList = null;
    }

    public void setAction(String action) {
        this.fAction = action == null ? null : new EStdString(action, this.getEPDCEngineSession());
    }

    public EStdString getAction() {
        return this.fAction;
    }

    @Override
    public String getDescription() {
        return "Zero Address BP data";
    }

    @Override
    int getTotalBytes() {
        return this.fIgnoreList == null ? super.getTotalBytes() : this.fIgnoreList.getTotalBytes();
    }

    @Override
    int getFixedLen() {
        return this.fIgnoreList == null ? super.getFixedLen() : this.fIgnoreList.getFixedLen();
    }

    @Override
    int getVarLen() {
        return this.fIgnoreList == null ? super.getVarLen() : this.fIgnoreList.getVarLen();
    }

    public void setConditionalExpr(EStdExpression2 conditionalExpr) {
        this.fConditionalExpr = conditionalExpr;
    }

    public EStdExpression2 getConditionalExpr() {
        return this.fConditionalExpr;
    }

    @Override
    void output(DataOutputStream dataOutputStream, int baseOffset) throws IOException {
        if (this.fIgnoreList != null) {
            this.fIgnoreList.output(dataOutputStream);
        }
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        if (this.fIgnoreList != null) {
            this.fIgnoreList.writeEPDC(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "IgnoreList (*RESERVED)", "NULL");
        }
    }

    public EStdString getIgnoreList() {
        return this.fIgnoreList;
    }
}

