/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class EStdView
extends EPDC_Structures
implements Serializable {
    private transient int _hashCode = 0;
    private static final long serialVersionUID = 20050124L;
    protected static final int FIXED_LENGTH = 12;
    public static final transient EStdView EMPTY_VIEW = new EStdView(0, 0, 0, 0);
    private int _partID;
    private int _view;
    private int _srcFileIndex;
    private int _lineNumber;

    public EStdView(int PPID, int View2, int SrcFileIndex, int LineNum) {
        this._partID = PPID;
        this._view = View2;
        this._srcFileIndex = SrcFileIndex;
        this._lineNumber = LineNum;
    }

    public EStdView(EStdView view) {
        this._partID = view._partID;
        this._view = view._view;
        this._srcFileIndex = view._srcFileIndex;
        this._lineNumber = view._lineNumber;
    }

    EStdView() {
    }

    EStdView(DataInputStream dataInputStream) throws IOException {
        this._partID = dataInputStream.readUnsignedShort();
        this._view = dataInputStream.readUnsignedShort();
        this._srcFileIndex = dataInputStream.readInt();
        this._lineNumber = dataInputStream.readInt();
    }

    public int getPartID() {
        return this._partID;
    }

    public int getViewNum() {
        return this._view;
    }

    public int getSrcFileIndex() {
        return this._srcFileIndex;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public boolean isComplete() {
        return this._partID != 0 && this._view != 0 && this._srcFileIndex != 0 && this._lineNumber != 0;
    }

    public void setLineNum(int lineNumber) {
        this._lineNumber = lineNumber;
        this._hashCode = 0;
    }

    @Override
    int getFixedLen() {
        return 12;
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this._partID);
        dataOutputStream.writeShort(this._view);
        dataOutputStream.writeInt(this._srcFileIndex);
        dataOutputStream.writeInt(this._lineNumber);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Part ID", this._partID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "View", this._view);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "File index", this._srcFileIndex);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Line number", this._lineNumber);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EStdView)) {
            return false;
        }
        EStdView view = (EStdView)obj;
        return this.isEquivalentView(view) && this._lineNumber == view.getLineNumber();
    }

    public boolean isEquivalentView(EStdView view) {
        return view != null && this._partID == view.getPartID() && this._view == view.getViewNum() && this._srcFileIndex == view.getSrcFileIndex();
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            this._hashCode = 17;
            this._hashCode = 37 * this._hashCode + this._partID;
            this._hashCode = 37 * this._hashCode + this._view;
            this._hashCode = 37 * this._hashCode + this._srcFileIndex;
            this._hashCode = 37 * this._hashCode + this._lineNumber;
        }
        return this._hashCode;
    }

    @Override
    public String getDescription() {
        return "Location <EStdView>";
    }
}

